var require = (function() {
    //var _loadedModules = {};

    var _require = function(ins, scriptName) {
        /*var moduleInfo = _loadedModules[scriptName];
        if (moduleInfo) {
            return moduleInfo;
        }
        */

        var moduleInfo = {
            loaded: false,
            id: scriptName,
            exports: {},
            require: _requireClosure()
        };

        var parameters = [
            moduleInfo.exports, /* exports */
            moduleInfo,         /* module */
            moduleInfo.require, /* require */
        ];

        try {
            var moduleContent = ins.getScript(scriptName).code;
            var func = new Function('exports', 'module', 'require', moduleContent);
            func.apply({}, parameters);
        } catch (e) {
            throw new Error('Unable to require ' + scriptName);
        }

        moduleInfo.loaded = true;
        //_loadedModules[scriptName] = moduleInfo;
        return moduleInfo;
    };

    var _requireClosure = function() {
        return function(ins, scriptName) {
            var module = _require(ins, scriptName);
            return module.exports;
        };
    };

    return _requireClosure();
})();