/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.restcontrollers;

import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.m.c_ia;
import com.inscada.mono.user.model.ResetPasswordToken;
import com.inscada.mono.user.model.Role;
import com.inscada.mono.user.model.User;
import com.inscada.mono.user.model.UserDto;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final c_ia b;

    @PutMapping(value={"/agree"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void acceptEula(Principal a) {
        UserController a2;
        a2.b.m_gc(a.getName());
    }

    @GetMapping
    public Collection<User> getUsers() {
        UserController a;
        return a.b.m_da();
    }

    @GetMapping(value={"/{userId}/spaces"})
    public Collection<Space> getSpaces(@PathVariable(value="userId") Integer a) {
        return this.b.m_uc(a);
    }

    @DeleteMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@PathVariable(value="userId") Integer a) {
        this.b.m_qa(a);
    }

    @PostMapping(value={"/{userId}/roles"})
    public ResponseEntity<Role> addRole(@PathVariable(value="userId") Integer userId, @RequestBody Integer roleId, UriComponentsBuilder a) {
        Role role = this.b.m_jc(userId, roleId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = roleId;
        return ResponseEntity.created((URI)a.path(VariableFilter.m_hi((Object)"\b+R#B\"n4Z\u007fU?K5T\u007f\\\"H<B\u0019C-")).buildAndExpand(objectArray).toUri()).body((Object)role);
    }

    @GetMapping(value={"/{userId}/roles/{roleId}"})
    public Role getRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        return this.b.m_yc(userId, a);
    }

    @PostMapping
    public ResponseEntity<User> createUser(@Valid @RequestBody UserDto userDto, UriComponentsBuilder a) {
        userDto = this.b.m_xb(userDto);
        Object[] objectArray = new Object[1];
        objectArray[0] = userDto.getId();
        return ResponseEntity.created((URI)a.path(AlarmFilter.m_hi((Object)"{\f!\u00041\u0005\u001d\u0013)")).buildAndExpand(objectArray).toUri()).body((Object)userDto);
    }

    @PutMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUser(@PathVariable(value="userId") Integer userId, @Valid @RequestBody User a) {
        this.b.m_bc(userId, a);
    }

    @GetMapping(value={"/{userId}/roles"})
    public Collection<Role> getRoles(@PathVariable(value="userId") Integer a) {
        return this.b.m_lc(a);
    }

    @PostMapping(value={"/{username}/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@PathVariable(value="username") String username, @Valid @RequestBody ResetPasswordToken a) {
        this.b.m_tc(username, a);
    }

    @PostMapping(value={"/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetOwnPassword(@Valid @RequestBody ResetPasswordToken resetPasswordToken, Principal a) {
        this.b.m_fc(a.getName(), resetPasswordToken);
    }

    public UserController(c_ia a) {
        UserController a2;
        a2.b = a;
    }

    @GetMapping(value={"/{userId}/spaces/{spaceId}"})
    public Space getSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        return this.b.m_ac(userId, a);
    }

    @DeleteMapping(value={"/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        this.b.m_oc(userId, a);
    }

    @GetMapping(value={"/{userId}"})
    public User getUser(@PathVariable(value="userId") Integer a) {
        return this.b.m_ba(a);
    }

    @DeleteMapping(value={""}, params={"userIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUsersByIds(@RequestParam(value="userIds") Integer[] a) {
        this.b.m_xc(List.of(a));
    }

    @DeleteMapping(value={"/{userId}/spaces/{spaceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        this.b.m_cb(userId, a);
    }

    @GetMapping(value={"/ui-configs"})
    public String getUIConfigs(Principal a) {
        UserController a2;
        return a2.b.m_pc(a.getName());
    }

    @PutMapping(value={"/ui-configs"})
    public void setUIConfigs(@RequestBody String value, Principal a) {
        this.b.m_hc(value, a.getName());
    }

    @GetMapping(value={"/active-space"})
    public String[] getAllSpaceUsers() {
        UserController a;
        return a.b.m_dc();
    }

    @PostMapping(value={"/{userId}/spaces"})
    public ResponseEntity<Space> addSpace(@PathVariable(value="userId") Integer userId, @RequestBody Integer spaceId, UriComponentsBuilder a) {
        Space space = this.b.m_sb(userId, spaceId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = spaceId;
        return ResponseEntity.created((URI)a.path(VariableFilter.m_hi((Object)"\b+R#B\"n4Z\u007fT F3B#\b+T F3B\u0019C-")).buildAndExpand(objectArray).toUri()).body((Object)space);
    }
}

