/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.trend.model.TrendTag;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="trend")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Trend
extends SpaceBaseModel {
    private String configs;
    @Size(max=255)
    private String dsc;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Id
    @Column(name="trend_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="trendSeq")
    @GenericGenerator(name="trendSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="trend_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @NotNull
    @Min(value=1000L)
    private Integer period;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Column(name="trend_order")
    private Integer order;
    @JsonIgnore
    @OneToMany(mappedBy="trend", orphanRemoval=true)
    private Set<TrendTag> trendTags;
    @NotBlank
    @Size(max=100)
    private String name;

    public void setName(String a) {
        a.name = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setTrendTags(Set<TrendTag> a) {
        a.trendTags = a;
    }

    public String getDsc() {
        Trend a;
        return a.dsc;
    }

    public String getConfigs() {
        Trend a;
        return a.configs;
    }

    public boolean equals(Object a) {
        Trend a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Trend)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Trend)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setPeriod(Integer a) {
        a.period = a;
    }

    public Trend() {
        Trend a;
        Trend trend = a;
        trend.trendTags = new HashSet();
    }

    public Set<TrendTag> getTrendTags() {
        Trend a;
        return a.trendTags;
    }

    public int hashCode() {
        Trend a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setConfigs(String a) {
        a.configs = a;
    }

    public void setProject(Project a) {
        Trend a2;
        Trend trend = a2;
        trend.project = a;
        trend.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setOrder(Integer a) {
        a.order = a;
    }

    public Project getProject() {
        Trend a;
        return a.project;
    }

    public Integer getProjectId() {
        Trend a;
        return a.projectId;
    }

    public String getName() {
        Trend a;
        return a.name;
    }

    public Integer getPeriod() {
        Trend a;
        return a.period;
    }

    public Integer getOrder() {
        Trend a;
        return a.order;
    }

    public Integer getId() {
        Trend a;
        return a.id;
    }

    public void setId(Integer a) {
        a.id = a;
    }
}

