/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.tracking.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="map_variable")
@CheckAtLeastOneNotNull.List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"})})
public class MapVariable
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="variable_id")
    private Variable<?, ?, ?> variable;
    @Column(name="var_order")
    private Integer varOrder;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Id
    @Column(name="map_variable_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="mapVariableSeq")
    @GenericGenerator(name="mapVariableSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="map_variable_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Column(name="variable_id", insertable=false, updatable=false)
    private Integer variableId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;

    public Project getProject() {
        MapVariable a;
        return a.project;
    }

    public Integer getId() {
        MapVariable a;
        return a.id;
    }

    public void setVariableId(Integer a) {
        a.variableId = a;
    }

    public Variable<?, ?, ?> getVariable() {
        MapVariable a;
        return a.variable;
    }

    public MapVariable() {
        MapVariable a;
    }

    public void setProject(Project a) {
        a.project = a;
    }

    public Integer getVarOrder() {
        MapVariable a;
        return a.varOrder;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public int hashCode() {
        MapVariable a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getVariableId();
        return Objects.hash(objectArray);
    }

    public Integer getProjectId() {
        MapVariable a;
        return a.projectId;
    }

    public void setVariable(Variable<?, ?, ?> a) {
        MapVariable a2;
        MapVariable mapVariable = a2;
        mapVariable.variable = a;
        mapVariable.variableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getVariableId() {
        MapVariable a;
        return a.variableId;
    }

    public boolean equals(Object a) {
        MapVariable a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof MapVariable)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (MapVariable)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getVariableId().equals(a.getVariableId());
    }

    public void setVarOrder(Integer a) {
        a.varOrder = a;
    }
}

