/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.log.model.LogEntryDto;
import com.inscada.mono.shared.exceptions.c_ha;
import com.inscada.mono.shared.exceptions.c_jf;
import com.inscada.mono.shared.exceptions.c_mj;
import com.inscada.mono.shared.exceptions.c_ml;
import com.inscada.mono.shared.exceptions.c_oj;
import com.inscada.mono.shared.exceptions.c_rc;
import com.inscada.mono.shared.exceptions.c_vc;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger D = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String l = "File Storage Error";
    private static final String F = "Constraint Violation";
    private static final String a = "Inscada Error";
    private static final String f = "Database Error";
    private static final String c = "Already Exists Error";
    private static final String I = "Validation Error";
    private static final String h = "Not Found Error";
    private static final String A = "Mismatch Error";
    private static final String C = "Not Active Error";
    private static final String B = "Unknown Error";
    private static final String k = "Security Error";
    private static final String i = "Relation Exists Error";
    @Value(value="${spring.profiles.active}")
    private String b;

    @ExceptionHandler(value={c_mj.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMismatch(c_mj a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, A);
        D.error(LogEntryDto.m_hi((Object)"1\u000f\u000f\u000b\u001d\u0012\u001f\u000e\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_ml.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleFileStorage(c_ml a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, l);
        D.error(CheckedAlarm.m_hi((Object)"\u000f\u001f%\u0013i\u0005=\u0019;\u0017.\u0013i\u0013;\u0004&\u0004sV2\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4) {
        GeneralExceptionHandler a5;
        return a5.createExceptionDetails(a, a2, a3, a4, null);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4, Map<String, List<String>> a5) {
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = a6;
        a2 = generalExceptionHandler.sanitizeMessage(a2, a3);
        String string = generalExceptionHandler.isDevelopment() ? a3.getClass().getName() : LogEntryDto.m_hi((Object)"#\u0004\u0005\u0019\u0016\b\u000f\u0013\b");
        String string2 = a6.isDevelopment() ? a4 : CheckedAlarm.m_hi((Object)"3;\u0004&\u0004");
        String string3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a3) : null;
        return new ExceptionDetails(a.value(), a2, string, string2, a5, a4 = string3, new Date(), a6.getCurrentPath());
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(status, ex.getMessage(), ex, B);
        D.error(LogEntryDto.m_hi((Object)"5\b\b\u0003\u000e\b\u001d\n\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)ex);
        return new ResponseEntity((Object)ex, status);
    }

    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a2) {
        headers = new HashMap();
        status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return LogEntryDto.m_hi((Object)"2\t\\\u000b\u0019\u0015\u000f\u0007\u001b\u0003\\\u0007\n\u0007\u0015\n\u001d\u0004\u0010\u0003");
        }, Collectors.toList())));
        a2 = ex.getBindingResult().getGlobalErrors().stream().map(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return LogEntryDto.m_hi((Object)"2\t\\\u000b\u0019\u0015\u000f\u0007\u001b\u0003\\\u0007\n\u0007\u0015\n\u001d\u0004\u0010\u0003");
        }).collect(Collectors.toList());
        headers.putAll(status);
        if (!a2.isEmpty()) {
            headers.put(CheckedAlarm.m_hi((Object)".\u001a&\u0014(\u001a"), a2);
        }
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, this.formatErrorMessages((Map)headers), (Exception)ex, I, (Map)headers);
        D.error(LogEntryDto.m_hi((Object)"*\u0007\u0010\u000f\u0018\u0007\b\u000f\u0013\b\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException a2) {
        GeneralExceptionHandler a3;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails(HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, F, map);
        D.error(CheckedAlarm.m_hi((Object)"\n\u0019'\u0005=\u0004(\u001f'\u0002i\u0000 \u0019%\u0017=\u001f&\u0018sV2\u000b"), (Object)a2);
        return new ResponseEntity((Object)a2, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={TransactionSystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException a) {
        GeneralExceptionHandler a2;
        Throwable throwable = a.getRootCause();
        if (throwable instanceof ConstraintViolationException) {
            return a2.handleConstraintViolation((ConstraintViolationException)throwable);
        }
        throwable = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, f);
        D.error(LogEntryDto.m_hi((Object)"(\u0014\u001d\b\u000f\u0007\u001f\u0012\u0015\t\u0012F\u000f\u001f\u000f\u0012\u0019\u000b\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)throwable, (Object)a);
        return new ResponseEntity((Object)throwable, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException a) {
        GeneralExceptionHandler a2;
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getName();
        objectArray[1] = a.getValue();
        objectArray[2] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : LogEntryDto.m_hi((Object)"\u0013\u0012\r\u0012\t\u000b\b");
        String string = String.format(CheckedAlarm.m_hi((Object)"\u0019\u0017;\u0017$\u0013=\u0013;VnS:Qi\u0001 \u0002!V?\u0017%\u0003,VnS:Qi\u0015&\u0003%\u0012i\u0018&\u0002i\u0014,V*\u0019'\u0000,\u0004=\u0013-V=\u0019i\u00020\u0006,VnS:Q"), objectArray);
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, string, (Exception)a, I);
        D.error(CheckedAlarm.m_hi((Object)"\"0\u0006,V$\u001f:\u001b(\u0002*\u001esV2\u000b"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_oj.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleAlreadyExists(c_oj a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, c);
        D.error(LogEntryDto.m_hi((Object)"=\n\u000e\u0003\u001d\u0002\u0005F\u0019\u001e\u0015\u0015\b\u0015\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    public GeneralExceptionHandler() {
        GeneralExceptionHandler a;
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return CheckedAlarm.m_hi((Object)"9\u0017=\u001ef\u0003'\u001d'\u0019>\u0018");
        }
    }

    private /* synthetic */ String sanitizeMessage(String a, Exception a2) {
        GeneralExceptionHandler a3;
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof c_oj) {
            return LogEntryDto.m_hi((Object)"4\u0019\u0015\u0013\u0013\u000e\u0005\u0019F\u001d\n\u000e\u0003\u001d\u0002\u0005F\u0019\u001e\u0015\u0015\b\u0015");
        }
        if (a2 instanceof c_ml) {
            return CheckedAlarm.m_hi((Object)"0 \u001a,V&\u0006,\u0004(\u0002 \u0019'V/\u0017 \u001a,\u0012");
        }
        if (a2 instanceof c_mj) {
            return LogEntryDto.m_hi((Object)"4\u0019\u0015\u0013\u0013\u000e\u0005\u0019F\u0011\u000f\u000f\u000b\u001d\u0012\u001f\u000e");
        }
        if (a2 instanceof c_jf) {
            return CheckedAlarm.m_hi((Object)"\u001b\u0013:\u0019<\u0004*\u0013i\u001f:V'\u0019=V(\u0015=\u001f?\u0013");
        }
        if (a2 instanceof c_vc) {
            return LogEntryDto.m_hi((Object)".\u0003\u000f\t\t\u0014\u001f\u0003\\\b\u0013\u0012\\\u0000\u0013\u0013\u0012\u0002");
        }
        if (a2 instanceof c_rc) {
            return CheckedAlarm.m_hi((Object)"$,\u001a(\u0002,\u0012i\u0004,\u0005&\u0003;\u0015,V,\u000e \u0005=\u0005");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return LogEntryDto.m_hi((Object)"\"\u001d\u0012\u001d\u0004\u001d\u0015\u0019F\u001f\t\u0012\u0015\b\u0014\u001d\u000f\u0012\u0012\\\u0010\u0015\t\u0010\u0007\b\u000f\u0013\b");
        }
        if (a2 instanceof TransactionSystemException) {
            return CheckedAlarm.m_hi((Object)"\r\u0017=\u0017+\u0017:\u0013i\u0002;\u0017'\u0005(\u0015=\u001f&\u0018i\u0013;\u0004&\u0004");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return LogEntryDto.m_hi((Object)"(\u000f\u0011\u0003\\\u0015\u0019\u0014\u0015\u0003\u000fF\u0018\u0007\b\u0007\u001e\u0007\u000f\u0003\\\u0003\u000e\u0014\u0013\u0014");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return CheckedAlarm.m_hi((Object)"7*\u0015,\u0005:V-\u0013'\u001f,\u0012");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return LogEntryDto.m_hi((Object)"/\u0012\u0010\u001d\n\u0015\u0002\\\u000f\u0012\u0016\t\u0012");
        }
        if (a2 instanceof ConstraintViolationException) {
            return CheckedAlarm.m_hi((Object)" (\u001a \u0012(\u0002 \u0019'V*\u0019'\u0005=\u0004(\u001f'\u0002i\u0000 \u0019%\u0017=\u001f&\u0018");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return LogEntryDto.m_hi((Object)"5\b\n\u0007\u0010\u000f\u0018F\u000e\u0003\r\u0013\u0019\u0015\bF\u001a\t\u000e\u000b\u001d\u0012");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return CheckedAlarm.m_hi((Object)"\u0004\u001f:\u0005 \u0018.V;\u00138\u0003 \u0004,\u0012i\u0006(\u0004(\u001b,\u0002,\u0004");
        }
        if (a2 instanceof IllegalStateException) {
            return LogEntryDto.m_hi((Object)"/\u0012\u0010\u001d\n\u0015\u0002\\\u0007\f\u0016\u0010\u000f\u001f\u0007\b\u000f\u0013\b\\\u0015\b\u0007\b\u0003");
        }
        return CheckedAlarm.m_hi((Object)"\b\u0018i\u0003'\u00131\u0006,\u0015=\u0013-V,\u0004;\u0019;V&\u0015*\u0003;\u0004,\u0012");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleAllExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), a, B);
        D.error(LogEntryDto.m_hi((Object)")\b\u0019\u001e\f\u0003\u001f\u0012\u0019\u0002\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, I);
        D.error(CheckedAlarm.m_hi((Object)"\u0004\u0013:\u0005(\u0011,V'\u0019=V;\u0013(\u0012(\u0014%\u0013sV2\u000b"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, a);
        D.error(LogEntryDto.m_hi((Object)"/\u0010\n\u0019\u0001\u001d\n\\\u0015\b\u0007\b\u0003FF\u0007\u001b"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={c_vc.class, EntityNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    protected ResponseEntity<Object> handleEntityNotFound(Exception a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.NOT_FOUND, a.getMessage(), a, h);
        D.error(CheckedAlarm.m_hi((Object)"\f\u0018=\u001f=\u000fi\u0018&\u0002i\u0010&\u0003'\u0012sV2\u000b"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.NOT_FOUND);
    }

    private /* synthetic */ boolean isDevelopment() {
        GeneralExceptionHandler a;
        String[] stringArray = new String[2];
        stringArray[0] = CheckedAlarm.m_hi((Object)"\u0012,\u0000");
        stringArray[1] = LogEntryDto.m_hi((Object)"\b\u0003\u000f\u0012");
        return Arrays.asList(stringArray).contains(a.b);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, f);
        D.error(CheckedAlarm.m_hi((Object)"\r\u0017=\u0017i\u001f'\u0002,\u0011;\u001f=\u000fi\u0000 \u0019%\u0017=\u001f&\u0018sV2\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={c_jf.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleNotActive(c_jf a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, C);
        D.error(LogEntryDto.m_hi((Object)"2\t\bF\u001d\u0005\b\u000f\n\u0003\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, I);
        D.error(CheckedAlarm.m_hi((Object)"\u0000\u001a%\u0013.\u0017%V(\u0004.\u0003$\u0013'\u0002sV2\u000b"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = ex.getParameterName();
        objectArray[1] = ex.getParameterType();
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, String.format(LogEntryDto.m_hi((Object)"4\u0019\u0017\t\u000f\u000e\u0003\u0018F\f\u0007\u000e\u0007\u0011\u0003\b\u0003\u000eF[C\u000fA\\\t\u001aF\b\u001f\f\u0003\\AY\u0015[F\u0015\u0015\\\u000b\u0015\u0015\u000f\u000f\u0012\u0001"), objectArray), (Exception)ex, I);
        D.error(CheckedAlarm.m_hi((Object)"; \u0005:\u001f'\u0011i\u0006(\u0004(\u001b,\u0002,\u0004sV2\u000b"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    protected ResponseEntity<Object> handleSecurityExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.FORBIDDEN, a.getMessage(), a, k);
        D.error(LogEntryDto.m_hi((Object)"/\u0003\u001f\u0013\u000e\u000f\b\u001f\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, f);
        D.error(CheckedAlarm.m_hi((Object)"?'\u0010%\u000312\u000bV$\u00179\u0006,\u0004i\u0013;\u0004&\u0004sV2\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> a2) {
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)CheckedAlarm.m_hi((Object)"eV"), (Iterable)a.getValue())).collect(Collectors.joining(LogEntryDto.m_hi((Object)"F\u0000F")));
    }

    @ExceptionHandler(value={c_ha.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInscadaException(c_ha a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, a);
        D.error(CheckedAlarm.m_hi((Object)"?'\u0005*\u0017-\u0017i\u0013;\u0004&\u0004sV2\u000b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={c_rc.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleRelationExists(c_rc a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, i);
        D.error(LogEntryDto.m_hi((Object)"4\u0019\n\u001d\u0012\u0015\t\u0012F\u0019\u001e\u0015\u0015\b\u0015\\\u0003\u000e\u0014\u0013\u0014FF\u0007\u001b"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }
}

