/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_cha;
import com.inscada.mono.cluster.m.c_oga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.fs.model.FileResult;
import com.inscada.mono.impexp.restcontrollers.ImportExportController;
import com.inscada.mono.job.a.c_dm;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.script.enums.c_ll;
import com.inscada.mono.script.enums.c_of;
import com.inscada.mono.script.events.CancelEvent;
import com.inscada.mono.script.events.RescheduleEvent;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_ko;
import com.inscada.mono.script.services.c_pe;
import com.inscada.mono.script.services.c_qd;
import com.inscada.mono.shared.exceptions.c_jf;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener {
    private final Lock J;
    private final c_qd G;
    public static final short H = 301;
    private final JedisPooled D;
    public static final short l = 305;
    public static final short F = 303;
    public static final short a = 306;
    private static final Logger f = LoggerFactory.getLogger(ScriptManager.class);
    public static final short c = 307;
    private final ClusterOperations I;
    private final c_ko h;
    public static final short A = 302;
    private final Map<Integer, Job> C;
    private final c_dm B;
    private final c_ye k;
    private static final String i = "scheduled_scripts";
    public static final short b = 304;

    @Order(value=1)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            Integer n = a.getProject().getId();
            f.info(FileResult.m_hi((Object)"\u001ct\u0011u\u0015cj\u0011\u0018P>U<X>Vpa\"^:T3E\u0014T1R$X&P$T\u0015G5_$\u00116^\"\u0011 C?[5R$\u0011\u0019uj\u0011+L"), (Object)n);
            a2.cancelScriptsByProjectIdInternal(n);
            return;
        }
        f.debug(ImportExportController.m_hi((Object)"rwr\u0015p}}|yj\u0006\u0018u_RWNQR_\u001chNWV]_Lx]][HQJYH]yNYVH\u0018ZWN\u0018LJSRY[H\u0018u|\u0006\u0018GE"), (Object)a.getProject().getId());
    }

    protected c_of getScriptStatusInternal(Integer a) {
        ScriptManager a2;
        if (a2.C.containsKey(a)) {
            return c_of.k;
        }
        return c_of.b;
    }

    protected void cancelScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.cancelScriptInternal(scriptManager.G.m_gj(a));
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            RepeatableScript repeatableScript = a.getScript();
            f.info(FileResult.m_hi((Object)"\u001ct\u0011u\u0015cj\u0011\u0018P>U<X>Vpr1_3T<t&T>EpW?CpB3C9A$\u000bpJ-\u0011xx\u0014\u000bpJ-\u0018"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            a2.cancelScriptInternal(repeatableScript);
            return;
        }
        f.debug(ImportExportController.m_hi((Object)"vsv\u0011tyyx}n\u0002\u001cq[VSJUV[\u0018\u007fYR[YTyNYVH\u0018ZWN\u0018O[NQLL\u0006\u0018GE"), (Object)a.getScript().getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.I.addListener((ClusterNodeListener)a);
        f.info(FileResult.m_hi((Object)"\u0003R\"X E\u001dP>P7T\"\u00119_9E9P<X*T4\u00111_4\u0011\"T7X#E5C5UpP#\u0011\u0013]%B$T\"\u007f?U5}9B$T>T\"\u001f"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        String string = scriptManager.I.getCurrentNode().getNodeId();
        f.info(ImportExportController.m_hi((Object)"k_JUHHu]V]_YJ\u0006\u0018hPUK\u001cVS\\Y\u0018\u0014CA\u0011\u001cP]K\u001cZY[SUY\u0018HPY\u0018p}}|yj\u0012\u0018n]OLSJUV[\u0018O[T]XMP]X\u0018O[NQLLO\u0016\u0012\u0016"), (Object)string);
        scriptManager.J.lock();
        try {
            Set set = a2.D.smembers(i).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                f.info(FileResult.m_hi((Object)"\u0003R\"X E\u001dP>P7T\"\u0011x}5P4T\"\u0011+Ly\u000bp\u007f?\u0011#R8T4D<T4\u0011#R\"X E#\u00116^%_4\u00119_pc5U9BpE?\u0011\"T#E?C5\u001f"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            f.info(ImportExportController.m_hi((Object)"o[NQLLqYRY[]N\u0018\u0014tYYX]N\u0018GE\u0015\u0002\u001c~SMR\\\u001cCA\u0018O[T]XMP]X\u0018O[NQLL\u001cqxK\u001cQR\u0018n]XQO\u0018HW\u001cJYKHWN]\u0006\u0018GE"), objectArray);
            ArrayList arrayList = new ArrayList(a2.G.m_qk(set));
            f.info(FileResult.m_hi((Object)"\u0003R\"X E\u001dP>P7T\"\u0011x}5P4T\"\u0011+Ly\u000bpp$E5\\ E9_7\u0011$^pC5B$^\"TpJ-\u0011#R\"X E#\u001f"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ScriptManager a2;
                String string = a2.I.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    f.info(FileResult.m_hi((Object)"\u0003R\"X E\u001dP>P7T\"\u0011x}5P4T\"\u0011+Ly\u000bpc5B$^\"X>VpB3C9A$\u000bpJ-\u0011xx\u0014\u000bpJ-\u0018"), objectArray);
                    a2.scheduleScriptInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.k.m_rea(a.getProject()).m_w("Script Restore (Leader " + string + ")", String.format(ImportExportController.m_hi((Object)"\u0019K\u001c\u0010u|\u0006\u0018\u0019\\\u0015\u0018ZYUTY\\\u001cLS\u0018N]OLSJY\u0016\u001c{]MO]\u0006\u0018\u0019K"), objectArray));
                    try {
                        f.warn(FileResult.m_hi((Object)"\u0003R\"X E\u001dP>P7T\"\u0011x}5P4T\"\u0011+Ly\u000bpp$E5\\ E9_7\u0011$^pR1_3T<\u0011#R\"X EpJ-\u00111W$T\"\u0011\"T#E?C1E9^>\u00116P9]%C5\u001f"), (Object)string, (Object)a.getId());
                        a2.cancelScriptInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        f.error(ImportExportController.m_hi((Object)"k_JUHHu]V]_YJ\u001c\u0010p]]\\YJ\u001cCA\u0011\u0006\u0018zYUTY\\\u001cLS\u0018_YR[YT\u001cK_JUHH\u0018GE\u001cYZLYJ\u001cJYKHWNYHQSV\u001c^]QPMN]\u0006\u0018GE"), objectArray2);
                        return;
                    }
                }
            });
            f.info(ImportExportController.m_hi((Object)"k_JUHHu]V]_YJ\u001c\u0010p]]\\YJ\u001cCA\u0011\u0006\u0018zQRQOPY\\\u001cK_JUHH\u0018N]OLSJ]LUWR\u0018LJS[YKO\u0016"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            f.error(FileResult.m_hi((Object)"\u0003R\"X E\u001dP>P7T\"\u0011x}5P4T\"\u0011+Ly\u000bpt\"C?CpU%C9_7\u0011#R\"X EpC5B$^\"P$X?_pA\"^3T#Bj\u0011+L"), objectArray);
            return;
        }
        finally {
            a2.J.unlock();
        }
    }

    protected void scheduleScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_cha.m_pcc(() -> {
            ScriptManager a2;
            a2.J.lock();
            try {
                Job job;
                ScriptManager scriptManager;
                block14: {
                    a2.cancelScriptInternal(a);
                    if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                        throw new c_jf("Project should be active to schedule script " + a.getName());
                    }
                    switch (c_pe.b[a.getType().ordinal()]) {
                        case 1: {
                            ScriptManager scriptManager2 = a2;
                            while (false) {
                            }
                            scriptManager = scriptManager2;
                            job = scriptManager2.createDailyScriptJob(a);
                            break block14;
                        }
                        case 2: {
                            ScriptManager scriptManager3 = a2;
                            scriptManager = scriptManager3;
                            job = scriptManager3.createPeriodicScriptJob(a);
                            break block14;
                        }
                        case 3: {
                            job = a2.createOnceScriptJob(a);
                            break;
                        }
                        case 4: {
                            return;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                        }
                    }
                    scriptManager = a2;
                }
                scriptManager.C.put(a.getId(), job);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.D.sadd(i, stringArray);
                return;
            }
            finally {
                a2.J.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_of getScriptStatus(Integer a, String a2) {
        ScriptManager a3;
        if ((a = a3.G.m_ud(a, a2)) == null) {
            return c_of.b;
        }
        return a3.getScriptStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_of getScriptStatus(Integer a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            f.debug(ImportExportController.m_hi((Object)"tyyx}n\u0002\u001c\u007fYLHQR_\u001cK_JUHH\u0018OL]LIK\u001c^SJ\u001cCA\u0018PW_YPTE\u0016"), (Object)a);
            return a2.getScriptStatusInternal(a);
        }
        f.debug(FileResult.m_hi((Object)"\u007f\u001f\u007f}}\u0015p\u0014t\u0002\u000bpc5@%T#E9_7\u0011<T1U5CpW?CpB3C9A$\u0011#E1E%BpW?CpJ-\u001f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_of)a2.I.callLeaderMethod(Short.valueOf((short)303), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get script status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            f.debug(ImportExportController.m_hi((Object)"tyyx}n\u0002\u001ck_PY\\ITUV[\u0018O[NQLL\u001cCA\u0018PW_YPTE\u0016"), (Object)a);
            a2.scheduleScriptInternal(a);
            return;
        }
        f.debug(FileResult.m_hi((Object)"\u001e~\u001e\u001c\u001ct\u0011u\u0015cj\u0011\u0002T!D5B$X>Vp]5P4T\"\u0011$^pB3Y5U%]5\u0011#R\"X EpJ-\u001f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)301), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC schedule script " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            f.debug(ImportExportController.m_hi((Object)"tyyx}n\u0002\u001c{]V_]PTUV[\u0018O[NQLL\u001cCA\u0018PW_YPTE\u0016"), (Object)a);
            a2.cancelScriptInternal(a);
            return;
        }
        f.debug(FileResult.m_hi((Object)"\u001e~\u001e\u001c\u001ct\u0011u\u0015cj\u0011\u0002T!D5B$X>Vp]5P4T\"\u0011$^pR1_3T<\u0011#R\"X EpJ-\u001f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)302), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC cancel script " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createDailyScriptJob(RepeatableScript a) {
        ScriptManager a2;
        Comparable<Date> comparable = a.getTime();
        comparable = LocalTime.of(comparable.getHours(), comparable.getMinutes(), comparable.getSeconds());
        return a2.B.m_kha(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.h.m_tk((Script)a);
        }, (LocalTime)comparable);
    }

    protected void cancelScriptsByProjectIdInternal(Integer a) {
        ScriptManager a2;
        if ((a = a2.G.m_hd((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_of> getScriptStatuses(Integer a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            f.debug(ImportExportController.m_hi((Object)"tyyx}n\u0002\u001c\u007fYLHQR_\u001cYPT\u001cK_JUHH\u0018OL]LIKYK\u001c^SJ\u001cHNWV]_L\u001cCA\u0018PW_YPTE\u0016"), (Object)a);
            return a2.getScriptStatusesByProjectIdInternal(a);
        }
        f.debug(FileResult.m_hi((Object)"\u007f\u001f\u007f}}\u0015p\u0014t\u0002\u000bpc5@%T#E9_7\u0011<T1U5CpW?CpP<]pB3C9A$\u0011#E1E%B5BpW?CpA\"^:T3EpJ-\u001f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)307), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(Integer a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            f.debug(ImportExportController.m_hi((Object)"p}}|yj\u0006\u0018o[T]XMPQR_\u001cYPT\u001cK_JUHHK\u001c^SJ\u001cHNWV]_L\u001cCA\u0018PW_YPTE\u0016"), (Object)a);
            a2.scheduleScriptsByProjectIdInternal(a);
            return;
        }
        f.debug(FileResult.m_hi((Object)"\u007f\u001f\u007f}}\u0015p\u0014t\u0002\u000bpc5@%T#E9_7\u0011<T1U5CpE?\u0011#R8T4D<TpP<]pB3C9A$BpW?CpA\"^:T3EpJ-\u001f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)304), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC schedule scripts for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_of> getScriptStatuses(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.I.isLeader()) {
            f.debug(ImportExportController.m_hi((Object)"p}}|yj\u0006\u0018{]HLUV[\u0018O[NQLL\u001cKHYHMO]O\u0018ZWN\u0018GE\u001cqxK\u001cTS[]TPA\u0006\u0018GE"), (Object)a.size(), a);
            return a2.getScriptStatusesByIdsInternal(a);
        }
        f.debug(FileResult.m_hi((Object)"\u001e~\u001e\u001c\u001ct\u0011u\u0015cj\u0011\u0002T!D5B$X>Vp]5P4T\"\u00116^\"\u0011#R\"X EpB$P$D#T#\u00116^\"\u0011+Lpx\u0014Bj\u0011+L"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)306), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ImportExportController.m_hi((Object)"\u0014"))), (Throwable)exception);
        }
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.B.m_cca(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            Script script = Script.newBuilder((RepeatableScript)a).build();
            a2.h.m_tk(script);
            a2.cancelScript(a.getId());
        }, Duration.ofMillis(a.getDelay().intValue()), false);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ScriptManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.I.addRemoteCall((short)301, (Object)a, ScriptManager.class.getDeclaredMethod(FileResult.m_hi((Object)"#R8T4D<T\u0003R\"X E\u0019_$T\"_1]"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.I.addRemoteCall((short)302, (Object)a, ScriptManager.class.getDeclaredMethod(ImportExportController.m_hi((Object)"_YR[YTo[NQLLuVH]NV]T"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.I.addRemoteCall((short)303, (Object)a, ScriptManager.class.getDeclaredMethod(FileResult.m_hi((Object)"V5E\u0003R\"X E\u0003E1E%B\u0019_$T\"_1]"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.I.addRemoteCall((short)304, (Object)a, ScriptManager.class.getDeclaredMethod(ImportExportController.m_hi((Object)"O[T]XMP]o[NQLLOzEhNWV]_Lu\\uVH]NV]T"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.I.addRemoteCall((short)305, (Object)a, ScriptManager.class.getDeclaredMethod(FileResult.m_hi((Object)"3P>R5]\u0003R\"X E#s)a\"^:T3E\u0019U\u0019_$T\"_1]"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.I.addRemoteCall((short)306, (Object)a, ScriptManager.class.getDeclaredMethod(ImportExportController.m_hi((Object)"[]Hk_JUHHkHYHMO]OzEqXKuVH]NV]T"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.I.addRemoteCall((short)307, (Object)a, ScriptManager.class.getDeclaredMethod(FileResult.m_hi((Object)"7T$b3C9A$b$P$D#T#s)a\"^:T3E\u0019U\u0019_$T\"_1]"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(ImportExportController.m_hi((Object)"zYUTY\\\u001cLS\u0018N][QOLYJ\u001ck_JUHHu]V]_YJ\u001cjl{\u001cUYLTWXK"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(Integer a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            f.debug(FileResult.m_hi((Object)"\u001ct\u0011u\u0015cj\u0011\u0013P>R5]<X>VpP<]pB3C9A$BpW?CpA\"^:T3EpJ-\u0011<^3P<])\u001f"), (Object)a);
            a2.cancelScriptsByProjectIdInternal(a);
            return;
        }
        f.debug(ImportExportController.m_hi((Object)"vsv\u0011tyyx}n\u0002\u001cjYII]OLUV[\u0018P]]\\YJ\u001cLS\u0018_YR[YT\u001cYPT\u001cK_JUHHK\u001c^SJ\u001cHNWV]_L\u001cCA\u0016"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)305), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC cancel scripts for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.cancelScript(scriptManager.G.m_dd(a, a2).getId());
    }

    private /* synthetic */ String generateJobName(RepeatableScript a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = a.getType().m_i();
        objectArray[1] = a.getName();
        return String.format(FileResult.m_hi((Object)"uBpb3C9A$\u0011}\u0011uB"), objectArray);
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ScriptManager a2;
        if (a2.I.isLeader()) {
            RepeatableScript repeatableScript = a.getScript();
            f.info(ImportExportController.m_hi((Object)"p}}|yj\u0006\u0018tYR\\PQR_\u001cjYK_PY\\ITY}J]RL\u001c^SJ\u001cK_JUHH\u0002\u001cCA\u0018\u0014qx\u0002\u001cCA\u0011"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            if (a2.getScriptStatusInternal(repeatableScript.getId()) == c_of.k) {
                a2.scheduleScriptInternal(repeatableScript.getId());
                return;
            }
        } else {
            f.debug(FileResult.m_hi((Object)"\u007f\u001f\u007f}}\u0015p\u0014t\u0002\u000bpx7_?C9_7\u0011\u0002T#R8T4D<T\u0015G5_$\u00116^\"\u0011#R\"X Ej\u0011+L"), (Object)a.getScript().getId());
        }
    }

    protected void scheduleScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.scheduleScriptInternal(scriptManager.G.m_gj(a));
    }

    public void notLeader() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        String string = scriptManager.I.getCurrentNode().getNodeId();
        f.info(ImportExportController.m_hi((Object)"o[NQLLqYRY[]N\u0002\u001clTQO\u0018RWX]\u001c\u0010GE\u0015\u0018UK\u001cvs\u0018pwr\u007fyj\u001clt}\u001ctyyx}n\u0016\u001c{]V_]PTUV[\u0018]TP\u0018PW_YP\u0018O[NQLL\u001cRSZO\u0016\u0012\u0016"), (Object)string);
        scriptManager.J.lock();
        try {
            new ArrayList(a.C.keySet()).forEach(a2 -> {
                ScriptManager a3;
                Job job = (Job)a3.C.get(a2);
                if (job != null) {
                    try {
                        f.info(FileResult.m_hi((Object)"b3C9A$|1_1V5Cp\u0019\u001e^$\u0011\u001cT1U5CpJ-\u0018j\u0011\u0013P>R5]<X>Vp]?R1]p[?SpW?CpB3C9A$\u0011\u0019uj\u0011+L"), (Object)string, a2);
                        a3.B.m_oda(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        f.error(ImportExportController.m_hi((Object)"o[NQLLqYRY[]N\u0018\u0014vSL\u001ctYYX]N\u0018GE\u0015\u0002\u001c}NJSJ\u001c[]V_]PTUV[\u0018PW_YP\u0018VW^\u0018ZWN\u0018O[NQLL\u001cqx\u0018GE\u0006\u0018GE"), objectArray);
                    }
                }
            });
            a.C.clear();
            f.info(FileResult.m_hi((Object)"b3C9A$|1_1V5Cp\u0019\u001e^$\u0011\u001cT1U5CpJ-\u0018j\u0011\u0011]<\u0011<^3P<\u0011#R\"X Ep[?S#\u00118P&TpS5T>\u0011\"T!D5B$T4\u0011$^pR1_3T<\u00111_4\u00113]5P\"T4\u00116C?\\p]?R1]pE\"P3Z9_7\u001f"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            f.error(ImportExportController.m_hi((Object)"k_JUHHu]V]_YJ\u001c\u0010rWH\u0018p]]\\YJ\u001cCA\u0011\u0006\u0018yJNWN\u0018XMNQR_\u001cHNW_]OK\u001cWZ\u0018_YR[YTPQR_\u001cTS[]T\u001cK_JUHH\u0018VW^K\u0006\u0018GE"), objectArray);
            return;
        }
        finally {
            a.J.unlock();
        }
    }

    protected void cancelScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_cha.m_pcc(() -> {
            ScriptManager a2;
            a2.J.lock();
            try {
                Job job = (Job)a2.C.get(a.getId());
                if (job != null) {
                    a2.B.m_oda(job);
                }
                ScriptManager scriptManager = a2;
                scriptManager.C.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                scriptManager.D.srem(i, stringArray);
                return;
            }
            finally {
                a2.J.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected void scheduleScriptsByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.G.m_hd((Integer)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> a.getType() != c_ll.i).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    public ScriptManager(c_qd a, c_dm a2, c_ko a3, c_ye a4, JedisPooled a5, ClusterOperations a6) {
        ScriptManager a7;
        ScriptManager scriptManager = a7;
        ScriptManager scriptManager2 = a7;
        ScriptManager scriptManager3 = a7;
        ScriptManager scriptManager4 = a7;
        a7.J = new ReentrantLock();
        scriptManager4.C = new ConcurrentHashMap();
        scriptManager3.G = a;
        scriptManager3.B = a2;
        scriptManager2.h = a3;
        scriptManager2.k = a4;
        scriptManager.D = a5;
        scriptManager.I = a6;
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.B.m_waa(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.h.m_tk((Script)a);
        }, Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    protected Map<Integer, c_of> getScriptStatusesByIdsInternal(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    protected Map<Integer, c_of> getScriptStatusesByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.G.m_rk((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, a -> {
            ScriptManager a2;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.scheduleScript(scriptManager.G.m_dd(a, a2).getId());
    }
}

