/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.restcontrollers;

import com.inscada.mono.animation.messages.AnimationResultsMessage;
import com.inscada.mono.animation.model.ScriptDto;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.script.enums.c_of;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.services.ScriptManager;
import com.inscada.mono.script.services.c_ko;
import com.inscada.mono.script.services.c_qd;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/scripts"})
public class ScriptController
extends ProjectBasedImportExportController {
    private final c_ko k;
    private final c_qd i;
    private final ScriptManager b;

    @GetMapping
    public Collection<RepeatableScript> getScripts(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.i.m_da();
        }
        return this.i.m_oa(a);
    }

    public ScriptController(c_qd a, ScriptManager a2, c_ko a3, c_ff a4, c_pg a5) {
        ScriptController a6;
        ScriptController scriptController = a6;
        super(a4, EnumSet.of(c_bh.P), a5);
        a6.i = a;
        scriptController.b = a2;
        scriptController.k = a3;
    }

    @PostMapping(value={"/runner"})
    public Object runScript(@RequestBody ScriptDto a) {
        return this.k.m_ye(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.b.scheduleScripts(a);
    }

    @PostMapping(value={"/{scriptId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="scriptId") Integer a) {
        this.b.scheduleScript(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_of> getScriptStatuses(@RequestParam(value="scriptIds") Integer[] a) {
        return this.b.getScriptStatuses(List.of(a));
    }

    @DeleteMapping(value={""}, params={"scriptIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScriptsByIds(@RequestParam(value="scriptIds") Integer[] a) {
        this.i.m_cf(List.of(a));
    }

    @PostMapping
    public ResponseEntity<RepeatableScript> createScript(@Valid @RequestBody RepeatableScript script, UriComponentsBuilder a) {
        script = this.i.m_sf(script);
        Object[] objectArray = new Object[1];
        objectArray[0] = script.getId();
        return ResponseEntity.created((URI)a.path(AnimationResultsMessage.m_hi((Object)"\u0010}LeMoOrvbB")).buildAndExpand(objectArray).toUri()).body((Object)script);
    }

    @DeleteMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScript(@PathVariable(value="scriptId") Integer a) {
        this.i.m_qa(a);
    }

    @GetMapping(value={"/{scriptId}/status"})
    public c_of getScriptStatus(@PathVariable(value="scriptId") Integer a) {
        return this.b.getScriptStatus(a);
    }

    @PutMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScript(@PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody RepeatableScript a) {
        this.i.m_pe(scriptId, a);
    }

    @PatchMapping(value={"/{scriptId}/code"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScriptCode(@PathVariable(value="scriptId") Integer scriptId, @RequestBody String a) {
        this.i.m_lf(scriptId, a);
    }

    @PostMapping(value={"/{scriptId}/run"})
    public Object runScript(@PathVariable(value="scriptId") Integer a) {
        return this.k.m_cj(a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.b.cancelScripts(a);
    }

    @PostMapping(value={"/{scriptId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="scriptId") Integer a) {
        this.b.cancelScript(a);
    }

    @GetMapping(value={"/{scriptId}"})
    public RepeatableScript getScript(@PathVariable(value="scriptId") Integer a) {
        return this.i.m_ba(a);
    }

    @GetMapping(value={"/summary"})
    public Collection<RepeatableScriptSummary> getScriptsSummary(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.i.m_im();
        }
        return this.i.m_ad(a);
    }
}

