/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.script.enums.c_ll;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="script")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class RepeatableScript
extends OwnedSpaceBaseModel {
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Id
    @Column(name="script_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="repeatableScriptSeq")
    @GenericGenerator(name="repeatableScriptSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="script_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Min(value=100L)
    private Integer period;
    @NotNull
    @Column(name="log_flag")
    private Boolean log;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm")
    @Temporal(value=TemporalType.TIME)
    @Column(name="sch_time")
    private Date time;
    @NotBlank
    private String code;
    @Min(value=0L)
    private Integer delay;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Min(value=0L)
    @Max(value=59L)
    @Column(name="off_set")
    private Integer offset;
    @NotNull
    @Column(name="sch_type")
    private c_ll type;
    @Size(max=255)
    private String dsc;

    public void setTime(Date a) {
        a.time = a;
    }

    public void setOffset(Integer a) {
        a.offset = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setType(c_ll a) {
        a.type = a;
    }

    public RepeatableScript() {
        RepeatableScript a;
    }

    public Integer getPeriod() {
        RepeatableScript a;
        return a.period;
    }

    public Project getProject() {
        RepeatableScript a;
        return a.project;
    }

    public void setProject(Project a) {
        RepeatableScript a2;
        RepeatableScript repeatableScript = a2;
        repeatableScript.project = a;
        repeatableScript.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setPeriod(Integer a) {
        a.period = a;
    }

    public c_ll getType() {
        RepeatableScript a;
        return a.type;
    }

    public void setCode(String a) {
        a.code = a;
    }

    public boolean equals(Object a) {
        RepeatableScript a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof RepeatableScript)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (RepeatableScript)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public Integer getOffset() {
        RepeatableScript a;
        return a.offset;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public Integer getProjectId() {
        RepeatableScript a;
        return a.projectId;
    }

    public Date getTime() {
        RepeatableScript a;
        return a.time;
    }

    public String getCode() {
        RepeatableScript a;
        return a.code;
    }

    public Integer getDelay() {
        RepeatableScript a;
        return a.delay;
    }

    public int hashCode() {
        RepeatableScript a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getDsc() {
        RepeatableScript a;
        return a.dsc;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setDelay(Integer a) {
        a.delay = a;
    }

    public String getName() {
        RepeatableScript a;
        return a.name;
    }

    public Integer getId() {
        RepeatableScript a;
        return a.id;
    }

    public void setLog(Boolean a) {
        a.log = a;
    }

    public Boolean getLog() {
        RepeatableScript a;
        return a.log;
    }
}

