/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.auth.c_cha;
import com.inscada.mono.cluster.m.c_oga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.communication.protocols.opcua.model.Tree;
import com.inscada.mono.job.a.c_dm;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.report.enums.c_oi;
import com.inscada.mono.report.enums.c_yk;
import com.inscada.mono.report.events.CancelEvent;
import com.inscada.mono.report.events.RescheduleEvent;
import com.inscada.mono.report.model.DeviationReportVariable;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.services.c_gh;
import com.inscada.mono.report.services.c_rm;
import com.inscada.mono.shared.exceptions.c_ha;
import com.inscada.mono.shared.exceptions.c_jf;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
implements ClusterNodeListener {
    private final c_ye J;
    public static final short G = 501;
    private static final String H = "scheduledReports";
    private final c_gh D;
    public static final short l = 502;
    private final c_rm F;
    private final ClusterOperations a;
    private static final Logger f = LoggerFactory.getLogger(ReportManager.class);
    public static final short c = 505;
    public static final short I = 503;
    public static final short h = 506;
    private final Lock A;
    public static final short C = 504;
    private final JedisPooled B;
    private final Map<Integer, List<Job>> k;
    private final c_dm i;
    public static final short b = 507;

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<Integer, c_oi> getReportStatuses(Integer a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            f.debug(DeviationReportVariable.m_hi((Object)"I\u0016D\u0017@\u0001?sB6q'l=bsd?isw6u<w'% q2q&v6vsc<wsu!j9`0qs~.%?j0d?i*+"), (Object)a);
            return a2.getReportStatusesByProjectIdInternal(a);
        }
        f.debug(Tree.m_hi((Object)"}\u001d}\u007f\u007f\u0017r\u0016v\u0000\tra7B'V!G;]5\u0013>V3W7ArU=ArR>_rA7C=A&\u0013!G3G'@7@rU=ArC \\8V1GrH/\u001d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.a.callLeaderMethod(Short.valueOf((short)507), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @Order(value=3)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            Integer n = a.getProject().getId();
            f.info(DeviationReportVariable.m_hi((Object)"\u001f@\u0012A\u0016Wi%\u001bd=a?l=bsU!j9`0q\u0017`2f'l%d'`\u0016s6k'%5j!%#w<o6f'%\u001aAi%(x"), (Object)n);
            a2.cancelReportsByProjectIdInternal(n);
            return;
        }
        f.debug(Tree.m_hi((Object)"\u001c|\u001c\u001e\u001ev\u0013w\u0017ah\u0013\u001bT<\\ Z<Trc \\8V1G\u0016V3P&Z$R&V\u0017E7]&\u00134\\ \u0013\"A=Y7P&\u0013\u001bwh\u0013)N"), (Object)a.getProject().getId());
    }

    protected void scheduleReportInternal(Report a) {
        ReportManager a2;
        c_cha.m_pcc(() -> a2.lambda$scheduleReportInternal$2(a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_oi getReportStatus(Integer a, String a2) {
        ReportManager a3;
        if ((a = a3.F.m_ud(a, a2)) == null) {
            return c_oi.b;
        }
        return a3.getReportStatus(a.getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        ReportManager reportManager = a;
        reportManager.registerRemoteCallsWithClusterNode();
        reportManager.a.addListener((ClusterNodeListener)a);
        f.info(DeviationReportVariable.m_hi((Object)"\u0001`#j!q\u001ed=d4`!%:k:q:d?l)`7%2k7%!`4l q6w6asd %\u0010i&v'`!K<a6I:v'`=`!+"));
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            Report report = a.getReport();
            f.info(Tree.m_hi((Object)"\u001ev\u0013w\u0017ah\u0013\u001aR<W>Z<Tra7@1[7W'_7v$V<GrU=ArA7C=A&\trH/\u0013zz\u0016\trH/\u001a"), (Object)report.getName(), (Object)report.getId());
            if (a2.getReportStatusInternal(report.getId()) == c_oi.B) {
                a2.scheduleReportInternal(report.getId());
                return;
            }
        } else {
            f.debug(DeviationReportVariable.m_hi((Object)"K\u001cK~I\u0016D\u0017@\u0001?sL4k<w:k4%\u0001` f;`7p?`\u0016s6k'%5j!%!`#j!qi%(x"), (Object)a.getReport().getId());
        }
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report a) {
        ReportManager a2;
        return a2.i.m_kha(a.getProject(), "Report Print - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(5, -1);
            Date date = calendar.getTime();
            a2.D.m_cy(a.getId(), date, (Date)comparable, true, a.getLang());
        }, LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(Integer a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            f.debug(Tree.m_hi((Object)"\u001ev\u0013w\u0017ah\u0013\u0001P:V6F>Z<TrR>_rA7C=A&@rU=ArC \\8V1GrH/\u0013>\\1R>_+\u001d"), (Object)a);
            a2.scheduleReportsByProjectIdInternal(a);
            return;
        }
        f.debug(DeviationReportVariable.m_hi((Object)"K\u001cK~I\u0016D\u0017@\u0001?sW6t&` q:k4%?`2a6wsq<% f;`7p?`sd?isw6u<w'vsc<wsu!j9`0qs~.+"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.a.callLeaderMethod(Short.valueOf((short)504), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC schedule reports for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            Report report = a.getReport();
            f.info(Tree.m_hi((Object)"\u001ev\u0013w\u0017ah\u0013\u001aR<W>Z<Trp3]1V>v$V<GrU=ArA7C=A&\trH/\u0013zz\u0016\trH/\u001a"), (Object)report.getName(), (Object)report.getId());
            a2.cancelReportInternal(report);
            return;
        }
        f.debug(DeviationReportVariable.m_hi((Object)"K\u001cK~I\u0016D\u0017@\u0001?sL4k<w:k4%\u0010d=f6i\u0016s6k'%5j!%!`#j!qi%(x"), (Object)a.getReport().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ReportManager a2;
        ReportManager reportManager = a2;
        String string = reportManager.a.getCurrentNode().getNodeId();
        f.info(Tree.m_hi((Object)"a7C=A&~3]3T7Ah\u0013\u0006[;@r]=W7\u0013zH/\u001ar[3@rQ7P=^7\u0013&[7\u0013\u001ev\u0013w\u0017a|\u0013\u0000V!G=A;]5\u0013!P:V6F>V6\u0013 V\"\\ G!\u001d|\u001d"), (Object)string);
        reportManager.A.lock();
        try {
            Set set = a2.B.smembers(H).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                f.info(DeviationReportVariable.m_hi((Object)"\u0001`#j!q\u001ed=d4`!%{I6d7`!%(xz?sK<% f;`7p?`7%!`#j!q %5j&k7%:ksW6a:vsq<%!` q<w6+"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            f.info(Tree.m_hi((Object)"\u0000V\"\\ G\u001fR<R5V \u0013z\u007f7R6V \u0013)N{\tru=F<WrH/\u0013!P:V6F>V6\u0013 V\"\\ Grz\u0016@rZ<\u0013\u0000V6Z!\u0013&\\rA7@&\\ Vh\u0013)N"), objectArray);
            ArrayList arrayList = new ArrayList(a2.F.m_qk(set));
            f.info(DeviationReportVariable.m_hi((Object)"\u0001`#j!q\u001ed=d4`!%{I6d7`!%(xz?sD'q6h#q:k4%'jsw6v'j!`s~.%!`#j!q +"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ReportManager a2;
                String string = a2.a.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    f.info(DeviationReportVariable.m_hi((Object)"\u0001`#j!q\u001ed=d4`!%{I6d7`!%(xz?sW6v'j!l=bsw6u<w'?s~.%{L\u0017?s~.,"), objectArray);
                    a2.scheduleReportInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.J.m_rea(a.getProject()).m_w("Report Restore (Leader " + string + ")", String.format(Tree.m_hi((Object)"w@r\u001b\u001bwh\u0013wW{\u00134R;_7WrG=\u0013 V!G=A7\u001drp3F!Vh\u0013w@"), objectArray));
                    try {
                        f.warn(DeviationReportVariable.m_hi((Object)"\u0001`#j!q\u001ed=d4`!%{I6d7`!%(xz?sD'q6h#q:k4%'jsf2k0`?%!`#j!qs~.%2c'`!%!` q<w2q:j=%5d:i&w6+"), (Object)string, (Object)a.getId());
                        a2.cancelReportInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        f.error(Tree.m_hi((Object)"a7C=A&~3]3T7Ar\u001b\u001eV3W7ArH/\u001ah\u0013\u0014R;_7WrG=\u00131R<P7_rA7C=A&\u0013)NrR4G7ArA7@&\\ R&Z=]rU3Z>F Vh\u0013)N"), objectArray2);
                        return;
                    }
                }
            });
            f.info(Tree.m_hi((Object)"a7C=A&~3]3T7Ar\u001b\u001eV3W7ArH/\u001ah\u0013\u0014Z<Z![7WrA7C=A&\u0013 V!G=A3G;\\<\u0013\"A=P7@!\u001d"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            f.error(DeviationReportVariable.m_hi((Object)"\u0001`#j!q\u001ed=d4`!%{I6d7`!%(xz?s@!w<wsa&w:k4%!`#j!qsw6v'j!d'l<ksu!j0` vi%(x"), objectArray);
            return;
        }
        finally {
            a2.A.unlock();
        }
    }

    protected Map<Integer, c_oi> getReportStatusesByIdsInternal(List<Integer> a) {
        ReportManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(Integer a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            f.debug(Tree.m_hi((Object)"\u001ev\u0013w\u0017ah\u0013\u0011R<P7_>Z<TrR>_rA7C=A&@rU=ArC \\8V1GrH/\u0013>\\1R>_+\u001d"), (Object)a);
            a2.cancelReportsByProjectIdInternal(a);
            return;
        }
        f.debug(DeviationReportVariable.m_hi((Object)"K\u001cK~I\u0016D\u0017@\u0001?sW6t&` q:k4%?`2a6wsq<%0d=f6isd?isw6u<w'vsc<wsu!j9`0qs~.+"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.a.callLeaderMethod(Short.valueOf((short)505), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC cancel reports for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report a) {
        ReportManager a2;
        return a2.i.m_kha(a.getProject(), "Report Mail - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(5, -1);
            Date date = calendar.getTime();
            a2.D.m_lx(a.getId(), date, (Date)comparable, true, a.getLang());
        }, LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    public void notLeader() {
        ReportManager a;
        ReportManager reportManager = a;
        String string = reportManager.a.getCurrentNode().getNodeId();
        f.info(Tree.m_hi((Object)"\u0000V\"\\ G\u001fR<R5V \trg:Z!\u0013<\\6Vr\u001b)N{\u0013;@r}\u001d\u0013\u001e|\u001ct\u0017arg\u001avr\u007f\u0017r\u0016v\u0000\u001drp3]1V>_;]5\u00133_>\u0013>\\1R>\u0013 V\"\\ GrY=Q!\u001d|\u001d"), (Object)string);
        reportManager.A.lock();
        try {
            new ArrayList(a.k.keySet()).forEach(a2 -> {
                ReportManager a3;
                List list = (List)a3.k.get(a2);
                if (list != null) {
                    try {
                        f.info(DeviationReportVariable.m_hi((Object)"W6u<w'H2k2b6ws-\u001dj'%\u001f`2a6ws~.,i%\u0010d=f6i?l=bsi<f2iso<gsc<wsw6u<w'%\u001aAi%(x"), (Object)string, a2);
                        list.forEach(arg_0 -> ((c_dm)a3.i).m_oda(arg_0));
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        f.error(Tree.m_hi((Object)"\u0000V\"\\ G\u001fR<R5V \u0013z}=Gr\u007f7R6V \u0013)N{\trv A=ArP3]1V>_;]5\u0013>\\1R>\u00138\\0\u00134\\ \u0013 V\"\\ Grz\u0016\u0013)Nh\u0013)N"), objectArray);
                    }
                }
            });
            a.k.clear();
            f.info(DeviationReportVariable.m_hi((Object)"W6u<w'H2k2b6ws-\u001dj'%\u001f`2a6ws~.,i%\u0012i?%?j0d?%!`#j!qso<g %;d%`sg6`=%!`\"p6v'`7%'jsf2k0`?%2k7%0i6d!`7%5w<hsi<f2isq!d0n:k4+"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            f.error(Tree.m_hi((Object)"a7C=A&~3]3T7Ar\u001b\u001c\\&\u0013\u001eV3W7ArH/\u001ah\u0013\u0017A \\ \u00136F Z<TrC \\1V!@r\\4\u00131R<P7_>Z<Tr_=P3_rA7C=A&\u00138\\0@h\u0013)N"), objectArray);
            return;
        }
        finally {
            a.A.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_oi getReportStatus(Integer a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            f.debug(DeviationReportVariable.m_hi((Object)"I\u0016D\u0017@\u0001?sB6q'l=bsw6u<w'% q2q&vsc<wsL\u0017?s~.%?j0d?i*+"), (Object)a);
            return a2.getReportStatusInternal(a);
        }
        f.debug(Tree.m_hi((Object)"}\u001d}\u007f\u007f\u0017r\u0016v\u0000\tra7B'V!G;]5\u0013>V3W7ArU=ArA7C=A&\u0013!G3G'@rU=Arz\u0016\trH/\u001d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_oi)a2.a.callLeaderMethod(Short.valueOf((short)503), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get report transfer status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(Integer a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            f.debug(DeviationReportVariable.m_hi((Object)"I\u0016D\u0017@\u0001?sV0m6a&i:k4%!`#j!qs~.%?j0d?i*+"), (Object)a);
            a2.scheduleReportInternal(a);
            return;
        }
        f.debug(Tree.m_hi((Object)"\u001c|\u001c\u001e\u001ev\u0013w\u0017ah\u0013\u0000V#F7@&Z<Tr_7R6V \u0013&\\r@1[7W'_7\u0013 V\"\\ GrH/\u001d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.a.callLeaderMethod(Short.valueOf((short)501), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC schedule report " + a, (Throwable)exception);
        }
    }

    protected void cancelReportInternal(Integer a) {
        ReportManager a2;
        ReportManager reportManager = a2;
        reportManager.cancelReportInternal(reportManager.F.m_gj(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$2(Report a) {
        a.A.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal(a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new c_jf("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_yk.h ? a.scheduleMonthlyPrintReportJob(a) : a.scheduleDailyPrintReportJob(a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.i.m_oda(var5_7);
                            }
                            throw new c_ha(DeviationReportVariable.m_hi((Object)"C2l?`7%'jsv0m6a&i6%!`#j!q"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_yk.h) break block12;
                    v1 = a.scheduleMonthlyMailReportJob(a);
                    ** GOTO lbl28
                }
                v1 = a.scheduleDailyMailReportJob(a);
lbl28:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.k.put(a.getId(), var2_3);
            v3 = new String[1];
            v3[0] = a.getId().toString();
            v2.B.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.A.unlock();
        }
    }

    protected Map<Integer, c_oi> getReportStatusesByProjectIdInternal(Integer a2) {
        ReportManager a3;
        if ((a2 = a3.F.m_hd((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Report::getId, a -> {
            ReportManager a2;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    protected void cancelReportsByProjectIdInternal(Integer a) {
        ReportManager a2;
        if ((a = a2.F.m_hd((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<Integer, c_oi> getReportStatuses(List<Integer> a) {
        ReportManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.a.isLeader()) {
            f.debug(Tree.m_hi((Object)"\u001ev\u0013w\u0017ah\u0013\u0015V&G;]5\u0013 V\"\\ Gr@&R&F!V!\u00134\\ \u0013)Nrz\u0016@r_=P3_>Jh\u0013)N"), (Object)a.size(), a);
            return a2.getReportStatusesByIdsInternal(a);
        }
        f.debug(DeviationReportVariable.m_hi((Object)"\u001dJ\u001d(\u001f@\u0012A\u0016Wi%\u0001`\"p6v'l=bsi6d7`!%5j!%!`#j!qsv'd'p ` %5j!%(xsL\u0017vi%(x"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.a.callLeaderMethod(Short.valueOf((short)506), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(Tree.m_hi((Object)"\u001f"))), (Throwable)exception);
        }
    }

    protected void scheduleReportInternal(Integer a) {
        ReportManager a2;
        ReportManager reportManager = a2;
        reportManager.scheduleReportInternal(reportManager.F.m_gj(a));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(Integer a, String a2) {
        ReportManager a3;
        ReportManager reportManager = a3;
        reportManager.cancelReport(reportManager.F.m_dd(a, a2).getId());
    }

    protected void scheduleReportsByProjectIdInternal(Integer a) {
        ReportManager a2;
        if ((a = a2.F.m_hd((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    protected c_oi getReportStatusInternal(Integer a) {
        ReportManager a2;
        if (a2.k.containsKey(a)) {
            return c_oi.B;
        }
        return c_oi.b;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ReportManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.a.addRemoteCall((short)501, (Object)a, ReportManager.class.getDeclaredMethod(DeviationReportVariable.m_hi((Object)" f;`7p?`\u0001`#j!q\u001ak'`!k2i"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.a.addRemoteCall((short)502, (Object)a, ReportManager.class.getDeclaredMethod(Tree.m_hi((Object)"1R<P7_\u0000V\"\\ G\u001b]&V ]3_"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.a.addRemoteCall((short)503, (Object)a, ReportManager.class.getDeclaredMethod(DeviationReportVariable.m_hi((Object)"b6q\u0001`#j!q\u0000q2q&v\u001ak'`!k2i"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.a.addRemoteCall((short)504, (Object)a, ReportManager.class.getDeclaredMethod(Tree.m_hi((Object)"!P:V6F>V\u0000V\"\\ G!q+c \\8V1G\u001bW\u001b]&V ]3_"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.a.addRemoteCall((short)505, (Object)a, ReportManager.class.getDeclaredMethod(DeviationReportVariable.m_hi((Object)"0d=f6i\u0001`#j!q G*U!j9`0q\u001aa\u001ak'`!k2i"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.a.addRemoteCall((short)506, (Object)a, ReportManager.class.getDeclaredMethod(Tree.m_hi((Object)"5V&a7C=A&`&R&F!V!q+z6@\u001b]&V ]3_"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.a.addRemoteCall((short)507, (Object)a, ReportManager.class.getDeclaredMethod(DeviationReportVariable.m_hi((Object)"4`'W6u<w'V'd'p ` G*U!j9`0q\u001aa\u001ak'`!k2i"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(Tree.m_hi((Object)"\u0014R;_7WrG=\u0013 V5Z!G7Ara7C=A&~3]3T7Ara\u0002pr^7G:\\6@"), noSuchMethodException);
        }
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report a) {
        ReportManager a2;
        return a2.i.m_rja(a.getProject(), "Report Print - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            comparable.set(5, a.getReportDay().shortValue());
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(2, -1);
            Date date = calendar.getTime();
            a2.D.m_cy(a.getId(), date, (Date)comparable, true, a.getLang());
        }, (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(Integer a, String a2) {
        ReportManager a3;
        ReportManager reportManager = a3;
        reportManager.scheduleReport(reportManager.F.m_dd(a, a2).getId());
    }

    protected void cancelReportInternal(Report a) {
        ReportManager a2;
        c_cha.m_pcc(() -> {
            ReportManager a2;
            a2.A.lock();
            try {
                Object object = (List)a2.k.get(a.getId());
                if (object != null) {
                    Object object2 = object = object.iterator();
                    while (object2.hasNext()) {
                        Job job = (Job)object.next();
                        object2 = object;
                        a2.i.m_oda(job);
                    }
                }
                ReportManager reportManager = a2;
                reportManager.k.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                reportManager.B.srem(H, stringArray);
                return;
            }
            finally {
                a2.A.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report a) {
        ReportManager a2;
        return a2.i.m_rja(a.getProject(), "Report Mail - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            comparable.set(5, a.getReportDay().shortValue());
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(2, -1);
            Date date = calendar.getTime();
            a2.D.m_lx(a.getId(), date, (Date)comparable, true, a.getLang());
        }, (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(Integer a) {
        ReportManager a2;
        if (a2.a.isLeader()) {
            f.debug(DeviationReportVariable.m_hi((Object)"I\u0016D\u0017@\u0001?sF2k0`?i:k4%!`#j!qs~.%?j0d?i*+"), (Object)a);
            a2.cancelReportInternal(a);
            return;
        }
        f.debug(Tree.m_hi((Object)"\u001c|\u001c\u001e\u001ev\u0013w\u0017ah\u0013\u0000V#F7@&Z<Tr_7R6V \u0013&\\rP3]1V>\u0013 V\"\\ GrH/\u001d"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.a.callLeaderMethod(Short.valueOf((short)502), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC cancel report " + a, (Throwable)exception);
        }
    }

    public ReportManager(c_rm a, c_dm a2, c_gh a3, c_ye a4, JedisPooled a5, ClusterOperations a6) {
        ReportManager a7;
        ReportManager reportManager = a7;
        ReportManager reportManager2 = a7;
        ReportManager reportManager3 = a7;
        ReportManager reportManager4 = a7;
        a7.A = new ReentrantLock();
        reportManager4.k = new ConcurrentHashMap();
        reportManager3.F = a;
        reportManager3.i = a2;
        reportManager2.D = a3;
        reportManager2.J = a4;
        reportManager.B = a5;
        reportManager.a = a6;
    }
}

