/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.restcontrollers;

import com.inscada.mono.communication.base.services.m.c_dd;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.report.enums.c_oi;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.report.services.ReportManager;
import com.inscada.mono.report.services.c_gh;
import com.inscada.mono.report.services.c_rm;
import com.inscada.mono.script.services.c_wf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/reports"})
public class ReportController
extends ProjectBasedImportExportController {
    private final ReportManager k;
    private final c_gh i;
    private final c_rm b;

    @PostMapping(value={"/{reportId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReport(@PathVariable(value="reportId") Integer a) {
        this.k.cancelReport(a);
    }

    @PostMapping(value={"/{reportId}/groups"})
    public ResponseEntity<ReportGroup> createReportGroup(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody ReportGroup reportGroup, UriComponentsBuilder a) {
        reportGroup = this.b.m_po(reportId, reportGroup);
        Object[] objectArray = new Object[2];
        objectArray[0] = reportId;
        objectArray[1] = reportGroup.getId();
        return ResponseEntity.created((URI)a.path(c_dd.m_hi((Object)"b\u0006?\u0018=\u0012?\t\u0004\u00190R*\u000f\"\b=\u000eb\u0006*\u000f\"\b=4)\u0000")).buildAndExpand(objectArray).toUri()).body((Object)reportGroup);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportGroup a) {
        this.b.m_bp(reportId, groupId, a);
    }

    @PostMapping
    public ResponseEntity<Report> createReport(@Valid @RequestBody Report report, UriComponentsBuilder a) {
        report = this.b.m_cv(report);
        Object[] objectArray = new Object[1];
        objectArray[0] = report.getId();
        return ResponseEntity.created((URI)a.path(c_wf.m_hi((Object)"iP4N6D4_\u000fO;")).buildAndExpand(objectArray).toUri()).body((Object)report);
    }

    @DeleteMapping(value={"/groups/subgroups/variables"}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.b.m_du(List.of(a));
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody ReportVariable a) {
        this.b.m_kr(reportId, groupId, subgroupId, variableId, a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        this.b.m_sz(reportId, groupId, a);
    }

    @DeleteMapping(value={"/groups/subgroups"}, params={"subgroupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubgroupsByIds(@RequestParam(value="subgroupIds") Integer[] a) {
        this.b.m_vo(List.of(a));
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        this.b.m_pw(reportId, a);
    }

    @DeleteMapping(value={"/groups"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.b.m_qq(List.of(a));
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    public ReportSubgroup getReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.b.m_by(reportId, groupId, a);
    }

    @GetMapping(value={"/{reportId}/status"})
    public c_oi getReportStatus(@PathVariable(value="reportId") Integer a) {
        return this.k.getReportStatus(a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public ResponseEntity<ReportSubgroup> createReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportSubgroup reportSubgroup, UriComponentsBuilder a) {
        reportSubgroup = this.b.m_ls(reportId, groupId, reportSubgroup);
        Object[] objectArray = new Object[3];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = reportSubgroup.getId();
        return ResponseEntity.created((URI)a.path(c_dd.m_hi((Object)"R6\u000f(\r\"\u000f94)\u0000b\u001a?\u00128\r>R6\u001a?\u00128\r\u0004\u00190R>\b/\u001a?\u00128\r>R6\u000e8\u001f*\u000f\"\b=4)\u0000")).buildAndExpand(objectArray).toUri()).body((Object)reportSubgroup);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public Collection<ReportSubgroup> getReportSubgroups(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.b.m_sr(reportId, a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    public ReportVariable getReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        return this.b.m_ew(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/{reportId}/mail"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void mailReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.i.m_lx(reportId, startDate, endDate, false, a);
    }

    @PostMapping(value={"/{reportId}/print"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void printReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.i.m_cy(reportId, startDate, endDate, false, a);
    }

    @DeleteMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReport(@PathVariable(value="reportId") Integer a) {
        this.b.m_qa(a);
    }

    @GetMapping(value={"/{reportId}"})
    public Report getReport(@PathVariable(value="reportId") Integer a) {
        return this.b.m_ba(a);
    }

    @GetMapping
    public Collection<Report> getReports(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_oa(a);
    }

    @GetMapping(value={"/{reportId}/excelExport"})
    public ResponseEntity<byte[]> exportToExcel(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.i.m_tw(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = c_dd.m_hi((Object)"\u001c9\t,\u001e%\u0010(\u00139Fm\u001b$\u0011(\u0013,\u0010(@o/(\r\"\u000f9S5\u0011>_");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(c_wf.m_hi((Object)"\u0005D(_#E2\u0006\u0002B5[)X/_/D("), stringArray)).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReports(@RequestParam(value="projectId") Integer a) {
        this.k.scheduleReports(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public Collection<ReportVariable> getReportVariables(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.b.m_ns(reportId, groupId, a);
    }

    @PutMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReport(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody Report a) {
        this.b.m_fu(reportId, a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public ResponseEntity<ReportVariable> createReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportVariable reportVariable, UriComponentsBuilder a) {
        reportVariable = this.b.m_gw(reportId, groupId, subgroupId, reportVariable);
        Object[] objectArray = new Object[4];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = subgroupId;
        objectArray[3] = reportVariable.getId();
        return ResponseEntity.created((URI)a.path(c_wf.m_hi((Object)"\u0004=Y#[)Y2b\"ViL4D3[5\u0004=L4D3[\u000fO;\u00045^$L4D3[5\u0004=X3I!Y)^6b\"Vi]'Y/J$G#XiP0J4B'I*N\u000fO;")).buildAndExpand(objectArray).toUri()).body((Object)reportVariable);
    }

    @DeleteMapping(value={""}, params={"reportIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportsByIds(@RequestParam(value="reportIds") Integer[] a) {
        this.b.m_xc(List.of(a));
    }

    @GetMapping(value={"/{reportId}/groups"})
    public Collection<ReportGroup> getReportGroups(@PathVariable(value="reportId") Integer a) {
        return this.b.m_av(a);
    }

    @GetMapping(value={"/statuses"})
    public Map<Integer, c_oi> getReportStatuses(@RequestParam(value="reportIds") Integer[] a) {
        return this.k.getReportStatuses(Arrays.asList(a));
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}"})
    public ReportGroup getReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.b.m_rv(reportId, a);
    }

    @GetMapping(value={"/{reportId}/preview"})
    public ResponseEntity<byte[]> previewReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.i.m_aw(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = c_wf.m_hi((Object)"'_2J%C+N(_}\u000b B*N(J+N{\t4N6D4_h[\"Md");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(c_dd.m_hi((Object)">\"\u00139\u0018#\t`9$\u000e=\u0012>\u00149\u0014\"\u0013"), stringArray)).contentType(MediaType.APPLICATION_PDF).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @PostMapping(value={"/{reportId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReport(@PathVariable(value="reportId") Integer a) {
        this.k.scheduleReport(a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        this.b.m_dp(reportId, groupId, subgroupId, a);
    }

    public ReportController(c_rm a, ReportManager a2, c_gh a3, c_ff a4, c_pg a5) {
        ReportController a6;
        ReportController reportController = a6;
        super(a4, EnumSet.of(c_bh.L), a5);
        a6.b = a;
        reportController.k = a2;
        reportController.i = a3;
    }

    @PostMapping(value={"/cancel"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReports(@RequestParam(value="projectId") Integer a) {
        this.k.cancelReports(a);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportSubgroup a) {
        this.b.m_vq(reportId, groupId, subgroupId, a);
    }
}

