/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.enums.c_wda;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="report_variable")
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"subgroupId", "reportSubgroup"}), @CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"})})
public class ReportVariable
extends SpaceBaseModel {
    @Column(name="total_variable_id", insertable=false, updatable=false)
    private Integer totalVariableId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="variable_id")
    private Variable<?, ?, ?> variable;
    @Size(max=50)
    private String pattern;
    @NotBlank
    @Size(max=100)
    private String name;
    @Id
    @Column(name="report_variable_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reportVariableSeq")
    @GenericGenerator(name="reportVariableSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="report_variable_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Column(name="deviation_calc_report_variable_id", insertable=false, updatable=false)
    private Integer deviationCalcReportVariableId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="report_subgroup_id")
    private ReportSubgroup reportSubgroup;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="total_variable_id")
    private Variable<?, ?, ?> totalVariable;
    @Column(name="report_subgroup_id", insertable=false, updatable=false)
    private Integer subgroupId;
    @Column(name="deviation_variable_id", insertable=false, updatable=false)
    private Integer deviationVariableId;
    @NotNull
    @Min(value=1L)
    @Column(name="variable_order")
    private Short variableOrder;
    @Column(name="total_calc_type")
    private c_wda totalCalcType;
    @NotNull
    @Column(name="calc_type")
    private c_wda calcType;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="deviation_variable_id")
    private Variable<?, ?, ?> deviationVariable;
    @Column(name="variable_id", insertable=false, updatable=false)
    private Integer variableId;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="deviation_calc_report_variable_id")
    private ReportVariable deviationCalcReportVariable;

    public void setCalcType(c_wda a) {
        a.calcType = a;
    }

    public Variable<?, ?, ?> getTotalVariable() {
        ReportVariable a;
        return a.totalVariable;
    }

    public void setDeviationVariableId(Integer a) {
        a.deviationVariableId = a;
    }

    public void setTotalCalcType(c_wda a) {
        a.totalCalcType = a;
    }

    public Variable<?, ?, ?> getDeviationVariable() {
        ReportVariable a;
        return a.deviationVariable;
    }

    public Integer getDeviationVariableId() {
        ReportVariable a;
        return a.deviationVariableId;
    }

    public ReportVariable getDeviationCalcReportVariable() {
        ReportVariable a;
        return a.deviationCalcReportVariable;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Integer getId() {
        ReportVariable a;
        return a.id;
    }

    public String getPattern() {
        ReportVariable a;
        return a.pattern;
    }

    public Integer getVariableId() {
        ReportVariable a;
        return a.variableId;
    }

    public void setTotalVariable(Variable<?, ?, ?> a) {
        a.totalVariable = a;
    }

    public Integer getTotalVariableId() {
        ReportVariable a;
        return a.totalVariableId;
    }

    public void setVariableId(Integer a) {
        a.variableId = a;
    }

    public void setReportSubgroup(ReportSubgroup a) {
        ReportVariable a2;
        ReportVariable reportVariable = a2;
        reportVariable.reportSubgroup = a;
        reportVariable.subgroupId = a != null ? a.getId() : null;
    }

    public void setVariable(Variable<?, ?, ?> a) {
        a.variable = a;
    }

    public ReportSubgroup getReportSubgroup() {
        ReportVariable a;
        return a.reportSubgroup;
    }

    public boolean equals(Object a) {
        ReportVariable a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof ReportVariable)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (ReportVariable)a;
        return a2.getName().equals(a.getName()) && a2.getSubgroupId().equals(a.getSubgroupId());
    }

    public c_wda getCalcType() {
        ReportVariable a;
        return a.calcType;
    }

    public void setDeviationCalcReportVariable(ReportVariable a) {
        a.deviationCalcReportVariable = a;
    }

    public void setVariableOrder(Short a) {
        a.variableOrder = a;
    }

    public Variable<?, ?, ?> getVariable() {
        ReportVariable a;
        return a.variable;
    }

    public String getName() {
        ReportVariable a;
        return a.name;
    }

    public void setPattern(String a) {
        a.pattern = a;
    }

    public Integer getSubgroupId() {
        ReportVariable a;
        return a.subgroupId;
    }

    public c_wda getTotalCalcType() {
        ReportVariable a;
        return a.totalCalcType;
    }

    public void setDeviationCalcReportVariableId(Integer a) {
        a.deviationCalcReportVariableId = a;
    }

    public void setDeviationVariable(Variable<?, ?, ?> a) {
        a.deviationVariable = a;
    }

    public Short getVariableOrder() {
        ReportVariable a;
        return a.variableOrder;
    }

    public ReportVariable() {
        ReportVariable a;
    }

    public Integer getDeviationCalcReportVariableId() {
        ReportVariable a;
        return a.deviationCalcReportVariableId;
    }

    public void setTotalVariableId(Integer a) {
        a.totalVariableId = a;
    }

    public void setSubgroupId(Integer a) {
        a.subgroupId = a;
    }

    public int hashCode() {
        ReportVariable a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        objectArray[2] = a.getSubgroupId();
        return Objects.hash(objectArray);
    }

    public void setId(Integer a) {
        a.id = a;
    }
}

