/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="jasper_report")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class JasperReport
extends SpaceBaseModel {
    private String parameters;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Size(max=255)
    private String dsc;
    private String subreports;
    @NotBlank
    @Column(name="template_file")
    private String templateFile;
    @Id
    @Column(name="jasper_report_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="jasperReportSeq")
    @GenericGenerator(name="jasperReportSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="jasper_report_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    private String datasource;

    public String getName() {
        JasperReport a;
        return a.name;
    }

    public boolean equals(Object a) {
        JasperReport a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof JasperReport)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (JasperReport)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setTemplateFile(String a) {
        a.templateFile = a;
    }

    public void setParameters(String a) {
        a.parameters = a;
    }

    public void setProject(Project a) {
        a.project = a;
    }

    public Integer getProjectId() {
        JasperReport a;
        return a.projectId;
    }

    public String getTemplateFile() {
        JasperReport a;
        return a.templateFile;
    }

    public Integer getId() {
        JasperReport a;
        return a.id;
    }

    public void setSubreports(String a) {
        a.subreports = a;
    }

    public String getParameters() {
        JasperReport a;
        return a.parameters;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public String getDsc() {
        JasperReport a;
        return a.dsc;
    }

    public Project getProject() {
        JasperReport a;
        return a.project;
    }

    public int hashCode() {
        JasperReport a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setDatasource(String a) {
        a.datasource = a;
    }

    public String getDatasource() {
        JasperReport a;
        return a.datasource;
    }

    public JasperReport() {
        JasperReport a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public String getSubreports() {
        JasperReport a;
        return a.subreports;
    }
}

