/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.restcontrollers;

import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.model.ImportResult;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.project.m.c_ol;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.project.m.c_yg;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.project.model.ProjectClone;
import com.inscada.mono.project.model.ProjectLocationDto;
import com.inscada.mono.project.model.ProjectStatus;
import com.inscada.mono.shared.repositories.BaseInfluxRepository;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/projects"})
public class ProjectController
extends ProjectBasedImportExportController {
    private final c_ol i;
    private final c_yg b;
    private final c_pg b;

    @GetMapping(value={"/{projectId}"})
    public Project getProject(@PathVariable(value="projectId") Integer a) {
        return this.b.m_ba(a);
    }

    @PostMapping(value={"/clone"})
    public ImportResult cloneProject(@Valid @RequestBody ProjectClone projectClone, @RequestParam(name="includeProjectAttachments", required=false) Boolean a) throws IOException {
        projectClone.setIncludeProjectAttachments(a);
        return this.b.m_jv(projectClone);
    }

    @GetMapping(value={"/name"}, params={"name"})
    public Project getProject(@RequestParam(name="name") String a) {
        return this.b.m_sh(a);
    }

    @GetMapping(value={"/{projectId}/status"})
    public ProjectStatus getStatus(@PathVariable(value="projectId") Integer a) {
        return this.i.m_st(a);
    }

    @PutMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProject(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody Project a) {
        this.b.m_ix(projectId, a);
    }

    @PatchMapping(value={"/{projectId}/location"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProjectLocation(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody ProjectLocationDto a) {
        this.b.m_tz(projectId, a.getLatitude(), a.getLongitude());
    }

    @GetMapping
    public Collection<Project> getProjects(@RequestParam(name="isActive", required=false) Boolean a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_fw(a);
    }

    @PostMapping
    public ResponseEntity<Project> createProject(@Valid @RequestBody Project project, UriComponentsBuilder a) {
        project = this.b.m_qp(project);
        Object[] objectArray = new Object[1];
        objectArray[0] = project.getId();
        return ResponseEntity.created((URI)a.path(BaseInfluxRepository.m_hi((Object)"j851*)  1\n!>")).buildAndExpand(objectArray).toUri()).body((Object)project);
    }

    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteProject(@PathVariable(value="projectId") Integer a) {
        this.b.m_qa(a);
    }

    public ProjectController(c_pg a, c_ol a2, c_yg a3, c_ff a4) {
        ProjectController a5;
        ProjectController projectController = a5;
        super(a4, EnumSet.of(c_bh.k), a);
        a5.b = a;
        projectController.i = a2;
        projectController.b = a3;
    }
}

