/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.ProjectAttachment;
import com.inscada.mono.shared.model.SpaceBaseModel;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="project")
public class Project
extends SpaceBaseModel {
    @NotNull
    @Column(name="active_flag")
    private Boolean isActive;
    private String properties;
    @Size(max=255)
    private String address;
    @Size(max=255)
    private String dsc;
    private Double longitude;
    @Id
    @Column(name="project_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="projectSeq")
    @GenericGenerator(name="projectSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="project_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    private Double latitude;
    @JsonIgnore
    @OneToMany(mappedBy="project", orphanRemoval=true)
    private Set<ProjectAttachment> projectAttachments;
    private String icon;
    @Column(name="contract_hour")
    private String contractHour;
    @Column(name="contract_day")
    private Integer contractDay;
    @NotBlank
    @Size(max=100)
    @Column(updatable=false)
    private String name;

    public boolean equals(Object a) {
        Project a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Project)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Project)a;
        return a2.getName().equals(a.getName());
    }

    public void setLatitude(Double a) {
        a.latitude = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setIsActive(Boolean a) {
        a.isActive = a;
    }

    public Integer getId() {
        Project a;
        return a.id;
    }

    public void setContractHour(String a) {
        a.contractHour = a;
    }

    public void setContractDay(Integer a) {
        a.contractDay = a;
    }

    public String getProperties() {
        Project a;
        return a.properties;
    }

    public Double getLatitude() {
        Project a;
        return a.latitude;
    }

    public Boolean getIsActive() {
        Project a;
        return a.isActive;
    }

    public void setProperties(String a) {
        a.properties = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public String getContractHour() {
        Project a;
        return a.contractHour;
    }

    public String getAddress() {
        Project a;
        return a.address;
    }

    public Set<ProjectAttachment> getProjectAttachments() {
        Project a;
        return a.projectAttachments;
    }

    public void setLongitude(Double a) {
        a.longitude = a;
    }

    public Double getLongitude() {
        Project a;
        return a.longitude;
    }

    public void setProjectAttachments(Set<ProjectAttachment> a) {
        a.projectAttachments = a;
    }

    public String getIcon() {
        Project a;
        return a.icon;
    }

    public void setAddress(String a) {
        a.address = a;
    }

    public void setIcon(String a) {
        a.icon = a;
    }

    public int hashCode() {
        Project a;
        Object[] objectArray = new Object[2];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getName() {
        Project a;
        return a.name;
    }

    public String getDsc() {
        Project a;
        return a.dsc;
    }

    public Project() {
        Project a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Integer getContractDay() {
        Project a;
        return a.contractDay;
    }
}

