/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.language.restcontrollers;

import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.language.m.c_dl;
import com.inscada.mono.language.model.Language;
import com.inscada.mono.language.model.LanguageFilter;
import com.inscada.mono.shared.a.c_ec;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/languages"})
public class LanguageController
extends ImportExportController {
    private final c_dl b;

    @DeleteMapping(value={"/{languageId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteLanguage(@PathVariable(value="languageId") Integer a) {
        this.b.m_qa(a);
    }

    @GetMapping(value={"/pages"})
    public Page<Language> findAll(Pageable a) {
        LanguageController a2;
        return a2.b.m_qea(a);
    }

    @GetMapping(params={"lang", "key"})
    public Language getLanguageByLangAndKey(@RequestParam(value="lang") String lang, @RequestParam(value="key") String a) {
        return this.b.m_jea(lang, a);
    }

    @PutMapping(value={"/{languageId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateLanguage(@PathVariable(value="languageId") Integer languageId, @Valid @RequestBody Language a) {
        this.b.m_sca(languageId, a);
    }

    @DeleteMapping(value={""}, params={"languageIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteLanguagesByIds(@RequestParam(value="languageIds") Integer[] a) {
        this.b.m_xc(List.of(a));
    }

    @PostMapping(value={"/filter"})
    public Page<Language> findLanguagesByFilter(@RequestBody LanguageFilter languageFilter, Pageable a) {
        return this.b.m_lja(languageFilter, a);
    }

    @GetMapping(params={"key"})
    public Collection<Language> getLanguagesByKey(@RequestParam(value="key") String a) {
        return this.b.m_wfa(a);
    }

    @GetMapping(value={"/pages"}, params={"key"})
    public Page<Language> findLanguagesByKey(@RequestParam(value="key") String key, Pageable a) {
        if (c_ec.m_zf((String)key)) {
            return this.b.m_taa(key, a);
        }
        return this.b.m_qea(a);
    }

    @GetMapping(value={"/langs"})
    public Collection<String> getLanguageDistinctLangs() {
        LanguageController a;
        return a.b.m_mga();
    }

    @GetMapping(value={"/{languageId}"})
    public Language getLanguage(@PathVariable(value="languageId") Integer a) {
        return this.b.m_ba(a);
    }

    @GetMapping(params={"lang", "keys"})
    public Collection<Language> getLanguagesByLangAndKeys(@RequestParam(value="lang") String lang, @RequestParam(value="keys") String[] a) {
        return this.b.m_fga(lang, a);
    }

    public LanguageController(c_dl a, c_ff a2) {
        super(a2, EnumSet.of(c_bh.X));
        LanguageController a3;
        a3.b = a;
    }

    @GetMapping(params={"lang"})
    public Collection<Language> getLanguagesByLang(@RequestParam(value="lang") String a) {
        return this.b.m_nfa(a);
    }

    @PutMapping(value={"/bulk"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void upsert(@Valid @RequestBody Collection<Language> a) {
        this.b.m_va(a);
    }

    @GetMapping
    public Collection<Language> getLanguages() {
        LanguageController a;
        return a.b.m_da();
    }

    @PostMapping
    public ResponseEntity<Language> createLanguage(@Valid @RequestBody Language language, UriComponentsBuilder a) {
        language = this.b.m_eha(language);
        Object[] objectArray = new Object[1];
        objectArray[0] = language.getId();
        return ResponseEntity.created((URI)a.path(SetValueRequest.m_hi((Object)"E#\u00069\u0004?\u001f9\r=#<\u0017")).buildAndExpand(objectArray).toUri()).body((Object)language);
    }
}

