/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.job.model;

import com.inscada.mono.job.model.Job;
import com.inscada.mono.project.model.Project;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;

public abstract class Job {
    private final Runnable runnable;
    private final AtomicLong successCounter;
    private final Project project;
    private final DescriptiveStatistics durationStatistics;
    private final AtomicLong failedCounter;
    private final AtomicLong requestCounter;
    private final String name;

    protected Job(Project a, String a2, Runnable a3) {
        Job a4;
        Job job = a4;
        Job job2 = a4;
        Job job3 = a4;
        a4.requestCounter = new AtomicLong(0L);
        job3.successCounter = new AtomicLong(0L);
        job2.failedCounter = new AtomicLong(0L);
        job2.durationStatistics = new DescriptiveStatistics(1000);
        job2.project = a;
        job.name = a2;
        job.runnable = a3;
    }

    public String getName() {
        Job a;
        return a.name;
    }

    public void failed() {
        Job a;
        a.failedCounter.incrementAndGet();
    }

    public double getPercentageAboveThresholdDuration(long a) {
        Job a2;
        return a2.durationStatistics.apply((UnivariateStatistic)new PercentageAboveThreshold((double)a * 1000000.0));
    }

    public long getRequestCount() {
        Job a;
        return a.requestCounter.get();
    }

    public long getSuccessCount() {
        Job a;
        return a.successCounter.get();
    }

    public double getMeanDuration() {
        Job a;
        return a.durationStatistics.getMean() * 1.0E-6;
    }

    public Project getProject() {
        Job a;
        return a.project;
    }

    public void succeed(long a) {
        Job a2;
        a2.successCounter.incrementAndGet();
        a2.durationStatistics.addValue((double)a);
    }

    public double getMinDuration() {
        Job a;
        return a.durationStatistics.getMin() * 1.0E-6;
    }

    public Runnable getRunnable() {
        Job a;
        return a.runnable;
    }

    public abstract String getType();

    public double getMaxDuration() {
        Job a;
        return a.durationStatistics.getMax() * 1.0E-6;
    }

    public void requested() {
        Job a;
        a.requestCounter.incrementAndGet();
    }

    public abstract String getSchedule();

    public long getFailCount() {
        Job a;
        return a.failedCounter.get();
    }

    public double getPercentageFailed() {
        Job a;
        if (a.requestCounter.get() == 0L) {
            return 0.0;
        }
        return (double)a.failedCounter.get() / (double)a.requestCounter.get() * 100.0;
    }
}

