/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.restcontrollers;

import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.communication.base.services.c_eja;
import com.inscada.mono.faceplate.m.c_do;
import com.inscada.mono.faceplate.model.Faceplate;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.project.m.c_pg;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/faceplates"})
public class FaceplateController
extends ProjectBasedImportExportController {
    private final c_do b;

    @PutMapping(value={"/{faceplateId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateSvg(@PathVariable(value="faceplateId") Integer faceplateId, @RequestBody String a) {
        this.b.m_zka(faceplateId, a);
    }

    @DeleteMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        this.b.m_iaa(faceplateId, a);
    }

    public FaceplateController(c_do a, c_ff a2, c_pg a3) {
        super(a2, EnumSet.of(c_bh.E), a3);
        FaceplateController a4;
        a4.b = a;
    }

    @DeleteMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        this.b.m_efa(faceplateId, a);
    }

    @PostMapping
    public ResponseEntity<Faceplate> createFaceplate(@Valid @RequestBody Faceplate faceplate, UriComponentsBuilder a) {
        faceplate = this.b.m_eia(faceplate);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplate.getId();
        return ResponseEntity.created((URI)a.path(CheckedAlarm.m_hi((Object)"f\r/\u0017*\u00139\u001a(\u0002,?-\u000b")).buildAndExpand(objectArray).toUri()).body((Object)faceplate);
    }

    @GetMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    public FaceplatePlaceholder getFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        return this.b.m_lca(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/svg"})
    public ResponseEntity<InputStreamResource> getFaceplateSvg(@PathVariable(value="faceplateId") Integer a) {
        a = this.b.m_ba(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(c_eja.m_hi((Object)"l|AgJ}[>kz\\c@`FgF|A"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)CheckedAlarm.m_hi((Object)"\u001f$\u0017.\u0013f\u0005?\u0011b\u000e$\u001a"))).body((Object)byteArrayInputStream);
    }

    @PutMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer placeholderId, @Valid @RequestBody FaceplatePlaceholder a) {
        this.b.m_qha(faceplateId, placeholderId, a);
    }

    @PutMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody Faceplate a) {
        this.b.m_fea(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/elements"})
    public Collection<FaceplateElement> getFaceplateElements(@PathVariable(value="faceplateId") Integer a) {
        return this.b.m_aga(a);
    }

    @PostMapping(value={"/{faceplateId}/clone"}, params={"name"})
    public ResponseEntity<Faceplate> cloneFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        faceplateId = this.b.m_yaa(faceplateId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplateId.getId();
        return ResponseEntity.created((URI)a.path(c_eja.m_hi((Object)"<TuNpJcCr[vfwR")).buildAndExpand(objectArray).toUri()).body((Object)faceplateId);
    }

    @PutMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody FaceplateElement a) {
        this.b.m_zba(faceplateId, elementId, a);
    }

    @PostMapping(value={"/{faceplateId}/placeholders"})
    public ResponseEntity<FaceplatePlaceholder> createFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplatePlaceholder faceplatePlaceholder, UriComponentsBuilder a) {
        faceplatePlaceholder = this.b.m_dha(faceplateId, faceplatePlaceholder);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplatePlaceholder.getId();
        return ResponseEntity.created((URI)a.path(CheckedAlarm.m_hi((Object)"Y2\u0010(\u0015,\u0006%\u0017=\u0013\u0000\u00124Y9\u001a(\u0015,\u001e&\u001a-\u0013;\u0005f\r,\u001a,\u001b,\u0018=?-\u000b")).buildAndExpand(objectArray).toUri()).body((Object)faceplatePlaceholder);
    }

    @GetMapping(value={"/{faceplateId}/placeholders"})
    public Collection<FaceplatePlaceholder> getFaceplatePlaceholders(@PathVariable(value="faceplateId") Integer a) {
        return this.b.m_tba(a);
    }

    @GetMapping
    public Collection<Faceplate> getFaceplates(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_oa(a);
    }

    @DeleteMapping(value={"/{faceplateId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElementsByIds(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(value="elementIds") Integer[] a) {
        this.b.m_wga(faceplateId, a);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Faceplate> getFaceplatesByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.b.m_zga(projectId, a);
    }

    @PostMapping(value={"/{faceplateId}/elements"})
    public ResponseEntity<FaceplateElement> createFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplateElement faceplateElement, UriComponentsBuilder a) {
        faceplateElement = this.b.m_vfa(faceplateId, faceplateElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplateElement.getId();
        return ResponseEntity.created((URI)a.path(c_eja.m_hi((Object)"\u0000hIrLv_\u007fNgJZKn\u0000vCvBvAg\\<TvCvBvAgfwR")).buildAndExpand(objectArray).toUri()).body((Object)faceplateElement);
    }

    @GetMapping(value={"/{faceplateId}"})
    public Faceplate getFaceplate(@PathVariable(value="faceplateId") Integer a) {
        return this.b.m_ba(a);
    }

    @GetMapping(value={"/{faceplateId}/elements/{elementId}"})
    public FaceplateElement getFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        return this.b.m_jia(faceplateId, a);
    }

    @DeleteMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplate(@PathVariable(value="faceplateId") Integer a) {
        this.b.m_qa(a);
    }
}

