/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_cha;
import com.inscada.mono.cluster.m.c_oga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.communication.base.enums.c_tka;
import com.inscada.mono.communication.base.enums.c_wda;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_eja;
import com.inscada.mono.communication.base.services.c_iea;
import com.inscada.mono.communication.base.services.c_tea;
import com.inscada.mono.communication.base.services.m.c_dd;
import com.inscada.mono.communication.protocols.mqtt.model.MqttMessage;
import com.inscada.mono.datatransfer.events.CancelEvent;
import com.inscada.mono.datatransfer.events.RescheduleEvent;
import com.inscada.mono.datatransfer.m.c_wh;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.c_jd;
import com.inscada.mono.datatransfer.services.c_sg;
import com.inscada.mono.job.a.c_dm;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_jf;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener {
    private final c_eja E;
    private static final String M = "scheduledDataTransfers";
    public static final short J = 403;
    private static final Logger G = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short H = 402;
    public static final short D = 405;
    private final Map<Integer, Job> l;
    private final c_dm F;
    public static final short a = 404;
    private final c_iea f;
    private final c_sg c;
    public static final short I = 406;
    private final ClusterOperations h;
    private final c_ye A;
    private final Lock C;
    private final c_tea B;
    private final JedisPooled k;
    public static final short i = 401;
    public static final short b = 407;

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            G.debug(MqttMessage.m_hi((Object)"\u0019\u0010\u0014\u0011\u0010\u0007ou\u00066=01 9<;2u499u14!4u!'4;&30'&u3:'u%':?06!u.(u9:6499,{"), (Object)a);
            a2.scheduleDataTransfersByProjectIdInternal(a);
            return;
        }
        G.debug(c_dd.m_hi((Object)"\u00032\u0003P\u00018\f9\b/w]\u001f\u0018<\b(\u000e9\u0014#\u001am\u0011(\u001c)\u0018?]9\u0012m\u000e.\u0015(\u00198\u0011(],\u0011!])\u001c9\u001cm\t?\u001c#\u000e+\u0018?\u000em\u001b\"\u000fm\r?\u0012'\u0018.\tm\u00060S"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.h.callLeaderMethod(Short.valueOf((short)404), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC schedule data transfers for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, Double a2, VariableValue<?> a3) {
        DataTransferManager a4;
        return a4.isValueInThresholdRange(a, (VariableValue)new NumberVariableValue((Number)a2, new Date()), a3);
    }

    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a2) {
        DataTransferManager a3;
        Object object = (Integer[])a.stream().map(DataTransferDetail::getSourceVariableId).toArray(Integer[]::new);
        Object object2 = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a3.f.m_msa(object2).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        DataTransferManager dataTransferManager = a3;
        object = dataTransferManager.B.m_qob(object);
        object2 = dataTransferManager.B.m_qob((Integer[])object2.toArray(Integer[]::new));
        a.forEach(arg_0 -> a3.lambda$handleCurrentValues$8((Map)object, (Map)object2, map, a2, arg_0));
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            G.info(MqttMessage.m_hi((Object)"\u0019\u0010\u0014\u0011\u0010\u0007ou\u001d4;19<;2u\u00070&6=01 90\u0010#0;!u3:'u14!4u!'4;&30'ou.(u}\u001c\u0011ou.(|"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            if (a2.getDataTransferStatusInternal(dataTransfer.getId()) == c_wh.B) {
                a2.scheduleDataTransferInternal(dataTransfer.getId());
                return;
            }
        } else {
            G.debug(c_dd.m_hi((Object)"\u00032\u0003P\u00018\f9\b/w]\u0004\u001a#\u0012?\u0014#\u001am/(\u000e.\u0015(\u00198\u0011(8;\u0018#\tm\u001b\"\u000fm\u0019,\t,]9\u000f,\u0013>\u001b(\u000fw]6\u0000"), (Object)a.getDataTransfer().getId());
        }
    }

    public DataTransferManager(c_sg a, c_iea a2, c_tea a3, c_eja a4, c_dm a5, JedisPooled a6, c_ye a7, ClusterOperations a8) {
        DataTransferManager a9;
        DataTransferManager dataTransferManager = a9;
        DataTransferManager dataTransferManager2 = a9;
        DataTransferManager dataTransferManager3 = a9;
        DataTransferManager dataTransferManager4 = a9;
        DataTransferManager dataTransferManager5 = a9;
        a9.C = new ReentrantLock();
        dataTransferManager5.l = new ConcurrentHashMap();
        dataTransferManager4.c = a;
        dataTransferManager4.f = a2;
        dataTransferManager3.B = a3;
        dataTransferManager3.E = a4;
        dataTransferManager2.F = a5;
        dataTransferManager2.A = a7;
        dataTransferManager.k = a6;
        dataTransferManager.h = a8;
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(MqttMessage.m_hi((Object)"14!4x!'4;&30'o&!4!&o#4'<4790op1op&op&"), objectArray);
    }

    protected void scheduleDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_cha.m_pcc(() -> {
            DataTransferManager a2;
            a2.C.lock();
            try {
                a2.cancelDataTransferInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_jf("Project should be active to schedule data transfer " + a.getName());
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = a.getName();
                PeriodicJob periodicJob = a2.F.m_bia(a.getProject(), String.format(c_dd.m_hi((Object)"h\u000em9,\t,]\u0019\u000f,\u0013>\u001b(\u000f"), objectArray), () -> {
                    DataTransferManager a2;
                    a2.transfer(a);
                }, Duration.ofMillis(a.getPeriod().intValue()));
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.l.put(a.getId(), periodicJob);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.k.sadd(M, stringArray);
                return;
            }
            finally {
                a2.C.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_wh> getDataTransferStatuses(Integer a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            G.debug(c_dd.m_hi((Object)"\u00018\f9\b/w]\n\u00189\t$\u0013*],\u0011!])\u001c9\u001cm\t?\u001c#\u000e+\u0018?]>\t,\t8\u000e(\u000em\u001b\"\u000fm\r?\u0012'\u0018.\tm\u00060]!\u0012.\u001c!\u00114S"), (Object)a);
            return a2.getDataTransferStatusesByProjectIdInternal(a);
        }
        G.debug(MqttMessage.m_hi((Object)"\u001b\u001a\u001bx\u0019\u0010\u0014\u0011\u0010\u0007ou\u00070$ 0&!<;2u90410'u3:'u499u14!4u!'4;&30'u&!4! &0&u3:'u%':?06!u.({"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.h.callLeaderMethod(Short.valueOf((short)407), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date a, c_tka a2) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar.setTime(a);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = (Calendar)calendar2.clone();
        switch (c_jd.i[a2.ordinal()]) {
            case 1: {
                Calendar calendar4 = calendar;
                while (false) {
                }
                calendar4.set(12, 0);
                return Pair.of((Object)calendar4.getTime(), (Object)a);
            }
            case 2: {
                calendar3.add(11, -1);
                Calendar calendar5 = calendar;
                calendar5.add(11, -2);
                calendar5.set(12, 0);
                return Pair.of((Object)calendar5.getTime(), (Object)calendar3.getTime());
            }
            case 3: {
                Calendar calendar6 = calendar;
                calendar6.set(11, 0);
                calendar6.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 4: {
                calendar3.add(5, -1);
                Calendar calendar7 = calendar;
                calendar.add(5, -2);
                calendar7.set(11, 0);
                calendar7.set(12, 0);
                return Pair.of((Object)calendar7.getTime(), (Object)calendar3.getTime());
            }
            case 5: {
                Calendar calendar8 = calendar;
                Calendar calendar9 = calendar;
                calendar9.set(7, calendar9.getFirstDayOfWeek());
                calendar8.set(11, 0);
                calendar8.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 6: {
                calendar3.add(3, -1);
                Calendar calendar10 = calendar;
                calendar.add(3, -2);
                Calendar calendar11 = calendar;
                calendar11.set(7, calendar11.getFirstDayOfWeek());
                calendar10.set(11, 0);
                calendar10.set(12, 0);
                return Pair.of((Object)calendar10.getTime(), (Object)calendar3.getTime());
            }
            case 7: {
                Calendar calendar12 = calendar;
                calendar.set(5, 1);
                calendar12.set(11, 0);
                calendar12.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 8: {
                calendar3.add(2, -1);
                Calendar calendar13 = calendar;
                Calendar calendar14 = calendar;
                calendar14.add(2, -2);
                calendar14.set(5, 1);
                calendar13.set(11, 0);
                calendar13.set(12, 0);
                return Pair.of((Object)calendar13.getTime(), (Object)calendar3.getTime());
            }
            case 9: {
                Calendar calendar15 = calendar;
                calendar.set(6, 1);
                calendar15.set(11, 0);
                calendar15.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 10: {
                calendar3.add(1, -1);
                Calendar calendar16 = calendar;
                Calendar calendar17 = calendar;
                calendar17.add(1, -2);
                calendar17.set(6, 1);
                calendar16.set(11, 0);
                calendar16.set(12, 0);
                return Pair.of((Object)calendar16.getTime(), (Object)calendar3.getTime());
            }
        }
        throw new IllegalArgumentException(c_dd.m_hi((Object)"(#\u00185\r(\u001e9\u0018)]?\u001c#\u001a(]9\u0004=\u0018"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        String string = dataTransferManager.h.getCurrentNode().getNodeId();
        G.info(MqttMessage.m_hi((Object)"\u00114!4\u0001'4;&30'\u00184;420'ou\u0001=<&u;:10u}.(|u=4&u706:80u!=0u\u0019\u0010\u0014\u0011\u0010\u0007{u\u00070&!:'<;2u&6=01 901u14!4u!'4;&30'&{{{"), (Object)string);
        dataTransferManager.C.lock();
        try {
            Set set = a2.k.smembers(M).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                G.info(c_dd.m_hi((Object)"9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fmU\u0001\u0018,\u0019(\u000fm\u00060Tw]\u0003\u0012m\u000e.\u0015(\u00198\u0011(\u0019m\u0019,\t,]9\u000f,\u0013>\u001b(\u000f>]+\u00128\u0013)]$\u0013m/(\u0019$\u000em\t\"]?\u0018>\t\"\u000f(S"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            G.info(MqttMessage.m_hi((Object)"\u00114!4\u0001'4;&30'\u00184;420'u}\u00190410'u.(|ou\u0013: ;1u.(u&6=01 901u14!4u!'4;&30'u\u001c\u0011&u<;u\u000701<&u!:u'0&!:'0ou.("), objectArray);
            ArrayList arrayList = new ArrayList(a2.c.m_qk(set));
            G.info(c_dd.m_hi((Object)"9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fmU\u0001\u0018,\u0019(\u000fm\u00060Tw]\f\t9\u0018 \r9\u0014#\u001am\t\"]?\u0018>\t\"\u000f(]6\u0000m\u0019,\t,]9\u000f,\u0013>\u001b(\u000f>S"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                DataTransferManager a2;
                String string = a2.h.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    G.info(c_dd.m_hi((Object)"9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fmU\u0001\u0018,\u0019(\u000fm\u00060Tw]\u001f\u0018>\t\"\u000f$\u0013*])\u001c9\u001cm\t?\u001c#\u000e+\u0018?Gm\u00060]e4\tGm\u00060T"), objectArray);
                    a2.scheduleDataTransferInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.A.m_rea(a.getProject()).m_w("Data Transfer Restore (Leader " + string + ")", String.format(MqttMessage.m_hi((Object)"p&u}\u001c\u0011oup1|u34<901u!:u'0&!:'0{u\u00164 &0oup&"), objectArray));
                    try {
                        G.warn(c_dd.m_hi((Object)"9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fmU\u0001\u0018,\u0019(\u000fm\u00060Tw]\f\t9\u0018 \r9\u0014#\u001am\t\"].\u001c#\u001e(\u0011m\u0019,\t,]9\u000f,\u0013>\u001b(\u000fm\u00060],\u001b9\u0018?]?\u0018>\t\"\u000f,\t$\u0012#]+\u001c$\u00118\u000f(S"), (Object)string, (Object)a.getId());
                        a2.cancelDataTransferInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        G.error(MqttMessage.m_hi((Object)"\u00114!4\u0001'4;&30'\u00184;420'u}\u00190410'u.(|ou\u00134<901u!:u64;609u14!4u!'4;&30'u.(u43!0'u'0&!:'4!<:;u34<9 '0ou.("), objectArray2);
                        return;
                    }
                }
            });
            G.info(MqttMessage.m_hi((Object)"\u00114!4\u0001'4;&30'\u00184;420'u}\u00190410'u.(|ou\u0013<;<&=01u14!4u!'4;&30'u'0&!:'4!<:;u%':60&&{"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            G.error(c_dd.m_hi((Object)"9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fmU\u0001\u0018,\u0019(\u000fm\u00060Tw]\b\u000f?\u0012?])\b?\u0014#\u001am\u0019,\t,]9\u000f,\u0013>\u001b(\u000fm\u000f(\u000e9\u0012?\u001c9\u0014\"\u0013m\r?\u0012.\u0018>\u000ew]6\u0000"), objectArray);
            return;
        }
        finally {
            a2.C.unlock();
        }
    }

    private /* synthetic */ void lambda$handleCurrentValues$8(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        a = (VariableValue)a.get(a5.getSourceVariableId());
        a2 = (VariableValue)a2.get(a5.getTargetVariableId());
        a3 = (Variable)a3.get(a5.getTargetVariableId());
        if (a != null && a3 != null && a6.isValueInThresholdRange(a5.getThreshold(), (VariableValue)a, (VariableValue)a2)) {
            a2 = new HashMap<String, Object>();
            a2.put(MqttMessage.m_hi((Object)"#49 0"), a.getValue());
            a4.put(a3.getName(), a2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail a, Date a2, String a3) {
        Date date;
        int n;
        boolean bl;
        DataTransferManager a4;
        if (a3 == null) {
            return true;
        }
        a3 = Calendar.getInstance();
        String string = a4.k.get(a4.buildStatLastCalcTimeKey(a));
        if (string == null) {
            return true;
        }
        ((Calendar)a3).setTimeInMillis(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(a2);
        boolean bl2 = false;
        switch (c_jd.i[a.getRangeType().ordinal()]) {
            case 1: 
            case 2: {
                bl = bl2 = ((Calendar)a3).get(11) != calendar.get(11);
                break;
            }
            case 3: 
            case 4: {
                bl = bl2 = ((Calendar)a3).get(6) != calendar.get(6);
                break;
            }
            case 5: 
            case 6: {
                bl = bl2 = ((Calendar)a3).get(3) != calendar.get(3);
                break;
            }
            case 7: 
            case 8: {
                bl = bl2 = ((Calendar)a3).get(2) != calendar.get(2);
                break;
            }
            case 9: 
            case 10: {
                bl2 = ((Calendar)a3).get(1) != calendar.get(1);
            }
            default: {
                bl = bl2;
            }
        }
        if (bl) {
            DataTransferManager dataTransferManager = a4;
            String string2 = dataTransferManager.buildStatCacheKey(a);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey(a);
            String[] stringArray = new String[2];
            stringArray[0] = string2;
            stringArray[1] = string3;
            dataTransferManager.k.del(stringArray);
            return true;
        }
        if (!a.getRangeType().toString().startsWith(MqttMessage.m_hi((Object)"\u0016 ''0;!"))) {
            return false;
        }
        switch (c_jd.i[a.getRangeType().ordinal()]) {
            case 1: {
                n = 5;
                date = a2;
                break;
            }
            case 3: {
                n = 5;
                date = a2;
                break;
            }
            case 5: {
                n = 60;
                date = a2;
                break;
            }
            case 7: {
                n = 720;
                date = a2;
                break;
            }
            case 9: {
                n = 720;
                date = a2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a.getRangeType()));
            }
        }
        long l = date.getTime();
        long l2 = Long.parseLong(string);
        return l - l2 >= (long)(n * 60 * 1000);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats a, c_wda a2) {
        switch (c_jd.b[a2.ordinal()]) {
            case 1: {
                return a.getMinValue();
            }
            case 2: {
                return a.getMaxValue();
            }
            case 3: {
                return a.getAvgValue();
            }
            case 4: {
                return a.getSumValue();
            }
            case 5: {
                return a.getCountValue();
            }
            case 6: {
                return a.getFirstValue();
            }
            case 7: {
                return a.getLastValue();
            }
            case 8: {
                return a.getMaxDiffValue();
            }
            case 9: {
                return a.getLastFirstDiffValue();
            }
            case 10: {
                return a.getMiddleValue();
            }
            case 11: {
                return a.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a2));
    }

    private /* synthetic */ void transfer(DataTransfer a) {
        DataTransferManager a2;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(a3 -> {
            if (a3.getCalcType() != null && a3.getRangeType() != null) {
                arrayList2.add(a3);
                return;
            }
            arrayList.add(a3);
        });
        HashMap hashMap = new HashMap();
        if (!arrayList.isEmpty()) {
            a2.handleCurrentValues(arrayList, hashMap);
        }
        if (!arrayList2.isEmpty()) {
            a2.handleStatValues(arrayList2, hashMap);
        }
        if (!hashMap.isEmpty()) {
            a2.B.m_lnb(a.getProjectId(), hashMap);
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            Integer n = a.getProject().getId();
            G.info(c_dd.m_hi((Object)"\u00018\f9\b/w]\u0005\u001c#\u0019!\u0014#\u001am-?\u0012'\u0018.\t\t\u0018,\u001e9\u0014;\u001c9\u0018\b\u000b(\u00139]+\u0012?]=\u000f\"\u0017(\u001e9]\u00049w]6\u0000"), (Object)n);
            a2.cancelDataTransfersByProjectIdInternal(n);
            return;
        }
        G.debug(MqttMessage.m_hi((Object)"\u001b\u001a\u001bx\u0019\u0010\u0014\u0011\u0010\u0007ou\u001c2;:'<;2u\u0005':?06!\u0011046!<#4!0\u0010#0;!u3:'u%':?06!u\u001c\u0011ou.("), (Object)a.getProject().getId());
    }

    protected Map<Integer, c_wh> getDataTransferStatusesByIdsInternal(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    private /* synthetic */ void handleStatValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a3) {
        DataTransferManager a4;
        Object object = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a4.f.m_msa(object).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = a4.B.m_qob((Integer[])object.toArray(Integer[]::new));
        Date date = new Date();
        a.stream().filter(arg_0 -> a4.lambda$handleStatValues$10(date, map, a3, (Map)object, arg_0)).collect(Collectors.groupingBy(a2 -> {
            DataTransferManager a3;
            return (Date)a3.calculateDateRange(date, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> a4.lambda$handleStatValues$15(date, map, (Map)object, a3, arg_0, arg_1));
    }

    protected void cancelDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.c.m_hd((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            G.debug(c_dd.m_hi((Object)"\u00018\f9\b/w]\u000e\u001c#\u001e(\u0011!\u0014#\u001am\u0019,\t,]9\u000f,\u0013>\u001b(\u000fm\u00060]!\u0012.\u001c!\u00114S"), (Object)a);
            a2.cancelDataTransferInternal(a);
            return;
        }
        G.debug(MqttMessage.m_hi((Object)"\u001b\u001a\u001bx\u0019\u0010\u0014\u0011\u0010\u0007ou\u00070$ 0&!<;2u90410'u!:u64;609u14!4u!'4;&30'u.({"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.h.callLeaderMethod(Short.valueOf((short)402), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC cancel data transfer " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(c_dd.m_hi((Object)")\u001c9\u001c`\t?\u001c#\u000e+\u0018?G!\u001c>\t`\u001e,\u0011.P9\u0014 \u0018w\u000b,\u000f$\u001c/\u0011(Gh\u0019wX>Gh\u000e"), objectArray);
    }

    private /* synthetic */ void lambda$handleStatValues$14(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        if ((a = (LoggedVariableValueStats)a.get(a5.getSourceVariableId())) != null && (a2 = (Variable)a2.get(a5.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = a6.extractValue((LoggedVariableValueStats)a, a5.getCalcType());
            a = (VariableValue)a3.get(a5.getTargetVariableId());
            DataTransferManager dataTransferManager = a6;
            a3 = dataTransferManager.buildStatCacheKey(a5);
            String string = dataTransferManager.buildStatLastCalcTimeKey(a5);
            int n = dataTransferManager.getMaxTTLForRangeType(a5.getRangeType());
            dataTransferManager.k.setex((String)a3, (long)n, String.valueOf(d));
            a6.k.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager.isValueInThresholdRange(a5.getThreshold(), Double.valueOf(d), (VariableValue)a)) {
                a = new HashMap<String, Double>();
                a.put(MqttMessage.m_hi((Object)"#49 0"), d);
                a4.put(a2.getName(), a);
            }
        }
    }

    protected void cancelDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_cha.m_pcc(() -> {
            DataTransferManager a2;
            a2.C.lock();
            try {
                Job job = (Job)a2.l.get(a.getId());
                if (job != null) {
                    a2.F.m_oda(job);
                }
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.l.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.k.srem(M, stringArray);
                return;
            }
            finally {
                a2.C.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            G.info(c_dd.m_hi((Object)"1\b<\t8\u001fGm5,\u0013)\u0011$\u0013*]\u000e\u001c#\u001e(\u0011\b\u000b(\u00139]+\u0012?])\u001c9\u001cm\t?\u001c#\u000e+\u0018?Gm\u00060]e4\tGm\u00060T"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            a2.cancelDataTransferInternal(dataTransfer);
            return;
        }
        G.debug(MqttMessage.m_hi((Object)"\u001b\u001a\u001bx\u0019\u0010\u0014\u0011\u0010\u0007ou\u001c2;:'<;2u\u00164;609\u0010#0;!u3:'u14!4u!'4;&30'ou.("), (Object)a.getDataTransfer().getId());
    }

    public void notLeader() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        String string = dataTransferManager.h.getCurrentNode().getNodeId();
        G.info(c_dd.m_hi((Object)"9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fw]\u0019\u0015$\u000em\u0013\"\u0019(]e\u00060Tm\u0014>]\u00032m1\u00023\n8\u001f]\u00195\b]\u00018\f9\b/c]\u000e\u001c#\u001e(\u0011!\u0014#\u001am\u001c!\u0011m\u0011\"\u001e,\u0011m\u0019,\t,]9\u000f,\u0013>\u001b(\u000fm\u0017\"\u001f>ScS"), (Object)string);
        dataTransferManager.C.lock();
        try {
            new ArrayList(a.l.keySet()).forEach(a2 -> {
                DataTransferManager a3;
                Job job = (Job)a3.l.get(a2);
                if (job != null) {
                    try {
                        G.info(c_dd.m_hi((Object)"\t\u001c9\u001c\u0019\u000f,\u0013>\u001b(\u000f\u0000\u001c#\u001c*\u0018?]e3\"\tm1(\u001c)\u0018?]6\u0000dGm>,\u0013.\u0018!\u0011$\u0013*]!\u0012.\u001c!]'\u0012/]+\u0012?])\u001c9\u001cm\t?\u001c#\u000e+\u0018?]\u00049w]6\u0000"), (Object)string, a2);
                        a3.F.m_oda(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        G.error(MqttMessage.m_hi((Object)"\u00114!4\u0001'4;&30'\u00184;420'u}\u001b:!u\u00190410'u.(|ou\u0010'':'u64;6099<;2u9:649u?:7u3:'u14!4u!'4;&30'u\u001c\u0011u.(ou.("), objectArray);
                    }
                }
            });
            a.l.clear();
            G.info(MqttMessage.m_hi((Object)"\u00114!4\u0001'4;&30'\u00184;420'u}\u001b:!u\u00190410'u.(|ou\u001499u9:649u14!4u!'4;&30'u?:7&u=4#0u700;u'0$ 0&!01u!:u64;609u4;1u6904'01u3':8u9:649u!'46><;2{"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            G.error(c_dd.m_hi((Object)"\t\u001c9\u001c\u0019\u000f,\u0013>\u001b(\u000f\u0000\u001c#\u001c*\u0018?]e3\"\tm1(\u001c)\u0018?]6\u0000dGm8?\u000f\"\u000fm\u00198\u000f$\u0013*]=\u000f\"\u001e(\u000e>]\"\u001bm\u001e,\u0013.\u0018!\u0011$\u0013*]!\u0012.\u001c!])\u001c9\u001cm\t?\u001c#\u000e+\u0018?]'\u0012/\u000ew]6\u0000"), objectArray);
            return;
        }
        finally {
            a.C.unlock();
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            DataTransferManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.h.addRemoteCall((short)401, (Object)a, DataTransferManager.class.getDeclaredMethod(MqttMessage.m_hi((Object)"&6=01 90\u00114!4\u0001'4;&30'\u001c;!0';49"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.h.addRemoteCall((short)402, (Object)a, DataTransferManager.class.getDeclaredMethod(c_dd.m_hi((Object)".\u001c#\u001e(\u0011\t\u001c9\u001c\u0019\u000f,\u0013>\u001b(\u000f\u0004\u00139\u0018?\u0013,\u0011"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.h.addRemoteCall((short)403, (Object)a, DataTransferManager.class.getDeclaredMethod(MqttMessage.m_hi((Object)"20!\u00114!4\u0001'4;&30'\u0006!4! &\u001c;!0';49"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.h.addRemoteCall((short)404, (Object)a, DataTransferManager.class.getDeclaredMethod(c_dd.m_hi((Object)">\u001e%\u0018)\b!\u0018\t\u001c9\u001c\u0019\u000f,\u0013>\u001b(\u000f>?4-?\u0012'\u0018.\t\u0004\u0019\u0004\u00139\u0018?\u0013,\u0011"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.h.addRemoteCall((short)405, (Object)a, DataTransferManager.class.getDeclaredMethod(MqttMessage.m_hi((Object)"64;609\u00114!4\u0001'4;&30'&\u0017,\u0005':?06!\u001c1\u001c;!0';49"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.h.addRemoteCall((short)406, (Object)a, DataTransferManager.class.getDeclaredMethod(c_dd.m_hi((Object)"*\u001899,\t,)?\u001c#\u000e+\u0018?.9\u001c9\b>\u0018>?44)\u000e\u0004\u00139\u0018?\u0013,\u0011"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.h.addRemoteCall((short)407, (Object)a, DataTransferManager.class.getDeclaredMethod(MqttMessage.m_hi((Object)"20!\u00114!4\u0001'4;&30'\u0006!4! &0&\u0017,\u0005':?06!\u001c1\u001c;!0';49"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_dd.m_hi((Object)"\u000b\u001c$\u0011(\u0019m\t\"]?\u0018*\u0014>\t(\u000fm9,\t,)?\u001c#\u000e+\u0018?0,\u0013,\u001a(\u000fm/\u001d>m\u0010(\t%\u0012)\u000e"), noSuchMethodException);
        }
    }

    protected Map<Integer, c_wh> getDataTransferStatusesByProjectIdInternal(Integer a2) {
        DataTransferManager a3;
        if ((a2 = a3.c.m_hd((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(DataTransfer::getId, a -> {
            DataTransferManager a2;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_wh getDataTransferStatus(Integer a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            G.debug(MqttMessage.m_hi((Object)"\u0019\u0010\u0014\u0011\u0010\u0007ou\u00120!!<;2u14!4u!'4;&30'u&!4! &u3:'u\u001c\u0011ou.(u9:6499,{"), (Object)a);
            return a2.getDataTransferStatusInternal(a);
        }
        G.debug(c_dd.m_hi((Object)"\u00032\u0003P\u00018\f9\b/w]\u001f\u0018<\b(\u000e9\u0014#\u001am\u0011(\u001c)\u0018?]+\u0012?])\u001c9\u001cm\t?\u001c#\u000e+\u0018?]>\t,\t8\u000em\u001b\"\u000fm4\tGm\u00060S"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_wh)a2.h.callLeaderMethod(Short.valueOf((short)403), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get data transfer status for " + a, (Throwable)exception);
        }
    }

    protected void cancelDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.c.m_gj(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_wh> getDataTransferStatuses(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.h.isLeader()) {
            G.debug(MqttMessage.m_hi((Object)"\u0019\u0010\u0014\u0011\u0010\u0007ou\u00120!!<;2u14!4u!'4;&30'u&!4! &0&u3:'u.(u\u001c\u0011&u9:6499,ou.("), (Object)a.size(), a);
            return a2.getDataTransferStatusesByIdsInternal(a);
        }
        G.debug(c_dd.m_hi((Object)"3\u00023`1\b<\t8\u001fGm/(\f8\u0018>\t$\u0013*]!\u0018,\u0019(\u000fm\u001b\"\u000fm\u0019,\t,]9\u000f,\u0013>\u001b(\u000fm\u000e9\u001c9\b>\u0018>]+\u0012?]6\u0000m4\t\u000ew]6\u0000"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.h.callLeaderMethod(Short.valueOf((short)406), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(MqttMessage.m_hi((Object)"y"))), (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.h.addListener((ClusterNodeListener)a);
        G.info(c_dd.m_hi((Object)"\t\u001c9\u001c\u0019\u000f,\u0013>\u001b(\u000f\u0000\u001c#\u001c*\u0018?]$\u0013$\t$\u001c!\u00147\u0018)],\u0013)]?\u0018*\u0014>\t(\u000f(\u0019m\u001c>]\u000e\u00118\u000e9\u0018?3\"\u0019(1$\u000e9\u0018#\u0018?S"));
    }

    private /* synthetic */ boolean lambda$handleStatValues$10(Date a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        DataTransferManager dataTransferManager = a6;
        String string = dataTransferManager.buildStatCacheKey(a5);
        if (!dataTransferManager.shouldRecalculateStats(a5, a, string = dataTransferManager.k.get(string))) {
            a6.updateVariableWithCachedValue(string, a5, a2, a3, a4);
            return false;
        }
        return true;
    }

    private /* synthetic */ void lambda$handleStatValues$15(Date a, Map a2, Map a3, Map a4, Date a5, List a6) {
        DataTransferManager a7;
        Integer[] integerArray = (Integer[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(Integer[]::new);
        c_wda[] c_wdaArray = (c_wda[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_wda[]::new);
        a = a7.E.m_lsb(integerArray, a5, (Date)a, c_wdaArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableIdAsInt, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$14((Map)a, a2, a3, a4, arg_0));
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, VariableValue<?> a2, VariableValue<?> a3) {
        double d;
        double d2;
        if (a == null || a3 == null) {
            return true;
        }
        if (!(a2 instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d3 = ((Number)a2.getValue()).doubleValue();
        double d4 = ((Number)a3.getValue()).doubleValue();
        return (d3 == 0.0 ? (d2 = Math.abs(d4 - d3)) : (d = Math.abs((d4 - d3) / d3 * 100.0))) >= a;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            G.debug(MqttMessage.m_hi((Object)"\u0019\u0010\u0014\u0011\u0010\u0007ou\u00164;6099<;2u499u14!4u!'4;&30'&u3:'u%':?06!u.(u9:6499,{"), (Object)a);
            a2.cancelDataTransfersByProjectIdInternal(a);
            return;
        }
        G.debug(c_dd.m_hi((Object)"\u00032\u0003P\u00018\f9\b/w]\u001f\u0018<\b(\u000e9\u0014#\u001am\u0011(\u001c)\u0018?]9\u0012m\u001e,\u0013.\u0018!],\u0011!])\u001c9\u001cm\t?\u001c#\u000e+\u0018?\u000em\u001b\"\u000fm\r?\u0012'\u0018.\tm\u00060S"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.h.callLeaderMethod(Short.valueOf((short)405), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC cancel data transfers for project " + a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.c.m_xda((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_tka a) {
        switch (c_jd.i[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    private /* synthetic */ void updateVariableWithCachedValue(String a, DataTransferDetail a2, Map<Integer, Variable<?, ?, ?>> a3, Map<String, Map<String, Object>> a4, Map<Integer, VariableValue<?>> a5) {
        if ((a3 = a3.get(a2.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = Double.parseDouble((String)a);
            a = a5.get(a2.getTargetVariableId());
            if (a6.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), a)) {
                a = new HashMap<String, Double>();
                a.put(MqttMessage.m_hi((Object)"#49 0"), d);
                a4.put(a3.getName(), (Map<String, Object>)a);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.cancelDataTransfer(dataTransferManager.c.m_dd(a, a2).getId());
    }

    protected c_wh getDataTransferStatusInternal(Integer a) {
        DataTransferManager a2;
        if (a2.l.containsKey(a)) {
            return c_wh.B;
        }
        return c_wh.k;
    }

    protected void scheduleDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.c.m_pka(a));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.c.m_dd(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_wh getDataTransferStatus(Integer a, String a2) {
        DataTransferManager a3;
        if ((a = a3.c.m_ud(a, a2)) == null) {
            return c_wh.k;
        }
        return a3.getDataTransferStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.h.isLeader()) {
            G.debug(c_dd.m_hi((Object)"\u00018\f9\b/w]\u001e\u001e%\u0018)\b!\u0014#\u001am\u0019,\t,]9\u000f,\u0013>\u001b(\u000fm\u00060]!\u0012.\u001c!\u00114S"), (Object)a);
            a2.scheduleDataTransferInternal(a);
            return;
        }
        G.debug(MqttMessage.m_hi((Object)"\u001b\u001a\u001bx\u0019\u0010\u0014\u0011\u0010\u0007ou\u00070$ 0&!<;2u90410'u!:u&6=01 90u14!4u!'4;&30'u.({"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.h.callLeaderMethod(Short.valueOf((short)401), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC schedule data transfer " + a, (Throwable)exception);
        }
    }
}

