/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.restcontrollers;

import com.inscada.mono.cluster.restcontrollers.ClusterController;
import com.inscada.mono.datatransfer.m.c_wh;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.DataTransferManager;
import com.inscada.mono.datatransfer.services.c_sg;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.shared.a.c_bc;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/datatransfer"})
public class DataTransferController
extends ProjectBasedImportExportController {
    private final DataTransferManager i;
    private final c_sg b;

    @PostMapping(value={"/{dataTransferId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="dataTransferId") Integer a) {
        this.i.scheduleDataTransfer(a);
    }

    @GetMapping
    public Collection<DataTransfer> getDataTransfers(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_oa(a);
    }

    @PutMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer detailId, @Valid @RequestBody DataTransferDetail a) {
        this.b.m_hfa(dataTransferId, detailId, a);
    }

    @DeleteMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        this.b.m_qa(a);
    }

    @DeleteMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        this.b.m_eba(dataTransferId, a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.i.scheduleDataTransfers(a);
    }

    @GetMapping(value={"/{dataTransferId}/status"})
    public c_wh getDataTransferStatus(@PathVariable(value="dataTransferId") Integer a) {
        return this.i.getDataTransferStatus(a);
    }

    @DeleteMapping(value={"/details"}, params={"dataTransferDetailIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransferDetailsByIds(@RequestParam(value="dataTransferDetailIds") Integer[] a) {
        this.b.m_yba(List.of(a));
    }

    @GetMapping(value={"/{dataTransferId}"})
    public DataTransfer getDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        return this.b.m_ba(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_wh> getDataTransferStatuses(@RequestParam(value="dataTransferIds") Integer[] a) {
        return this.i.getDataTransferStatuses(Arrays.asList(a));
    }

    @DeleteMapping(value={""}, params={"dataTransferIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfersByIds(@RequestParam(value="dataTransferIds") Integer[] a) {
        this.b.m_paa(List.of(a));
    }

    @PostMapping
    public ResponseEntity<DataTransfer> createDataTransfer(@Valid @RequestBody DataTransfer dataTransfer, UriComponentsBuilder a) {
        dataTransfer = this.b.m_dca(dataTransfer);
        Object[] objectArray = new Object[1];
        objectArray[0] = dataTransfer.getId();
        return ResponseEntity.created((URI)a.path(c_bc.m_hi((Object)":\u0018q\u0002a\u0002A\u0011t\rf\u0005p\u0011\\\u0007h")).buildAndExpand(objectArray).toUri()).body((Object)dataTransfer);
    }

    @GetMapping(value={"/{dataTransferId}/details"})
    public Collection<DataTransferDetail> getDetails(@PathVariable(value="dataTransferId") Integer a) {
        return this.b.m_qca(a);
    }

    public DataTransferController(c_sg a, DataTransferManager a2, c_ff a3, c_pg a4) {
        DataTransferController a5;
        DataTransferController dataTransferController = a5;
        super(a3, EnumSet.of(c_bh.j), a4);
        dataTransferController.b = a;
        dataTransferController.i = a2;
    }

    @PutMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDataTransfer(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransfer a) {
        this.b.m_cka(dataTransferId, a);
    }

    @GetMapping(value={"/{dataTransferId}/details/{detailId}"})
    public DataTransferDetail getDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        return this.b.m_gfa(dataTransferId, a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.i.cancelDataTransfers(a);
    }

    @PostMapping(value={"/{dataTransferId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="dataTransferId") Integer a) {
        this.i.cancelDataTransfer(a);
    }

    @PostMapping(value={"/{dataTransferId}/details"})
    public ResponseEntity<DataTransferDetail> createDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransferDetail dataTransferDetail, UriComponentsBuilder a) {
        dataTransferDetail = this.b.m_ufa(dataTransferId, dataTransferDetail);
        Object[] objectArray = new Object[2];
        objectArray[0] = dataTransferId;
        objectArray[1] = dataTransferDetail.getId();
        return ResponseEntity.created((URI)a.path(ClusterController.m_hi((Object)"!\u0002j\u0018z\u0018Z\u000bo\u0017}\u001fk\u000bG\u001dsVj\u001cz\u0018g\u0015}Vu\u001dk\ro\u0010b0j\u0004")).buildAndExpand(objectArray).toUri()).body((Object)dataTransferDetail);
    }
}

