/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.enums.c_tka;
import com.inscada.mono.communication.base.enums.c_wda;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="data_transfer_detail")
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"dataTransferId", "dataTransfer"}), @CheckAtLeastOneNotNull(fieldNames={"sourceVariableId", "sourceVariable"}), @CheckAtLeastOneNotNull(fieldNames={"targetVariableId", "targetVariable"})})
public class DataTransferDetail
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="data_transfer_id")
    private DataTransfer dataTransfer;
    @ManyToOne(optional=false)
    @JoinColumn(name="target_var_id")
    private Variable<?, ?, ?> targetVariable;
    @Id
    @Column(name="data_transfer_detail_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="dataTransferDetailSeq")
    @GenericGenerator(name="dataTransferDetailSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="data_transfer_detail_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @ManyToOne(optional=false)
    @JoinColumn(name="source_var_id")
    private Variable<?, ?, ?> sourceVariable;
    @Column(name="threshold")
    private Double threshold;
    @Column(name="source_var_id", insertable=false, updatable=false)
    @NotNull
    private Integer sourceVariableId;
    @Column(name="target_var_id", insertable=false, updatable=false)
    @NotNull
    private Integer targetVariableId;
    @Column(name="calc_type")
    private c_wda calcType;
    @Column(name="data_transfer_id", insertable=false, updatable=false)
    private Integer dataTransferId;
    @Column(name="range_type")
    private c_tka rangeType;

    public void setId(Integer a) {
        a.id = a;
    }

    public int hashCode() {
        DataTransferDetail a;
        Object[] objectArray = new Object[4];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getDataTransferId();
        objectArray[2] = a.getSourceVariableId();
        objectArray[3] = a.getTargetVariableId();
        return Objects.hash(objectArray);
    }

    public Variable<?, ?, ?> getSourceVariable() {
        DataTransferDetail a;
        return a.sourceVariable;
    }

    public void setTargetVariable(Variable<?, ?, ?> a) {
        DataTransferDetail a2;
        DataTransferDetail dataTransferDetail = a2;
        dataTransferDetail.targetVariable = a;
        dataTransferDetail.targetVariableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setDataTransfer(DataTransfer a) {
        DataTransferDetail a2;
        DataTransferDetail dataTransferDetail = a2;
        dataTransferDetail.dataTransfer = a;
        dataTransferDetail.dataTransferId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Variable<?, ?, ?> getTargetVariable() {
        DataTransferDetail a;
        return a.targetVariable;
    }

    public Integer getTargetVariableId() {
        DataTransferDetail a;
        return a.targetVariableId;
    }

    public DataTransfer getDataTransfer() {
        DataTransferDetail a;
        return a.dataTransfer;
    }

    public Integer getSourceVariableId() {
        DataTransferDetail a;
        return a.sourceVariableId;
    }

    public c_tka getRangeType() {
        DataTransferDetail a;
        return a.rangeType;
    }

    public void setSourceVariableId(Integer a) {
        a.sourceVariableId = a;
    }

    public void setRangeType(c_tka a) {
        a.rangeType = a;
    }

    public Integer getId() {
        DataTransferDetail a;
        return a.id;
    }

    public void setCalcType(c_wda a) {
        a.calcType = a;
    }

    public void setDataTransferId(Integer a) {
        a.dataTransferId = a;
    }

    public boolean equals(Object a) {
        DataTransferDetail a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof DataTransferDetail)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (DataTransferDetail)a;
        return a2.getDataTransferId().equals(a.getDataTransferId()) && a2.getSourceVariableId().equals(a.getSourceVariableId()) && a2.getTargetVariableId().equals(a.getTargetVariableId());
    }

    public c_wda getCalcType() {
        DataTransferDetail a;
        return a.calcType;
    }

    public void setThreshold(Double a) {
        a.threshold = a;
    }

    public void setTargetVariableId(Integer a) {
        a.targetVariableId = a;
    }

    public void setSourceVariable(Variable<?, ?, ?> a) {
        DataTransferDetail a2;
        DataTransferDetail dataTransferDetail = a2;
        dataTransferDetail.sourceVariable = a;
        dataTransferDetail.sourceVariableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getDataTransferId() {
        DataTransferDetail a;
        return a.dataTransferId;
    }

    public Double getThreshold() {
        DataTransferDetail a;
        return a.threshold;
    }

    public DataTransferDetail() {
        DataTransferDetail a;
    }
}

