/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datasource.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="custom_query")
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public abstract class CustomQuery
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    @Column(name="query_str")
    private String queryStr;
    @Size(max=255)
    private String dsc;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @Id
    @Column(name="custom_query_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="customQuerySeq")
    @GenericGenerator(name="customQuerySeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="custom_query_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;

    public Integer getId() {
        CustomQuery a;
        return a.id;
    }

    public Project getProject() {
        CustomQuery a;
        return a.project;
    }

    public String getName() {
        CustomQuery a;
        return a.name;
    }

    public void setQueryStr(String a) {
        a.queryStr = a;
    }

    public void setProject(Project a) {
        CustomQuery a2;
        CustomQuery customQuery = a2;
        customQuery.project = a;
        customQuery.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getProjectId() {
        CustomQuery a;
        return a.projectId;
    }

    public CustomQuery() {
        CustomQuery a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public String getDsc() {
        CustomQuery a;
        return a.dsc;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public String getQueryStr() {
        CustomQuery a;
        return a.queryStr;
    }
}

