/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.template.m.c_ug;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.communication.protocols.mqtt.model.MqttMessage;
import com.inscada.mono.shared.a.c_xc;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class TemplateController<TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TTemplateService extends c_ug<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    private final TTemplateService b;

    @DeleteMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="deviceId") Integer a) {
        this.b.m_woa(a);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariableTemplate a) {
        this.b.m_tna(deviceId, frameId, variableId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    public TFrameTemplate getFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrameTemplate)this.b.m_vla(deviceId, a);
    }

    @PostMapping(value={"/devices"})
    public ResponseEntity<TDeviceTemplate> createDevice(@Valid @RequestBody TDeviceTemplate device, UriComponentsBuilder a) {
        device = this.b.m_ula(device);
        Object[] objectArray = new Object[1];
        objectArray[0] = device.getId();
        return ResponseEntity.created((URI)a.path(MqttMessage.m_hi((Object)"z10#<60&z.10#<60\u001c1(")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public Collection<TVariableTemplate> getVariables(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return this.b.m_rsa(deviceId, a);
    }

    @PutMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDeviceTemplate a) {
        this.b.m_qwa(deviceId, a);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrameTemplate a) {
        this.b.m_iua(deviceId, frameId, a);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.b.m_eqa(deviceId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    public TVariableTemplate getVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        return (TVariableTemplate)this.b.m_hma(deviceId, frameId, a);
    }

    @PostMapping(value={"/devices/{deviceId}/frames"})
    public ResponseEntity<TFrameTemplate> createFrame(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrameTemplate frame, UriComponentsBuilder a) {
        frame = this.b.m_xla(deviceId, frame);
        Object[] objectArray = new Object[2];
        objectArray[0] = deviceId;
        objectArray[1] = frame.getId();
        return ResponseEntity.created((URI)a.path(c_xc.m_hi((Object)"M\u0015\u0007\u0007\u000b\u0012\u0007\u0002M\n\u0006\u0014\u0014\u0018\u0001\u0014+\u0015\u001f^\u0004\u0003\u0003\u001c\u0007\u0002M\n\u0004\u0003\u0003\u001c\u00078\u0006\f")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @PostMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public ResponseEntity<TVariableTemplate> createVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TVariableTemplate variable, UriComponentsBuilder a) {
        variable = this.b.m_wwa(deviceId, frameId, variable);
        Object[] objectArray = new Object[3];
        objectArray[0] = deviceId;
        objectArray[1] = frameId;
        objectArray[2] = variable.getId();
        return ResponseEntity.created((URI)a.path(MqttMessage.m_hi((Object)"z10#<60&z.10#<60\u001c1(z3'480&z.3'480\u001c1(z#4'<4790&z.#4'<4790\u001c1(")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDeviceTemplate> getDevices() {
        TemplateController a;
        return a.b.m_aua();
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        this.b.m_xna(deviceId, frameId, a);
    }

    public TemplateController(TTemplateService a) {
        TemplateController a2;
        a2.b = a;
    }

    @GetMapping(value={"/devices/{deviceId}/frames"})
    public Collection<TFrameTemplate> getFrames(@PathVariable(value="deviceId") Integer a) {
        return this.b.m_esa(a);
    }

    @GetMapping(value={"/devices/{deviceId}"})
    public TDeviceTemplate getDevice(@PathVariable(value="deviceId") Integer a) {
        return (TDeviceTemplate)this.b.m_mua(a);
    }
}

