/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_cha;
import com.inscada.mono.c_dga;
import com.inscada.mono.cluster.m.c_oga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.communication.base.enums.c_oba;
import com.inscada.mono.communication.base.events.DeleteEvent;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.ConnectorFactory;
import com.inscada.mono.communication.base.services.c_efa;
import com.inscada.mono.communication.base.services.c_rf;
import com.inscada.mono.communication.base.services.c_t;
import com.inscada.mono.license.services.c_ok;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.aspects.SpaceFilterAspect;
import com.inscada.mono.shared.exceptions.c_jf;
import com.inscada.mono.shared.exceptions.c_vc;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener {
    private final ConnectorFactory<C, V> E;
    private final c_ye M;
    public static final short J = 203;
    private static final Logger G = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short H = 210;
    public static final short D = 202;
    private final Lock l;
    public static final short F = 201;
    public static final short a = 204;
    public static final short f = 206;
    private final JedisPooled c;
    private final c_efa I;
    public static final short h = 205;
    private final ClusterOperations A;
    public static final short C = 208;
    private static final String B = "activeConnections";
    public static final short k = 209;
    public static final short i = 207;
    private final c_ok b;

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ConnectionManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.A.addRemoteCall((short)201, (Object)a, ConnectionManager.class.getDeclaredMethod(SpaceFilterAspect.m_hi((Object)"7M%K0z+W*\\'M-V*p*M!K*X("), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.A.addRemoteCall((short)202, (Object)a, ConnectionManager.class.getDeclaredMethod(c_dga.m_hi((Object)"z,f(J7g6l;}1f6@6}={6h4"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.A.addRemoteCall((short)203, (Object)a, ConnectionManager.class.getDeclaredMethod(SpaceFilterAspect.m_hi((Object)"#\\0z+W*\\'M-V*j0X0L7p*M!K*X("), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = SetValueRequest.class;
            a.A.addRemoteCall((short)204, (Object)a, ConnectionManager.class.getDeclaredMethod(c_dga.m_hi((Object)"z=}\u000eh*`9k4l\u000eh4|=@6}={6h4"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Collection.class;
            a.A.addRemoteCall((short)205, (Object)a, ConnectionManager.class.getDeclaredMethod(SpaceFilterAspect.m_hi((Object)"7\\0o%K-X&U!o%U1\\7p*M!K*X("), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.A.addRemoteCall((short)206, (Object)a, ConnectionManager.class.getDeclaredMethod(c_dga.m_hi((Object)"+}9{,J7g6l;}1f6z\u001ap\b{7c=j,@<@6}={6h4"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.A.addRemoteCall((short)207, (Object)a, ConnectionManager.class.getDeclaredMethod(SpaceFilterAspect.m_hi((Object)"J0V4z+W*\\'M-V*J\u0006@\u0014K+S!Z0p p*M!K*X("), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.A.addRemoteCall((short)208, (Object)a, ConnectionManager.class.getDeclaredMethod(c_dga.m_hi((Object)"n=}\u001bf6g=j,`7g\u000b}9}-z=z\u001ap\b{7c=j,@<@6}={6h4"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer[].class;
            a.A.addRemoteCall((short)209, (Object)a, ConnectionManager.class.getDeclaredMethod(SpaceFilterAspect.m_hi((Object)"^!M\u0007V*W!Z0P+W\u0017M%M1J!J\u0006@\r]7p*M!K*X("), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = Integer.class;
            a.A.addRemoteCall((short)210, (Object)a, ConnectionManager.class.getDeclaredMethod(c_dga.m_hi((Object)"k*f/z=J7g6l;}1f6@6}={6h4"), classArray10));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(SpaceFilterAspect.m_hi((Object)"\u007f%P(\\ \u00190VdK!^-J0\\6\u0019\u0007V*W!Z0P+W\tX*X#\\6\u0019\u0016i\u0007\u0019)\\0Q+]7"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.stopConnection(connectionManager.I.m_bub(a, a2).getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.A.addListener((ClusterNodeListener)a);
        G.info(c_dga.m_hi((Object)"J7g6l;}1f6D9g9n={x`6`,`9e1s=mxh6mx{=n1z,l*l<)9zxJ4|+}={\u0016f<l\u0014`+}=g={v"));
    }

    protected void startConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.startConnectionInternal(connectionManager.I.m_pka(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        String string = connectionManager.A.getCurrentNode().getNodeId();
        G.info(c_dga.m_hi((Object)"J7g6l;}1f6D9g9n={b)\fa1zxg7m=)pr% xa9zxk=j7d=),a=)\u0014L\u0019M\u001d[v)\nl+}7{1g?)9j,`.lxj7g6l;}1f6zv'v"), (Object)string);
        connectionManager.l.lock();
        try {
            Set set = a2.c.smembers(B).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                G.info(SpaceFilterAspect.m_hi((Object)"\u0007V*W!Z0P+W\tX*X#\\6\u0019lu!X \\6\u0019?Dm\u0003dw+\u0019%Z0P2\\dZ+W*\\'M-V*Jd_+L*]dP*\u0019\u0016\\ P7\u00190VdK!J0V6\\j"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            G.info(c_dga.m_hi((Object)"\u001bf6g=j,`7g\u0015h6h?l*)pE=h<l*)#tq3xO7|6mxr%)9j,`.lxj7g6l;}1f6)\u0011M+)1gx[=m1zx}7)*l+}7{=3xr%"), objectArray);
            ArrayList arrayList = new ArrayList(a2.I.m_cxb(set));
            G.info(SpaceFilterAspect.m_hi((Object)"z+W*\\'M-V*t%W%^!Kd\u0011\b\\%]!KdB9\u0010~\u0019\u0005M0\\)I0P*^dM+\u00196\\7M+K!\u0019?DdZ+W*\\'M-V*Jj"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ConnectionManager a2;
                String string = a2.A.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    G.info(c_dga.m_hi((Object)"J7g6l;}1f6D9g9n={x!\u0014l9m={xr% b)\nl+}7{1g?);f6g=j,`7gb)#tx!\u0011Mb)#tq"), objectArray);
                    a2.startConnectionInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.M.m_rea(a.getProject()).m_w("Connection Restore (Leader " + string + ")", String.format(SpaceFilterAspect.m_hi((Object)"\u001c7\u0019lp\u0000\u0003d\u001c \u0010d_%P(\\ \u00190VdK!J0V6\\j\u0019\u0007X1J!\u0003d\u001c7"), objectArray));
                    try {
                        G.warn(c_dga.m_hi((Object)"J7g6l;}1f6D9g9n={x!\u0014l9m={xr% b)\u0019},l5y,`6nx}7)+}7yxj7g6l;}1f6)#txh>}={x{=z,f*h,`7gxo9`4|*lv"), (Object)string, (Object)a.getId());
                        a2.stopConnectionInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        G.error(SpaceFilterAspect.m_hi((Object)"\u0007V*W!Z0P+W\tX*X#\\6\u0019lu!X \\6\u0019?Dm\u0003d\u007f%P(\\ \u00190VdJ0V4\u0019'V*W!Z0P+WdB9\u0019%_0\\6\u00196\\7M+K%M-V*\u0019\"X-U1K!\u0003dB9"), objectArray2);
                        return;
                    }
                }
            });
            G.info(c_dga.m_hi((Object)"\u001bf6g=j,`7g\u0015h6h?l*)pE=h<l*)#tq3xO1g1z0l<);f6g=j,`7gx{=z,f*h,`7gxy*f;l+zv"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            G.error(SpaceFilterAspect.m_hi((Object)"z+W*\\'M-V*t%W%^!Kd\u0011\b\\%]!KdB9\u0010~\u0019\u0001K6V6\u0019 L6P*^dZ+W*\\'M-V*\u00196\\7M+K%M-V*\u00194K+Z!J7\u0003dB9"), objectArray);
            return;
        }
        finally {
            a2.l.unlock();
        }
    }

    public ConnectionManager(c_efa a, c_ok a2, c_ye a3, ConnectorFactory<C, V> a4, JedisPooled a5, ClusterOperations a6) {
        ConnectionManager a7;
        ConnectionManager connectionManager = a7;
        ConnectionManager connectionManager2 = a7;
        ConnectionManager connectionManager3 = a7;
        ConnectionManager connectionManager4 = a7;
        connectionManager4.l = new ReentrantLock();
        connectionManager3.I = a;
        connectionManager3.b = a2;
        connectionManager2.M = a3;
        connectionManager2.E = a4;
        connectionManager.c = a5;
        connectionManager.A = a6;
    }

    protected Map<Integer, c_oba> getConnectionStatusesByIdsInternal(Integer[] a2) {
        ConnectionManager a3;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> a3.getConnectionStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={DeleteEvent.class})
    public void handleDeleteEvent(DeleteEvent a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            Connection connection = a.getConnection();
            G.info(c_dga.m_hi((Object)"E\u001dH\u001cL\n3xA9g<e1g?)\u001cl4l,l\u001d\u007f=g,)>f*);f6g=j,`7gb)#tx!\u0011Mb)#tq"), (Object)connection.getName(), (Object)connection.getId());
            a2.stopConnectionInternal(connection);
            return;
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"\nv\n\u0014\b|\u0005}\u0001k~\u0019\r^*V6P*^d}!U!M!|2\\*Md_+KdZ+W*\\'M-V*\u0003dB9"), (Object)a.getConnection().getId());
    }

    protected void stopConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_cha.m_pcc(() -> {
            ConnectionManager a2;
            a2.l.lock();
            try {
                c_rf c_rf2 = a2.E.getConnector(a.getId());
                if (c_rf2 != null) {
                    c_rf2.m_yfb();
                    a2.E.removeConnector(a.getId(), c_rf2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.c.srem(B, stringArray);
                return;
            }
            finally {
                a2.l.unlock();
            }
        }, a);
    }

    protected void stopConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.I.m_hd((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    protected Object browseConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        Connection connection = connectionManager.I.m_gj(a);
        return c_cha.m_svb(() -> {
            ConnectionManager a2;
            if ((a = a2.E.getConnector(a)) instanceof c_t) {
                return ((c_t)a).m_ja();
            }
            throw new RuntimeException(SpaceFilterAspect.m_hi((Object)"{6V3J!\u0019+I!K%M-V*\u0019*V0\u00197L4I+K0\\ "));
        }, (OwnedSpaceBaseModel)connection);
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"E\u001dH\u001cL\n3xZ,f(y1g?)9e4);f6g=j,`7g+)>f*)({7c=j,)#txe7j9e4pv"), (Object)a);
            a2.stopConnectionsByProjectIdInternal(a);
            return;
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"\nv\n\u0014\b|\u0005}\u0001k~\u0019\u0016\\5L!J0P*^dU!X \\6\u00190VdJ0V4\u0019%U(\u0019'V*W!Z0P+W7\u0019\"V6\u00194K+S!Z0\u0019?Dj"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)207), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC stop connections for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_oba getConnectionStatus(Integer a, String a2) {
        ConnectionManager a3;
        if ((a = a3.I.m_ud(a, a2)) == null) {
            return c_oba.b;
        }
        return a3.getConnectionStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_oba> getConnectionStatuses(Integer[] a) {
        ConnectionManager a2;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"\u0014L\u0019M\u001d[b)\u001fl,}1g?);f6g=j,`7gxz,h,|+l+)>f*)#tx@\u001czxe7j9e4pv"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal(a);
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"\nv\n\u0014\b|\u0005}\u0001k~\u0019\u0016\\5L!J0P*^dU!X \\6\u0019\"V6\u0019'V*W!Z0P+WdJ0X0L7\\7\u0019\"V6\u0019?Ddp\u0000Jj"), (Object)a.length);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.A.callLeaderMethod(Short.valueOf((short)209), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get connection statuses for IDs " + Arrays.toString((Object[])a), (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_cha.m_pcc(() -> {
            ConnectionManager a2;
            a2.l.lock();
            try {
                a2.stopConnectionInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_jf("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.b.m_eka();
                connectionManager.E.provideConnector(a).m_tfb();
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                connectionManager.c.sadd(B, stringArray);
                return;
            }
            finally {
                a2.l.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"E\u001dH\u001cL\n3xZ,h*}1g?)9e4);f6g=j,`7g+)>f*)({7c=j,)#txe7j9e4pv"), (Object)a);
            a2.startConnectionsByProjectIdInternal(a);
            return;
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"w\u000bwiu\u0001x\u0000|\u0016\u0003dk!H1\\7M-W#\u0019(\\%]!KdM+\u00197M%K0\u0019%U(\u0019'V*W!Z0P+W7\u0019\"V6\u00194K+S!Z0\u0019?Dj"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)206), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC start connections for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> a22) {
        ConnectionManager a3;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_dga.m_hi((Object)"Z=}\u000eh4|=[=x-l+}xj9g6f,):lxg-e4")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), SpaceFilterAspect.m_hi((Object)"z+W*\\'M-V*p \u0019-Wdj!M\u0012X(L!k!H1\\7MdZ%W*V0\u0019&\\dW1U(")));
        if (a3.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"\u0014L\u0019M\u001d[b)\u000bl,}1g?)#tx\u007f9{1h:e=).h4|=zxe7j9e4pv"), (Object)a22.size());
            a3.setVariableValuesInternal(a22);
            return;
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"w\u000bwiu\u0001x\u0000|\u0016\u0003dk!H1\\7M-W#\u0019(\\%]!KdM+\u00197\\0\u0019?DdO%K-X&U!\u00192X(L!Jj"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<SetValueRequest<V>>(a22);
            a3.A.callLeaderMethod(Short.valueOf((short)205), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new c_oga(c_dga.m_hi((Object)"\u001eh1e=mx}7)\nY\u001b)+l,).h*`9k4lx\u007f9e-l+"), (Throwable)a22);
        }
    }

    public void notLeader() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        String string = connectionManager.A.getCurrentNode().getNodeId();
        G.info(SpaceFilterAspect.m_hi((Object)"\u0007V*W!Z0P+W\tX*X#\\6\u0003dm,P7\u0019*V \\d\u0011?Dm\u0019-Jdw\u000b\u0019\bv\n~\u0001kdm\f|du\u0001x\u0000|\u0016\u0017dj0V4I-W#\u0019%U(\u0019(V'X(\u0019'V*W!Z0V6Jj\u0017j"), (Object)string);
        connectionManager.l.lock();
        try {
            a.E.stopAllLocalConnectors();
            G.info(c_dga.m_hi((Object)"J7g6l;}1f6D9g9n={x!\u0016f,)\u0014l9m={xr% b)\u0019e4)4f;h4);f6g=j,f*zxa9\u007f=):l=gx{=x-l+}=mx}7)+}7yxh6mxj4l9{=mxo*f5)4f;h4),{9j3`6nv"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            G.error(SpaceFilterAspect.m_hi((Object)"z+W*\\'M-V*t%W%^!Kd\u0011\nV0\u0019\b\\%]!KdB9\u0010~\u0019\u0001K6V6\u0019 L6P*^dI6V'\\7JdV\"\u00197M+I4P*^dU+Z%UdZ+W*\\'M+K7\u0003dB9"), objectArray);
            return;
        }
        finally {
            a.l.unlock();
        }
    }

    protected Map<Integer, c_oba> getConnectionStatusesByProjectIdInternal(Integer a2) {
        ConnectionManager a3;
        if ((a2 = a3.I.m_hd((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Connection::getId, a -> {
            ConnectionManager a2;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_oba getConnectionStatus(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"\u0014L\u0019M\u001d[b)\u001fl,}1g?);f6g=j,`7gxz,h,|+)>f*)#txe7j9e4pv"), (Object)a);
            return a2.getConnectionStatusInternal(a);
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"\nv\n\u0014\b|\u0005}\u0001k~\u0019\u0016\\5L!J0P*^dU!X \\6\u0019\"V6\u0019'V*W!Z0P+WdJ0X0L7\u0019\"V6\u0019?Dj"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_oba)a2.A.callLeaderMethod(Short.valueOf((short)203), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get connection status for " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={RestartEvent.class})
    public void handleRestartEvent(RestartEvent a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            Connection connection = a.getConnection();
            G.info(SpaceFilterAspect.m_hi((Object)"\b|\u0005}\u0001k~\u0019\fX*](P*^dk!J0X6M\u0001O!W0\u0019\"V6\u0019'V*W!Z0P+W~\u0019?Dd\u0011\r}~\u0019?Dm"), (Object)connection.getName(), (Object)connection.getId());
            a2.l.lock();
            try {
                if (a2.getConnectionStatusInternal(connection.getId()) == c_oba.i) {
                    a2.startConnectionInternal(connection.getId());
                }
                return;
            }
            finally {
                a2.l.unlock();
            }
        }
        G.debug(c_dga.m_hi((Object)"G\u0017GuE\u001dH\u001cL\n3x@?g7{1g?)\nl+}9{,L.l6}xo7{xj7g6l;}1f63xr%"), (Object)a.getConnection().getId());
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(SpaceFilterAspect.m_hi((Object)"\b|\u0005}\u0001k~\u0019\u0017M+I4P*^dZ+W*\\'M-V*\u0019?DdU+Z%U(@j"), (Object)a);
            a2.stopConnectionInternal(a);
            return;
        }
        G.debug(c_dga.m_hi((Object)"G\u0017GuE\u001dH\u001cL\n3x[=x-l+}1g?)4l9m={x}7)+}7yxj7g6l;}1f6)#tv"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)202), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC stop connection " + a, (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> a) {
        ConnectionManager a2;
        c_rf c_rf2 = a2.E.getConnector(a.getConnectionId());
        if (c_rf2 == null) {
            throw new c_vc("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_rf2.m_gbb(a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(SpaceFilterAspect.m_hi((Object)"\b|\u0005}\u0001k~\u0019\u0017M%K0P*^dZ+W*\\'M-V*\u0019?DdU+Z%U(@j"), (Object)a);
            a2.startConnectionInternal(a);
            return;
        }
        G.debug(c_dga.m_hi((Object)"\u0016F\u0016$\u0014L\u0019M\u001d[b)\nl)|=z,`6nxe=h<l*),fxz,h*}xj7g6l;}1f6)#tv"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)201), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC start connection " + a, (Throwable)exception);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> a3) {
        ConnectionManager a4;
        a3.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((a, a2) -> {
            ConnectionManager a3;
            if ((a = a3.E.getConnector(a)) != null) {
                a.m_shb(a2);
            }
        });
    }

    protected c_oba getConnectionStatusInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.E.getConnector(a)) != null && a.m_xgb()) {
            return c_oba.i;
        }
        return c_oba.b;
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_oba> getConnectionStatuses(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"\u0014L\u0019M\u001d[b)\u001fl,}1g?)9e4);f6g=j,`7gxz,h,|+l+)>f*)({7c=j,)#txe7j9e4pv"), (Object)a);
            return a2.getConnectionStatusesByProjectIdInternal(a);
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"\nv\n\u0014\b|\u0005}\u0001k~\u0019\u0016\\5L!J0P*^dU!X \\6\u0019\"V6\u0019%U(\u0019'V*W!Z0P+WdJ0X0L7\\7\u0019\"V6\u00194K+S!Z0\u0019?Dj"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.A.callLeaderMethod(Short.valueOf((short)208), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get connection statuses for project " + a, (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.I.m_xda((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.startConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> a) {
        ConnectionManager a2;
        Objects.requireNonNull(a, c_dga.m_hi((Object)"Z=}\u000eh4|=[=x-l+}xj9g6f,):lxg-e4"));
        Objects.requireNonNull(a.getConnectionId(), SpaceFilterAspect.m_hi((Object)"z+W*\\'M-V*p \u0019-Wdj!M\u0012X(L!k!H1\\7MdZ%W*V0\u0019&\\dW1U("));
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"E\u001dH\u001cL\n3xZ=},`6nx\u007f9{1h:e=).h4|=)>f*);f6g=j,`7gxr%)4f;h4e!3xr%"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"\nv\n\u0014\b|\u0005}\u0001k~\u0019\u0016\\5L!J0P*^dU!X \\6\u00190VdJ!MdO%K-X&U!\u00192X(L!\u0019\"V6\u0019'V*W!Z0P+WdB9\u0003dB9"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)204), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(Integer a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            G.debug(c_dga.m_hi((Object)"E\u001dH\u001cL\n3xY={>f*d1g?):{7~+lxf(l*h,`7gxo7{xj7g6l;}1f6)#txe7j9e4pv"), (Object)a);
            return a2.browseConnectionInternal(a);
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"w\u000bwiu\u0001x\u0000|\u0016\u0003dk!H1\\7M-W#\u0019(\\%]!KdM+\u00194\\6_+K)\u0019&K+N7\\dV4\\6X0P+Wd_+KdZ+W*\\'M-V*\u0019?Dj"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return a2.A.callLeaderMethod(Short.valueOf((short)210), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC browse connection " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.startConnection(connectionManager.I.m_bub(a, a2).getId());
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ConnectionManager a2;
        if (a2.A.isLeader()) {
            Integer n = a.getProject().getId();
            G.info(c_dga.m_hi((Object)"E\u001dH\u001cL\n3xA9g<e1g?)\b{7c=j,M=h;}1\u007f9}=L.l6}xo7{xy*f2l;}x@\u001c3xr%"), (Object)n);
            a2.stopConnectionsByProjectIdInternal(n);
            return;
        }
        G.debug(SpaceFilterAspect.m_hi((Object)"w\u000bwiu\u0001x\u0000|\u0016\u0003dp#W+K-W#\u0019\u0014K+S!Z0}!X'M-O%M!|2\\*Md_+KdI6V.\\'Mdp\u0000\u0003dB9"), (Object)a.getProject().getId());
    }

    protected void stopConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.stopConnectionInternal(connectionManager.I.m_gj(a));
    }
}

