/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.services.c_ve;
import com.inscada.mono.system.model.Stats;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class VariableController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    private final c_ve<TConnection, TDevice, TFrame, TVariable> b;

    public VariableController(c_ve<TConnection, TDevice, TFrame, TVariable> a) {
        VariableController a2;
        a2.b = a;
    }

    @PostMapping
    public ResponseEntity<TVariable> createVariable(@Valid @RequestBody TVariable variable, UriComponentsBuilder a) {
        variable = this.b.m_lta(variable);
        Object[] objectArray = new Object[1];
        objectArray[0] = variable.getId();
        return ResponseEntity.created((URI)a.path(Stats.m_hi((Object)"W'\u000e=\n5\u0019>\u0014918\u0005")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @DeleteMapping(value={"/filter"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariablesByFilter(@Valid @RequestBody VariableFilter a) {
        this.b.m_upa(a);
    }

    @GetMapping(value={"/{variableId}"})
    public TVariable getVariable(@PathVariable(value="variableId") Integer a) {
        return (TVariable)this.b.m_ba(a);
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void upsertVariables(@Valid @RequestBody Collection<TVariable> a) {
        this.b.m_rh(a, true);
    }

    @PutMapping(value={"/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariable a) {
        this.b.m_mpa(variableId, a);
    }

    @DeleteMapping(value={"/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="variableId") Integer a) {
        this.b.m_qa(a);
    }

    @DeleteMapping(value={""}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.b.m_qoa(List.of(a));
    }

    @GetMapping(params={"projectId", "name"})
    public TVariable getVariableByName(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return (TVariable)this.b.m_apa(projectId, a);
    }

    @GetMapping(params={"variableIds"})
    public Collection<TVariable> getVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        return this.b.m_msa(Arrays.asList(a));
    }

    @GetMapping(params={"projectId"})
    public Collection<TVariable> getVariables(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_oa(a);
    }

    @GetMapping(value={"/pages"}, params={"projectId"})
    public Page<TVariable> getVariablesByPages(@RequestParam(name="projectId") Integer projectId, Pageable a) {
        return this.b.m_ksa(projectId, a);
    }

    @GetMapping(params={"frameId"})
    public Collection<TVariable> getVariablesByFrameId(@RequestParam(name="frameId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_jpa(a);
    }
}

