/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.auth.services.m.a.m.c_iaa;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_di;
import com.inscada.mono.communication.base.template.m.c_ug;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_di<TConnection, TDevice, TFrame>, TTemplateService extends c_ug> {
    protected final TConnectionService i;
    protected final TTemplateService b;

    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TDevice device, UriComponentsBuilder a) {
        device = this.i.m_psa(connectionId, device, Boolean.valueOf(true));
        Object[] objectArray = new Object[2];
        objectArray[0] = connectionId;
        objectArray[1] = device.getId();
        return ResponseEntity.created((URI)a.path(c_iaa.m_hi((Object)"So\u001f{\u0012z\u0019w\b}\u0013z5p\u0001;\u0018q\n}\u001fq\u000f;\u0007p\u0019b\u0015w\u0019]\u0018i")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable(value="connectionId") Integer a) {
        return this.i.m_pna(a);
    }

    protected ConnectionController(TConnectionService a, TTemplateService a2) {
        ConnectionController a3;
        ConnectionController connectionController = a3;
        connectionController.i = a;
        connectionController.b = a2;
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrame a) {
        this.i.m_ewa(connectionId, deviceId, frameId, a, Boolean.valueOf(true));
    }

    @DeleteMapping(value={""}, params={"connectionIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam(value="connectionIds") Integer[] a) {
        this.i.m_zra(List.of(a));
    }

    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrame frame, UriComponentsBuilder a) {
        frame = this.i.m_nwa(connectionId, deviceId, frame, Boolean.valueOf(true));
        Object[] objectArray = new Object[3];
        objectArray[0] = connectionId;
        objectArray[1] = deviceId;
        objectArray[2] = frame.getId();
        return ResponseEntity.created((URI)a.path(AuthToken.m_hi((Object)"\u0003yOmBlIaXkClefQ-HgZkOg_-WfItEaIKH\u007f\u0003d^cAg_-Wd^cAgefQ")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        this.i.m_yma(connectionId, a);
    }

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable(value="connectionId") Integer a) {
        this.i.m_qa(a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.i.m_hua(connectionId, deviceId, a);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return this.i.m_sua(connectionId, a);
    }

    public static String m_hi(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (3 ^ 5) << 4;
        int cfr_ignored_0 = 5 << 4 ^ (3 << 2 ^ 3);
        int n4 = n2;
        int n5 = 2 << 3 ^ 2;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TConnection a) {
        this.i.m_hpa(connectionId, a);
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable(value="connectionId") Integer a) {
        return (TConnection)this.i.m_ba(a);
    }

    @GetMapping
    public Collection<TConnection> getConnections(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.i.m_da();
        }
        return this.i.m_oa(a);
    }

    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable(value="connectionId") Integer connectionId, @RequestBody DeviceGenerationRequest a) {
        this.b.m_mta(connectionId, a);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.i.m_ola();
        }
        return this.i.m_nsa(a);
    }

    @DeleteMapping(value={"/frames"}, params={"frameIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam(value="frameIds") Integer[] a) {
        this.i.m_lva(List.of(a));
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevicesByProjectId(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.i.m_aua();
        }
        return this.i.m_vma(a);
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable(value="frameId") Integer a) {
        return (TFrame)this.i.m_hqa(a);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.i.m_xpa(a);
    }

    @DeleteMapping(value={"/devices"}, params={"deviceIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam(value="deviceIds") Integer[] a) {
        this.i.m_bna(List.of(a));
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.i.m_xwa(connectionId, a);
    }

    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection connection, UriComponentsBuilder a) {
        connection = this.i.m_uoa(connection);
        Object[] objectArray = new Object[1];
        objectArray[0] = connection.getId();
        return ResponseEntity.created((URI)a.path(c_iaa.m_hi((Object)";\u0007w\u0013z\u0012q\u001f`\u0015{\u0012]\u0018i")).buildAndExpand(objectArray).toUri()).body(connection);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDevice a) {
        this.i.m_npa(connectionId, deviceId, a, Boolean.valueOf(true));
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrame)this.i.m_hna(connectionId, deviceId, a);
    }
}

