/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.enums.c_lia;
import com.inscada.mono.communication.base.enums.c_nka;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Where;

@Entity
@Table(name="variable")
@Inheritance(strategy=InheritanceType.JOINED)
@Where(clause="project_id is not null")
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})})
public class Variable<TFrame extends Frame<?, ?>, TDevice extends Device<?, ?>, TConnection extends Connection<?>>
extends SpaceBaseModel {
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @JsonIgnore
    @Transient
    protected VariableValue<?> value;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected Integer valueExpressionId;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected Integer frameId;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    protected String unit;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @JsonIgnore
    @OneToMany(mappedBy="sourceVariable")
    protected Set<DataTransferDetail> sourceVariableDataTransferDetails;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected Integer logExpressionId;
    @Column(name="value_expression_type")
    protected c_lia valueExpressionType;
    @Column(name="log_type")
    protected c_nka logType;
    @Size(max=20)
    protected String code;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @JsonIgnore
    @OneToMany(mappedBy="targetVariable")
    protected Set<DataTransferDetail> targetVariableDataTransferDetails;
    @JsonIgnore
    @ManyToOne(targetEntity=Frame.class)
    @JoinColumn(name="frame_id")
    protected TFrame frame;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @Id
    @Column(name="variable_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="variableSeq")
    @GenericGenerator(name="variableSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="variable_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Column(name="project_id", insertable=false, updatable=false)
    protected Integer projectId;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @Size(max=255)
    protected String dsc;

    public void setValueExpressionCode(String a) {
        a.valueExpressionCode = a;
    }

    public Set<DataTransferDetail> getSourceVariableDataTransferDetails() {
        Variable a;
        return a.sourceVariableDataTransferDetails;
    }

    public void setUnit(String a) {
        a.unit = a;
    }

    public void setFrame(TFrame a) {
        Variable a2;
        Variable variable = a2;
        variable.frame = a;
        variable.frameId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Set<DataTransferDetail> getTargetVariableDataTransferDetails() {
        Variable a;
        return a.targetVariableDataTransferDetails;
    }

    public VariableValue<?> getValue() {
        Variable a;
        return a.value;
    }

    public Double getLogThreshold() {
        Variable a;
        return a.logThreshold;
    }

    public String getName() {
        Variable a;
        return a.name;
    }

    public Double getEngFullScale() {
        Variable a;
        return a.engFullScale;
    }

    public Double getLogMaxValue() {
        Variable a;
        return a.logMaxValue;
    }

    public void setLogMaxValue(Double a) {
        a.logMaxValue = a;
    }

    public void setRawFullScale(Double a) {
        a.rawFullScale = a;
    }

    public void setLogExpression(Expression a) {
        Variable a2;
        Variable variable = a2;
        variable.logExpression = a;
        variable.logExpressionId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setFrameId(Integer a) {
        a.frameId = a;
    }

    public Double getRawFullScale() {
        Variable a;
        return a.rawFullScale;
    }

    public Integer getConnectionId() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return a.getDevice().getConnectionId();
    }

    public Integer getLogPeriod() {
        Variable a;
        return a.logPeriod;
    }

    public Boolean getIsPulseOff() {
        Variable a;
        return a.isPulseOff;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public Integer getValueExpressionId() {
        Variable a;
        return a.valueExpressionId;
    }

    public Double getEngZeroScale() {
        Variable a;
        return a.engZeroScale;
    }

    public void setTargetVariableDataTransferDetails(Set<DataTransferDetail> a) {
        a.targetVariableDataTransferDetails = a;
    }

    public Project getProject() {
        Variable a;
        return a.project;
    }

    public String getCode() {
        Variable a;
        return a.code;
    }

    public Integer getDeviceId() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return a.frame.getDeviceId();
    }

    public Double getSetMaxValue() {
        Variable a;
        return a.setMaxValue;
    }

    public Expression getValueExpression() {
        Variable a;
        return a.valueExpression;
    }

    public Double getLogMinValue() {
        Variable a;
        return a.logMinValue;
    }

    public void setSetMaxValue(Double a) {
        a.setMaxValue = a;
    }

    public Integer getPulseOffDuration() {
        Variable a;
        return a.pulseOffDuration;
    }

    public TFrame getFrame() {
        Variable a;
        return (TFrame)a.frame;
    }

    public Variable() {
        Variable a;
    }

    public void setPulseOffDuration(Integer a) {
        a.pulseOffDuration = a;
    }

    public c_nka getLogType() {
        Variable a;
        return a.logType;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setEngFullScale(Double a) {
        a.engFullScale = a;
    }

    public String getUnit() {
        Variable a;
        return a.unit;
    }

    public Short getFractionalDigitCount() {
        Variable a;
        return a.fractionalDigitCount;
    }

    public void setLogExpressionCode(String a) {
        a.logExpressionCode = a;
    }

    public void setLogThreshold(Double a) {
        a.logThreshold = a;
    }

    public void setIsActive(Boolean a) {
        a.isActive = a;
    }

    public void setKeepLastValues(Boolean a) {
        a.keepLastValues = a;
    }

    public void setValueExpression(Expression a) {
        Variable a2;
        Variable variable = a2;
        variable.valueExpression = a;
        variable.valueExpressionId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setLogExpressionId(Integer a) {
        a.logExpressionId = a;
    }

    public void setPulseOnDuration(Integer a) {
        a.pulseOnDuration = a;
    }

    public Integer getFrameId() {
        Variable a;
        return a.frameId;
    }

    public String getValueExpressionCode() {
        Variable a;
        return a.valueExpressionCode;
    }

    @JsonIgnore
    public TDevice getDevice() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return (TDevice)a.frame.getDevice();
    }

    @JsonIgnore
    public TConnection getConnection() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return (TConnection)a.getDevice().getConnection();
    }

    public boolean equals(Object a) {
        Variable a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Variable)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Variable)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setValueExpressionId(Integer a) {
        a.valueExpressionId = a;
    }

    public void setProject(Project a) {
        Variable a2;
        Variable variable = a2;
        variable.project = a;
        variable.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getPulseOnDuration() {
        Variable a;
        return a.pulseOnDuration;
    }

    public Integer getId() {
        Variable a;
        return a.id;
    }

    public void setCode(String a) {
        a.code = a;
    }

    public void setValue(VariableValue<?> a) {
        a.value = a;
    }

    public void setFractionalDigitCount(Short a) {
        a.fractionalDigitCount = a;
    }

    public Expression getLogExpression() {
        Variable a;
        return a.logExpression;
    }

    public c_lia getValueExpressionType() {
        Variable a;
        return a.valueExpressionType;
    }

    public int hashCode() {
        Variable a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setLogPeriod(Integer a) {
        a.logPeriod = a;
    }

    public Double getSetMinValue() {
        Variable a;
        return a.setMinValue;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public String getDsc() {
        Variable a;
        return a.dsc;
    }

    public void setRawZeroScale(Double a) {
        a.rawZeroScale = a;
    }

    public void setLogType(c_nka a) {
        a.logType = a;
    }

    public void setIsPulseOff(Boolean a) {
        a.isPulseOff = a;
    }

    public Boolean getKeepLastValues() {
        Variable a;
        return a.keepLastValues;
    }

    public void setSourceVariableDataTransferDetails(Set<DataTransferDetail> a) {
        a.sourceVariableDataTransferDetails = a;
    }

    public void setEngZeroScale(Double a) {
        a.engZeroScale = a;
    }

    public void setLogMinValue(Double a) {
        a.logMinValue = a;
    }

    public Boolean getIsPulseOn() {
        Variable a;
        return a.isPulseOn;
    }

    public Double getRawZeroScale() {
        Variable a;
        return a.rawZeroScale;
    }

    public Integer getLogExpressionId() {
        Variable a;
        return a.logExpressionId;
    }

    public void setSetMinValue(Double a) {
        a.setMinValue = a;
    }

    public String getLogExpressionCode() {
        Variable a;
        return a.logExpressionCode;
    }

    public Boolean getIsActive() {
        Variable a;
        return a.isActive;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Integer getProjectId() {
        Variable a;
        return a.projectId;
    }

    public void setIsPulseOn(Boolean a) {
        a.isPulseOn = a;
    }

    public void setValueExpressionType(c_lia a) {
        a.valueExpressionType = a;
    }
}

