/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="frame")
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull(fieldNames={"deviceId", "device"})
public class Frame<TDevice extends Device<?, ?>, TVariable extends Variable<?, ?, ?>>
extends SpaceBaseModel {
    @Id
    @Column(name="frame_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="frameSeq")
    @GenericGenerator(name="frameSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="frame_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @Size(max=255)
    protected String dsc;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Column(name="minutes_offset")
    protected Integer minutesOffset;
    @Column(name="scan_time_factor")
    protected Integer scanTimeFactor;
    @JsonIgnore
    @ManyToOne(optional=false, targetEntity=Device.class)
    @JoinColumn(name="device_id")
    protected TDevice device;
    @NotNull
    @Column(name="readable_flag", nullable=false)
    protected Boolean isReadable;
    @Column(name="device_id", insertable=false, updatable=false)
    protected Integer deviceId;
    @JsonIgnore
    @OneToMany(mappedBy="frame", targetEntity=Variable.class)
    protected Set<TVariable> variables;

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setIsReadable(Boolean a) {
        a.isReadable = a;
    }

    public Integer getScanTimeFactor() {
        Frame a;
        return a.scanTimeFactor;
    }

    public void setDeviceId(Integer a) {
        a.deviceId = a;
    }

    public void setMinutesOffset(Integer a) {
        a.minutesOffset = a;
    }

    public Integer getMinutesOffset() {
        Frame a;
        return a.minutesOffset;
    }

    public Frame() {
        Frame a;
        Frame frame = a;
        frame.variables = new HashSet();
    }

    public Set<TVariable> getVariables() {
        Frame a;
        return a.variables;
    }

    public void setScanTimeFactor(Integer a) {
        a.scanTimeFactor = a;
    }

    public void setVariables(Set<TVariable> a) {
        a.variables = a;
    }

    public Boolean getIsReadable() {
        Frame a;
        return a.isReadable;
    }

    public void setName(String a) {
        a.name = a;
    }

    public boolean equals(Object a) {
        Frame a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Frame)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Frame)a;
        return a2.getDeviceId().equals(a.getDeviceId()) && a2.getName().equals(a.getName());
    }

    public TDevice getDevice() {
        Frame a;
        return (TDevice)a.device;
    }

    public String getDsc() {
        Frame a;
        return a.dsc;
    }

    public Boolean getIsWritable() {
        Frame a;
        return a.isWritable;
    }

    public int hashCode() {
        Frame a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getDeviceId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setDevice(TDevice a) {
        Frame a2;
        Frame frame = a2;
        frame.device = a;
        frame.deviceId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getDeviceId() {
        Frame a;
        return a.deviceId;
    }

    public String getName() {
        Frame a;
        return a.name;
    }

    public void setIsWritable(Boolean a) {
        a.isWritable = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Integer getId() {
        Frame a;
        return a.id;
    }
}

