/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.auth.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.auth.enums.c_cka;
import com.inscada.mono.auth.events.RevokeEvent;
import com.inscada.mono.auth.model.AuthSecret;
import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.auth.repositories.AuthSecretRepository;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.shared.exceptions.c_vc;
import com.inscada.mono.user.model.ResetPasswordToken;
import com.inscada.mono.user.model.User;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.Key;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;

@Service
public class AuthTokenService
implements ClusterNodeListener {
    private static final String J = "user_tokens:";
    private final SecretKey G;
    public static final short H = 10;
    @Value(value="${ins.refreshToken.duration}")
    private long D;
    private final JedisPooled l;
    private final AuthSecretRepository F;
    private final ScheduledExecutorService a;
    private static final long f = 5L;
    private final ObjectMapper c;
    @Value(value="${ins.accessToken.duration}")
    private long I;
    private final ApplicationEventPublisher h;
    @Value(value="${ins.jwt.secret}")
    private String A;
    private static final long C = 15L;
    private static final String B = "authtoken:";
    private static final Logger k = LoggerFactory.getLogger(AuthTokenService.class);
    private volatile ScheduledFuture<?> i;
    private final ClusterOperations b;

    private /* synthetic */ Map<c_cka, AuthToken> generateAndStoreTokens(String a, String a2) {
        AuthTokenService a3;
        AuthTokenService authTokenService = a3;
        AuthToken authToken = authTokenService.generateAndStoreToken(a, (String)a2, c_cka.k);
        a = authTokenService.generateAndStoreToken(a, (String)a2, c_cka.i);
        Object object = a2 = new EnumMap<c_cka, AuthToken>(c_cka.class);
        a2.put((c_cka)c_cka.k, authToken);
        object.put(c_cka.i, a);
        return object;
    }

    private /* synthetic */ void deleteTokenFromRedis(String a, String a2) {
        AuthTokenService a3;
        if (a == null) {
            return;
        }
        String string = B + a;
        a3.l.del(string);
        if (a2 != null) {
            a2 = J + (String)a2;
            String[] stringArray = new String[1];
            stringArray[0] = a;
            a3.l.srem((String)a2, stringArray);
        }
    }

    public void notLeader() {
        AuthTokenService a;
        k.info(ResetPasswordToken.m_hi((Object)"|PAK\bVG\\M\u0018AK\bY\b~gtdw\u007f}z\u0016\bk\\WXHAVO\u0018\\WC]F\u0018KTMYFMX\u0018BWJ\u0016"));
        a.stopCleanupJob();
    }

    public AuthTokenService(AuthSecretRepository a, JedisPooled a2, ObjectMapper a3, ApplicationEventPublisher a4, ClusterOperations a5) {
        AuthTokenService a6;
        AuthTokenService authTokenService = a6;
        AuthTokenService authTokenService2 = a6;
        a6.a = Executors.newSingleThreadScheduledExecutor();
        a6.F = a;
        authTokenService2.l = a2;
        authTokenService2.c = a3;
        a6.h = a4;
        authTokenService.b = a5;
        authTokenService.G = a6.initSecretKey();
    }

    @PostConstruct
    public void initialize() throws NoSuchMethodException {
        AuthTokenService a;
        Class[] classArray = new Class[2];
        classArray[0] = Integer.class;
        classArray[1] = String.class;
        a.b.addRemoteCall((short)10, (Object)a, AuthTokenService.class.getDeclaredMethod(c_ye.m_hi((Object)"\u001bx\u001dk\fo,e\u0013o\u0016y7d4o\u0019n\u001dx"), classArray));
        a.b.addListener((ClusterNodeListener)a);
    }

    private /* synthetic */ void startCleanupJob() {
        AuthTokenService a;
        if (a.i != null && !a.i.isDone()) {
            k.warn(ResetPasswordToken.m_hi((Object)"lGSMV\b[D]IV]H\bRGZ\bQ[\u0018ITZ]I\\Q\u0018ZMFVAVO\u0016\bqOVGJAVO\u0018[LIJ\\\u0018Z]YMMK\\\u0016"));
            return;
        }
        k.info(c_ye.m_hi((Object)"+~\u0019x\fc\u0016mX~\u0017a\u001ddXi\u0014o\u0019d\rzX`\u0017hX}\u0011~\u0010*\u0019dXc\u0016~\u001dx\u000ek\u0014*\u0017lXq\u0005*\u0015c\u0016\u007f\fo\u000b$"), (Object)5L);
        a.i = a.a.scheduleWithFixedDelay(() -> {
            try {
                AuthTokenService a;
                Set set = a.l.keys(ResetPasswordToken.m_hi((Object)"M[]Zg\\WC]FK\u0012\u0012"));
                for (String string : set) {
                    for (String string2 : a.l.smembers(string)) {
                        String string3 = B + string2;
                        if (a.l.exists(string3)) continue;
                        String[] stringArray = new String[1];
                        stringArray[0] = string2;
                        a.l.srem(string, stringArray);
                    }
                }
            }
            catch (Exception exception) {
                k.error(c_ye.m_hi((Object)",e\u0013o\u0016*\u001bf\u001dk\u0016\u007f\b*\u0012e\u001a*\u001ek\u0011f\u001dn"), (Throwable)exception);
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    private /* synthetic */ void expireTokenInRedis(String a, long a2) {
        AuthTokenService a3;
        if (a == null) {
            return;
        }
        a = B + (String)a;
        a3.l.expire((String)a, a2);
    }

    public Map<c_cka, AuthToken> refresh(String a) {
        EnumMap<c_cka, AuthToken> enumMap;
        AuthTokenService a2;
        AuthToken authToken = a2.validate(a);
        if (authToken.getType() != c_cka.i) {
            throw new IllegalArgumentException(ResetPasswordToken.m_hi((Object)"qFNITA\\\bLGSMV\bLQHM\u0018NWZ\u0018Z]NJMK@\u0018GHMJILAWF\u0016"));
        }
        AuthTokenService authTokenService = a2;
        authTokenService.expireTokenInRedis(a, 15L);
        a = authTokenService.generateAndStoreToken(authToken.getUserId(), authToken.getUsername(), c_cka.k);
        authToken = a2.generateAndStoreToken(authToken.getUserId(), authToken.getUsername(), c_cka.i);
        EnumMap<c_cka, AuthToken> enumMap2 = enumMap = new EnumMap<c_cka, AuthToken>(c_cka.class);
        enumMap.put(c_cka.k, (AuthToken)a);
        enumMap2.put(c_cka.i, authToken);
        return enumMap2;
    }

    public AuthToken validate(String a) {
        AuthTokenService a2;
        String string = B + a;
        String string2 = a2.l.get(string);
        if (string2 == null) {
            throw new c_vc(c_ye.m_hi((Object)",e\u0013o\u0016*\u0016e\f*\u001ee\rd\u001c*\u0017xXo\u0000z\u0011x\u001dn"));
        }
        try {
            string2 = (AuthToken)a2.c.readValue(string2, AuthToken.class);
        }
        catch (IOException iOException) {
            a2.l.del(string);
            throw new RuntimeException(ResetPasswordToken.m_hi((Object)"nYATM\\\bLG\u0018L][]ZQITABM\u0018\\WC]F\u0018LY\\Y"), iOException);
        }
        try {
            Jwts.parserBuilder().setSigningKey((Key)a2.G).build().parseClaimsJws(a);
            return string2;
        }
        catch (JwtException jwtException) {
            String string3 = string2;
            a2.deleteTokenFromRedis(a, string3.getUserId());
            if (string3.getType() == c_cka.i) {
                a2.revokeByTokenData((AuthToken)string2);
            }
            throw jwtException;
        }
    }

    public Map<c_cka, AuthToken> create(User a3) {
        AuthTokenService a2;
        if (a2.b.isLeader()) {
            return a2.createTokensOnLeader(a3.getId(), a3.getUsername());
        }
        k.debug(c_ye.m_hi((Object)">e\u0014f\u0017}\u001dxXd\u0017n\u001d*\u001co\u0014o\u001fk\fc\u0016mX~\u0017a\u001ddXi\no\u0019~\u0011e\u0016*\feXf\u001dk\u001co\n*\u001ee\n*\ry\u001dxB*\u0003w"), (Object)a3.getUsername());
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3.getId();
            objectArray[1] = a3.getUsername();
            return (Map)a2.b.callLeaderMethod(Short.valueOf((short)10), objectArray);
        }
        catch (Exception a3) {
            throw new RuntimeException(ResetPasswordToken.m_hi((Object)"~IQD]L\u0018\\W\b[Z]ILM\u0018\\WC]F\u0018^QI\u0018zhk\u0018KYDT\bLG\u0018D]I\\MJ"), a3);
        }
    }

    public void leader() {
        AuthTokenService a;
        k.info(c_ye.m_hi((Object)",b\u0011yXd\u0017n\u001d*\u0010k\u000b*\u001ao\u001be\u0015oX~\u0010oXF=K<O*$XY\fk\n~\u0011d\u001f*\fe\u0013o\u0016*\u001bf\u001dk\u0016\u007f\b*\u0012e\u001a$"));
        a.startCleanupJob();
    }

    public void revoke(User a2) {
        AuthTokenService a3;
        String string = J + a2.getId();
        Collection<Object> collection = a3.l.smembers(string);
        if (collection != null && !collection.isEmpty() && !(collection = collection.stream().map(a -> B + a).collect(Collectors.toList())).isEmpty()) {
            a3.l.del(collection.toArray(new String[0]));
        }
        a3.l.del(string);
        a3.h.publishEvent((ApplicationEvent)new RevokeEvent((Object)a3, a2.getUsername()));
    }

    private /* synthetic */ void stopCleanupJob() {
        AuthTokenService a;
        if (a.i != null) {
            k.info(ResetPasswordToken.m_hi((Object)"k\\WXHAVO\u0018\\WC]F\u0018KTMYFMX\u0018BWJ\u0016"));
            a.i.cancel(false);
            a.i = null;
        }
    }

    private /* synthetic */ void revokeByTokenData(AuthToken a2) {
        AuthTokenService a3;
        if (a2 == null || a2.getUserId() == null) {
            return;
        }
        String string = J + a2.getUserId();
        Collection<Object> collection = a3.l.smembers(string);
        if (collection != null && !collection.isEmpty() && !(collection = collection.stream().map(a -> B + a).collect(Collectors.toList())).isEmpty()) {
            a3.l.del(collection.toArray(new String[0]));
        }
        a3.l.del(string);
        a3.h.publishEvent((ApplicationEvent)new RevokeEvent((Object)a3, a2.getUsername()));
    }

    private /* synthetic */ SecretKey initSecretKey() {
        Object object;
        String string;
        AuthTokenService a;
        if (a.A != null && !a.A.isBlank()) {
            k.info(c_ye.m_hi((Object)"-y\u0011d\u001f*2],*9\u007f\fb\u001dd\fc\u001bk\fc\u0017dXY\u001di\no\f*\u001ex\u0017gXi\u0017d\u001ec\u001f\u007f\no\u001c*\bx\u0017z\u001dx\fsWo\u0016|\u0011x\u0017d\u0015o\u0016~X|\u0019x\u0011k\u001af\u001d$"));
            string = a.A;
        } else {
            k.warn(ResetPasswordToken.m_hi((Object)"r\u007fl\by]L@]FLA[ILAWF\u0018{]KJML\b\u0010M\u0016O\u0016\u0004\u0018\u000fQFK\u0006R_L\u0006KM[Z]\\\u001f\bHZWX]ZLQ\u0011\bQ[\u0018FW\\\u0018KWF^A_]JM\\\u0006\u0018nYDTAVO\u0018JYKS\bLG\u0018LY\\YJY[]\bTGWCMX\u0016"));
            object = a.F.findFirstByOrderByIdAsc();
            if (object == null) {
                k.error(c_ye.m_hi((Object)"I*C,C;K40XK\r~\u0010*\u000bo\u001bx\u001d~Xd\u0017~Xl\u0017\u007f\u0016nXc\u0016*\u001ck\fk\u001ak\u000boXo\u0011~\u0010o\n+"));
                throw new c_vc(ResetPasswordToken.m_hi((Object)"y]L@\u0018[]KJML\bVGL\b^GMF\\\bQF\u0018MV^QZWFUMV\\\u0018GJ\b\\ILIZIKM\u0016"));
            }
            string = object.getAuthSecretValue();
            k.info(c_ye.m_hi((Object)"-y\u0011d\u001f*2],*9\u007f\fb\u001dd\fc\u001bk\fc\u0017dXY\u001di\no\f*\u001ex\u0017gXn\u0019~\u0019h\u0019y\u001d$"));
        }
        try {
            object = Base64.getDecoder().decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(ResetPasswordToken.m_hi((Object)"bo|\u0018iM\\PMV\\QKY\\QGV\bkM[Z]\\\u0018AK\bVGL\bNITA\\\bzIKM\u000e\u001c\u0016"), illegalArgumentException);
        }
        if (((AuthSecret)object).length < 64) {
            k.error(c_ye.m_hi((Object)";X1^1I9FB*2],*9\u007f\fb\u001dd\fc\u001bk\fc\u0017dXY\u001di\no\f*\u0011yX~\u0017eXy\u0010e\n~Xl\u0017xXB+?I8X\"\u0015\u007f\u000b~Xh\u001d*F7X<L*\u001as\fo\u000b*\u0019l\fo\n*\u001co\u001be\u001cc\u0016mQ$XN\u001di\u0017n\u001dnXf\u001dd\u001f~\u00100Xq\u0005*\u001as\fo\u000b$"), (Object)((AuthSecret)object).length);
            throw new IllegalStateException(ResetPasswordToken.m_hi((Object)"r\u007fl\by]L@]FLA[ILAWF\u0018{]KJML\bQ[\u0018\\WG\u0018[PGJ\\\u0018NWZ\u0018`k\u001d\t\u001a\u0016"));
        }
        Object object2 = object;
        return new SecretKeySpec((byte[])object2, 0, ((AuthSecret)object2).length, c_ye.m_hi((Object)"0g\u0019i+B9?I8"));
    }

    @PreDestroy
    public void shutdownCleanupJob() {
        AuthTokenService a;
        a.a.shutdown();
        try {
            if (!a.a.awaitTermination(10L, TimeUnit.SECONDS)) {
                a.a.shutdownNow();
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            a.a.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected Map<c_cka, AuthToken> createTokensOnLeader(Integer a, String a2) {
        AuthTokenService a3;
        return a3.generateAndStoreTokens(a.toString(), a2);
    }

    private /* synthetic */ AuthToken generateAndStoreToken(String a, String a2, c_cka a3) {
        Instant instant;
        long l;
        AuthTokenService a4;
        Object object = Instant.now();
        if (a3 == c_cka.k) {
            l = TimeUnit.MINUTES.toSeconds(a4.I);
            instant = object;
        } else {
            l = TimeUnit.DAYS.toSeconds(a4.D);
            instant = object;
        }
        Object object2 = instant.plusSeconds(l);
        object = Jwts.builder().setSubject(a2).setIssuedAt(Date.from((Instant)object)).setExpiration(Date.from((Instant)object2)).claim(ResetPasswordToken.m_hi((Object)"MA\\"), (Object)a).claim(c_ye.m_hi((Object)"~\u0001z"), (Object)a3.name()).signWith((Key)a4.G, SignatureAlgorithm.HS512).compact();
        object2 = B + (String)object;
        Object object3 = new AuthToken(a, a2, a3, Long.valueOf(l));
        try {
            AuthTokenService authTokenService = a4;
            object3 = authTokenService.c.writeValueAsString(object3);
            authTokenService.l.setex((String)object2, l, (String)object3);
            object2 = J + a;
            String[] stringArray = new String[1];
            stringArray[0] = object;
            a4.l.sadd((String)object2, stringArray);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException(ResetPasswordToken.m_hi((Object)"nYATM\\\bLG\u0018[LGJM\u0018\\WC]F\u0018LMM\u0018\\W\bKMJAYDQRY\\QGV\b]ZJGJ"), jsonProcessingException);
        }
        object3 = new AuthToken(a, a2, a3, Long.valueOf(l));
        object3.setTokenValue((String)object);
        return object3;
    }
}

