/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.restcontrollers;

import com.inscada.mono.animation.enums.c_gaa;
import com.inscada.mono.animation.m.c_xba;
import com.inscada.mono.animation.m.c_xda;
import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.log.model.LogEntryFilter;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.user.model.UserDto;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/animations"})
public class AnimationController
extends ProjectBasedImportExportController {
    private final c_xba i;
    private final c_xda b;

    @GetMapping(value={"/{animationId}/elements/{elementId}"})
    public AnimationElement getAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        return this.b.m_jia(animationId, a);
    }

    @GetMapping(value={"/name/elements"}, params={"name", "type"})
    public AnimationElement getAnimationElementByNameAndType(@RequestParam(name="name") String name, @RequestParam(name="type") c_gaa a) {
        return this.b.m_tcc(name, a);
    }

    @GetMapping
    public Collection<Animation> getAnimations(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_oa(a);
    }

    @DeleteMapping(value={"/{animationId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElementsByIds(@PathVariable(value="animationId") Integer animationId, @RequestParam(value="elementIds") Integer[] a) {
        this.b.m_iec(animationId, a);
    }

    @GetMapping(value={"/project/{projectId}"}, params={"name"})
    public Animation getAnimationByProjectId(@PathVariable(value="projectId") Integer projectId, @RequestParam(name="name") String a) {
        return this.b.m_ud(projectId, a);
    }

    @DeleteMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        this.b.m_zub(animationId, a);
    }

    @PostMapping(value={"/{animationId}/elements"})
    public ResponseEntity<AnimationElement> createAnimationElement(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationElement animationElement, UriComponentsBuilder a) {
        animationElement = this.b.m_afc(animationId, animationElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationElement.getId();
        return ResponseEntity.created((URI)a.path(UserDto.m_hi((Object)"\u001ciR|Z\u007fRfZ}][Wo\u001cw_w^w]f@=Hw_w^w]fzvN")).buildAndExpand(objectArray).toUri()).body((Object)animationElement);
    }

    @GetMapping(value={"/{animationId}/scripts"})
    public Collection<AnimationScript> getAnimationScripts(@PathVariable(value="animationId") Integer a) {
        return this.b.m_lec(a);
    }

    @PostMapping(value={"/{animationId}/clone"}, params={"name"})
    public ResponseEntity<Animation> cloneAnimation(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        animationId = this.b.m_yaa(animationId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = animationId.getId();
        return ResponseEntity.created((URI)a.path(LogEntryFilter.m_hi((Object)"\u000b%E0M3E*M1J\u0017@#")).buildAndExpand(objectArray).toUri()).body((Object)animationId);
    }

    @PutMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimation(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody Animation a) {
        this.b.m_sxb(animationId, a);
    }

    @DeleteMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        this.b.m_efa(animationId, a);
    }

    @DeleteMapping(value={"/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="elementId") Integer a) {
        this.b.m_nac(a);
    }

    @PostMapping(value={"/{animationId}/scripts"})
    public ResponseEntity<AnimationScript> createAnimationScript(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationScript animationScript, UriComponentsBuilder a) {
        animationScript = this.b.m_zvb(animationId, animationScript);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationScript.getId();
        return ResponseEntity.created((URI)a.path(UserDto.m_hi((Object)"\u001ciR|Z\u007fRfZ}][Wo\u001caP`ZbGa\u001ci@qA{CfzvN")).buildAndExpand(objectArray).toUri()).body((Object)animationScript);
    }

    @GetMapping(value={"/{animationId}"})
    public Animation getAnimation(@PathVariable(value="animationId") Integer a) {
        return this.b.m_ba(a);
    }

    @MessageMapping(value={"/run-animation-script"})
    public void runAnimationScript(@Payload RunAnimScriptDto runAnimScriptDto, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.i.m_vic(runAnimScriptDto, a.getName(), sessionId);
    }

    @DeleteMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimation(@PathVariable(value="animationId") Integer a) {
        this.b.m_qa(a);
    }

    @PutMapping(value={"/{animationId}/placeholders"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatePlaceholders(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.b.m_pvb(animationId, a);
    }

    @PutMapping(value={"/{animationId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationSvg(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.b.m_zka(animationId, a);
    }

    @PutMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody AnimationElement a) {
        this.b.m_hac(animationId, elementId, a);
    }

    @PostMapping
    public ResponseEntity<Animation> createAnimation(@Valid @RequestBody Animation animation, UriComponentsBuilder a) {
        animation = this.b.m_mac(animation);
        Object[] objectArray = new Object[1];
        objectArray[0] = animation.getId();
        return ResponseEntity.created((URI)a.path(LogEntryFilter.m_hi((Object)"\u000b%E0M3E*M1J\u0017@#")).buildAndExpand(objectArray).toUri()).body((Object)animation);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Animation> getAnimationsByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.b.m_zga(projectId, a);
    }

    @PutMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody AnimationScript a) {
        this.b.m_ozb(animationId, scriptId, a);
    }

    @GetMapping(value={"/{animationId}/elements"})
    public Collection<AnimationElement> getAnimationElements(@PathVariable(value="animationId") Integer a) {
        return this.b.m_aga(a);
    }

    @GetMapping(value={"/project"}, params={"projectName", "name"})
    public Animation getAnimationByProjectName(@RequestParam(name="projectName") String projectName, @RequestParam(name="name") String a) {
        return this.b.m_jyb(projectName, a);
    }

    @MessageMapping(value={"/eval-animation"})
    public void animationResultMessage(@Payload EvalAnimationMessage evalAnimationMessage, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.i.m_kqc(evalAnimationMessage, a.getName(), sessionId);
    }

    @GetMapping(value={"/{animationId}/scripts/{scriptId}"})
    public AnimationScript getAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        return this.b.m_vub(animationId, a);
    }

    @GetMapping(value={"/{animationId}/elements"}, params={"type"})
    public Collection<AnimationElement> getAnimationElementsByType(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="type") c_gaa a) {
        return this.b.m_mbc(animationId, a);
    }

    public AnimationController(c_xda a, c_xba a2, c_ff a3, c_pg a4) {
        AnimationController a5;
        AnimationController animationController = a5;
        super(a3, EnumSet.of(c_bh.d), a4);
        animationController.b = a;
        animationController.i = a2;
    }

    @GetMapping(value={"/{animationId}/svg"})
    public ResponseEntity<InputStreamResource> getAnimationSvg(@PathVariable(value="animationId") Integer a) {
        a = this.b.m_mb(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(UserDto.m_hi((Object)"p}]fV|G?w{@b\\aZfZ}]"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)LogEntryFilter.m_hi((Object)"7I?C;\u000b-R9\u000f&I2"))).body((Object)byteArrayInputStream);
    }
}

