/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.alarm.repositories.AlarmGroupRepository;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.services.c_qd;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_mj;
import com.inscada.mono.shared.exceptions.c_rc;
import com.inscada.mono.shared.exceptions.c_vc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@EnableSpaceFilter
public class c_dfa {
    private static final String[] C;
    private final c_qd B;
    private final AlarmGroupRepository k;
    private final c_pg i;
    private final ApplicationEventPublisher b;

    static {
        String[] stringArray = new String[8];
        stringArray[0] = AlarmFilter.m_hi((Object)"\u001e0");
        stringArray[1] = CheckedAlarm.m_hi((Object)"\u00059\u0017*\u0013");
        stringArray[2] = AlarmFilter.m_hi((Object)"$\u0005;\u001d1\u0014 ");
        stringArray[3] = CheckedAlarm.m_hi((Object)"(\u001a(\u0004$\u0005");
        stringArray[4] = AlarmFilter.m_hi((Object)"7\u00051\u0016 \u001205-");
        stringArray[5] = CheckedAlarm.m_hi((Object)"*\u0004,\u0017=\u001f&\u0018\r\u0017=\u0013");
        stringArray[6] = AlarmFilter.m_hi((Object)"\u001b5\u0004 :;\u0013=\u0011=\u001205-");
        stringArray[7] = CheckedAlarm.m_hi((Object)"%\u0017:\u0002\u0004\u0019-\u001f/\u001f,\u0012\r\u0017=\u0013");
        C = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_tjc(AlarmGroup a, boolean a2) {
        AlarmGroup alarmGroup;
        c_dfa a3;
        AlarmGroup alarmGroup2 = a;
        a3.m_bkc(alarmGroup2);
        if ((alarmGroup2.getId() != null ? (alarmGroup = a3.m_ba(a.getId())) : (alarmGroup = a3.m_ud(a.getProjectId(), a.getName()))) != null) {
            a3.m_qgc(a, alarmGroup, a2);
            return;
        }
        c_dfa c_dfa2 = a3;
        c_dfa2.m_hkc(a);
        c_dfa2.k.save((Object)a);
    }

    private /* synthetic */ void m_qgc(AlarmGroup a, AlarmGroup a2, boolean a3) {
        c_dfa a4;
        AlarmGroup alarmGroup = a2;
        a4.m_bkc(a);
        BeanUtils.copyProperties((Object)a, (Object)alarmGroup, (String[])C);
        a4.m_hkc(alarmGroup);
        if (a3) {
            a4.b.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a4, a2));
        }
    }

    public void m_eic(AlarmGroup a) {
        c_dfa a2;
        c_dfa c_dfa2 = a2;
        c_dfa2.m_bkc(a);
        c_dfa2.m_hkc(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP')")
    public void m_xpc(Integer a, AlarmGroup a2) {
        c_dfa a3;
        c_dfa c_dfa2 = a3;
        a = c_dfa2.m_mb(a);
        c_dfa2.m_qgc(a2, (AlarmGroup)a, true);
    }

    private /* synthetic */ void m_hkc(AlarmGroup a) {
        if (a.getOnScript() != null && !a.getOnScript().getProject().equals((Object)a.getProject())) {
            throw new c_mj(AlarmFilter.m_hi((Object)"68\u0016&\u001at\u0010&\u0018!\u0007t\u0007&\u0018>\u00127\u0003t\u0016:\u0013t\u0018:W'\u0014&\u001e$\u0003t\u0007&\u0018>\u00127\u0003t\u001a!\u0004 W9\u0016 \u0014<"));
        }
        if (a.getOffScript() != null && !a.getOffScript().getProject().equals((Object)a.getProject())) {
            throw new c_mj(CheckedAlarm.m_hi((Object)"7%\u0017;\u001bi\u0011;\u0019<\u0006i\u0006;\u0019#\u0013*\u0002i\u0017'\u0012i\u0019/\u0010i\u0005*\u0004 \u0006=V9\u0004&\u001c,\u0015=V$\u0003:\u0002i\u001b(\u0002*\u001e"));
        }
        if (a.getAckScript() != null && !a.getAckScript().getProject().equals((Object)a.getProject())) {
            throw new c_mj(AlarmFilter.m_hi((Object)"\u0015\u001b5\u00059W3\u0005;\u0002$W$\u0005;\u001d1\u0014 W5\u00190W5\u0014?W'\u0014&\u001e$\u0003t\u0007&\u0018>\u00127\u0003t\u001a!\u0004 W9\u0016 \u0014<"));
        }
    }

    @DisableSpaceFilter
    public AlarmGroup m_vnc(Integer a) {
        c_dfa a2;
        return a2.k.findById((Object)a).orElse(null);
    }

    @Order(value=4)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_pm(ProjectDeleteEvent a) {
        c_dfa a2;
        a2.m_ha(a.getProject().getId());
    }

    @DisableSpaceFilter
    public AlarmGroup m_gj(Integer a) {
        c_dfa a2;
        AlarmGroup alarmGroup = a2.m_ba(a);
        if (alarmGroup == null) {
            throw new c_vc("Alarm group not found with id of " + a);
        }
        return alarmGroup;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_zmc(Set<Integer> a) {
        c_dfa a2;
        if ((a = a2.k.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_ud(Integer a, String a2) {
        c_dfa a3;
        return a3.k.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_oa(Integer a) {
        c_dfa a2;
        if ((a = a2.k.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_da() {
        c_dfa a;
        return a.k.findAll();
    }

    public c_dfa(c_pg a, c_qd a2, AlarmGroupRepository a3, ApplicationEventPublisher a4) {
        c_dfa a5;
        c_dfa c_dfa2 = a5;
        c_dfa c_dfa3 = a5;
        c_dfa3.i = a;
        c_dfa3.B = a2;
        c_dfa2.k = a3;
        c_dfa2.b = a4;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_ha(Integer a) {
        if (a != null) {
            c_dfa a2;
            a2.k.deleteByProjectId(a);
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_jw(List<AlarmGroup> a2, boolean a3) {
        c_dfa a4;
        a2.forEach(a -> {
            RepeatableScript repeatableScript;
            c_dfa a2;
            if (a.getProject() == null) {
                AlarmGroup alarmGroup = a;
                alarmGroup.setProject(a2.i.m_mb(alarmGroup.getProjectId()));
            }
            if (a.getOnScript() == null && a.getOnScriptId() != null) {
                repeatableScript = a2.B.m_mb(a.getOnScriptId());
                a.setOnScript(repeatableScript);
            }
            if (a.getOffScript() == null && a.getOffScriptId() != null) {
                repeatableScript = a2.B.m_mb(a.getOffScriptId());
                a.setOffScript(repeatableScript);
            }
            if (a.getAckScript() == null && a.getAckScriptId() != null) {
                repeatableScript = a2.B.m_mb(a.getAckScriptId());
                a.setAckScript(repeatableScript);
            }
        });
        Object object = a2.stream().map(AlarmGroup::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.k.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(AlarmGroup::getProjectId, Collectors.mapping(AlarmGroup::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_dfa a2;
            return a2.k.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(AlarmGroup::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<AlarmGroup> arrayList = new ArrayList<AlarmGroup>();
        HashSet<AlarmGroup> hashSet = new HashSet<AlarmGroup>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a2.next();
            if ((alarmGroup.getId() != null ? (AlarmGroup)map.get(alarmGroup.getId()) : (AlarmGroup)object.get(ImmutablePair.of((Object)alarmGroup.getProjectId(), (Object)alarmGroup.getName()))) != null) {
                AlarmGroup alarmGroup2;
                AlarmGroup alarmGroup3 = alarmGroup2;
                a4.m_qgc(alarmGroup, alarmGroup3, false);
                hashSet.add(alarmGroup3);
                arrayList.add(alarmGroup2);
                continue;
            }
            a4.m_hkc(alarmGroup);
            arrayList.add(alarmGroup);
        }
        a4.k.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_dfa a2;
                a2.b.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a2, a));
            });
        }
    }

    @DisableSpaceFilter
    public Collection<AlarmGroup> m_ogc(Set<Integer> a) {
        c_dfa a2;
        if ((a = a2.k.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_mb(Integer a) {
        c_dfa a2;
        AlarmGroup alarmGroup = a2.m_ba(a);
        if (alarmGroup == null) {
            throw new c_vc("Alarm group not found with id of " + a);
        }
        return alarmGroup;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM_GROUP')")
    public AlarmGroup m_dgc(AlarmGroup a) {
        c_dfa a2;
        c_dfa c_dfa2 = a2;
        c_dfa2.m_eic(a);
        return (AlarmGroup)c_dfa2.k.save((Object)a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_qa(Integer a) {
        c_dfa a2;
        if ((a = a2.m_ba(a)) != null) {
            Set set = a.getAlarms();
            if (!set.isEmpty()) {
                throw new c_rc("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
            }
            c_dfa c_dfa2 = a2;
            c_dfa2.k.delete((Object)a);
            c_dfa2.b.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, (AlarmGroup)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_akc(List<Integer> a2) {
        c_dfa a3;
        if (!(a2 = a3.k.findAllById(a2)).isEmpty()) {
            c_dfa c_dfa2 = a3;
            List list = a2;
            c_dfa2.k.deleteInBatch((Iterable)list);
            list.forEach(a -> {
                c_dfa a2;
                Set set = a.getAlarms();
                if (!set.isEmpty()) {
                    throw new c_rc("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
                }
                a2.b.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_dd(Integer a, String a2) {
        c_dfa a3;
        if ((a = a3.m_ud(a, a2)) == null) {
            throw new c_vc("Alarm group not found with name of " + a2);
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_ba(Integer a) {
        c_dfa a2;
        return a2.k.findById((Object)a).orElse(null);
    }

    @DisableSpaceFilter
    public Collection<AlarmGroup> m_hd(Integer a) {
        c_dfa a2;
        if ((a = a2.k.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }
}

