/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.alarm.repositories.AlarmRepository;
import com.inscada.mono.alarm.services.c_dfa;
import com.inscada.mono.cluster.restcontrollers.ClusterController;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_iea;
import com.inscada.mono.config.AuditConfig;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.m.c_pg;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_mj;
import com.inscada.mono.shared.exceptions.c_vc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_bfa<T extends Alarm> {
    protected final AlarmRepository<T> A;
    protected final ApplicationEventPublisher C;
    protected final c_dfa B;
    protected final c_iea k;
    protected static final String[] i;
    protected final c_pg b;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_pic(Collection<Integer> a) {
        c_bfa a2;
        return a2.A.findAllById(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_ba(Integer a) {
        c_bfa a2;
        return (T)((Alarm)a2.A.findById((Object)a).orElse(null));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_foc(Integer a, String[] a2) {
        c_bfa a3;
        return a3.A.findByProjectIdAndNameIn(a, Arrays.stream(a2).collect(Collectors.toSet()));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_oa(Integer a) {
        c_bfa a2;
        return a2.A.findByProjectId(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_ksa(Integer a, Pageable a2) {
        c_bfa a3;
        return a3.A.findByProjectId(a, a2);
    }

    protected c_bfa(c_pg a, c_dfa a2, AlarmRepository<T> a3, c_iea a4, ApplicationEventPublisher a5) {
        c_bfa a6;
        c_bfa c_bfa2 = a6;
        c_bfa c_bfa3 = a6;
        a6.b = a;
        c_bfa3.B = a2;
        c_bfa3.A = a3;
        c_bfa2.k = a4;
        c_bfa2.C = a5;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_jw(List<T> a2, boolean a3) {
        c_bfa a4;
        a2.forEach(arg_0 -> a4.m_ajc(arg_0));
        Object object = a2.stream().map(Alarm::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.A.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Alarm::getProjectId, Collectors.mapping(Alarm::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_bfa a2;
            return a2.A.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Alarm::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Alarm> arrayList = new ArrayList<Alarm>();
        HashSet<Alarm> hashSet = new HashSet<Alarm>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Alarm alarm = (Alarm)a2.next();
            if ((alarm.getId() != null ? (Alarm)map.get(alarm.getId()) : (Alarm)object.get(ImmutablePair.of((Object)alarm.getProjectId(), (Object)alarm.getName()))) != null) {
                Alarm alarm2;
                Alarm alarm3 = alarm2;
                a4.m_cgc(alarm, alarm3, false);
                hashSet.add(alarm3);
                arrayList.add(alarm2);
                continue;
            }
            a4.m_hpc(alarm);
            arrayList.add(alarm);
        }
        a4.A.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_bfa a2;
                a2.C.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a2, a));
            });
        }
    }

    public void m_fic(T a) {
        c_bfa a2;
        c_bfa c_bfa2 = a2;
        c_bfa2.m_ajc(a);
        c_bfa2.m_hpc(a);
    }

    protected void m_ajc(T a) {
        Variable variable;
        c_bfa a2;
        if (a.getProject() == null) {
            T t = a;
            t.setProject(a2.b.m_mb(t.getProjectId()));
        }
        if (a.getGroup() == null) {
            T t = a;
            t.setGroup(a2.B.m_mb(t.getGroupId()));
        }
        if (a.getOnTimeVariable() == null && a.getOnTimeVariableId() != null) {
            variable = a2.k.m_mb(a.getOnTimeVariableId());
            a.setOnTimeVariable(variable);
        }
        if (a.getOffTimeVariable() == null && a.getOffTimeVariableId() != null) {
            variable = a2.k.m_mb(a.getOffTimeVariableId());
            a.setOffTimeVariable(variable);
        }
        if (a instanceof DigitalAlarm) {
            Variable variable2;
            variable = (DigitalAlarm)a;
            if (variable.getVariableA() == null) {
                variable2 = a2.k.m_mb(variable.getVariableAId());
                variable.setVariableA(variable2);
            }
            if (variable.getVariableB() == null && variable.getVariableBId() != null) {
                variable2 = a2.k.m_mb(variable.getVariableBId());
                variable.setVariableB(variable2);
                return;
            }
        } else if (a instanceof AnalogAlarm && (variable = (AnalogAlarm)a).getVariable() == null) {
            Variable variable3 = a2.k.m_mb(variable.getVariableId());
            variable.setVariable(variable3);
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM')")
    public void m_bgc(Integer a, T a2) {
        c_bfa a3;
        c_bfa c_bfa2 = a3;
        a = c_bfa2.m_mb(a);
        c_bfa2.m_cgc(a2, (Alarm)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_wlc(Integer a, String a2) {
        c_bfa a3;
        return a3.A.findByGroupName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_mb(Integer a) {
        c_bfa a2;
        Alarm alarm = a2.m_ba(a);
        if (alarm == null) {
            throw new c_vc("Alarm not found with id of " + a);
        }
        return (T)alarm;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_qea(Pageable a) {
        c_bfa a2;
        return a2.A.findAll(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_ikc(Integer a) {
        c_bfa a2;
        return a2.A.findByGroupIdAndIsActiveTrue(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_da() {
        c_bfa a;
        return a.A.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_ud(Integer a, String a2) {
        c_bfa a3;
        return (T)a3.A.findOneByProjectIdAndName(a, a2);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = ClusterController.m_hi((Object)"g\u001d");
        stringArray[1] = AuditConfig.m_hi((Object)"T#F0B");
        stringArray[2] = ClusterController.m_hi((Object)"\t|\u0016d\u001cm\r");
        stringArray[3] = AuditConfig.m_hi((Object)"@!H&W");
        stringArray[4] = ClusterController.m_hi((Object)"\u001a|\u001co\rk\u001dL\u0000");
        stringArray[5] = AuditConfig.m_hi((Object)"0U6F'N<I\u0017F'B");
        stringArray[6] = ClusterController.m_hi((Object)"b\u0018}\rC\u0016j\u0010h\u0010k\u001dL\u0000");
        stringArray[7] = AuditConfig.m_hi((Object)"?F S\u001eH7N5N6C\u0017F'B");
        i = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM')")
    public T m_tfc(T a) {
        c_bfa a2;
        c_bfa c_bfa2 = a2;
        c_bfa2.m_fic(a);
        a = (Alarm)c_bfa2.A.save(a);
        a2.C.publishEvent((ApplicationEvent)new AlarmAddEvent((Object)a2, a));
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_oqc(T a, boolean a2) {
        Alarm alarm;
        c_bfa a3;
        T t = a;
        a3.m_ajc(t);
        if ((t.getId() != null ? (alarm = a3.m_ba(a.getId())) : (alarm = a3.m_ud(a.getProjectId(), a.getName()))) != null) {
            a3.m_cgc(a, alarm, a2);
            return;
        }
        c_bfa c_bfa2 = a3;
        c_bfa2.m_hpc(a);
        c_bfa2.A.save(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_ha(Integer a) {
        if (a != null) {
            c_bfa a2;
            a2.A.deleteByProjectId(a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_dd(Integer a, String a2) {
        c_bfa a3;
        Alarm alarm = a3.m_ud(a, a2);
        if (alarm == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_vc(String.format(ClusterController.m_hi((Object)"8b\u0018|\u0014.\u0017a\r.\u001fa\f`\u001d4Y~\u000ba\u0013k\u001azYg\u001d4Y+\u001d\"Y`\u0018c\u001c4Y+\n"), objectArray));
        }
        return (T)alarm;
    }

    protected void m_hpc(T a) {
        AnalogAlarm analogAlarm;
        if (!a.getGroup().getProject().equals((Object)a.getProject())) {
            throw new c_mj(AuditConfig.m_hi((Object)"\u0012K2U>\u00074U<R#\u0007#U<M6D'\u00072I7\u00072K2U>\u0007#U<M6D'\u0007>R SsJ2S0O"));
        }
        if (a.getOnTimeVariable() != null && !a.getOnTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mj(ClusterController.m_hi((Object)"8b\u0018|\u0014.\t|\u0016d\u001cm\r.\u0018`\u001d.\u000fo\u000bg\u0018l\u0015kY~\u000ba\u0013k\u001azYc\f}\r.\u0014o\rm\u0011"));
        }
        if (a.getOffTimeVariable() != null && !a.getOffTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mj(AuditConfig.m_hi((Object)"f?F!JsW!H9B0SsF=CsQ2U:F1K6\u0007#U<M6D'\u0007>R SsJ2S0O"));
        }
        if (a instanceof DigitalAlarm) {
            DigitalAlarm digitalAlarm = (DigitalAlarm)a;
            if (!digitalAlarm.getVariableA().getProject().equals((Object)a.getProject())) {
                throw new c_mj(ClusterController.m_hi((Object)"8b\u0018|\u0014.\t|\u0016d\u001cm\r.\u0018`\u001d.\u000fo\u000bg\u0018l\u0015kY~\u000ba\u0013k\u001azYc\f}\r.\u0014o\rm\u0011"));
            }
            if (digitalAlarm.getVariableB() != null && !digitalAlarm.getVariableB().getProject().equals((Object)a.getProject())) {
                throw new c_mj(AuditConfig.m_hi((Object)"f?F!JsW!H9B0SsF=CsQ2U:F1K6\u0007#U<M6D'\u0007>R SsJ2S0O"));
            }
        } else if (a instanceof AnalogAlarm && !(analogAlarm = (AnalogAlarm)a).getVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mj(ClusterController.m_hi((Object)"8b\u0018|\u0014.\t|\u0016d\u001cm\r.\u0018`\u001d.\u000fo\u000bg\u0018l\u0015kY~\u000ba\u0013k\u001azYc\f}\r.\u0014o\rm\u0011"));
        }
    }

    @DisableSpaceFilter
    public Collection<T> m_hd(Integer a) {
        c_bfa a2;
        return a2.A.findByProjectId(a);
    }

    private /* synthetic */ void m_cgc(T a, T a2, boolean a3) {
        c_bfa a4;
        if (!a.getClass().equals(a2.getClass())) {
            throw new c_mj(AuditConfig.m_hi((Object)"\u0012K2U>\u0007'^#B \u0007 O<R?CsE6\u0007 F>B"));
        }
        T t = a2;
        a4.m_ajc(a);
        BeanUtils.copyProperties(a, t, (String[])i);
        a4.m_hpc(t);
        if (a3) {
            a4.C.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a4, a2));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_vhc(List<Integer> a2) {
        c_bfa a3;
        c_bfa c_bfa2 = a3;
        a2 = c_bfa2.m_pic(a2);
        c_bfa2.A.deleteInBatch(a2);
        a2.forEach(a -> {
            c_bfa a2;
            a2.C.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<String> m_jpc(Integer a) {
        c_bfa a2;
        return a2.A.findDistinctPartsByProjectId(a);
    }

    @Order(value=3)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_pm(ProjectDeleteEvent a) {
        c_bfa a2;
        a2.m_ha(a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_agc(AlarmFilter a, Pageable a2) {
        c_bfa a3;
        return a3.A.findAlarmsByFilter(a, a2);
    }

    @DisableSpaceFilter
    public T m_vnc(Integer a) {
        c_bfa a2;
        return (T)((Alarm)a2.A.findById((Object)a).orElse(null));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_qa(Integer a) {
        c_bfa a2;
        if ((a = a2.m_ba(a)) != null) {
            c_bfa c_bfa2 = a2;
            c_bfa2.A.delete((Object)a);
            c_bfa2.C.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, (Alarm)a));
        }
    }
}

