/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.m.c_zba;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.c_dfa;
import com.inscada.mono.alarm.services.c_eia;
import com.inscada.mono.alarm.services.c_pka;
import com.inscada.mono.alarm.services.c_zia;
import com.inscada.mono.auth.c_cha;
import com.inscada.mono.cluster.m.c_oga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.fs.restcontrollers.FileController;
import com.inscada.mono.log.services.c_ye;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.settings.restcontrollers.LogoController;
import com.inscada.mono.shared.exceptions.c_jf;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener {
    private final c_eia M;
    public static final short J = 104;
    public static final short G = 109;
    private final c_ye H;
    public static final short D = 107;
    private final c_zia l;
    public static final short F = 102;
    private static final Logger a = LoggerFactory.getLogger(AlarmManager.class);
    private static final String f = "activeAlarmGroups";
    public static final short c = 106;
    public static final short I = 105;
    public static final short h = 103;
    private final Lock A;
    private final JedisPooled C;
    public static final short B = 108;
    private final c_dfa k;
    private final ClusterOperations i;
    public static final short b = 101;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_zba> getAlarmStatuses(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(FileController.m_hi((Object)"(6%7!!^S#\u0016\u0010\u0007\r\u001d\u0003S\u0005\u001f\bS\u0005\u001f\u0005\u0001\tS\u0017\u0007\u0005\u0007\u0011\u0000\u0001\u0000D\u0015\u000b\u0001D\u0003\u0016\u001c\u000e\u0016\u0007\u0007D\b\u0019S\b\u001c\u0007\u0012\b\u001f\u001d]"), (Object)a);
            return a2.getAlarmStatusesByProjectIdInternal(a);
        }
        AlarmManager.a.debug(LogoController.m_hi((Object)"QnQ\fSd^eZs%\u0001MDnTzRkHqF?Mz@{Dm\u0001yNm\u0001~Ms\u0001~M~Sr\u0001lU~UjRzR?GpS?QmNuD|U?Zb\u000f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.i.callLeaderMethod(Short.valueOf((short)105), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get alarm statuses for project " + a, (Throwable)exception);
        }
    }

    protected c_zba getAlarmGroupStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmGroupStatusInternal(alarmManager.k.m_vnc(a));
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.k.m_hd((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(FileController.m_hi((Object)"?!2 66ID2\u0007\u0007\r\u0005\u0005\u0007\r\u001d\u0003S\u0005\u001f\bS\u0005\u001f\u0005\u0001\tS\u0003\u0001\u000b\u0006\u0014\u0000D\u0015\u000b\u0001D\u0003\u0016\u001c\u000e\u0016\u0007\u0007D\b\u0019S\b\u001c\u0007\u0012\b\u001f\u001d]"), (Object)a);
            a2.activateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        AlarmManager.a.debug(LogoController.m_hi((Object)"QnQ\fSd^eZs%\u0001MDnTzRkHqF?Mz@{Dm\u0001kN?@|UvW~Uz\u0001~Ms\u0001~M~Sr\u0001xSpToR?GpS?QmNuD|U?Zb\u000f"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.i.callLeaderMethod(Short.valueOf((short)108), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC activate alarm groups for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            AlarmManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.i.addRemoteCall((short)101, (Object)a, AlarmManager.class.getDeclaredMethod(FileController.m_hi((Object)"\u0005\u0010\u0010\u001a\u0012\u0012\u0010\u0016%\u001f\u0005\u0001\t4\u0016\u001c\u0011\u0003-\u001d\u0010\u0016\u0016\u001d\u0005\u001f"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.i.addRemoteCall((short)102, (Object)a, AlarmManager.class.getDeclaredMethod(LogoController.m_hi((Object)"{D~BkHi@kD^M~SrfmNjQVOkDmO~M"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.i.addRemoteCall((short)103, (Object)a, AlarmManager.class.getDeclaredMethod(FileController.m_hi((Object)"\u0003\u0016\u00102\b\u0012\u0016\u001e7\u0007\u0005\u0007\u0011\u0000-\u001d\u0010\u0016\u0016\u001d\u0005\u001f"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.i.addRemoteCall((short)104, (Object)a, AlarmManager.class.getDeclaredMethod(LogoController.m_hi((Object)"FzU^M~SrfmNjQLU~UjRVOkDmO~M"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.i.addRemoteCall((short)105, (Object)a, AlarmManager.class.getDeclaredMethod(FileController.m_hi((Object)"\u0014\u0001\u0007%\u001f\u0005\u0001\t \u0010\u0012\u0010\u0006\u0017\u0016\u00171\u001d#\u0016\u001c\u000e\u0016\u0007\u0007-\u0017-\u001d\u0010\u0016\u0016\u001d\u0005\u001f"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.i.addRemoteCall((short)106, (Object)a, AlarmManager.class.getDeclaredMethod(LogoController.m_hi((Object)"xDk`s@mLXSpTork@kTlDlcfqmNuD|UVEVOkDmO~M"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            a.i.addRemoteCall((short)107, (Object)a, AlarmManager.class.getDeclaredMethod(FileController.m_hi((Object)"\u0003\u0016\u00102\b\u0012\u0016\u001e7\u0007\u0005\u0007\u0011\u0000\u0001\u0000-\u001d\u0010\u0016\u0016\u001d\u0005\u001f"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.i.addRemoteCall((short)108, (Object)a, AlarmManager.class.getDeclaredMethod(LogoController.m_hi((Object)"~BkHi@kD^M~SrfmNjQlcfqmNuD|UVEVOkDmO~M"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer.class;
            a.i.addRemoteCall((short)109, (Object)a, AlarmManager.class.getDeclaredMethod(FileController.m_hi((Object)"\u0000\u0016\u0005\u0010\u0010\u001a\u0012\u0012\u0010\u0016%\u001f\u0005\u0001\t4\u0016\u001c\u0011\u0003\u00171\u001d#\u0016\u001c\u000e\u0016\u0007\u0007-\u0017-\u001d\u0010\u0016\u0016\u001d\u0005\u001f"), classArray9));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(LogoController.m_hi((Object)"g~HsD{\u0001kN?SzFvRkDm\u0001^M~Srl~O~FzS?sOb?LzUwN{R"), noSuchMethodException);
        }
    }

    protected void deactivateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.k.m_gj(a));
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_cha.m_pcc(() -> {
            AlarmManager a2;
            a2.A.lock();
            try {
                c_pka c_pka2 = a2.M.m_fhc(a.getId());
                if (c_pka2 != null) {
                    c_pka2.m_nza();
                    a2.M.m_ilc(a.getId(), c_pka2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.C.srem(f, stringArray);
                return;
            }
            finally {
                a2.A.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected void activateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.activateAlarmGroupInternal(alarmManager.k.m_gj(a));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.deactivateAlarmGroup(alarmManager.k.m_dd(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_zba getAlarmStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.l.m_ud(a, a2)) == null) {
            return c_zba.B;
        }
        return a3.getAlarmStatus(a.getId());
    }

    public void notLeader() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        String string = alarmManager.i.getCurrentNode().getNodeId();
        AlarmManager.a.info(FileController.m_hi((Object)"%\u001f\u0005\u0001\t>\u0005\u001d\u0005\u0014\u0001\u0001^S0\u001b\r\u0000D\u001d\u000b\u0017\u0001SL\b\u0019ZD\u001a\u0017S*<D?+=#66S0;!S(6%7!!JS7\u0007\u000b\u0003\u0014\u001a\n\u0014D\u0012\b\u001fD\u001f\u000b\u0010\u0005\u001fD\u0012\b\u0012\u0016\u001eD\u001a\n\u0000\u0014\u0016\u0007\u0007\u000b\u0001\u0017]J]"), (Object)string);
        alarmManager.A.lock();
        try {
            a.M.m_rqc();
            AlarmManager.a.info(LogoController.m_hi((Object)"`s@mLR@q@xDm\u00017opU?mz@{Dm\u0001d\\6\u001b?`sM?MpB~M?@s@mL?HqRoD|UvNq\u0001k@lJl\u0001w@iD?CzDq\u0001mDnTzRkD{\u0001kN?RkNo\u000f"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            AlarmManager.a.error(FileController.m_hi((Object)"2\b\u0012\u0016\u001e)\u0012\n\u0012\u0003\u0016\u0016SL=\u000b\u0007D?\u0001\u0012\u0000\u0016\u0016S\u001f\u000eMID6\u0016\u0001\u000b\u0001D\u0017\u0011\u0001\r\u001d\u0003S\u0014\u0001\u000b\u0010\u0001\u0000\u0017S\u000b\u0015D\u0000\u0010\u001c\u0014\u0003\r\u001d\u0003S\b\u001c\u0007\u0012\bS\u0005\u001f\u0005\u0001\tS\r\u001d\u0017\u0003\u0001\u0010\u0010\u001c\u0016\u0000^S\u001f\u000e"), objectArray);
            return;
        }
        finally {
            a.A.unlock();
        }
    }

    protected Map<Integer, c_zba> getAlarmStatusesInternal(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"mZ`[dM\u001b?ez@|UvW~UvOx\u0001~Ms\u0001~M~Sr\u0001xSpToR?GpS?QmNuD|U?Zb\u0001sN|@sMf\u000f"), (Object)a);
            a2.deactivateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S6\u0016\u0015\u0006\u0001\u0000\u0010\u001a\n\u0014D\u001f\u0001\u0012\u0000\u0016\u0016S\u0010\u001cD\u0017\u0001\u0012\u0007\u0007\r\u0005\u0005\u0007\u0001S\u0005\u001f\bS\u0005\u001f\u0005\u0001\tS\u0003\u0001\u000b\u0006\u0014\u0000D\u0015\u000b\u0001D\u0003\u0016\u001c\u000e\u0016\u0007\u0007D\b\u0019]"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.i.callLeaderMethod(Short.valueOf((short)109), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC deactivate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_zba getAlarmGroupStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.k.m_ud(a, a2)) == null) {
            return c_zba.B;
        }
        return a3.getAlarmGroupStatus(a.getId());
    }

    @TransactionalEventListener(value={AlarmGroupChangeEvent.class})
    public void handleAlarmGroupChangeEvent(AlarmGroupChangeEvent a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.info(LogoController.m_hi((Object)"mZ`[dM\u001b?i~O{MvOx\u0001^M~SrfmNjQ\\I~OxDZWzOk\u0001yNm\u0001xSpTo\u0001Ve%\u0001d\\"), (Object)a.getAlarmGroup().getId());
            a2.A.lock();
            try {
                Integer n = a.getAlarmGroup().getId();
                if (a2.getAlarmGroupStatusInternal(n) == c_zba.k) {
                    AlarmManager alarmManager = a2;
                    alarmManager.deactivateAlarmGroupInternal(n);
                    alarmManager.activateAlarmGroupInternal(n);
                }
                return;
            }
            finally {
                a2.A.unlock();
            }
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"=+=I?!2 66ID:\u0003\u001d\u000b\u0001\r\u001d\u0003S%\u001f\u0005\u0001\t4\u0016\u001c\u0011\u0003'\u001b\u0005\u001d\u0003\u0016!\u0005\u0001\u001d\u0010S\u0002\u001c\u0016S\u0003\u0001\u000b\u0006\u0014S-7^S\u001f\u000e"), (Object)a.getAlarmGroup().getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"Sd^eZs%\u0001[D~BkHi@kHqF?@s@mL?FmNjQ?Zb\u0001sN|@sMf\u000f"), (Object)a);
            a2.deactivateAlarmGroupInternal(a);
            return;
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"=+=I?!2 66ID!\u0001\u0002\u0011\u0016\u0017\u0007\r\u001d\u0003S\b\u0016\u0005\u0017\u0001\u0001D\u0007\u000bS\u0000\u0016\u0005\u0010\u0010\u001a\u0012\u0012\u0010\u0016D\u0012\b\u0012\u0016\u001eD\u0014\u0016\u001c\u0011\u0003D\b\u0019]"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.i.callLeaderMethod(Short.valueOf((short)102), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC deactivate alarm group " + a, (Throwable)exception);
        }
    }

    protected c_zba getAlarmGroupStatusInternal(AlarmGroup a) {
        AlarmManager a2;
        if (a == null) {
            return c_zba.B;
        }
        if ((a = a2.M.m_fhc(a.getId())) != null && a.m_hhc()) {
            return c_zba.k;
        }
        return c_zba.B;
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.activateAlarmGroup(alarmManager.k.m_dd(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_zba getAlarmStatus(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"Sd^eZs%\u0001XDkUvOx\u0001~M~Sr\u0001lU~UjR?GpS?Zb\u0001sN|@sMf\u000f"), (Object)a);
            return a2.getAlarmStatusInternal(a);
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S6\u0016\u0015\u0006\u0001\u0000\u0010\u001a\n\u0014D\u001f\u0001\u0012\u0000\u0016\u0016S\u0002\u001c\u0016S\u0005\u001f\u0005\u0001\tS\u0017\u0007\u0005\u0007\u0011\u0000D\u0015\u000b\u0001D\b\u0019]"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_zba)a2.i.callLeaderMethod(Short.valueOf((short)103), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get alarm status for " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmChangeEvent.class})
    public void handleAlarmChangeEvent(AlarmChangeEvent a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            Alarm alarm = a.getAlarm();
            AlarmManager.a.info(LogoController.m_hi((Object)"Sd^eZs%\u0001W@qEsHqF?`s@mL\\I~OxDZWzOk\u0001yNm\u0001~M~Sr\u0001Ve%\u0001d\\3\u0001XSpTo\u0001Ve%\u0001d\\"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_pka c_pka2 = a2.M.m_fhc(alarm.getGroupId());
            if (c_pka2 != null && c_pka2.m_hhc()) {
                if (Boolean.TRUE.equals(alarm.getIsActive())) {
                    c_pka2.m_qnc(alarm);
                    return;
                }
                c_pka2.m_ahc(alarm);
                return;
            }
        } else {
            AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S-\u0014\n\u001c\u0016\u001a\n\u0014D2\b\u0012\u0016\u001e'\u001b\u0005\u001d\u0003\u0016!\u0005\u0001\u001d\u0010S\u0002\u001c\u0016S\u0005\u001f\u0005\u0001\tS-7^S\u001f\u000e"), (Object)a.getAlarm().getId());
        }
    }

    public AlarmManager(c_zia a, c_dfa a2, c_eia a3, c_ye a4, JedisPooled a5, ClusterOperations a6) {
        AlarmManager a7;
        AlarmManager alarmManager = a7;
        AlarmManager alarmManager2 = a7;
        AlarmManager alarmManager3 = a7;
        AlarmManager alarmManager4 = a7;
        alarmManager4.A = new ReentrantLock();
        alarmManager3.l = a;
        alarmManager3.k = a2;
        alarmManager2.M = a3;
        alarmManager2.H = a4;
        alarmManager.C = a5;
        alarmManager.i = a6;
    }

    protected c_zba getAlarmStatusInternal(Alarm a) {
        AlarmManager a2;
        if (a == null) {
            return c_zba.B;
        }
        c_pka c_pka2 = a2.M.m_fhc(a.getGroup().getId());
        if (c_pka2 != null && c_pka2.m_hhc() && c_pka2.m_vlc(a.getId())) {
            return c_zba.k;
        }
        return c_zba.B;
    }

    @TransactionalEventListener(value={AlarmDeleteEvent.class})
    public void handleAlarmDeleteEvent(AlarmDeleteEvent a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            Alarm alarm = a.getAlarm();
            AlarmManager.a.info(LogoController.m_hi((Object)"Sd^eZs%\u0001W@qEsHqF?`s@mL[DsDkDZWzOk\u0001yNm\u0001~M~Sr\u0001Ve%\u0001d\\3\u0001XSpTo\u0001Ve%\u0001d\\"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_pka c_pka2 = a2.M.m_fhc(alarm.getGroupId());
            if (c_pka2 != null && c_pka2.m_hhc()) {
                c_pka2.m_ahc(alarm);
                return;
            }
        } else {
            AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S-\u0014\n\u001c\u0016\u001a\n\u0014D2\b\u0012\u0016\u001e \u0016\b\u0016\u0010\u0016!\u0005\u0001\u001d\u0010S\u0002\u001c\u0016S\u0005\u001f\u0005\u0001\tS-7^S\u001f\u000e"), (Object)a.getAlarm().getId());
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.k.m_hd((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.info(LogoController.m_hi((Object)"Sd^eZs%\u0001W@qEsHqF?qmNuD|U[D~BkHi@kDZWzOk\u0001yNm\u0001oSpKzBk\u0001Ve%\u0001d\\"), (Object)a.getProject().getId());
            a2.deactivateAlarmGroupsByProjectIdInternal(a.getProject().getId());
            return;
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S-\u0014\n\u001c\u0016\u001a\n\u0014D#\u0016\u001c\u000e\u0016\u0007\u0007 \u0016\u0005\u0010\u0010\u001a\u0012\u0012\u0010\u0016!\u0005\u0001\u001d\u0010S\u0002\u001c\u0016S\u0014\u0001\u000b\u0019\u0001\u0010\u0010S-7^S\u001f\u000e"), (Object)a.getProject().getId());
    }

    protected void activateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_cha.m_pcc(() -> {
            AlarmManager a2;
            a2.A.lock();
            try {
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_jf("Project should be active to start alarm group " + a.getName());
                }
                c_pka c_pka2 = a2.M.m_zoc(a);
                c_pka2.m_mxa();
                if (c_pka2.m_hhc()) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a.getId().toString();
                    a2.C.sadd(f, stringArray);
                }
                return;
            }
            finally {
                a2.A.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_zba getAlarmGroupStatus(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"Sd^eZs%\u0001XDkUvOx\u0001~M~Sr\u0001xSpTo\u0001lU~UjR?GpS?Zb\u0001sN|@sMf\u000f"), (Object)a);
            return a2.getAlarmGroupStatusInternal(a);
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S6\u0016\u0015\u0006\u0001\u0000\u0010\u001a\n\u0014D\u001f\u0001\u0012\u0000\u0016\u0016S\u0002\u001c\u0016S\u0005\u001f\u0005\u0001\tS\u0003\u0001\u000b\u0006\u0014S\u0017\u0007\u0005\u0007\u0011\u0000D\u0015\u000b\u0001D\b\u0019]"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_zba)a2.i.callLeaderMethod(Short.valueOf((short)104), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get alarm group status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"Sd^eZs%\u0001^BkHi@kHqF?@s@mL?FmNjQ?Zb\u0001sN|@sMf\u000f"), (Object)a);
            a2.activateAlarmGroupInternal(a);
            return;
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"=+=I?!2 66ID!\u0001\u0002\u0011\u0016\u0017\u0007\r\u001d\u0003S\b\u0016\u0005\u0017\u0001\u0001D\u0007\u000bS\u0005\u0010\u0010\u001a\u0012\u0012\u0010\u0016D\u0012\b\u0012\u0016\u001eD\u0014\u0016\u001c\u0011\u0003D\b\u0019]"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.i.callLeaderMethod(Short.valueOf((short)101), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC activate alarm group " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_zba> getAlarmGroupStatuses(Integer a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"Sd^eZs%\u0001XDkUvOx\u0001~Ms\u0001~M~Sr\u0001xSpTo\u0001lU~UjRzR?GpS?QmNuD|U?Zb\u0001sN|@sMf\u000f"), (Object)a);
            return a2.getAlarmGroupStatusesByProjectIdInternal(a);
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"*<*^(6%7!!^S6\u0016\u0015\u0006\u0001\u0000\u0010\u001a\n\u0014D\u001f\u0001\u0012\u0000\u0016\u0016S\u0002\u001c\u0016S\u0005\u001f\bS\u0005\u001f\u0005\u0001\tS\u0003\u0001\u000b\u0006\u0014S\u0017\u0007\u0005\u0007\u0011\u0000\u0001\u0000D\u0015\u000b\u0001D\u0003\u0016\u001c\u000e\u0016\u0007\u0007D\b\u0019]"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.i.callLeaderMethod(Short.valueOf((short)106), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get alarm group statuses for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmAddEvent.class})
    public void handleAlarmAddEvent(AlarmAddEvent a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            c_pka c_pka2;
            Alarm alarm = a.getAlarm();
            AlarmManager.a.info(LogoController.m_hi((Object)"mZ`[dM\u001b?i~O{MvOx\u0001^M~Sr`{EZWzOk\u0001yNm\u0001~M~Sr\u0001Ve%\u0001d\\3\u0001XSpTo\u0001Ve%\u0001d\\"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            if (Boolean.TRUE.equals(alarm.getIsActive()) && (c_pka2 = a2.M.m_fhc(alarm.getGroupId())) != null && c_pka2.m_hhc()) {
                c_pka2.m_qnc(alarm);
                return;
            }
        } else {
            AlarmManager.a.debug(FileController.m_hi((Object)"=+=I?!2 66ID:\u0003\u001d\u000b\u0001\r\u001d\u0003S%\u001f\u0005\u0001\t2\u0000\u0017!\u0005\u0001\u001d\u0010S\u0002\u001c\u0016S\u0005\u001f\u0005\u0001\tS-7^S\u001f\u000e"), (Object)a.getAlarm().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        String string = alarmManager.i.getCurrentNode().getNodeId();
        AlarmManager.a.info(LogoController.m_hi((Object)"^M~Srl~O~FzS%\u0001KIvR?OpEz\u00017Zb\b?I~R?CzBpLz\u0001kIz\u0001Sd^eZs1\u0001MDlUpSvOx\u0001~BkHiD?@s@mLl\u000f1\u000f"), (Object)string);
        alarmManager.A.lock();
        try {
            Set set = a2.C.smembers(f).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                AlarmManager.a.info(FileController.m_hi((Object)"2\b\u0012\u0016\u001e)\u0012\n\u0012\u0003\u0016\u0016SL?\u0001\u0012\u0000\u0016\u0016S\u001f\u000eMID=\u000bS\u0005\u0010\u0010\u001a\u0012\u0016D\u0012\b\u0012\u0016\u001eD\u0014\u0016\u001c\u0011\u0003\u0017S\u0002\u001c\u0011\u001d\u0000S\r\u001dD!\u0001\u0017\r\u0000D\u0007\u000bS\u0016\u0016\u0017\u0007\u000b\u0001\u0001]"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            AlarmManager.a.info(LogoController.m_hi((Object)"`s@mLR@q@xDm\u00017mz@{Dm\u0001d\\6\u001b?gpTqE?Zb\u0001~BkHiD?@s@mL?FmNjQ?h[R?Hq\u0001MD{Hl\u0001kN?SzRkNmD%\u0001d\\"), objectArray);
            ArrayList arrayList = new ArrayList(a2.k.m_ogc(set));
            AlarmManager.a.info(FileController.m_hi((Object)"%\u001f\u0005\u0001\t>\u0005\u001d\u0005\u0014\u0001\u0001D[(\u0016\u0005\u0017\u0001\u0001D\b\u0019Z^S%\u0007\u0010\u0016\t\u0003\u0010\u001a\n\u0014D\u0007\u000bS\u0016\u0016\u0017\u0007\u000b\u0001\u0001S\u001f\u000eD\u0012\b\u0012\u0016\u001eD\u0014\u0016\u001c\u0011\u0003\u0017]"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                AlarmManager a2;
                String string = a2.i.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    AlarmManager.a.info(LogoController.m_hi((Object)"^M~Srl~O~FzS?\tSD~EzS?Zb\b%\u0001MDlUpSvOx\u0001~M~Sr\u0001xSpTo\u001b?Zb\u00017h[\u001b?Zb\b"), objectArray);
                    a2.activateAlarmGroupInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.H.m_rea(a.getProject()).m_w("Alarm Group Restore (Leader " + string + ")", String.format(FileController.m_hi((Object)"A\u0000D[-7^SA\u0017MS\u0002\u0012\r\u001f\u0001\u0017D\u0007\u000bS\u0016\u0016\u0017\u0007\u000b\u0001\u0001]D0\u0005\u0006\u0017\u0016^SA\u0000"), objectArray));
                    try {
                        AlarmManager.a.warn(LogoController.m_hi((Object)"^M~Srl~O~FzS?\tSD~EzS?Zb\b%\u0001^UkDrQkHqF?Up\u0001{D~BkHi@kD?@s@mL?FmNjQ?Zb\u0001~GkDm\u0001mDlUpS~UvNq\u0001y@vMjSz\u000f"), (Object)string, (Object)a.getId());
                        a2.deactivateAlarmGroupInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        AlarmManager.a.error(FileController.m_hi((Object)"2\b\u0012\u0016\u001e)\u0012\n\u0012\u0003\u0016\u0016SL?\u0001\u0012\u0000\u0016\u0016S\u001f\u000eMID5\u0005\u001a\b\u0016\u0000S\u0010\u001cD\u0017\u0001\u0012\u0007\u0007\r\u0005\u0005\u0007\u0001S\u0005\u001f\u0005\u0001\tS\u0003\u0001\u000b\u0006\u0014S\u001f\u000eD\u0012\u0002\u0007\u0001\u0001D\u0001\u0001\u0000\u0010\u001c\u0016\u0012\u0010\u001a\u000b\u001dD\u0015\u0005\u001a\b\u0006\u0016\u0016^S\u001f\u000e"), objectArray2);
                        return;
                    }
                }
            });
            AlarmManager.a.info(LogoController.m_hi((Object)"`s@mLR@q@xDm\u00017mz@{Dm\u0001d\\6\u001b?gvOvRwD{\u0001~M~Sr\u0001mDlUpS~UvNq\u0001oSpBzRl\u000f"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            AlarmManager.a.error(FileController.m_hi((Object)"%\u001f\u0005\u0001\t>\u0005\u001d\u0005\u0014\u0001\u0001D[(\u0016\u0005\u0017\u0001\u0001D\b\u0019Z^S!\u0001\u0016\u001c\u0016S\u0000\u0006\u0016\u001a\n\u0014D\u0012\b\u0012\u0016\u001eD\u0001\u0001\u0000\u0010\u001c\u0016\u0012\u0010\u001a\u000b\u001dD\u0003\u0016\u001c\u0007\u0016\u0017\u0000^S\u001f\u000e"), objectArray);
            return;
        }
        finally {
            a2.A.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_zba> getAlarmStatuses(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.i.isLeader()) {
            AlarmManager.a.debug(LogoController.m_hi((Object)"mZ`[dM\u001b?fzUkHqF?@s@mL?Rk@kTlDl\u0001yNm\u0001d\\?h[R?MpB~MsX%\u0001d\\"), (Object)a.size(), a);
            return a2.getAlarmStatusesInternal(a);
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"=+=I?!2 66ID!\u0001\u0002\u0011\u0016\u0017\u0007\r\u001d\u0003S\b\u0016\u0005\u0017\u0001\u0001D\u0015\u000b\u0001D\u0012\b\u0012\u0016\u001eD\u0000\u0010\u0012\u0010\u0006\u0017\u0016\u0017S\u0002\u001c\u0016S\u001f\u000eD: \u0000^S\u001f\u000e"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.i.callLeaderMethod(Short.valueOf((short)107), objectArray);
        }
        catch (Exception exception) {
            throw new c_oga("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmGroupDeleteEvent.class})
    public void handleAlarmGroupDeleteEvent(AlarmGroupDeleteEvent a) {
        AlarmManager a2;
        if (a2.i.isLeader()) {
            AlarmManager.a.info(LogoController.m_hi((Object)"mZ`[dM\u001b?i~O{MvOx\u0001^M~SrfmNjQ[DsDkDZWzOk\u0001yNm\u0001xSpTo\u0001Ve%\u0001d\\"), (Object)a.getAlarmGroup().getId());
            a2.deactivateAlarmGroupInternal(a.getAlarmGroup().getId());
            return;
        }
        AlarmManager.a.debug(FileController.m_hi((Object)"=+=I?!2 66ID:\u0003\u001d\u000b\u0001\r\u001d\u0003S%\u001f\u0005\u0001\t4\u0016\u001c\u0011\u0003 \u0016\b\u0016\u0010\u0016!\u0005\u0001\u001d\u0010S\u0002\u001c\u0016S\u0003\u0001\u000b\u0006\u0014S-7^S\u001f\u000e"), (Object)a.getAlarmGroup().getId());
    }

    protected c_zba getAlarmStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmStatusInternal(alarmManager.l.m_vnc(a));
    }

    protected Map<Integer, c_zba> getAlarmGroupStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.k.m_hd((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroup::getId, arg_0 -> a2.getAlarmGroupStatusInternal(arg_0)));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.i.addListener((ClusterNodeListener)a);
        AlarmManager.a.info(LogoController.m_hi((Object)"`s@mLR@q@xDm\u0001vOvUv@sHeD{\u0001~O{\u0001mDxHlUzSzE?@l\u0001\\MjRkDmopEzmvRkDqDm\u000f"));
    }

    protected Map<Integer, c_zba> getAlarmStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.l.m_hd((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Alarm::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }
}

