/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.m.c_zba;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_bfa;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.impexp.a.c_ff;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.x.c_bh;
import com.inscada.mono.project.m.c_pg;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AlarmController<T extends Alarm>
extends ProjectBasedImportExportController {
    protected final AlarmManager i;
    protected final c_bfa<T> b;

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_zba getAlarmStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.i.getAlarmStatus(projectId, a);
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_zba> getAlarmStatuses(@RequestParam(value="projectId") Integer a) {
        return this.i.getAlarmStatuses(a);
    }

    @PostMapping(value={"/filter/pages"})
    public Page<T> getAlarmsByFilter(@Valid @RequestBody AlarmFilter alarmFilter, Pageable a) {
        return this.b.m_agc(alarmFilter, a);
    }

    protected AlarmController(c_bfa<T> a, AlarmManager a2, c_ff a3, c_pg a4) {
        AlarmController a5;
        AlarmController alarmController = a5;
        super(a3, EnumSet.of(c_bh.K), a4);
        alarmController.b = a;
        alarmController.i = a2;
    }

    @GetMapping(value={"/{alarmId}"})
    public T getAlarm(@PathVariable(value="alarmId") Integer a) {
        return (T)this.b.m_ba(a);
    }

    @GetMapping(value={"/{alarmId}/status"})
    public c_zba getAlarmStatus(@PathVariable(value="alarmId") Integer a) {
        return this.i.getAlarmStatus(a);
    }

    @DeleteMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarm(@PathVariable(value="alarmId") Integer a) {
        this.b.m_qa(a);
    }

    @GetMapping(params={"projectId"})
    public Collection<T> getAlarms(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.b.m_da();
        }
        return this.b.m_oa(a);
    }

    @GetMapping(value={"/parts"})
    public Collection<String> getPartsByProjectId(@RequestParam(name="projectId") Integer a) {
        return this.b.m_jpc(a);
    }

    @PostMapping
    public ResponseEntity<T> createAlarm(@Valid @RequestBody T alarm, UriComponentsBuilder a) {
        alarm = this.b.m_tfc(alarm);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarm.getId();
        return ResponseEntity.created((URI)a.path(SetValueRequest.m_hi((Object)"w\u00119\u00069\u00185#<\u0017")).buildAndExpand(objectArray).toUri()).body(alarm);
    }

    @GetMapping(value={"/status"}, params={"alarmIds"})
    public Map<Integer, c_zba> getAlarmStatuses(@RequestParam(value="alarmIds") Integer[] a) {
        return this.i.getAlarmStatuses(Arrays.asList(a));
    }

    @PutMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarm(@PathVariable(value="alarmId") Integer alarmId, @Valid @RequestBody T a) {
        this.b.m_bgc(alarmId, a);
    }

    @GetMapping(value={"/pages"})
    public Page<T> getAlarmsByProjectId(@RequestParam(name="projectId", required=false) Integer projectId, Pageable a) {
        if (projectId == null) {
            return this.b.m_qea(a);
        }
        return this.b.m_ksa(projectId, a);
    }

    @GetMapping(value={"/name"})
    public T getAlarmByName(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="alarmName") String a) {
        return (T)this.b.m_dd(projectId, a);
    }

    @GetMapping(params={"projectId", "groupName"})
    public Collection<T> getAlarmsByGroupId(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="groupName") String a) {
        return this.b.m_wlc(projectId, a);
    }

    @DeleteMapping(value={"/multi"}, params={"alarmIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmsByIds(@RequestParam(value="alarmIds") Integer[] a) {
        this.b.m_vhc(List.of(a));
    }
}

