/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.inscada.mono.alarm.m.c_fda;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.CustomAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="alarm")
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"groupId", "group"})})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DigitalAlarm.class, name="Digital"), @JsonSubTypes.Type(value=AnalogAlarm.class, name="Analog"), @JsonSubTypes.Type(value=CustomAlarm.class, name="Custom")})
public abstract class Alarm
extends SpaceBaseModel {
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Min(value=0L)
    protected Integer delay;
    private static final String ALARM_TYPE = "Base";
    @NotBlank
    @Size(max=100)
    protected String name;
    @Column(name="project_id", insertable=false, updatable=false)
    protected Integer projectId;
    @Column(name="off_time_variable_id", insertable=false, updatable=false)
    protected Integer offTimeVariableId;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="on_time_variable_id")
    private Variable<?, ?, ?> onTimeVariable;
    @JsonIgnore
    @Transient
    protected Map<c_fda, Long> lastDelayTimes;
    @Size(max=255)
    protected String dsc;
    @Size(max=100)
    protected String part;
    @Column(name="on_time_variable_id", insertable=false, updatable=false)
    protected Integer onTimeVariableId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="off_time_variable_id")
    private Variable<?, ?, ?> offTimeVariable;
    @Id
    @Column(name="alarm_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="alarmSeq")
    @GenericGenerator(name="alarmSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="alarm_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="group_id")
    protected AlarmGroup group;
    @Column(name="group_id", insertable=false, updatable=false)
    protected Integer groupId;

    public void setOffTimeVariable(Variable<?, ?, ?> a) {
        Alarm a2;
        Alarm alarm = a2;
        alarm.offTimeVariable = a;
        alarm.offTimeVariableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setOnTimeVariable(Variable<?, ?, ?> a) {
        Alarm a2;
        Alarm alarm = a2;
        alarm.onTimeVariable = a;
        alarm.onTimeVariableId = a != null && a.getId() != null ? a.getId() : null;
    }

    public String getAlarmType() {
        return ALARM_TYPE;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public Variable<?, ?, ?> getOffTimeVariable() {
        Alarm a;
        return a.offTimeVariable;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setGroupId(Integer a) {
        a.groupId = a;
    }

    public void setOnTimeVariableId(Integer a) {
        a.onTimeVariableId = a;
    }

    public Integer getOffTimeVariableId() {
        Alarm a;
        return a.offTimeVariableId;
    }

    public AlarmGroup getGroup() {
        Alarm a;
        return a.group;
    }

    public void setOffTimeVariableId(Integer a) {
        a.offTimeVariableId = a;
    }

    public boolean equals(Object a) {
        Alarm a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Alarm)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Alarm)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public String getPart() {
        Alarm a;
        return a.part;
    }

    public void setIsActive(Boolean a) {
        a.isActive = a;
    }

    public String getName() {
        Alarm a;
        return a.name;
    }

    public Variable<?, ?, ?> getOnTimeVariable() {
        Alarm a;
        return a.onTimeVariable;
    }

    public void setPart(String a) {
        a.part = a;
    }

    public Integer getDelay() {
        Alarm a;
        return a.delay;
    }

    public int hashCode() {
        Alarm a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setDelay(Integer a) {
        a.delay = a;
    }

    public Map<c_fda, Long> getLastDelayTimes() {
        Alarm a;
        return a.lastDelayTimes;
    }

    public Integer getOnTimeVariableId() {
        Alarm a;
        return a.onTimeVariableId;
    }

    public Integer getGroupId() {
        Alarm a;
        return a.groupId;
    }

    public Project getProject() {
        Alarm a;
        return a.project;
    }

    public String getDsc() {
        Alarm a;
        return a.dsc;
    }

    public Integer getId() {
        Alarm a;
        return a.id;
    }

    public void setGroup(AlarmGroup a) {
        Alarm a2;
        Alarm alarm = a2;
        alarm.group = a;
        alarm.groupId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setLastDelayTimes(Map<c_fda, Long> a) {
        a.lastDelayTimes = a;
    }

    public Integer getProjectId() {
        Alarm a;
        return a.projectId;
    }

    public Alarm() {
        Alarm a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setProject(Project a) {
        Alarm a2;
        Alarm alarm = a2;
        alarm.project = a;
        alarm.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Boolean getIsActive() {
        Alarm a;
        return a.isActive;
    }
}

