create table custom_query
(
    custom_query_id serial    not null
        constraint custom_query_custom_query_id_pk
        primary key,
    project_id   integer      not null
        constraint custom_query_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    query_str    text         not null,

    space_id     integer      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index custom_query_project_id_name_uindex
    on custom_query(project_id, name)
;

ALTER SEQUENCE custom_query_custom_query_id_seq RENAME TO custom_query_seq;

ALTER SEQUENCE custom_query_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (211, 'CREATE_CUSTOM_QUERY'), (212, 'VIEW_CUSTOM_QUERY'),
        (213, 'UPDATE_CUSTOM_QUERY'), (214, 'DELETE_CUSTOM_QUERY'),
        (215, 'EXPORT_CUSTOM_QUERY'), (216, 'IMPORT_CUSTOM_QUERY');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 211), (1, 212), (1, 213), (1, 214), (1, 215), (1, 216);

INSERT INTO inscada.menus (menu_id, name)
VALUES (77, 'Custom Query Dev');

INSERT INTO inscada.role_menus (role_id, menu_id)
VALUES (1, 77);