/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.restcontrollers;

import com.inscada.mono.c_lba;
import com.inscada.mono.log.services.c_ce;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.j.c_pa;
import com.inscada.mono.user.model.ResetPasswordToken;
import com.inscada.mono.user.model.Role;
import com.inscada.mono.user.model.User;
import com.inscada.mono.user.model.UserDto;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final c_pa l;

    @DeleteMapping(value={"/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        this.l.m_wc(userId, a);
    }

    public UserController(c_pa a) {
        UserController a2;
        a2.l = a;
    }

    @PostMapping
    public ResponseEntity<User> createUser(@Valid @RequestBody UserDto userDto, UriComponentsBuilder a) {
        userDto = this.l.m_ec(userDto);
        Object[] objectArray = new Object[1];
        objectArray[0] = userDto.getId();
        return ResponseEntity.created((URI)a.path(c_lba.m_rl((Object)"\u000fgUoEnix]")).buildAndExpand(objectArray).toUri()).body((Object)userDto);
    }

    @GetMapping(value={"/ui-configs"})
    public String getUIConfigs(Principal a) {
        UserController a2;
        return a2.l.m_jc(a.getName());
    }

    @PostMapping(value={"/{username}/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@PathVariable(value="username") String username, @Valid @RequestBody ResetPasswordToken a) {
        this.l.m_kb(username, a);
    }

    @PostMapping(value={"/{userId}/spaces"})
    public ResponseEntity<Space> addSpace(@PathVariable(value="userId") Integer userId, @RequestBody Integer spaceId, UriComponentsBuilder a) {
        Space space = this.l.m_fc(userId, spaceId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = spaceId;
        return ResponseEntity.created((URI)a.path(c_ce.m_rl((Object)">\u007fdwtvX`l+btpgtw>\u007fbtpgtMuy")).buildAndExpand(objectArray).toUri()).body((Object)space);
    }

    @PostMapping(value={"/{userId}/roles"})
    public ResponseEntity<Role> addRole(@PathVariable(value="userId") Integer userId, @RequestBody Integer roleId, UriComponentsBuilder a) {
        Role role = this.l.m_zb(userId, roleId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = roleId;
        return ResponseEntity.created((URI)a.path(c_lba.m_rl((Object)"3[iSyRUDa\u000fnOpEo\u000fgRsLyix]")).buildAndExpand(objectArray).toUri()).body((Object)role);
    }

    @GetMapping(value={"/{userId}/roles/{roleId}"})
    public Role getRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        return this.l.m_cc(userId, a);
    }

    @PutMapping(value={"/agree"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void acceptEula(Principal a) {
        UserController a2;
        a2.l.m_lc(a.getName());
    }

    @GetMapping
    public Collection<User> getUsers() {
        UserController a;
        return a.l.m_ta();
    }

    @PutMapping(value={"/ui-configs"})
    public void setUIConfigs(@RequestBody String value, Principal a) {
        this.l.m_oc(value, a.getName());
    }

    @GetMapping(value={"/active-space"})
    public String[] getAllSpaceUsers() {
        UserController a;
        return a.l.m_rc();
    }

    @DeleteMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@PathVariable(value="userId") Integer a) {
        this.l.m_ma(a);
    }

    @GetMapping(value={"/{userId}"})
    public User getUser(@PathVariable(value="userId") Integer a) {
        return this.l.m_la(a);
    }

    @DeleteMapping(value={""}, params={"userIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUsersByIds(@RequestParam(value="userIds") Integer[] a) {
        this.l.m_uc(List.of(a));
    }

    @GetMapping(value={"/{userId}/roles"})
    public Collection<Role> getRoles(@PathVariable(value="userId") Integer a) {
        return this.l.m_yc(a);
    }

    @GetMapping(value={"/{userId}/spaces"})
    public Collection<Space> getSpaces(@PathVariable(value="userId") Integer a) {
        return this.l.m_qc(a);
    }

    @PostMapping(value={"/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetOwnPassword(@Valid @RequestBody ResetPasswordToken resetPasswordToken, Principal a) {
        this.l.m_xc(a.getName(), resetPasswordToken);
    }

    @GetMapping(value={"/{userId}/spaces/{spaceId}"})
    public Space getSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        return this.l.m_dc(userId, a);
    }

    @PutMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUser(@PathVariable(value="userId") Integer userId, @Valid @RequestBody User a) {
        this.l.m_vc(userId, a);
    }

    @DeleteMapping(value={"/{userId}/spaces/{spaceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        this.l.m_nc(userId, a);
    }
}

