/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.user.model.Menu;
import com.inscada.mono.user.model.Permission;
import com.inscada.mono.user.model.User;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="roles")
public class Role
extends BaseModel {
    @JsonIgnore
    @ManyToMany(mappedBy="roles")
    private Set<User> users;
    private String name;
    @JsonIgnore
    @Fetch(value=FetchMode.SUBSELECT)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="role_menus", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="menu_id")})
    private Set<Menu> menus;
    @JsonIgnore
    @Fetch(value=FetchMode.SUBSELECT)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="role_permissions", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")})
    private Set<Permission> permissions;
    @Id
    @Column(name="role_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="roleSeq")
    @GenericGenerator(name="roleSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="roles_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;

    public void setPermissions(Set<Permission> a) {
        a.permissions = a;
    }

    private static /* synthetic */ boolean lambda$removeMenu$1(Integer a, Menu a2) {
        return a2.getId().equals(a);
    }

    public void setUsers(Set<User> a) {
        a.users = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setMenus(Set<Menu> a) {
        a.menus = a;
    }

    public Role() {
        Role a;
        Role role = a;
        a.permissions = new HashSet();
        role.menus = new HashSet();
        a.users = new HashSet();
    }

    public void setId(Integer a) {
        a.id = a;
    }

    private static /* synthetic */ boolean lambda$removePermission$0(Integer a, Permission a2) {
        return a2.getId().equals(a);
    }

    public void remove() {
        Permission permission;
        Role a;
        Iterator iterator;
        Iterator iterator2 = iterator = new HashSet(a.permissions).iterator();
        while (iterator2.hasNext()) {
            permission = (Permission)iterator.next();
            iterator2 = iterator;
            a.permissions.remove(permission);
            permission.getRoles().remove(a);
        }
        iterator = new HashSet(a.menus).iterator();
        Iterator iterator3 = iterator;
        while (iterator3.hasNext()) {
            permission = (Menu)iterator.next();
            iterator3 = iterator;
            a.menus.remove(permission);
            permission.getRoles().remove(a);
        }
    }

    public Set<User> getUsers() {
        Role a;
        return a.users;
    }

    public void removePermission(Integer a) {
        Role a2;
        a = a2.permissions.stream().filter(arg_0 -> Role.lambda$removePermission$0((Integer)((Object)a), arg_0)).findFirst();
        if (a.isPresent()) {
            Optional<Permission> optional = a;
            a2.permissions.remove(optional.get());
            ((Permission)optional.get()).getRoles().remove(a2);
        }
    }

    public void removeMenu(Integer a) {
        Role a2;
        a = a2.menus.stream().filter(arg_0 -> Role.lambda$removeMenu$1((Integer)((Object)a), arg_0)).findFirst();
        if (a.isPresent()) {
            Optional<Menu> optional = a;
            a2.menus.remove(optional.get());
            ((Menu)optional.get()).getRoles().remove(a2);
        }
    }

    public Integer getId() {
        Role a;
        return a.id;
    }

    public Set<Permission> getPermissions() {
        Role a;
        return a.permissions;
    }

    public int hashCode() {
        Role a;
        Object[] objectArray = new Object[1];
        objectArray[0] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getName() {
        Role a;
        return a.name;
    }

    public void addMenu(Menu a) {
        Role a2;
        a2.menus.add(a);
        a.getRoles().add(a2);
    }

    public void addPermission(Permission a) {
        Role a2;
        a2.permissions.add(a);
        a.getRoles().add(a2);
    }

    public boolean equals(Object a) {
        Role a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Role)) {
            return false;
        }
        a = (Role)a;
        return a2.getName().equals(a.getName());
    }

    public Set<Menu> getMenus() {
        Role a;
        return a.menus;
    }
}

