/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.broadcast.model.Broadcast;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_dk;
import com.inscada.mono.shared.exceptions.c_lf;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.shared.exceptions.c_sk;
import com.inscada.mono.shared.exceptions.c_xi;
import com.inscada.mono.shared.exceptions.c_ya;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.system.restcontrollers.SystemController;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String C = "Not Active Error";
    private static final Logger F = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String I = "Unknown Error";
    private static final String M = "Validation Error";
    private static final String L = "Mismatch Error";
    @Value(value="${spring.profiles.active}")
    private String i;
    private static final String d = "Security Error";
    private static final String c = "Not Found Error";
    private static final String D = "Inscada Error";
    private static final String H = "File Storage Error";
    private static final String m = "Relation Exists Error";
    private static final String E = "Constraint Violation";
    private static final String K = "Already Exists Error";
    private static final String l = "Database Error";

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, l);
        F.error(SystemController.m_rl((Object)"q\u0015A\u0015\u0015\u001d[\u0000P\u0013G\u001dA\r\u0015\u0002\\\u001bY\u0015A\u001dZ\u001a\u000fTN\t"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(status, ex.getMessage(), ex, I);
        F.error(Broadcast.m_rl((Object)"@j}a{jhh)a{vfv3$ry"), (Object)ex);
        return new ResponseEntity((Object)ex, status);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return SystemController.m_rl((Object)"E\u0015A\u001c\u001a\u0001[\u001f[\u001bB\u001a");
        }
    }

    private /* synthetic */ String sanitizeMessage(String a, Exception a2) {
        GeneralExceptionHandler a3;
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof c_xi) {
            return Broadcast.m_rl((Object)"Vlwfq{gl$hh{ah`p$l|`w}w");
        }
        if (a2 instanceof c_dk) {
            return SystemController.m_rl((Object)"2\\\u0018PTZ\u0004P\u0006T\u0000\\\u001b[TS\u0015\\\u0018P\u0010");
        }
        if (a2 instanceof c_lf) {
            return Broadcast.m_rl((Object)"Vlwfq{gl$dmzihpjl");
        }
        if (a2 instanceof c_sk) {
            return SystemController.m_rl((Object)"g\u0011F\u001b@\u0006V\u0011\u0015\u001dFT[\u001bATT\u0017A\u001dC\u0011");
        }
        if (a2 instanceof c_ac) {
            return Broadcast.m_rl((Object)"[azk|vja)jfp)bfqg`");
        }
        if (a2 instanceof c_mc) {
            return SystemController.m_rl((Object)"&P\u0018T\u0000P\u0010\u0015\u0006P\u0007Z\u0001G\u0017PTP\f\\\u0007A\u0007");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return Broadcast.m_rl((Object)"@hphfhwl$jkgw}vhmgp)r`kee}mfj");
        }
        if (a2 instanceof TransactionSystemException) {
            return SystemController.m_rl((Object)"q\u0015A\u0015W\u0015F\u0011\u0015\u0000G\u0015[\u0007T\u0017A\u001dZ\u001a\u0015\u0011G\u0006Z\u0006");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return Broadcast.m_rl((Object)"]mda)wlv`az$me}ekeza)a{vfv");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return SystemController.m_rl((Object)"5V\u0017P\u0007FTQ\u0011[\u001dP\u0010");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return Broadcast.m_rl((Object)"Mgrhh``)mgt|p");
        }
        if (a2 instanceof ConstraintViolationException) {
            return SystemController.m_rl((Object)"\"T\u0018\\\u0010T\u0000\\\u001b[TV\u001b[\u0007A\u0006T\u001d[\u0000\u0015\u0002\\\u001bY\u0015A\u001dZ\u001a");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return Broadcast.m_rl((Object)"@j\u007feemm${axqlw}$ok{ihp");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return SystemController.m_rl((Object)"x\u001dF\u0007\\\u001aRTG\u0011D\u0001\\\u0006P\u0010\u0015\u0004T\u0006T\u0019P\u0000P\u0006");
        }
        if (a2 instanceof IllegalStateException) {
            return Broadcast.m_rl((Object)"Mgrhh``)eytemje}mfj)w}e}a");
        }
        return SystemController.m_rl((Object)"t\u001a\u0015\u0001[\u0011M\u0004P\u0017A\u0011QTP\u0006G\u001bGTZ\u0017V\u0001G\u0006P\u0010");
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4) {
        GeneralExceptionHandler a5;
        return a5.createExceptionDetails(a, a2, a3, a4, null);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    protected ResponseEntity<Object> handleSecurityExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.FORBIDDEN, a.getMessage(), a, d);
        F.error(SystemController.m_rl((Object)"f\u0011V\u0001G\u001dA\r\u0015\u0011G\u0006Z\u0006\u000fTN\t"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleAllExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), a, I);
        F.error(Broadcast.m_rl((Object)"\\jl|yajpl`)a{vfv3$ry"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, M);
        F.error(SystemController.m_rl((Object)"x\u0011F\u0007T\u0013PT[\u001bATG\u0011T\u0010T\u0016Y\u0011\u000fTN\t"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_dk.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleFileStorage(c_dk a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, H);
        F.error(Broadcast.m_rl((Object)"Omea)w}k{ena)a{vfv3$ry"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, D);
        F.error(SystemController.m_rl((Object)"=Y\u0018P\u0013T\u0018\u0015\u0007A\u0015A\u0011\u000fTN\t"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={c_ya.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInscadaException(c_ya a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, D);
        F.error(Broadcast.m_rl((Object)"Mgwjeme)a{vfv3$ry"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public GeneralExceptionHandler() {
        GeneralExceptionHandler a;
    }

    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a2) {
        headers = new HashMap();
        status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return Broadcast.m_rl((Object)"Gk)ilwzena)e\u007fe`hhfea");
        }, Collectors.toList())));
        a2 = ex.getBindingResult().getGlobalErrors().stream().map(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return Broadcast.m_rl((Object)"Gk)ilwzena)e\u007fe`hhfea");
        }).collect(Collectors.toList());
        headers.putAll(status);
        if (!a2.isEmpty()) {
            headers.put(SystemController.m_rl((Object)"R\u0018Z\u0016T\u0018"), a2);
        }
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, this.formatErrorMessages((Map)headers), (Exception)ex, M, (Map)headers);
        F.error(Broadcast.m_rl((Object)"_eemme}mfj)a{vfv3$ry"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={TransactionSystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException a) {
        GeneralExceptionHandler a2;
        Throwable throwable = a.getRootCause();
        if (throwable instanceof ConstraintViolationException) {
            return a2.handleConstraintViolation((ConstraintViolationException)throwable);
        }
        throwable = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, l);
        F.error(SystemController.m_rl((Object)"a\u0006T\u001aF\u0015V\u0000\\\u001b[TF\rF\u0000P\u0019\u0015\u0011G\u0006Z\u0006\u000fTN\t"), (Object)throwable, (Object)a);
        return new ResponseEntity((Object)throwable, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4, Map<String, List<String>> a5) {
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = a6;
        a2 = generalExceptionHandler.sanitizeMessage(a2, a3);
        String string = generalExceptionHandler.isDevelopment() ? a3.getClass().getName() : Broadcast.m_rl((Object)"Aqglt}mfj");
        String string2 = a6.isDevelopment() ? a4 : SystemController.m_rl((Object)"1G\u0006Z\u0006");
        String string3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a3) : null;
        return new ExceptionDetails(a.value(), a2, string, string2, a5, a4 = string3, new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException a) {
        GeneralExceptionHandler a2;
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getName();
        objectArray[1] = a.getValue();
        objectArray[2] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : SystemController.m_rl((Object)"\u0001[\u001f[\u001bB\u001a");
        String string = String.format(Broadcast.m_rl((Object)"Ye{eda}a{$.!z#)s`pa$\u007feeql$.!z#)gfqe`)jfp)fl$jkgrlv}am$}k)pptl$.!z#"), objectArray);
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, string, (Exception)a, M);
        F.error(Broadcast.m_rl((Object)"Pptl$dmzihpjl3$ry"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, M);
        F.error(SystemController.m_rl((Object)"|\u0018Y\u0011R\u0015YTT\u0006R\u0001X\u0011[\u0000\u000fTN\t"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_xi.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleAlreadyExists(c_xi a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, K);
        F.error(Broadcast.m_rl((Object)"Hh{ah`p$l|`w}w)a{vfv3$ry"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={c_sk.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleNotActive(c_sk a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, C);
        F.error(SystemController.m_rl((Object)"{\u001bATT\u0017A\u001dC\u0011\u0015\u0011G\u0006Z\u0006\u000fTN\t"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> a2) {
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)Broadcast.m_rl((Object)"%$"), (Iterable)a.getValue())).collect(Collectors.joining(Broadcast.m_rl((Object)"$u$")));
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = ex.getParameterName();
        objectArray[1] = ex.getParameterType();
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, String.format(SystemController.m_rl((Object)"&P\u0005@\u001dG\u0011QTE\u0015G\u0015X\u0011A\u0011GT\u0012QFS\u0015\u001bSTA\rE\u0011\u0015S\u0010\u0007\u0012T\\\u0007\u0015\u0019\\\u0007F\u001d[\u0013"), objectArray), (Exception)ex, M);
        F.error(Broadcast.m_rl((Object)"I`wzmgc)thvhilplv3$ry"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_ac.class, EntityNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    protected ResponseEntity<Object> handleEntityNotFound(Exception a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.NOT_FOUND, a.getMessage(), a, c);
        F.error(SystemController.m_rl((Object)"p\u001aA\u001dA\r\u0015\u001aZ\u0000\u0015\u0012Z\u0001[\u0010\u000fTN\t"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.NOT_FOUND);
    }

    private /* synthetic */ boolean isDevelopment() {
        GeneralExceptionHandler a;
        String[] stringArray = new String[2];
        stringArray[0] = SystemController.m_rl((Object)"\u0010P\u0002");
        stringArray[1] = Broadcast.m_rl((Object)"}azp");
        return Arrays.asList(stringArray).contains(a.i);
    }

    @ExceptionHandler(value={c_lf.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMismatch(c_lf a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, L);
        F.error(SystemController.m_rl((Object)"x\u001dF\u0019T\u0000V\u001c\u0015\u0011G\u0006Z\u0006\u000fTN\t"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException a2) {
        GeneralExceptionHandler a3;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails(HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, E, map);
        F.error(Broadcast.m_rl((Object)"Jkgw}vhmgp)r`kee}mfj3$ry"), (Object)a2);
        return new ResponseEntity((Object)a2, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, l);
        F.error(SystemController.m_rl((Object)"=[\u0012Y\u0001M0wTX\u0015E\u0004P\u0006\u0015\u0011G\u0006Z\u0006\u000fTN\t"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={c_mc.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleRelationExists(c_mc a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, m);
        F.error(Broadcast.m_rl((Object)"Vlhhp`kg$l|`w}w)a{vfv3$ry"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }
}

