/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.alarm.model.FiredAlarmFilter;
import com.inscada.mono.auth.c_zia;
import com.inscada.mono.broadcast.model.BroadcastOperationResponse;
import com.inscada.mono.cluster.j.c_ska;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.job.c.c_ni;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.log.services.c_bd;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.script.enums.c_ll;
import com.inscada.mono.script.enums.c_mj;
import com.inscada.mono.script.events.CancelEvent;
import com.inscada.mono.script.events.RescheduleEvent;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_gm;
import com.inscada.mono.script.services.c_jm;
import com.inscada.mono.script.services.c_ti;
import com.inscada.mono.shared.exceptions.c_sk;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener {
    private static final String f = "scheduled_scripts";
    private final c_ni J;
    private final ClusterOperations b;
    public static final short C = 304;
    public static final short F = 303;
    private final Map<Integer, Job> I;
    private final c_jm M;
    private static final Logger L = LoggerFactory.getLogger(ScriptManager.class);
    public static final short i = 301;
    private final JedisPooled d;
    public static final short c = 306;
    public static final short D = 305;
    private final c_bd H;
    private final Lock m;
    public static final short E = 302;
    public static final short K = 307;
    private final c_ti l;

    public ScriptManager(c_ti a, c_ni a2, c_jm a3, c_bd a4, JedisPooled a5, ClusterOperations a6) {
        ScriptManager a7;
        ScriptManager scriptManager = a7;
        ScriptManager scriptManager2 = a7;
        ScriptManager scriptManager3 = a7;
        ScriptManager scriptManager4 = a7;
        a7.m = new ReentrantLock();
        scriptManager4.I = new ConcurrentHashMap();
        scriptManager3.l = a;
        scriptManager3.J = a2;
        scriptManager2.M = a3;
        scriptManager2.H = a4;
        scriptManager.d = a5;
        scriptManager.b = a6;
    }

    protected void cancelScriptsByProjectIdInternal(Integer a) {
        ScriptManager a2;
        if ((a = a2.l.m_nf((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            RepeatableScript repeatableScript = a.getScript();
            L.info(FiredAlarmFilter.m_rl((Object)"\n\u001c\u0007\u001d\u0003\u000b|y\u000e8(=*0(>f\u001a'7%<*\u001c0<(-f?)+f*%+/)2cf\";yn\u0010\u0002cf\";p"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            a2.cancelScriptInternal(repeatableScript);
            return;
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"fTf6d^i_mI\u0012;a|FtZrF|\bXIuK~D^^~Fo\b}Gi\bhKiAk\\!\b`U"), (Object)a.getScript().getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\u0015\u0003\u0018\u0002\u001c\u0014cf\n%1#=35/7!y5:406-f\";y*6%8*5?w"), (Object)a);
            a2.scheduleScriptInternal(a);
            return;
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"UgU\u0005WmZl^z!\bIMj]~[oAuO;D~I\u007fMi\boG;[x@~LnD~\bhKiAk\\;Sf\u0006"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.b.callLeaderMethod(Short.valueOf((short)301), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC schedule script " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.J.m_bca(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            Script script = Script.newBuilder((RepeatableScript)a).build();
            a2.M.m_yg(script);
            a2.cancelScript(a.getId());
        }, Duration.ofMillis(a.getDelay().intValue()), false);
    }

    protected void scheduleScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.scheduleScriptInternal(scriptManager.l.m_wl(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        String string = scriptManager.b.getCurrentNode().getNodeId();
        L.info(FiredAlarmFilter.m_rl((Object)"\n%+/)2\u0014'7'>#+|y\u00121/*f7)=#yn\";pf1'*f;#:)4#y21#y\n\u001c\u0007\u001d\u0003\u000bhy\u0014<5-)+/7!y5:.<\",*<\"y5:406-5whw"), (Object)string);
        scriptManager.m.lock();
        try {
            Set set = a2.d.smembers(f).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                L.info(BroadcastOperationResponse.m_rl((Object)"HKiAk\\VIuI|Mi\b3d~I\u007fMi\b`U2\u0012;ft\bhKsM\u007f]wM\u007f\bhKiAk\\h\b}GnF\u007f\brF;z~Lr[;\\t\biMh\\tZ~\u0006"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            L.info(FiredAlarmFilter.m_rl((Object)"\u0015:406-\u000b8(8!<4yn\u0015#8\"<4y=$ocf\u001f),(=f\";y5:.<\",*<\"y5:406-f\u0010\u0002*f0(y\u0014<\"05y26f+#*264<|y=$"), objectArray);
            ArrayList arrayList = new ArrayList(a2.l.m_vk(set));
            L.info(BroadcastOperationResponse.m_rl((Object)"HKiAk\\VIuI|Mi\b3d~I\u007fMi\b`U2\u0012;io\\~Ek\\rF|\boG;Z~[oGiM;Sf\bhKiAk\\h\u0006"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ScriptManager a2;
                String string = a2.b.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    L.info(FiredAlarmFilter.m_rl((Object)"\u0015:406-\u000b8(8!<4yn\u0015#8\"<4y=$ocf\u000b#*2640(>f*%+/)2cf\";yn\u0010\u0002cf\";p"), objectArray);
                    a2.scheduleScriptInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.H.m_efa(a.getProject()).m_q("Script Restore (Leader " + string + ")", String.format(BroadcastOperationResponse.m_rl((Object)">[;\u0000Rl!\b>L2\b}IrD~L;\\t\biMh\\tZ~\u0006;kz]hM!\b>["), objectArray));
                    try {
                        L.warn(FiredAlarmFilter.m_rl((Object)"\u0015:406-\u000b8(8!<4yn\u0015#8\"<4y=$ocf\u00182-#46-/7!y26f:'7%<*y5:406-f\";y'?2<4y4<5-)+'-/6(y 8/53+#w"), (Object)string, (Object)a.getId());
                        a2.cancelScriptInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        L.error(BroadcastOperationResponse.m_rl((Object)"{xZrXoezFzO~Z;\u0000WMzL~Z;Sf\u0001!\b]IrD~L;\\t\bxIuK~D;[xZrXo\b`U;I}\\~Z;Z~[oGiIoAtF;NzAw]iM!\b`U"), objectArray2);
                        return;
                    }
                }
            });
            L.info(FiredAlarmFilter.m_rl((Object)"\n%+/)2\u0014'7'>#+fq\n<'=#+f\";p|y\u00000(051#=f*%+/)2y4<5-)+'-/6(y6+):#*5w"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            L.error(BroadcastOperationResponse.m_rl((Object)"HKiAk\\VIuI|Mi\b3d~I\u007fMi\b`U2\u0012;miZtZ;LnZrF|\bhKiAk\\;Z~[oGiIoAtF;XiGxMh[!\b`U"), objectArray);
            return;
        }
        finally {
            a2.m.unlock();
        }
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            RepeatableScript repeatableScript = a.getScript();
            L.info(FiredAlarmFilter.m_rl((Object)"\n\u001c\u0007\u001d\u0003\u000b|y\u000e8(=*0(>f\u000b#*%1#=35#\u001c0<(-f?)+f*%+/)2cf\";yn\u0010\u0002cf\";p"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            if (a2.getScriptStatusInternal(repeatableScript.getId()) == c_mj.m) {
                a2.scheduleScriptInternal(repeatableScript.getId());
                return;
            }
        } else {
            L.debug(BroadcastOperationResponse.m_rl((Object)"fTf6d^i_mI\u0012;a|FtZrF|\bIMhKsM\u007f]wM^^~Fo\b}Gi\bhKiAk\\!\b`U"), (Object)a.getScript().getId());
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.b.addListener((ClusterNodeListener)a);
        L.info(FiredAlarmFilter.m_rl((Object)"\u0015:406-\u000b8(8!<4y/7/-/8*0<<\"y'7\"y4<!05-#+#=f85y\u000553*2<4\u0017)=#\u0015/*2<(<4w"));
    }

    public void notLeader() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        String string = scriptManager.b.getCurrentNode().getNodeId();
        L.info(BroadcastOperationResponse.m_rl((Object)"HKiAk\\VIuI|Mi\u0012;|sAh\buG\u007fM;\u0000`U2\br[;fT\bWgUo^z;|Sm;d^i_mI\u0006;kzFxMwDrF|\bzDw\bwGxIw\bhKiAk\\;BtJh\u00065\u0006"), (Object)string);
        scriptManager.m.lock();
        try {
            new ArrayList(a.I.keySet()).forEach(a2 -> {
                ScriptManager a3;
                Job job = (Job)a3.I.get(a2);
                if (job != null) {
                    try {
                        L.info(FiredAlarmFilter.m_rl((Object)"\n%+/)2\u0014'7'>#+fq\b62y\n<'=#+f\";p|y\u00058(:#5*0(>f5):'5f3);f?)+f*%+/)2y\u000f\u001d|y=$"), (Object)string, a2);
                        a3.J.m_jia(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        L.error(BroadcastOperationResponse.m_rl((Object)"HKiAk\\VIuI|Mi\b3ft\\;d~I\u007fMi\b`U2\u0012;miZtZ;KzFxMwDrF|\bwGxIw\bqGy\b}Gi\bhKiAk\\;a_\b`U!\b`U"), objectArray);
                    }
                }
            });
            a.I.clear();
            L.info(FiredAlarmFilter.m_rl((Object)"\n%+/)2\u0014'7'>#+fq\b62y\n<'=#+f\";p|y\u00075*y*6%8*y5:406-f3);5y.80<f;#<(y4<7,#*2<\"y26f:'7%<*y'7\"y%5#84<\"y +)4f5):'5f-48%2/7!w"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            L.error(BroadcastOperationResponse.m_rl((Object)"{xZrXoezFzO~Z;\u0000UGo\bWMzL~Z;Sf\u0001!\b^ZiGi\b\u007f]iAuO;XiGxMh[;G}\bxIuK~DwAuO;DtKzD;[xZrXo\bqGy[!\b`U"), objectArray);
            return;
        }
        finally {
            a.m.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_mj getScriptStatus(Integer a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\u0015\u0003\u0018\u0002\u001c\u0014cf\u001e#-20(>f*%+/)2y5-'-3*f?)+f\";y*6%8*5?w"), (Object)a);
            return a2.getScriptStatusInternal(a);
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"fTf6d^i_mI\u0012;z~YnMh\\rF|\bwMzL~Z;NtZ;[xZrXo\bh\\z\\n[;NtZ;Sf\u0006"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_mj)a2.b.callLeaderMethod(Short.valueOf((short)303), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get script status for " + a, (Throwable)exception);
        }
    }

    protected void scheduleScriptsByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.l.m_nf((Integer)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> a.getType() != c_ll.H).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    protected Map<Integer, c_mj> getScriptStatusesByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.l.m_jg((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, a -> {
            ScriptManager a2;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_mj getScriptStatus(Integer a, String a2) {
        ScriptManager a3;
        if ((a = a3.l.m_jk(a, a2)) == null) {
            return c_mj.l;
        }
        return a3.getScriptStatus(a.getId());
    }

    protected void cancelScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.cancelScriptInternal(scriptManager.l.m_wl(a));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.scheduleScript(scriptManager.l.m_xk(a, a2).getId());
    }

    protected Map<Integer, c_mj> getScriptStatusesByIdsInternal(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    protected void scheduleScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_zia.m_iec(() -> {
            ScriptManager a2;
            a2.m.lock();
            try {
                Job job;
                ScriptManager scriptManager;
                block14: {
                    a2.cancelScriptInternal(a);
                    if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                        throw new c_sk("Project should be active to schedule script " + a.getName());
                    }
                    switch (c_gm.l[a.getType().ordinal()]) {
                        case 1: {
                            ScriptManager scriptManager2 = a2;
                            while (false) {
                            }
                            scriptManager = scriptManager2;
                            job = scriptManager2.createDailyScriptJob(a);
                            break block14;
                        }
                        case 2: {
                            ScriptManager scriptManager3 = a2;
                            scriptManager = scriptManager3;
                            job = scriptManager3.createPeriodicScriptJob(a);
                            break block14;
                        }
                        case 3: {
                            job = a2.createOnceScriptJob(a);
                            break;
                        }
                        case 4: {
                            return;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                        }
                    }
                    scriptManager = a2;
                }
                scriptManager.I.put(a.getId(), job);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.d.sadd(f, stringArray);
                return;
            }
            finally {
                a2.m.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.cancelScript(scriptManager.l.m_xk(a, a2).getId());
    }

    @Order(value=1)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            Integer n = a.getProject().getId();
            L.info(FiredAlarmFilter.m_rl((Object)"\n\u001c\u0007\u001d\u0003\u000b|y\u000e8(=*0(>f\t46,<%-\u0002<':20082<\u0003/#72y 64y6+)3#:2y\u000f\u001d|y=$"), (Object)n);
            a2.cancelScriptsByProjectIdInternal(n);
            return;
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"UgU\u0005WmZl^z!\bROuGiAuO;xiGqMx\\_MzKoAmIoM^^~Fo\b}Gi\bkZtB~Ko\bRl!\b`U"), (Object)a.getProject().getId());
    }

    protected c_mj getScriptStatusInternal(Integer a) {
        ScriptManager a2;
        if (a2.I.containsKey(a)) {
            return c_mj.m;
        }
        return c_mj.l;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ScriptManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.b.addRemoteCall((short)301, (Object)a, ScriptManager.class.getDeclaredMethod(FiredAlarmFilter.m_rl((Object)"5:.<\",*<\u0015:406-\u000f72<47'5"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.b.addRemoteCall((short)302, (Object)a, ScriptManager.class.getDeclaredMethod(BroadcastOperationResponse.m_rl((Object)"xIuK~DHKiAk\\RFoMiFzD"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.b.addRemoteCall((short)303, (Object)a, ScriptManager.class.getDeclaredMethod(FiredAlarmFilter.m_rl((Object)">#-\u0015:406-\u0015-'-3*\u000f72<47'5"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.b.addRemoteCall((short)304, (Object)a, ScriptManager.class.getDeclaredMethod(BroadcastOperationResponse.m_rl((Object)"hKsM\u007f]wMHKiAk\\hjbxiGqMx\\RLRFoMiFzD"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.b.addRemoteCall((short)305, (Object)a, ScriptManager.class.getDeclaredMethod(FiredAlarmFilter.m_rl((Object)"%8(:#5\u0015:406-5\u001b?\t46,<%-\u000f=\u000f72<47'5"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.b.addRemoteCall((short)306, (Object)a, ScriptManager.class.getDeclaredMethod(BroadcastOperationResponse.m_rl((Object)"|Mo{xZrXo{oIo]hMhjba\u007f[RFoMiFzD"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.b.addRemoteCall((short)307, (Object)a, ScriptManager.class.getDeclaredMethod(FiredAlarmFilter.m_rl((Object)"!<2\n%+/)2\n282,5<5\u001b?\t46,<%-\u000f=\u000f72<47'5"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(BroadcastOperationResponse.m_rl((Object)"]IrD~L;\\t\biM|Ah\\~Z;{xZrXoezFzO~Z;zKk;E~\\sG\u007f["), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\u0015\u0003\u0018\u0002\u001c\u0014cf\u001a'7%<*5/7!y5:406-f\";y*6%8*5?w"), (Object)a);
            a2.cancelScriptInternal(a);
            return;
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"UgU\u0005WmZl^z!\bIMj]~[oAuO;D~I\u007fMi\boG;KzFxMw\bhKiAk\\;Sf\u0006"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.b.callLeaderMethod(Short.valueOf((short)302), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC cancel script " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createDailyScriptJob(RepeatableScript a) {
        ScriptManager a2;
        Comparable<Date> comparable = a.getTime();
        comparable = LocalTime.of(comparable.getHours(), comparable.getMinutes(), comparable.getSeconds());
        return a2.J.m_sia(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.M.m_yg((Script)a);
        }, (LocalTime)comparable);
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.J.m_ija(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.M.m_yg((Script)a);
        }, Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(Integer a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\n\u001c\u0007\u001d\u0003\u000b|y\u00058(:#5*0(>f8*5f*%+/)2*f?)+f)46,<%-f\";y*6%8*5?w"), (Object)a);
            a2.cancelScriptsByProjectIdInternal(a);
            return;
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"fTf6d^i_mI\u0012;z~YnMh\\rF|\bwMzL~Z;\\t\bxIuK~D;IwD;[xZrXo[;NtZ;XiGqMx\\;Sf\u0006"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.b.callLeaderMethod(Short.valueOf((short)305), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC cancel scripts for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(Integer a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\n\u001c\u0007\u001d\u0003\u000b|y\u0015:.<\",*0(>f8*5f*%+/)2*f?)+f)46,<%-f\";y*6%8*5?w"), (Object)a);
            a2.scheduleScriptsByProjectIdInternal(a);
            return;
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"fTf6d^i_mI\u0012;z~YnMh\\rF|\bwMzL~Z;\\t\bhKsM\u007f]wM;IwD;[xZrXo[;NtZ;XiGqMx\\;Sf\u0006"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.b.callLeaderMethod(Short.valueOf((short)304), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC schedule scripts for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_mj> getScriptStatuses(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\n\u001c\u0007\u001d\u0003\u000b|y\u0001<2-/7!y5:406-f*282,5<5y 64y=$f\u0010\u0002*f5):'5* |y=$"), (Object)a.size(), a);
            return a2.getScriptStatusesByIdsInternal(a);
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"UgU\u0005WmZl^z!\bIMj]~[oAuO;D~I\u007fMi\b}Gi\bhKiAk\\;[oIo]hMh\b}Gi\b`U;a_[!\b`U"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.b.callLeaderMethod(Short.valueOf((short)306), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(FiredAlarmFilter.m_rl((Object)"u"))), (Throwable)exception);
        }
    }

    private /* synthetic */ String generateJobName(RepeatableScript a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = a.getType().m_f();
        objectArray[1] = a.getName();
        return String.format(BroadcastOperationResponse.m_rl((Object)">[;{xZrXo\b6\b>["), objectArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_mj> getScriptStatuses(Integer a) {
        ScriptManager a2;
        if (a2.b.isLeader()) {
            L.debug(FiredAlarmFilter.m_rl((Object)"\u0015\u0003\u0018\u0002\u001c\u0014cf\u001e#-20(>f8*5f*%+/)2y5-'-3*#*f?)+f)46,<%-f\";y*6%8*5?w"), (Object)a);
            return a2.getScriptStatusesByProjectIdInternal(a);
        }
        L.debug(BroadcastOperationResponse.m_rl((Object)"fTf6d^i_mI\u0012;z~YnMh\\rF|\bwMzL~Z;NtZ;IwD;[xZrXo\bh\\z\\n[~[;NtZ;XiGqMx\\;Sf\u0006"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.b.callLeaderMethod(Short.valueOf((short)307), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    protected void cancelScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_zia.m_iec(() -> {
            ScriptManager a2;
            a2.m.lock();
            try {
                Job job = (Job)a2.I.get(a.getId());
                if (job != null) {
                    a2.J.m_jia(job);
                }
                ScriptManager scriptManager = a2;
                scriptManager.I.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                scriptManager.d.srem(f, stringArray);
                return;
            }
            finally {
                a2.m.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }
}

