/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.restcontrollers;

import com.inscada.mono.animation.model.ScriptDto;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.script.enums.c_mj;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.services.ScriptManager;
import com.inscada.mono.script.services.c_jm;
import com.inscada.mono.script.services.c_ti;
import com.inscada.mono.settings.restcontrollers.OtpSettingsController;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/scripts"})
public class ScriptController
extends ProjectBasedImportExportController {
    private final c_ti E;
    private final ScriptManager K;
    private final c_jm l;

    @PostMapping
    public ResponseEntity<RepeatableScript> createScript(@Valid @RequestBody RepeatableScript script, UriComponentsBuilder a) {
        script = this.E.m_ee(script);
        Object[] objectArray = new Object[1];
        objectArray[0] = script.getId();
        return ResponseEntity.created((URI)a.path(OtpSettingsController.m_rl((Object)"B6\u001e.\u001f$\u001d9$)\u0010")).buildAndExpand(objectArray).toUri()).body((Object)script);
    }

    @PatchMapping(value={"/{scriptId}/code"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScriptCode(@PathVariable(value="scriptId") Integer scriptId, @RequestBody String a) {
        this.E.m_qh(scriptId, a);
    }

    @DeleteMapping(value={""}, params={"scriptIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScriptsByIds(@RequestParam(value="scriptIds") Integer[] a) {
        this.E.m_cn(List.of(a));
    }

    @PostMapping(value={"/{scriptId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="scriptId") Integer a) {
        this.K.scheduleScript(a);
    }

    @PostMapping(value={"/{scriptId}/run"})
    public Object runScript(@PathVariable(value="scriptId") Integer a) {
        return this.l.m_oj(a);
    }

    @DeleteMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScript(@PathVariable(value="scriptId") Integer a) {
        this.E.m_ma(a);
    }

    @GetMapping(value={"/summary"})
    public Collection<RepeatableScriptSummary> getScriptsSummary(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.E.m_qd();
        }
        return this.E.m_kd(a);
    }

    @GetMapping(value={"/{scriptId}"})
    public RepeatableScript getScript(@PathVariable(value="scriptId") Integer a) {
        return this.E.m_la(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.K.scheduleScripts(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_mj> getScriptStatuses(@RequestParam(value="scriptIds") Integer[] a) {
        return this.K.getScriptStatuses(List.of(a));
    }

    @GetMapping
    public Collection<RepeatableScript> getScripts(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.E.m_ta();
        }
        return this.E.m_ra(a);
    }

    @PostMapping(value={"/runner"})
    public Object runScript(@RequestBody ScriptDto a) {
        return this.l.m_jd(a);
    }

    @PutMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScript(@PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody RepeatableScript a) {
        this.E.m_ej(scriptId, a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.K.cancelScripts(a);
    }

    @PostMapping(value={"/{scriptId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="scriptId") Integer a) {
        this.K.cancelScript(a);
    }

    @GetMapping(value={"/{scriptId}/status"})
    public c_mj getScriptStatus(@PathVariable(value="scriptId") Integer a) {
        return this.K.getScriptStatus(a);
    }

    public ScriptController(c_ti a, ScriptManager a2, c_jm a3, c_am a4, c_tm a5) {
        ScriptController a6;
        ScriptController scriptController = a6;
        super(a4, EnumSet.of(c_nn.D), a5);
        a6.E = a;
        scriptController.K = a2;
        scriptController.l = a3;
    }
}

