/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.auth.c_zia;
import com.inscada.mono.cluster.j.c_ska;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.job.c.c_ni;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.log.services.c_bd;
import com.inscada.mono.mail.j.c_sm;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.report.enums.c_ah;
import com.inscada.mono.report.enums.c_vi;
import com.inscada.mono.report.events.CancelEvent;
import com.inscada.mono.report.events.RescheduleEvent;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.services.c_jo;
import com.inscada.mono.report.services.c_vj;
import com.inscada.mono.search.repositories.SearchRepository;
import com.inscada.mono.shared.exceptions.c_sk;
import com.inscada.mono.shared.exceptions.c_ya;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
implements ClusterNodeListener {
    private final c_ni f;
    public static final short J = 504;
    private final c_jo b;
    private final Lock C;
    private static final Logger F = LoggerFactory.getLogger(ReportManager.class);
    public static final short I = 503;
    private final ClusterOperations M;
    public static final short L = 501;
    public static final short i = 507;
    private final Map<Integer, List<Job>> d;
    private final c_bd c;
    private final JedisPooled D;
    public static final short H = 502;
    private final c_vj m;
    public static final short E = 505;
    public static final short K = 506;
    private static final String l = "scheduledReports";

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report a) {
        ReportManager a2;
        return a2.f.m_vda(a.getProject(), "Report Print - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            comparable.set(5, a.getReportDay().shortValue());
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(2, -1);
            Date date = calendar.getTime();
            a2.b.m_gy(a.getId(), date, (Date)comparable, true, a.getLang());
        }, (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<Integer, c_ah> getReportStatuses(Integer a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            F.debug(SearchRepository.m_rl((Object)"0{=z9lF\u001e;[\bJ\u0015P\u001b\u001e\u001dR\u0010\u001e\u000e[\fQ\u000eJ\\M\b_\bK\u000f[\u000f\u001e\u001aQ\u000e\u001e\fL\u0013T\u0019]\b\u001e\u0007C\\R\u0013]\u001dR\u0010GR"), (Object)a);
            return a2.getReportStatusesByProjectIdInternal(a);
        }
        F.debug(c_sm.m_rl((Object)"@\u0017@uB\u001dO\u001cK\n4x\\=\u007f-k+z1`?.4k9j=|xh7|xo4bx|=~7|,.+z9z-}=}xh7|x~*a2k;zxu% "), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.M.callLeaderMethod(Short.valueOf((short)507), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            Report report = a.getReport();
            F.info(SearchRepository.m_rl((Object)"r9\u007f8{.\u0004\\v\u001dP\u0018R\u0015P\u001b\u001e?_\u0012]\u0019R9H\u0019P\b\u001e\u001aQ\u000e\u001e\u000e[\fQ\u000eJF\u001e\u0007C\\\u00165zF\u001e\u0007CU"), (Object)report.getName(), (Object)report.getId());
            a2.cancelReportInternal(report);
            return;
        }
        F.debug(c_sm.m_rl((Object)"@\u0017@uB\u001dO\u001cK\n4xG?`7|1`?.\u001bo6m=b\u001dx=`,.>a*.*k(a*zb.#s"), (Object)a.getReport().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_ah getReportStatus(Integer a, String a2) {
        ReportManager a3;
        if ((a = a3.m.m_jk(a, a2)) == null) {
            return c_ah.m;
        }
        return a3.getReportStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(Integer a, String a2) {
        ReportManager a3;
        ReportManager reportManager = a3;
        reportManager.scheduleReport(reportManager.m.m_xk(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<Integer, c_ah> getReportStatuses(List<Integer> a) {
        ReportManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.M.isLeader()) {
            F.debug(SearchRepository.m_rl((Object)"r9\u007f8{.\u0004\\y\u0019J\bW\u0012Y\\L\u0019N\u0013L\b\u001e\u000fJ\u001dJ\tM\u0019M\\X\u0013L\\E\u0001\u001e5z\u000f\u001e\u0010Q\u001f_\u0010R\u0005\u0004\\E\u0001"), (Object)a.size(), a);
            return a2.getReportStatusesByIdsInternal(a);
        }
        F.debug(c_sm.m_rl((Object)"\u0016A\u0016#\u0014K\u0019J\u001d\\b.\nk){=},g6ixb=o<k*.>a*.*k(a*zx},o,{+k+.>a*.#sxG\u001c}b.#s"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.M.callLeaderMethod(Short.valueOf((short)506), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(SearchRepository.m_rl((Object)"P"))), (Throwable)exception);
        }
    }

    protected c_ah getReportStatusInternal(Integer a) {
        ReportManager a2;
        if (a2.d.containsKey(a)) {
            return c_ah.K;
        }
        return c_ah.m;
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_ah getReportStatus(Integer a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            F.debug(c_sm.m_rl((Object)"B\u001dO\u001cK\n4xI=z,g6ix|=~7|,.+z9z-}xh7|xG\u001c4xu%.4a;o4b! "), (Object)a);
            return a2.getReportStatusInternal(a);
        }
        F.debug(SearchRepository.m_rl((Object)"2q2\u00130{=z9lF\u001e.[\rK\u0019M\bW\u0012Y\\R\u0019_\u0018[\u000e\u001e\u001aQ\u000e\u001e\u000e[\fQ\u000eJ\\M\b_\bK\u000f\u001e\u001aQ\u000e\u001e5zF\u001e\u0007CR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_ah)a2.M.callLeaderMethod(Short.valueOf((short)503), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get report transfer status for " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report a) {
        ReportManager a2;
        return a2.f.m_vda(a.getProject(), "Report Mail - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            comparable.set(5, a.getReportDay().shortValue());
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(2, -1);
            Date date = calendar.getTime();
            a2.b.m_yz(a.getId(), date, (Date)comparable, true, a.getLang());
        }, (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    protected Map<Integer, c_ah> getReportStatusesByIdsInternal(List<Integer> a) {
        ReportManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        ReportManager reportManager = a;
        reportManager.registerRemoteCallsWithClusterNode();
        reportManager.M.addListener((ClusterNodeListener)a);
        F.info(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.1`1z1o4g\"k<.9`<.*k?g+z=|=jxo+.\u001bb-},k*@7j=B1},k6k* "));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(Integer a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            F.debug(SearchRepository.m_rl((Object)"0{=z9lF\u001e/]\u0014[\u0018K\u0010W\u0012Y\\L\u0019N\u0013L\b\u001e\u0007C\\R\u0013]\u001dR\u0010GR"), (Object)a);
            a2.scheduleReportInternal(a);
            return;
        }
        F.debug(c_sm.m_rl((Object)"\u0016A\u0016#\u0014K\u0019J\u001d\\b.\nk){=},g6ixb=o<k*.,ax};f=j-b=.*k(a*zxu% "), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)501), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC schedule report " + a, (Throwable)exception);
        }
    }

    public ReportManager(c_vj a, c_ni a2, c_jo a3, c_bd a4, JedisPooled a5, ClusterOperations a6) {
        ReportManager a7;
        ReportManager reportManager = a7;
        ReportManager reportManager2 = a7;
        ReportManager reportManager3 = a7;
        ReportManager reportManager4 = a7;
        a7.C = new ReentrantLock();
        reportManager4.d = new ConcurrentHashMap();
        reportManager3.m = a;
        reportManager3.f = a2;
        reportManager2.b = a3;
        reportManager2.c = a4;
        reportManager.D = a5;
        reportManager.M = a6;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(Integer a, String a2) {
        ReportManager a3;
        ReportManager reportManager = a3;
        reportManager.cancelReport(reportManager.m.m_xk(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(Integer a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            F.debug(SearchRepository.m_rl((Object)"r9\u007f8{.\u0004\\m\u001fV\u0019Z\tR\u0015P\u001b\u001e\u001dR\u0010\u001e\u000e[\fQ\u000eJ\u000f\u001e\u001aQ\u000e\u001e\fL\u0013T\u0019]\b\u001e\u0007C\\R\u0013]\u001dR\u0010GR"), (Object)a);
            a2.scheduleReportsByProjectIdInternal(a);
            return;
        }
        F.debug(c_sm.m_rl((Object)"@\u0017@uB\u001dO\u001cK\n4x\\=\u007f-k+z1`?.4k9j=|xz7.+m0k<{4kxo4bx|=~7|,}xh7|x~*a2k;zxu% "), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)504), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC schedule reports for project " + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_ah> getReportStatusesByProjectIdInternal(Integer a2) {
        ReportManager a3;
        if ((a2 = a3.m.m_nf((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Report::getId, a -> {
            ReportManager a2;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    @Order(value=3)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            Integer n = a.getProject().getId();
            F.info(SearchRepository.m_rl((Object)"r9\u007f8{.\u0004\\v\u001dP\u0018R\u0015P\u001b\u001e,L\u0013T\u0019]\bz\u0019_\u001fJ\u0015H\u001dJ\u0019{\n[\u0012J\\X\u0013L\\N\u000eQ\u0016[\u001fJ\\w8\u0004\\E\u0001"), (Object)n);
            a2.cancelReportsByProjectIdInternal(n);
            return;
        }
        F.debug(c_sm.m_rl((Object)"\u0016A\u0016#\u0014K\u0019J\u001d\\b.\u0011i6a*g6ix^*a2k;z\u001ck9m,g.o,k\u001dx=`,.>a*.(|7d=m,.\u0011Jb.#s"), (Object)a.getProject().getId());
    }

    protected void cancelReportInternal(Report a) {
        ReportManager a2;
        c_zia.m_iec(() -> {
            ReportManager a2;
            a2.C.lock();
            try {
                Object object = (List)a2.d.get(a.getId());
                if (object != null) {
                    Object object2 = object = object.iterator();
                    while (object2.hasNext()) {
                        Job job = (Job)object.next();
                        object2 = object;
                        a2.f.m_jia(job);
                    }
                }
                ReportManager reportManager = a2;
                reportManager.d.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                reportManager.D.srem(l, stringArray);
                return;
            }
            finally {
                a2.C.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report a) {
        ReportManager a2;
        return a2.f.m_sia(a.getProject(), "Report Print - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(5, -1);
            Date date = calendar.getTime();
            a2.b.m_gy(a.getId(), date, (Date)comparable, true, a.getLang());
        }, LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    protected void cancelReportsByProjectIdInternal(Integer a) {
        ReportManager a2;
        if ((a = a2.m.m_nf((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    protected void scheduleReportInternal(Integer a) {
        ReportManager a2;
        ReportManager reportManager = a2;
        reportManager.scheduleReportInternal(reportManager.m.m_wl(a));
    }

    protected void scheduleReportInternal(Report a) {
        ReportManager a2;
        c_zia.m_iec(() -> a2.lambda$scheduleReportInternal$2(a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelReportInternal(Integer a) {
        ReportManager a2;
        ReportManager reportManager = a2;
        reportManager.cancelReportInternal(reportManager.m.m_wl(a));
    }

    public void notLeader() {
        ReportManager a;
        ReportManager reportManager = a;
        String string = reportManager.M.getCurrentNode().getNodeId();
        F.info(SearchRepository.m_rl((Object)"l\u0019N\u0013L\bs\u001dP\u001dY\u0019LF\u001e(V\u0015M\\P\u0013Z\u0019\u001eTE\u0001\u0017\\W\u000f\u001e2q\\r3p;{.\u001e(v9\u001e0{=z9lR\u001e?_\u0012]\u0019R\u0010W\u0012Y\\_\u0010R\\R\u0013]\u001dR\\L\u0019N\u0013L\b\u001e\u0016Q\u001eMR\u0010R"), (Object)string);
        reportManager.C.lock();
        try {
            new ArrayList(a.d.keySet()).forEach(a2 -> {
                ReportManager a3;
                List list = (List)a3.d.get(a2);
                if (list != null) {
                    try {
                        F.info(SearchRepository.m_rl((Object)".[\fQ\u000eJ1_\u0012_\u001b[\u000e\u001eTp\u0013J\\r\u0019_\u0018[\u000e\u001e\u0007CU\u0004\\}\u001dP\u001f[\u0010R\u0015P\u001b\u001e\u0010Q\u001f_\u0010\u001e\u0016Q\u001e\u001e\u001aQ\u000e\u001e\u000e[\fQ\u000eJ\\w8\u0004\\E\u0001"), (Object)string, a2);
                        list.forEach(arg_0 -> ((c_ni)a3.f).m_jia(arg_0));
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        F.error(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.p@7zxB=o<k*.#sq4xK*|7|xm9`;k4b1`?.4a;o4.2a:.>a*.*k(a*zxG\u001c.#sb.#s"), objectArray);
                    }
                }
            });
            a.d.clear();
            F.info(c_sm.m_rl((Object)"\\=~7|,C9`9i=|x&\u0016a,.\u0014k9j=|xu%'b.\u0019b4.4a;o4.*k(a*zxd7l+.0o.kxl=k6.*k){=},k<.,axm9`;k4.9`<.;b=o*k<.>|7cxb7m9bxz*o;e1`? "), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            F.error(SearchRepository.m_rl((Object)".[\fQ\u000eJ1_\u0012_\u001b[\u000e\u001eTp\u0013J\\r\u0019_\u0018[\u000e\u001e\u0007CU\u0004\\{\u000eL\u0013L\\Z\tL\u0015P\u001b\u001e\fL\u0013]\u0019M\u000f\u001e\u0013X\\]\u001dP\u001f[\u0010R\u0015P\u001b\u001e\u0010Q\u001f_\u0010\u001e\u000e[\fQ\u000eJ\\T\u0013\\\u000f\u0004\\E\u0001"), objectArray);
            return;
        }
        finally {
            a.C.unlock();
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ReportManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.M.addRemoteCall((short)501, (Object)a, ReportManager.class.getDeclaredMethod(c_sm.m_rl((Object)"+m0k<{4k\nk(a*z\u0011`,k*`9b"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.M.addRemoteCall((short)502, (Object)a, ReportManager.class.getDeclaredMethod(SearchRepository.m_rl((Object)"]\u001dP\u001f[\u0010l\u0019N\u0013L\bw\u0012J\u0019L\u0012_\u0010"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.M.addRemoteCall((short)503, (Object)a, ReportManager.class.getDeclaredMethod(c_sm.m_rl((Object)"i=z\nk(a*z\u000bz9z-}\u0011`,k*`9b"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.M.addRemoteCall((short)504, (Object)a, ReportManager.class.getDeclaredMethod(SearchRepository.m_rl((Object)"M\u001fV\u0019Z\tR\u0019l\u0019N\u0013L\bM>G,L\u0013T\u0019]\bw\u0018w\u0012J\u0019L\u0012_\u0010"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.M.addRemoteCall((short)505, (Object)a, ReportManager.class.getDeclaredMethod(c_sm.m_rl((Object)";o6m=b\nk(a*z+L!^*a2k;z\u0011j\u0011`,k*`9b"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.M.addRemoteCall((short)506, (Object)a, ReportManager.class.getDeclaredMethod(SearchRepository.m_rl((Object)"Y\u0019J.[\fQ\u000eJ/J\u001dJ\tM\u0019M>G5Z\u000fw\u0012J\u0019L\u0012_\u0010"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.M.addRemoteCall((short)507, (Object)a, ReportManager.class.getDeclaredMethod(c_sm.m_rl((Object)"?k,\\=~7|,],o,{+k+L!^*a2k;z\u0011j\u0011`,k*`9b"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(SearchRepository.m_rl((Object)"x\u001dW\u0010[\u0018\u001e\bQ\\L\u0019Y\u0015M\b[\u000e\u001e.[\fQ\u000eJ1_\u0012_\u001b[\u000e\u001e.n?\u001e\u0011[\bV\u0013Z\u000f"), noSuchMethodException);
        }
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            Report report = a.getReport();
            F.info(c_sm.m_rl((Object)"\u0014K\u0019J\u001d\\b.\u0010o6j4g6ix\\=};f=j-b=K.k6zxh7|x|=~7|,4xu%.pG\u001c4xu%'"), (Object)report.getName(), (Object)report.getId());
            if (a2.getReportStatusInternal(report.getId()) == c_ah.K) {
                a2.scheduleReportInternal(report.getId());
                return;
            }
        } else {
            F.debug(SearchRepository.m_rl((Object)"2q2\u00130{=z9lF\u001e5Y\u0012Q\u000eW\u0012Y\\l\u0019M\u001fV\u0019Z\tR\u0019{\n[\u0012J\\X\u0013L\\L\u0019N\u0013L\b\u0004\\E\u0001"), (Object)a.getReport().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$2(Report a) {
        a.C.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal(a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new c_sk("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_vi.K ? a.scheduleMonthlyPrintReportJob(a) : a.scheduleDailyPrintReportJob(a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.f.m_jia(var5_7);
                            }
                            throw new c_ya(c_sm.m_rl((Object)"H9g4k<.,ax};f=j-b=.*k(a*z"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_vi.K) break block12;
                    v1 = a.scheduleMonthlyMailReportJob(a);
                    ** GOTO lbl28
                }
                v1 = a.scheduleDailyMailReportJob(a);
lbl28:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.d.put(a.getId(), var2_3);
            v3 = new String[1];
            v3[0] = a.getId().toString();
            v2.D.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.C.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(Integer a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            F.debug(SearchRepository.m_rl((Object)"0{=z9lF\u001e?_\u0012]\u0019R\u0010W\u0012Y\\L\u0019N\u0013L\b\u001e\u0007C\\R\u0013]\u001dR\u0010GR"), (Object)a);
            a2.cancelReportInternal(a);
            return;
        }
        F.debug(c_sm.m_rl((Object)"\u0016A\u0016#\u0014K\u0019J\u001d\\b.\nk){=},g6ixb=o<k*.,axm9`;k4.*k(a*zxu% "), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)502), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC cancel report " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(Integer a) {
        ReportManager a2;
        if (a2.M.isLeader()) {
            F.debug(SearchRepository.m_rl((Object)"r9\u007f8{.\u0004\\}\u001dP\u001f[\u0010R\u0015P\u001b\u001e\u001dR\u0010\u001e\u000e[\fQ\u000eJ\u000f\u001e\u001aQ\u000e\u001e\fL\u0013T\u0019]\b\u001e\u0007C\\R\u0013]\u001dR\u0010GR"), (Object)a);
            a2.cancelReportsByProjectIdInternal(a);
            return;
        }
        F.debug(c_sm.m_rl((Object)"@\u0017@uB\u001dO\u001cK\n4x\\=\u007f-k+z1`?.4k9j=|xz7.;o6m=bxo4bx|=~7|,}xh7|x~*a2k;zxu% "), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)505), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC cancel reports for project " + a, (Throwable)exception);
        }
    }

    protected void scheduleReportsByProjectIdInternal(Integer a) {
        ReportManager a2;
        if ((a = a2.m.m_nf((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ReportManager a2;
        ReportManager reportManager = a2;
        String string = reportManager.M.getCurrentNode().getNodeId();
        F.info(SearchRepository.m_rl((Object)".[\fQ\u000eJ1_\u0012_\u001b[\u000e\u0004\\j\u0014W\u000f\u001e\u0012Q\u0018[\\\u0016\u0007CU\u001e\u0014_\u000f\u001e\u001e[\u001fQ\u0011[\\J\u0014[\\r9\u007f8{.\u0010\\l\u0019M\bQ\u000eW\u0012Y\\M\u001fV\u0019Z\tR\u0019Z\\L\u0019N\u0013L\bMR\u0010R"), (Object)string);
        reportManager.C.lock();
        try {
            Set set = a2.D.smembers(l).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                F.info(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.pB=o<k*.#sq4x@7.+m0k<{4k<.*k(a*z+.>a-`<.1`x\\=j1}xz7.*k+z7|= "), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            F.info(SearchRepository.m_rl((Object)"l\u0019N\u0013L\bs\u001dP\u001dY\u0019L\\\u00160[\u001dZ\u0019L\\E\u0001\u0017F\u001e:Q\tP\u0018\u001e\u0007C\\M\u001fV\u0019Z\tR\u0019Z\\L\u0019N\u0013L\b\u001e5z\u000f\u001e\u0015P\\l\u0019Z\u0015M\\J\u0013\u001e\u000e[\u000fJ\u0013L\u0019\u0004\\E\u0001"), objectArray);
            ArrayList arrayList = new ArrayList(a2.m.m_vk(set));
            F.info(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.pB=o<k*.#sq4xO,z=c(z1`?.,ax|=},a*kxu%.*k(a*z+ "), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ReportManager a2;
                String string = a2.M.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    F.info(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.pB=o<k*.#sq4x\\=},a*g6ix|=~7|,4xu%.pG\u001c4xu%'"), objectArray);
                    a2.scheduleReportInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.c.m_efa(a.getProject()).m_q("Report Restore (Leader " + string + ")", String.format(SearchRepository.m_rl((Object)"\u001b\u000f\u001eTw8\u0004\\\u001b\u0018\u0017\\X\u001dW\u0010[\u0018\u001e\bQ\\L\u0019M\bQ\u000e[R\u001e?_\tM\u0019\u0004\\\u001b\u000f"), objectArray));
                    try {
                        F.warn(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.pB=o<k*.#sq4xO,z=c(z1`?.,axm9`;k4.*k(a*zxu%.9h,k*.*k+z7|9z1a6.>o1b-|= "), (Object)string, (Object)a.getId());
                        a2.cancelReportInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        F.error(SearchRepository.m_rl((Object)".[\fQ\u000eJ1_\u0012_\u001b[\u000e\u001eTr\u0019_\u0018[\u000e\u001e\u0007CU\u0004\\x\u001dW\u0010[\u0018\u001e\bQ\\]\u001dP\u001f[\u0010\u001e\u000e[\fQ\u000eJ\\E\u0001\u001e\u001dX\b[\u000e\u001e\u000e[\u000fJ\u0013L\u001dJ\u0015Q\u0012\u001e\u001a_\u0015R\tL\u0019\u0004\\E\u0001"), objectArray2);
                        return;
                    }
                }
            });
            F.info(SearchRepository.m_rl((Object)".[\fQ\u000eJ1_\u0012_\u001b[\u000e\u001eTr\u0019_\u0018[\u000e\u001e\u0007CU\u0004\\x\u0015P\u0015M\u0014[\u0018\u001e\u000e[\fQ\u000eJ\\L\u0019M\bQ\u000e_\bW\u0013P\\N\u000eQ\u001f[\u000fMR"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            F.error(c_sm.m_rl((Object)"\nk(a*z\u0015o6o?k*.pB=o<k*.#sq4xK*|7|xj-|1`?.*k(a*zx|=},a*o,g7`x~*a;k+}b.#s"), objectArray);
            return;
        }
        finally {
            a2.C.unlock();
        }
    }

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report a) {
        ReportManager a2;
        return a2.f.m_sia(a.getProject(), "Report Mail - " + a.getName(), () -> {
            ReportManager a2;
            Comparable<Calendar> comparable;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = comparable = calendar;
            Calendar calendar3 = comparable;
            calendar3.set(11, a.getReportTime().getHours());
            calendar3.set(12, a.getReportTime().getMinutes());
            calendar2.set(13, a.getReportTime().getSeconds());
            calendar.set(14, 0);
            comparable = calendar2.getTime();
            calendar.add(5, -1);
            Date date = calendar.getTime();
            a2.b.m_yz(a.getId(), date, (Date)comparable, true, a.getLang());
        }, LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }
}

