/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.restcontrollers;

import com.inscada.mono.auth.services.j.c.j.c_hha;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.report.enums.c_ah;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.report.services.ReportManager;
import com.inscada.mono.report.services.c_jo;
import com.inscada.mono.report.services.c_vj;
import com.inscada.mono.settings.restcontrollers.OtpSettingsController;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/reports"})
public class ReportController
extends ProjectBasedImportExportController {
    private final c_jo E;
    private final c_vj K;
    private final ReportManager l;

    @GetMapping(value={"/{reportId}/preview"})
    public ResponseEntity<byte[]> previewReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.E.m_gz(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = c_hha.m_rl((Object)"6H#]4T:Y9Hl\u001c1U;Y9]:Yj\u001e%Y'S%HyL3Zu");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(OtpSettingsController.m_rl((Object)".\"\u00039\b#\u0019`)$\u001e=\u0002>\u00049\u0004\"\u0003"), stringArray)).contentType(MediaType.APPLICATION_PDF).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @PostMapping
    public ResponseEntity<Report> createReport(@Valid @RequestBody Report report, UriComponentsBuilder a) {
        report = this.K.m_yr(report);
        Object[] objectArray = new Object[1];
        objectArray[0] = report.getId();
        return ResponseEntity.created((URI)a.path(OtpSettingsController.m_rl((Object)"B6\u001f(\u001d\"\u001f9$)\u0010")).buildAndExpand(objectArray).toUri()).body((Object)report);
    }

    @DeleteMapping(value={"/groups/subgroups/variables"}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.K.m_ct(List.of(a));
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public ResponseEntity<ReportVariable> createReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportVariable reportVariable, UriComponentsBuilder a) {
        reportVariable = this.K.m_es(reportId, groupId, subgroupId, reportVariable);
        Object[] objectArray = new Object[4];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = subgroupId;
        objectArray[3] = reportVariable.getId();
        return ResponseEntity.created((URI)a.path(c_hha.m_rl((Object)"\u0013,N2L8N#u3Ax[%S\"L$\u0013,[%S\"L\u001eX*\u0013$I5[%S\"L$\u0013,O\"^0N8I'u3AxJ6N>]5P2OxG!]%U6^;Y\u001eX*")).buildAndExpand(objectArray).toUri()).body((Object)reportVariable);
    }

    @PostMapping(value={"/{reportId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReport(@PathVariable(value="reportId") Integer a) {
        this.l.cancelReport(a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public ResponseEntity<ReportSubgroup> createReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportSubgroup reportSubgroup, UriComponentsBuilder a) {
        reportSubgroup = this.K.m_xz(reportId, groupId, reportSubgroup);
        Object[] objectArray = new Object[3];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = reportSubgroup.getId();
        return ResponseEntity.created((URI)a.path(OtpSettingsController.m_rl((Object)"B6\u001f(\u001d\"\u001f9$)\u0010b\n?\u00028\u001d>B6\n?\u00028\u001d\u0004\t0B>\u0018/\n?\u00028\u001d>B6\u001e8\u000f*\u001f\"\u0018=$)\u0010")).buildAndExpand(objectArray).toUri()).body((Object)reportSubgroup);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportGroup a) {
        this.K.m_fz(reportId, groupId, a);
    }

    @DeleteMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReport(@PathVariable(value="reportId") Integer a) {
        this.K.m_ma(a);
    }

    @PutMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReport(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody Report a) {
        this.K.m_iy(reportId, a);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportSubgroup a) {
        this.K.m_bu(reportId, groupId, subgroupId, a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    public ReportVariable getReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        return this.K.m_fq(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/cancel"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReports(@RequestParam(value="projectId") Integer a) {
        this.l.cancelReports(a);
    }

    @PostMapping(value={"/{reportId}/groups"})
    public ResponseEntity<ReportGroup> createReportGroup(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody ReportGroup reportGroup, UriComponentsBuilder a) {
        reportGroup = this.K.m_oz(reportId, reportGroup);
        Object[] objectArray = new Object[2];
        objectArray[0] = reportId;
        objectArray[1] = reportGroup.getId();
        return ResponseEntity.created((URI)a.path(c_hha.m_rl((Object)"\u0013,N2L8N#u3Ax[%S\"L$\u0013,[%S\"L\u001eX*")).buildAndExpand(objectArray).toUri()).body((Object)reportGroup);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}"})
    public ReportGroup getReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.K.m_fv(reportId, a);
    }

    @GetMapping(value={"/statuses"})
    public Map<Integer, c_ah> getReportStatuses(@RequestParam(value="reportIds") Integer[] a) {
        return this.l.getReportStatuses(Arrays.asList(a));
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody ReportVariable a) {
        this.K.m_xy(reportId, groupId, subgroupId, variableId, a);
    }

    @GetMapping(value={"/{reportId}"})
    public Report getReport(@PathVariable(value="reportId") Integer a) {
        return this.K.m_la(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public Collection<ReportSubgroup> getReportSubgroups(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.K.m_qr(reportId, a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        this.K.m_ap(reportId, a);
    }

    @PostMapping(value={"/{reportId}/mail"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void mailReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.E.m_yz(reportId, startDate, endDate, false, a);
    }

    @GetMapping(value={"/{reportId}/excelExport"})
    public ResponseEntity<byte[]> exportToExcel(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.E.m_lr(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = c_hha.m_rl((Object)"6H#]4T:Y9Hl\u001c1U;Y9]:Yj\u001e\u0005Y'S%HyD;Ou");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(OtpSettingsController.m_rl((Object)".\"\u00039\b#\u0019`)$\u001e=\u0002>\u00049\u0004\"\u0003"), stringArray)).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    public ReportSubgroup getReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.K.m_tu(reportId, groupId, a);
    }

    @PostMapping(value={"/{reportId}/print"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void printReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.E.m_gy(reportId, startDate, endDate, false, a);
    }

    @DeleteMapping(value={""}, params={"reportIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportsByIds(@RequestParam(value="reportIds") Integer[] a) {
        this.K.m_uc(List.of(a));
    }

    @DeleteMapping(value={"/groups/subgroups"}, params={"subgroupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubgroupsByIds(@RequestParam(value="subgroupIds") Integer[] a) {
        this.K.m_lu(List.of(a));
    }

    @GetMapping(value={"/{reportId}/status"})
    public c_ah getReportStatus(@PathVariable(value="reportId") Integer a) {
        return this.l.getReportStatus(a);
    }

    @GetMapping
    public Collection<Report> getReports(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.K.m_ta();
        }
        return this.K.m_ra(a);
    }

    @DeleteMapping(value={"/groups"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.K.m_yq(List.of(a));
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        this.K.m_cv(reportId, groupId, subgroupId, a);
    }

    @PostMapping(value={"/{reportId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReport(@PathVariable(value="reportId") Integer a) {
        this.l.scheduleReport(a);
    }

    @GetMapping(value={"/{reportId}/groups"})
    public Collection<ReportGroup> getReportGroups(@PathVariable(value="reportId") Integer a) {
        return this.K.m_pr(a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        this.K.m_zr(reportId, groupId, a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReports(@RequestParam(value="projectId") Integer a) {
        this.l.scheduleReports(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public Collection<ReportVariable> getReportVariables(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.K.m_jp(reportId, groupId, a);
    }

    public ReportController(c_vj a, ReportManager a2, c_jo a3, c_am a4, c_tm a5) {
        ReportController a6;
        ReportController reportController = a6;
        super(a4, EnumSet.of(c_nn.F), a5);
        a6.K = a;
        reportController.l = a2;
        reportController.E = a3;
    }
}

