/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.restcontrollers;

import com.inscada.mono.communication.base.services.c_hn;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.model.ImportResult;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_gf;
import com.inscada.mono.project.j.c_sh;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.project.model.ProjectClone;
import com.inscada.mono.project.model.ProjectLocationDto;
import com.inscada.mono.project.model.ProjectStatus;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/projects"})
public class ProjectController
extends ProjectBasedImportExportController {
    private final c_gf K;
    private final c_sh l;
    private final c_tm l;

    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteProject(@PathVariable(value="projectId") Integer a) {
        this.l.m_ma(a);
    }

    @PostMapping(value={"/clone"})
    public ImportResult cloneProject(@Valid @RequestBody ProjectClone projectClone, @RequestParam(name="includeProjectAttachments", required=false) Boolean a) throws IOException {
        projectClone.setIncludeProjectAttachments(a);
        return this.K.m_ru(projectClone);
    }

    @GetMapping(value={"/{projectId}"})
    public Project getProject(@PathVariable(value="projectId") Integer a) {
        return this.l.m_la(a);
    }

    @GetMapping
    public Collection<Project> getProjects(@RequestParam(name="isActive", required=false) Boolean a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_qo(a);
    }

    @PutMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProject(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody Project a) {
        this.l.m_uz(projectId, a);
    }

    @PostMapping
    public ResponseEntity<Project> createProject(@Valid @RequestBody Project project, UriComponentsBuilder a) {
        project = this.l.m_xw(project);
        Object[] objectArray = new Object[1];
        objectArray[0] = project.getId();
        return ResponseEntity.created((URI)a.path(c_hn.m_rl((Object)"\u0010\u001bO\u0012P\nZ\u0003K)[\u001d")).buildAndExpand(objectArray).toUri()).body((Object)project);
    }

    @GetMapping(value={"/{projectId}/status"})
    public ProjectStatus getStatus(@PathVariable(value="projectId") Integer a) {
        return this.l.m_uw(a);
    }

    public ProjectController(c_tm a, c_sh a2, c_gf a3, c_am a4) {
        ProjectController a5;
        ProjectController projectController = a5;
        super(a4, EnumSet.of(c_nn.m), a);
        a5.l = a;
        projectController.l = a2;
        projectController.K = a3;
    }

    @PatchMapping(value={"/{projectId}/location"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProjectLocation(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody ProjectLocationDto a) {
        this.l.m_ay(projectId, a.getLatitude(), a.getLongitude());
    }

    @GetMapping(value={"/name"}, params={"name"})
    public Project getProject(@RequestParam(name="name") String a) {
        return this.l.m_xj(a);
    }
}

