/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.ProjectAttachment;
import com.inscada.mono.shared.model.SpaceBaseModel;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="project")
public class Project
extends SpaceBaseModel {
    @Size(max=255)
    private String dsc;
    @NotNull
    @Column(name="active_flag")
    private Boolean isActive;
    @Column(name="contract_hour")
    private String contractHour;
    @Id
    @Column(name="project_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="projectSeq")
    @GenericGenerator(name="projectSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="project_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    private String icon;
    private Double longitude;
    @JsonIgnore
    @OneToMany(mappedBy="project", orphanRemoval=true)
    private Set<ProjectAttachment> projectAttachments;
    @Size(max=255)
    private String address;
    @Column(name="contract_day")
    private Integer contractDay;
    @NotBlank
    @Size(max=100)
    @Column(updatable=false)
    private String name;
    private Double latitude;
    private String properties;

    public String getContractHour() {
        Project a;
        return a.contractHour;
    }

    public void setIsActive(Boolean a) {
        a.isActive = a;
    }

    public String getAddress() {
        Project a;
        return a.address;
    }

    public Double getLatitude() {
        Project a;
        return a.latitude;
    }

    public Set<ProjectAttachment> getProjectAttachments() {
        Project a;
        return a.projectAttachments;
    }

    public Integer getId() {
        Project a;
        return a.id;
    }

    public void setLongitude(Double a) {
        a.longitude = a;
    }

    public void setProperties(String a) {
        a.properties = a;
    }

    public Double getLongitude() {
        Project a;
        return a.longitude;
    }

    public String getDsc() {
        Project a;
        return a.dsc;
    }

    public void setIcon(String a) {
        a.icon = a;
    }

    public String getProperties() {
        Project a;
        return a.properties;
    }

    public void setProjectAttachments(Set<ProjectAttachment> a) {
        a.projectAttachments = a;
    }

    public void setAddress(String a) {
        a.address = a;
    }

    public void setContractDay(Integer a) {
        a.contractDay = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setContractHour(String a) {
        a.contractHour = a;
    }

    public int hashCode() {
        Project a;
        Object[] objectArray = new Object[2];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setLatitude(Double a) {
        a.latitude = a;
    }

    public Project() {
        Project a;
    }

    public String getName() {
        Project a;
        return a.name;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Integer getContractDay() {
        Project a;
        return a.contractDay;
    }

    public String getIcon() {
        Project a;
        return a.icon;
    }

    public Boolean getIsActive() {
        Project a;
        return a.isActive;
    }

    public boolean equals(Object a) {
        Project a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Project)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Project)a;
        return a2.getName().equals(a.getName());
    }
}

