/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.restcontrollers;

import com.inscada.mono.animation.model.AnimationJoin;
import com.inscada.mono.faceplate.j.c_eo;
import com.inscada.mono.faceplate.model.Faceplate;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.script.model.Script;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/faceplates"})
public class FaceplateController
extends ProjectBasedImportExportController {
    private final c_eo l;

    @GetMapping(value={"/{faceplateId}/svg"})
    public ResponseEntity<InputStreamResource> getFaceplateSvg(@PathVariable(value="faceplateId") Integer a) {
        a = this.l.m_la(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(Script.m_rl((Object)"Q.|5w/flV(a1}2{5{.|"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)AnimationJoin.m_rl((Object)"Y9Q3U{C\"W\u007fH9\\"))).body((Object)byteArrayInputStream);
    }

    @DeleteMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        this.l.m_pja(faceplateId, a);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Faceplate> getFaceplatesByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.l.m_kia(projectId, a);
    }

    @PutMapping(value={"/{faceplateId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateSvg(@PathVariable(value="faceplateId") Integer faceplateId, @RequestBody String a) {
        this.l.m_sea(faceplateId, a);
    }

    @DeleteMapping(value={"/{faceplateId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElementsByIds(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(value="elementIds") Integer[] a) {
        this.l.m_oha(faceplateId, a);
    }

    @GetMapping
    public Collection<Faceplate> getFaceplates(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    public FaceplateController(c_eo a, c_am a2, c_tm a3) {
        super(a2, EnumSet.of(c_nn.C), a3);
        FaceplateController a4;
        a4.l = a;
    }

    @PutMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody Faceplate a) {
        this.l.m_wea(faceplateId, a);
    }

    @PostMapping(value={"/{faceplateId}/placeholders"})
    public ResponseEntity<FaceplatePlaceholder> createFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplatePlaceholder faceplatePlaceholder, UriComponentsBuilder a) {
        faceplatePlaceholder = this.l.m_rja(faceplateId, faceplatePlaceholder);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplatePlaceholder.getId();
        return ResponseEntity.created((URI)a.path(Script.m_rl((Object)"=:t q$b-s5w\bv<=1~ q$z.~%w3ani$~$\u007f$|5[%o")).buildAndExpand(objectArray).toUri()).body((Object)faceplatePlaceholder);
    }

    @PostMapping(value={"/{faceplateId}/elements"})
    public ResponseEntity<FaceplateElement> createFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplateElement faceplateElement, UriComponentsBuilder a) {
        faceplateElement = this.l.m_tia(faceplateId, faceplateElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplateElement.getId();
        return ResponseEntity.created((URI)a.path(AnimationJoin.m_rl((Object)"\u001f/V5S1@8Q U\u001dT)\u001f1\\1]1^ C{K1\\1]1^ y0M")).buildAndExpand(objectArray).toUri()).body((Object)faceplateElement);
    }

    @DeleteMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplate(@PathVariable(value="faceplateId") Integer a) {
        this.l.m_ma(a);
    }

    @GetMapping(value={"/{faceplateId}/placeholders"})
    public Collection<FaceplatePlaceholder> getFaceplatePlaceholders(@PathVariable(value="faceplateId") Integer a) {
        return this.l.m_bga(a);
    }

    @PutMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer placeholderId, @Valid @RequestBody FaceplatePlaceholder a) {
        this.l.m_tja(faceplateId, placeholderId, a);
    }

    @DeleteMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        this.l.m_pea(faceplateId, a);
    }

    @PostMapping
    public ResponseEntity<Faceplate> createFaceplate(@Valid @RequestBody Faceplate faceplate, UriComponentsBuilder a) {
        faceplate = this.l.m_aca(faceplate);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplate.getId();
        return ResponseEntity.created((URI)a.path(Script.m_rl((Object)"ni's\"w1~ f$[%o")).buildAndExpand(objectArray).toUri()).body((Object)faceplate);
    }

    @PostMapping(value={"/{faceplateId}/clone"}, params={"name"})
    public ResponseEntity<Faceplate> cloneFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        faceplateId = this.l.m_fea(faceplateId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplateId.getId();
        return ResponseEntity.created((URI)a.path(AnimationJoin.m_rl((Object)"{K2Q7U$\\5D1y0M")).buildAndExpand(objectArray).toUri()).body((Object)faceplateId);
    }

    @GetMapping(value={"/{faceplateId}/elements"})
    public Collection<FaceplateElement> getFaceplateElements(@PathVariable(value="faceplateId") Integer a) {
        return this.l.m_afa(a);
    }

    @PutMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody FaceplateElement a) {
        this.l.m_mea(faceplateId, elementId, a);
    }

    @GetMapping(value={"/{faceplateId}"})
    public Faceplate getFaceplate(@PathVariable(value="faceplateId") Integer a) {
        return this.l.m_la(a);
    }

    @GetMapping(value={"/{faceplateId}/elements/{elementId}"})
    public FaceplateElement getFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        return this.l.m_eba(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    public FaceplatePlaceholder getFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        return this.l.m_fga(faceplateId, a);
    }
}

