/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.communication.base.services.c_fha;
import com.inscada.mono.communication.base.services.c_oca;
import com.inscada.mono.datatransfer.events.CancelEvent;
import com.inscada.mono.datatransfer.events.RescheduleEvent;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.repositories.DataTransferDetailRepository;
import com.inscada.mono.datatransfer.repositories.DataTransferRepository;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_lf;
import com.inscada.mono.shared.repositories.BaseInfluxRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@EnableSpaceFilter
public class c_ok {
    private final c_oca c;
    private final c_tm D;
    private final DataTransferDetailRepository H;
    private final DataTransferRepository m;
    private static final String[] E;
    private final ApplicationEventPublisher K;
    private static final String[] l;

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Collection<DataTransfer> m_ra(Integer a) {
        c_ok a2;
        if ((a = a2.m.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_yb(Integer a) {
        c_ok a2;
        DataTransfer dataTransfer = a2.m_la(a);
        if (dataTransfer == null) {
            throw new c_ac("Data transfer not found with id of " + a);
        }
        return dataTransfer;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransferDetail m_lha(Integer a, String a2, String a3) {
        c_ok a4;
        return a4.H.findByDataTransferIdAndVariableNames(a, a2, a3);
    }

    @DisableSpaceFilter
    public Collection<DataTransfer> m_vk(Set<Integer> a) {
        c_ok a2;
        return a2.m.findByIdsWithDetails(a);
    }

    private /* synthetic */ DataTransferDetail m_nka(DataTransferDetail a, boolean a2) {
        c_ok a3;
        c_ok c_ok2 = a3;
        c_ok2.m_xja(a);
        DataTransferDetail dataTransferDetail = (DataTransferDetail)c_ok2.H.save((Object)a);
        if (a2) {
            a3.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a3, a.getDataTransfer()));
        }
        return dataTransferDetail;
    }

    @DisableSpaceFilter
    public Collection<DataTransfer> m_cda(Integer a) {
        c_ok a2;
        if ((a = a2.m.findByProjectIdWithDetails((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    public void m_xja(DataTransferDetail a) {
        c_ok a2;
        c_ok c_ok2 = a2;
        c_ok2.m_zha(a);
        c_ok2.m_sba(a);
    }

    private /* synthetic */ void m_nja(DataTransferDetail a, DataTransferDetail a2, boolean a3) {
        c_ok a4;
        DataTransferDetail dataTransferDetail = a;
        a4.m_zha(dataTransferDetail);
        if (!dataTransferDetail.getDataTransfer().getProject().equals((Object)a2.getDataTransfer().getProject())) {
            throw new c_lf(c_fha.m_rl((Object)"\u0012J0@2[`M%C/A'\\`[/\u000f!A/[(J2\u000f0]/E%L4"));
        }
        Integer n = a2.getDataTransferId();
        DataTransferDetail dataTransferDetail2 = a2;
        BeanUtils.copyProperties((Object)a, (Object)dataTransferDetail2, (String[])l);
        a4.m_sba(dataTransferDetail2);
        if (a3) {
            a4.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a4, a2.getDataTransfer()));
            if (!n.equals(a2.getDataTransferId())) {
                a4.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a4, a2.getDataTransfer()));
            }
        }
    }

    public void m_eha(DataTransfer a) {
        c_ok a2;
        c_ok c_ok2 = a2;
        c_ok2.m_qea(a);
        c_ok2.m_waa(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransferDetail m_baa(Integer a, Integer a2) {
        c_ok a3;
        DataTransferDetail dataTransferDetail = a3.m_sha(a, a2);
        if (dataTransferDetail == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ac(String.format(BaseInfluxRepository.m_rl((Object)"\b\u000b8\u000bl\u001e>\u000b\"\u0019*\u000f>J(\u000f8\u000b%\u0006l\u0004#\u001el\f#\u001f\"\u000evJ(\u000b8\u000bl\u001e>\u000b\"\u0019*\u000f>J%\u000evJi\u000e`J(\u000f8\u000b%\u0006l\u0003(PlO("), objectArray));
        }
        return dataTransferDetail;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, DataTransfer> m_of(Integer a, Set<String> a2) {
        c_ok a3;
        return a3.m.findByProjectIdAndNameIn(a, a2).stream().collect(Collectors.toMap(DataTransfer::getName, Function.identity()));
    }

    @DisableSpaceFilter
    public DataTransfer m_kba(Integer a) {
        c_ok a2;
        DataTransfer dataTransfer = a2.m_gaa(a);
        if (a == null) {
            throw new c_ac("Data Transfer not found with id of " + a);
        }
        return dataTransfer;
    }

    @DisableSpaceFilter
    public DataTransfer m_wl(Integer a) {
        c_ok a2;
        DataTransfer dataTransfer = a2.m_la(a);
        if (dataTransfer == null) {
            throw new c_ac("Data transfer not found with id of " + a);
        }
        return dataTransfer;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_uba(Integer a, String a2) {
        c_ok a3;
        DataTransfer dataTransfer = a3.m_yha(a, a2);
        if (dataTransfer == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ac(String.format(c_fha.m_rl((Object)"\u0004N4N`{2N.\\&J2\u000f.@4\u000f&@5A$\u0015`_2@*J#[`F$\u0015`\n$\u0003`A!B%\u0015`\n3"), objectArray));
        }
        return dataTransfer;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_DATA_TRANSFER')")
    public void m_iga(List<Integer> a2) {
        c_ok a3;
        c_ok c_ok2 = a3;
        c_ok2.H.deleteAllByIdIn(a2);
        a3.H.findAllById(a2).stream().map(DataTransferDetail::getDataTransfer).distinct().collect(Collectors.toList()).forEach(a -> {
            c_ok a2;
            a2.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a2, a));
        });
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_DATA_TRANSFER')")
    public void m_hba(Integer a, Integer a2) {
        c_ok a3;
        DataTransferDetail dataTransferDetail = a3.m_sha(a, a2);
        if (dataTransferDetail != null) {
            c_ok c_ok2 = a3;
            a = c_ok2.m_yb(a);
            c_ok2.H.delete((Object)dataTransferDetail);
            a.removeDetail(a2);
            c_ok2.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a3, (DataTransfer)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_DATA_TRANSFER')")
    public void m_eca(Integer a, DataTransfer a2) {
        c_ok a3;
        c_ok c_ok2 = a3;
        a = c_ok2.m_yb(a);
        c_ok2.m_nba(a2, (DataTransfer)a, true);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_DATA_TRANSFER')")
    public void m_yca(List<Integer> a2) {
        c_ok a3;
        c_ok c_ok2 = a3;
        List list = c_ok2.m.findAllById(a2);
        c_ok2.m.deleteAllByIdIn(a2);
        list.forEach(a -> {
            c_ok a2;
            a2.K.publishEvent((ApplicationEvent)new CancelEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_la(Integer a) {
        c_ok a2;
        return a2.m.findById((Object)a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_yha(Integer a, String a2) {
        c_ok a3;
        return a3.m.findOneByProjectIdAndNameWithDetails(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_DATA_TRANSFER') and hasAuthority('UPDATE_DATA_TRANSFER')")
    public void m_fla(DataTransfer a, boolean a2) {
        DataTransfer dataTransfer;
        c_ok a3;
        DataTransfer dataTransfer2 = a;
        a3.m_qea(dataTransfer2);
        if ((dataTransfer2.getId() != null ? (dataTransfer = a3.m_la(a.getId())) : (dataTransfer = a3.m_jk(a.getProjectId(), a.getName()))) != null) {
            a3.m_nba(a, dataTransfer, a2);
            return;
        }
        c_ok c_ok2 = a3;
        c_ok2.m_waa(a);
        c_ok2.m.save((Object)a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_DATA_TRANSFER') and hasAuthority('UPDATE_DATA_TRANSFER')")
    public void m_mo(Collection<DataTransfer> a2, boolean a3) {
        c_ok a4;
        a2.forEach(a -> {
            if (a.getProject() == null) {
                c_ok a2;
                DataTransfer dataTransfer = a;
                dataTransfer.setProject(a2.D.m_yb(dataTransfer.getProjectId()));
            }
        });
        Object object = a2.stream().map(DataTransfer::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.m.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(DataTransfer::getProjectId, Collectors.mapping(DataTransfer::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_ok a2;
            return a2.m.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(DataTransfer::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<DataTransfer> arrayList = new ArrayList<DataTransfer>();
        HashSet<DataTransfer> hashSet = new HashSet<DataTransfer>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            DataTransfer dataTransfer = (DataTransfer)a2.next();
            if ((dataTransfer.getId() != null ? (DataTransfer)map.get(dataTransfer.getId()) : (DataTransfer)object.get(ImmutablePair.of((Object)dataTransfer.getProjectId(), (Object)dataTransfer.getName()))) != null) {
                DataTransfer dataTransfer2;
                DataTransfer dataTransfer3 = dataTransfer2;
                a4.m_nba(dataTransfer, dataTransfer3, false);
                hashSet.add(dataTransfer3);
                arrayList.add(dataTransfer2);
                continue;
            }
            a4.m_waa(dataTransfer);
            arrayList.add(dataTransfer);
        }
        a4.m.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_ok a2;
                a2.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a2, a));
            });
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_DATA_TRANSFER')")
    public DataTransfer m_pba(DataTransfer a) {
        c_ok a2;
        c_ok c_ok2 = a2;
        c_ok2.m_eha(a);
        return (DataTransfer)c_ok2.m.save((Object)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransferDetail m_sha(Integer a, Integer a2) {
        c_ok a3;
        return a3.H.findByDataTransferIdAndId(a, a2);
    }

    private /* synthetic */ void m_nba(DataTransfer a, DataTransfer a2, boolean a3) {
        c_ok a4;
        DataTransfer dataTransfer = a;
        c_ok c_ok2 = a4;
        c_ok2.m_qea(a);
        BeanUtils.copyProperties((Object)dataTransfer, (Object)a2, (String[])E);
        c_ok2.m_waa(dataTransfer);
        if (a3) {
            a4.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a4, a2));
        }
    }

    private /* synthetic */ void m_waa(DataTransfer a) {
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_jk(Integer a, String a2) {
        c_ok a3;
        return a3.m.findOneByProjectIdAndName(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_DATA_TRANSFER')")
    public void m_ma(Integer a) {
        c_ok a2;
        if ((a = a2.m_la(a)) != null) {
            c_ok c_ok2 = a2;
            c_ok2.m.delete((Object)a);
            c_ok2.K.publishEvent((ApplicationEvent)new CancelEvent((Object)a2, (DataTransfer)a));
        }
    }

    @Order(value=3)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_DATA_TRANSFER')")
    public void m_hi(ProjectDeleteEvent a) {
        c_ok a2;
        a2.m_qa(a.getProject().getId());
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_DATA_TRANSFER') and hasAuthority('UPDATE_DATA_TRANSFER')")
    public void m_pha(DataTransferDetail a, boolean a2) {
        DataTransferDetail dataTransferDetail;
        c_ok a3;
        DataTransferDetail dataTransferDetail2 = a;
        a3.m_zha(dataTransferDetail2);
        if ((dataTransferDetail2.getId() != null ? (dataTransferDetail = a3.m_sha(a.getDataTransferId(), a.getId())) : (dataTransferDetail = a3.m_lha(a.getDataTransferId(), a.getSourceVariable().getName(), a.getTargetVariable().getName()))) != null) {
            a3.m_nja(a, dataTransferDetail, a2);
            return;
        }
        a3.m_nka(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_DATA_TRANSFER')")
    public void m_kfa(Integer a, Integer a2, DataTransferDetail a3) {
        c_ok a4;
        c_ok c_ok2 = a4;
        a = c_ok2.m_baa(a, a2);
        DataTransferDetail dataTransferDetail = a3;
        dataTransferDetail.setDataTransfer(a.getDataTransfer());
        c_ok2.m_nja(dataTransferDetail, (DataTransferDetail)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_xk(Integer a, String a2) {
        c_ok a3;
        DataTransfer dataTransfer = a3.m_jk(a, a2);
        if (dataTransfer == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ac(String.format(BaseInfluxRepository.m_rl((Object)"\b\u000b8\u000bl\u001e>\u000b\"\u0019*\u000f>J\"\u00058J*\u00059\u0004(Pl\u001a>\u0005&\u000f/\u001el\u0003(PlO(Fl\u0004-\u0007)PlO?"), objectArray));
        }
        return dataTransfer;
    }

    @DisableSpaceFilter
    public Collection<DataTransfer> m_nf(Integer a) {
        c_ok a2;
        if ((a = a2.m.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_gaa(Integer a) {
        c_ok a2;
        return a2.m.findOneWithDetails(a);
    }

    private /* synthetic */ void m_sba(DataTransferDetail a) {
        DataTransferDetail dataTransferDetail = a;
        Project project = dataTransferDetail.getDataTransfer().getProject();
        if (!dataTransferDetail.getSourceVariable().getProject().equals((Object)project)) {
            throw new c_lf(c_fha.m_rl((Object)"\u0016N2F!M,J`M%C/A'\\`[/\u000f!A/[(J2\u000f0]/E%L4"));
        }
        if (!a.getTargetVariable().getProject().equals((Object)project)) {
            throw new c_lf(BaseInfluxRepository.m_rl((Object)"\u001a\u000b>\u0003-\b \u000fl\b)\u0006#\u0004+\u0019l\u001e#J-\u0004#\u001e$\u000f>J<\u0018#\u0000)\t8"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Collection<DataTransferDetail> m_gfa(Integer a) {
        c_ok a2;
        if ((a = a2.H.findByDataTransferId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = c_fha.m_rl((Object)"F$");
        stringArray[1] = BaseInfluxRepository.m_rl((Object)"?\u001a-\t)");
        stringArray[2] = c_fha.m_rl((Object)"0]/E%L4");
        stringArray[3] = BaseInfluxRepository.m_rl((Object)"(\u000b8\u000b\u0018\u0018-\u0004?\f)\u0018\b\u000f8\u000b%\u0006?");
        stringArray[4] = c_fha.m_rl((Object)"#]%N4J$m9");
        stringArray[5] = BaseInfluxRepository.m_rl((Object)"\t>\u000f-\u001e%\u0005\".-\u001e)");
        stringArray[6] = c_fha.m_rl((Object)"C!\\4b/K)I)J$m9");
        stringArray[7] = BaseInfluxRepository.m_rl((Object)"\u0006-\u00198'#\u000e%\f%\u000f(.-\u001e)");
        E = stringArray;
        String[] stringArray2 = new String[6];
        stringArray2[0] = c_fha.m_rl((Object)"F$");
        stringArray2[1] = BaseInfluxRepository.m_rl((Object)"?\u001a-\t)");
        stringArray2[2] = c_fha.m_rl((Object)"#]%N4J$m9");
        stringArray2[3] = BaseInfluxRepository.m_rl((Object)"\t>\u000f-\u001e%\u0005\".-\u001e)");
        stringArray2[4] = c_fha.m_rl((Object)"C!\\4b/K)I)J$m9");
        stringArray2[5] = BaseInfluxRepository.m_rl((Object)"\u0006-\u00198'#\u000e%\f%\u000f(.-\u001e)");
        l = stringArray2;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public DataTransfer m_ida(Integer a) {
        c_ok a2;
        DataTransfer dataTransfer = a2.m_gaa(a);
        if (a == null) {
            throw new c_ac("Data Transfer not found with id of " + a);
        }
        return dataTransfer;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_DATA_TRANSFER') and hasAuthority('UPDATE_DATA_TRANSFER')")
    public void m_ofa(Collection<DataTransferDetail> a2, boolean a3) {
        c_ok a4;
        a2.forEach(a -> {
            c_ok a2;
            if (a.getDataTransfer() == null) {
                DataTransferDetail dataTransferDetail = a;
                dataTransferDetail.setDataTransfer(a2.m_yb(dataTransferDetail.getDataTransferId()));
            }
            if (a.getSourceVariable() == null) {
                DataTransferDetail dataTransferDetail = a;
                dataTransferDetail.setSourceVariable(a2.c.m_yb(dataTransferDetail.getSourceVariableId()));
            }
            if (a.getTargetVariable() == null) {
                DataTransferDetail dataTransferDetail = a;
                dataTransferDetail.setTargetVariable(a2.c.m_yb(dataTransferDetail.getTargetVariableId()));
            }
        });
        Object object = a2.stream().map(DataTransferDetail::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Object object2 = a2.stream().map(DataTransferDetail::getDataTransferId).collect(Collectors.toSet());
        object = new HashSet(a4.H.findAllById(object));
        object.addAll(a4.H.findByDataTransferIdIn(object2));
        object2 = object.stream().collect(Collectors.toMap(DataTransferDetail::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutableTriple.of((Object)a.getDataTransferId(), (Object)a.getSourceVariable().getName(), (Object)a.getTargetVariable().getName()), Function.identity()));
        ArrayList<DataTransferDetail> arrayList = new ArrayList<DataTransferDetail>();
        HashSet<DataTransfer> hashSet = new HashSet<DataTransfer>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            DataTransferDetail dataTransferDetail = (DataTransferDetail)a2.next();
            if ((dataTransferDetail.getId() != null ? (DataTransferDetail)object2.get(dataTransferDetail.getId()) : (DataTransferDetail)object.get(ImmutableTriple.of((Object)dataTransferDetail.getDataTransferId(), (Object)dataTransferDetail.getSourceVariable().getName(), (Object)dataTransferDetail.getTargetVariable().getName()))) != null) {
                DataTransferDetail dataTransferDetail2;
                DataTransfer dataTransfer = dataTransferDetail2.getDataTransfer();
                a4.m_nja(dataTransferDetail, dataTransferDetail2, false);
                hashSet.add(dataTransfer);
                hashSet.add(dataTransferDetail.getDataTransfer());
                arrayList.add(dataTransferDetail2);
                continue;
            }
            a4.m_sba(dataTransferDetail);
            hashSet.add(dataTransferDetail.getDataTransfer());
            arrayList.add(dataTransferDetail);
        }
        a4.H.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_ok a2;
                a2.K.publishEvent((ApplicationEvent)new RescheduleEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Collection<DataTransfer> m_ta() {
        c_ok a;
        return a.m.findAll();
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_DATA_TRANSFER')")
    public void m_qa(Integer a) {
        if (a != null) {
            c_ok a2;
            a2.m.deleteByProjectId(a);
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_DATA_TRANSFER')")
    public DataTransferDetail m_yaa(Integer a, DataTransferDetail a2) {
        c_ok a3;
        c_ok c_ok2 = a3;
        a = c_ok2.m_yb(a);
        DataTransferDetail dataTransferDetail = a2;
        dataTransferDetail.setDataTransfer((DataTransfer)a);
        return c_ok2.m_nka(dataTransferDetail, true);
    }

    public c_ok(c_tm a, c_oca a2, DataTransferRepository a3, DataTransferDetailRepository a4, ApplicationEventPublisher a5) {
        c_ok a6;
        c_ok c_ok2 = a6;
        c_ok c_ok3 = a6;
        a6.D = a;
        c_ok3.c = a2;
        c_ok3.m = a3;
        c_ok2.H = a4;
        c_ok2.K = a5;
    }
}

