/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_zia;
import com.inscada.mono.cluster.j.c_ska;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.communication.base.enums.c_efa;
import com.inscada.mono.communication.base.enums.c_lfa;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_gea;
import com.inscada.mono.communication.base.services.c_oca;
import com.inscada.mono.communication.base.services.c_pea;
import com.inscada.mono.datatransfer.events.CancelEvent;
import com.inscada.mono.datatransfer.events.RescheduleEvent;
import com.inscada.mono.datatransfer.j.c_ej;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.c_ok;
import com.inscada.mono.datatransfer.services.c_we;
import com.inscada.mono.job.c.c_ni;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.services.c_bd;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.report.model.DeviationReportVariable;
import com.inscada.mono.shared.exceptions.c_sk;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.user.model.UserDto;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener {
    private final c_ok G;
    private final c_pea h;
    public static final short f = 403;
    private final JedisPooled J;
    public static final short b = 401;
    public static final short C = 406;
    private final Map<Integer, Job> F;
    private final ClusterOperations I;
    public static final short M = 402;
    private final c_ni L;
    private static final String i = "scheduledDataTransfers";
    private static final Logger d = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short c = 404;
    public static final short D = 407;
    private final c_bd H;
    private final c_gea m;
    private final Lock E;
    public static final short K = 405;
    private final c_oca l;

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_ej> getDataTransferStatuses(Integer a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            d.debug(UserDto.m_rl((Object)"_<R=V+)YT\u001cg\rz\u0017tYr\u0015\u007fYw\u0018g\u00183\ra\u0018}\nu\u001caY`\rr\rf\nv\n3\u001f|\u000b3\ta\u0016y\u001cp\r3\u0002nY\u007f\u0016p\u0018\u007f\u0015jW"), (Object)a);
            return a2.getDataTransferStatusesByProjectIdInternal(a);
        }
        d.debug(DeviationReportVariable.m_rl((Object)"&h&\n$b)c-uR\u0007:B\u0019R\rT\u001cN\u0006@HK\rF\fB\u001a\u0007\u000eH\u001a\u0007\tK\u0004\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001a\u0007\u001bS\tS\u001dT\rTHA\u0007UHW\u001aH\u0002B\u000bSH\\\u0015\t"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)407), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            DataTransferManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.I.addRemoteCall((short)401, (Object)a, DataTransferManager.class.getDeclaredMethod(UserDto.m_rl((Object)"`\u001a{\u001cw\f\u007f\u001cW\u0018g\u0018G\u000br\u0017`\u001fv\u000bZ\u0017g\u001ca\u0017r\u0015"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.I.addRemoteCall((short)402, (Object)a, DataTransferManager.class.getDeclaredMethod(DeviationReportVariable.m_rl((Object)"\u000bF\u0006D\rK,F\u001cF<U\tI\u001bA\rU!I\u001cB\u001aI\tK"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.I.addRemoteCall((short)403, (Object)a, DataTransferManager.class.getDeclaredMethod(UserDto.m_rl((Object)"\u001ev\rW\u0018g\u0018G\u000br\u0017`\u001fv\u000b@\rr\rf\nZ\u0017g\u001ca\u0017r\u0015"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.I.addRemoteCall((short)404, (Object)a, DataTransferManager.class.getDeclaredMethod(DeviationReportVariable.m_rl((Object)"\u001bD\u0000B\fR\u0004B,F\u001cF<U\tI\u001bA\rU\u001be\u0011w\u001aH\u0002B\u000bS!C!I\u001cB\u001aI\tK"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.I.addRemoteCall((short)405, (Object)a, DataTransferManager.class.getDeclaredMethod(UserDto.m_rl((Object)"p\u0018}\u001av\u0015W\u0018g\u0018G\u000br\u0017`\u001fv\u000b`;j)a\u0016y\u001cp\rZ\u001dZ\u0017g\u001ca\u0017r\u0015"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.I.addRemoteCall((short)406, (Object)a, DataTransferManager.class.getDeclaredMethod(DeviationReportVariable.m_rl((Object)"\u000fB\u001cc\tS\ts\u001aF\u0006T\u000eB\u001at\u001cF\u001cR\u001bB\u001be\u0011n\fT!I\u001cB\u001aI\tK"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.I.addRemoteCall((short)407, (Object)a, DataTransferManager.class.getDeclaredMethod(UserDto.m_rl((Object)"t\u001cg=r\rr-a\u0018}\nu\u001ca*g\u0018g\f`\u001c`;j)a\u0016y\u001cp\rZ\u001dZ\u0017g\u001ca\u0017r\u0015"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(DeviationReportVariable.m_rl((Object)".F\u0001K\rCHS\u0007\u0007\u001aB\u000fN\u001bS\rUHc\tS\ts\u001aF\u0006T\u000eB\u001aj\tI\t@\rUHu8dHJ\rS\u0000H\fT"), noSuchMethodException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail a, Date a2, String a3) {
        Date date;
        int n;
        boolean bl;
        DataTransferManager a4;
        if (a3 == null) {
            return true;
        }
        a3 = Calendar.getInstance();
        String string = a4.J.get(a4.buildStatLastCalcTimeKey(a));
        if (string == null) {
            return true;
        }
        ((Calendar)a3).setTimeInMillis(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(a2);
        boolean bl2 = false;
        switch (c_we.K[a.getRangeType().ordinal()]) {
            case 1: 
            case 2: {
                bl = bl2 = ((Calendar)a3).get(11) != calendar.get(11);
                break;
            }
            case 3: 
            case 4: {
                bl = bl2 = ((Calendar)a3).get(6) != calendar.get(6);
                break;
            }
            case 5: 
            case 6: {
                bl = bl2 = ((Calendar)a3).get(3) != calendar.get(3);
                break;
            }
            case 7: 
            case 8: {
                bl = bl2 = ((Calendar)a3).get(2) != calendar.get(2);
                break;
            }
            case 9: 
            case 10: {
                bl2 = ((Calendar)a3).get(1) != calendar.get(1);
            }
            default: {
                bl = bl2;
            }
        }
        if (bl) {
            DataTransferManager dataTransferManager = a4;
            String string2 = dataTransferManager.buildStatCacheKey(a);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey(a);
            String[] stringArray = new String[2];
            stringArray[0] = string2;
            stringArray[1] = string3;
            dataTransferManager.J.del(stringArray);
            return true;
        }
        if (!a.getRangeType().toString().startsWith(UserDto.m_rl((Object)":f\u000ba\u001c}\r"))) {
            return false;
        }
        switch (c_we.K[a.getRangeType().ordinal()]) {
            case 1: {
                n = 5;
                date = a2;
                break;
            }
            case 3: {
                n = 5;
                date = a2;
                break;
            }
            case 5: {
                n = 60;
                date = a2;
                break;
            }
            case 7: {
                n = 720;
                date = a2;
                break;
            }
            case 9: {
                n = 720;
                date = a2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a.getRangeType()));
            }
        }
        long l = date.getTime();
        long l2 = Long.parseLong(string);
        return l - l2 >= (long)(n * 60 * 1000);
    }

    protected void scheduleDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.G.m_kba(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_ej getDataTransferStatus(Integer a, String a2) {
        DataTransferManager a3;
        if ((a = a3.G.m_jk(a, a2)) == null) {
            return c_ej.K;
        }
        return a3.getDataTransferStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            d.debug(DeviationReportVariable.m_rl((Object)"k-f,b:\u001dHd\tI\u000bB\u0004K\u0001I\u000f\u0007\tK\u0004\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001aTHA\u0007UHW\u001aH\u0002B\u000bSH\\\u0015\u0007\u0004H\u000bF\u0004K\u0011\t"), (Object)a);
            a2.cancelDataTransfersByProjectIdInternal(a);
            return;
        }
        d.debug(UserDto.m_rl((Object)"]6]T_<R=V+)YA\u001cb\fv\ng\u0010}\u001e3\u0015v\u0018w\u001caYg\u00163\u001ar\u0017p\u001c\u007fYr\u0015\u007fYw\u0018g\u00183\ra\u0018}\nu\u001ca\n3\u001f|\u000b3\ta\u0016y\u001cp\r3\u0002nW"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)405), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC cancel data transfers for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(DeviationReportVariable.m_rl((Object)"\fF\u001cFES\u001aF\u0006T\u000eB\u001a\u001d\u0004F\u001bSED\tK\u000b\n\u001cN\u0005BRQ\tU\u0001F\nK\r\u001dMCR\u0002\u001b\u001dMT"), objectArray);
    }

    public void notLeader() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        String string = dataTransferManager.I.getCurrentNode().getNodeId();
        d.info(UserDto.m_rl((Object)"=r\rr-a\u0018}\nu\u001ca4r\u0017r\u001ev\u000b)YG\u0011z\n3\u0017|\u001dvY;\u0002nP3\u0010`Y]635\\7T<AYG1VY_<R=V+=YP\u0018}\u001av\u0015\u007f\u0010}\u001e3\u0018\u007f\u00153\u0015|\u001ar\u00153\u001dr\rrYg\u000br\u0017`\u001fv\u000b3\u0013|\u001b`W=W"), (Object)string);
        dataTransferManager.E.lock();
        try {
            new ArrayList(a.F.keySet()).forEach(a2 -> {
                DataTransferManager a3;
                Job job = (Job)a3.F.get(a2);
                if (job != null) {
                    try {
                        d.info(UserDto.m_rl((Object)"W\u0018g\u0018G\u000br\u0017`\u001fv\u000b^\u0018}\u0018t\u001caY;7|\r35v\u0018w\u001caYh\u0004:C3:r\u0017p\u001c\u007f\u0015z\u0017tY\u007f\u0016p\u0018\u007fYy\u0016qYu\u0016aYw\u0018g\u00183\ra\u0018}\nu\u001caYZ=)Yh\u0004"), (Object)string, a2);
                        a3.L.m_jia(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        d.error(DeviationReportVariable.m_rl((Object)"c\tS\ts\u001aF\u0006T\u000eB\u001aj\tI\t@\rUH\u000f&H\u001c\u0007$B\tC\rUH\\\u0015\u000eR\u0007-U\u001aH\u001a\u0007\u000bF\u0006D\rK\u0004N\u0006@HK\u0007D\tKHM\u0007EHA\u0007UHC\tS\t\u0007\u001cU\tI\u001bA\rUHn,\u0007\u0013ZR\u0007\u0013Z"), objectArray);
                    }
                }
            });
            a.F.clear();
            d.info(DeviationReportVariable.m_rl((Object)",F\u001cF<U\tI\u001bA\rU%F\u0006F\u000fB\u001a\u0007@i\u0007SHk\rF\fB\u001a\u0007\u0013ZA\u001dHf\u0004KHK\u0007D\tKHC\tS\t\u0007\u001cU\tI\u001bA\rUHM\u0007E\u001b\u0007\u0000F\u001eBHE\rB\u0006\u0007\u001aB\u0019R\rT\u001cB\f\u0007\u001cHHD\tI\u000bB\u0004\u0007\tI\f\u0007\u000bK\rF\u001aB\f\u0007\u000eU\u0007JHK\u0007D\tKHS\u001aF\u000bL\u0001I\u000f\t"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            d.error(UserDto.m_rl((Object)"W\u0018g\u0018G\u000br\u0017`\u001fv\u000b^\u0018}\u0018t\u001caY;7|\r35v\u0018w\u001caYh\u0004:C3<a\u000b|\u000b3\u001df\u000bz\u0017tYc\u000b|\u001av\n`Y|\u001f3\u001ar\u0017p\u001c\u007f\u0015z\u0017tY\u007f\u0016p\u0018\u007fYw\u0018g\u00183\ra\u0018}\nu\u001caYy\u0016q\n)Yh\u0004"), objectArray);
            return;
        }
        finally {
            a.E.unlock();
        }
    }

    private /* synthetic */ void updateVariableWithCachedValue(String a, DataTransferDetail a2, Map<Integer, Variable<?, ?, ?>> a3, Map<String, Map<String, Object>> a4, Map<Integer, VariableValue<?>> a5) {
        if ((a3 = a3.get(a2.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = Double.parseDouble((String)a);
            a = a5.get(a2.getTargetVariableId());
            if (a6.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), a)) {
                a = new HashMap<String, Double>();
                a.put(DeviationReportVariable.m_rl((Object)"Q\tK\u001dB"), d);
                a4.put(a3.getName(), (Map<String, Object>)a);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats a, c_efa a2) {
        switch (c_we.l[a2.ordinal()]) {
            case 1: {
                return a.getMinValue();
            }
            case 2: {
                return a.getMaxValue();
            }
            case 3: {
                return a.getAvgValue();
            }
            case 4: {
                return a.getSumValue();
            }
            case 5: {
                return a.getCountValue();
            }
            case 6: {
                return a.getFirstValue();
            }
            case 7: {
                return a.getLastValue();
            }
            case 8: {
                return a.getMaxDiffValue();
            }
            case 9: {
                return a.getLastFirstDiffValue();
            }
            case 10: {
                return a.getMiddleValue();
            }
            case 11: {
                return a.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_lfa a) {
        switch (c_we.K[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    private /* synthetic */ void transfer(DataTransfer a) {
        DataTransferManager a2;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(a3 -> {
            if (a3.getCalcType() != null && a3.getRangeType() != null) {
                arrayList2.add(a3);
                return;
            }
            arrayList.add(a3);
        });
        HashMap hashMap = new HashMap();
        if (!arrayList.isEmpty()) {
            a2.handleCurrentValues(arrayList, hashMap);
        }
        if (!arrayList2.isEmpty()) {
            a2.handleStatValues(arrayList2, hashMap);
        }
        if (!hashMap.isEmpty()) {
            a2.h.m_xrb(a.getProjectId(), hashMap);
        }
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            d.info(UserDto.m_rl((Object)"5V8W<AC31r\u0017w\u0015z\u0017tYA\u001c`\u001a{\u001cw\f\u007f\u001cV\u000fv\u0017gYu\u0016aYw\u0018g\u00183\ra\u0018}\nu\u001caC3\u0002nY;0WC3\u0002nP"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            if (a2.getDataTransferStatusInternal(dataTransfer.getId()) == c_ej.E) {
                a2.scheduleDataTransferInternal(dataTransfer.getId());
                return;
            }
        } else {
            d.debug(DeviationReportVariable.m_rl((Object)"&h&\n$b)c-uR\u0007!@\u0006H\u001aN\u0006@Hu\rT\u000bO\rC\u001dK\rb\u001eB\u0006SHA\u0007UHC\tS\t\u0007\u001cU\tI\u001bA\rUR\u0007\u0013Z"), (Object)a.getDataTransfer().getId());
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.G.m_nf((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        String string = dataTransferManager.I.getCurrentNode().getNodeId();
        d.info(DeviationReportVariable.m_rl((Object)",F\u001cF<U\tI\u001bA\rU%F\u0006F\u000fB\u001a\u001dHs\u0000N\u001b\u0007\u0006H\fBH\u000f\u0013ZA\u0007\u0000F\u001b\u0007\nB\u000bH\u0005BHS\u0000BHk-f,b:\tHu\rT\u001cH\u001aN\u0006@HT\u000bO\rC\u001dK\rCHC\tS\t\u0007\u001cU\tI\u001bA\rU\u001b\tF\t"), (Object)string);
        dataTransferManager.E.lock();
        try {
            Set set = a2.J.smembers(i).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                d.info(UserDto.m_rl((Object)"=r\rr-a\u0018}\nu\u001ca4r\u0017r\u001ev\u000b3Q_\u001cr\u001dv\u000b3\u0002nP)Y]\u00163\np\u0011v\u001df\u0015v\u001d3\u001dr\rrYg\u000br\u0017`\u001fv\u000b`Yu\u0016f\u0017wYz\u00173+v\u001dz\n3\r|Ya\u001c`\r|\u000bvW"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            d.info(DeviationReportVariable.m_rl((Object)"c\tS\ts\u001aF\u0006T\u000eB\u001aj\tI\t@\rUH\u000f$B\tC\rUH\\\u0015\u000eR\u0007.H\u001dI\f\u0007\u0013ZHT\u000bO\rC\u001dK\rCHC\tS\t\u0007\u001cU\tI\u001bA\rUHn,THN\u0006\u0007:B\fN\u001b\u0007\u001cHHU\rT\u001cH\u001aBR\u0007\u0013Z"), objectArray);
            ArrayList arrayList = new ArrayList(a2.G.m_vk(set));
            d.info(UserDto.m_rl((Object)"=r\rr-a\u0018}\nu\u001ca4r\u0017r\u001ev\u000b3Q_\u001cr\u001dv\u000b3\u0002nP)YR\rg\u001c~\tg\u0010}\u001e3\r|Ya\u001c`\r|\u000bvYh\u00043\u001dr\rrYg\u000br\u0017`\u001fv\u000b`W"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                DataTransferManager a2;
                String string = a2.I.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    d.info(UserDto.m_rl((Object)"=r\rr-a\u0018}\nu\u001ca4r\u0017r\u001ev\u000b3Q_\u001cr\u001dv\u000b3\u0002nP)YA\u001c`\r|\u000bz\u0017tYw\u0018g\u00183\ra\u0018}\nu\u001caC3\u0002nY;0WC3\u0002nP"), objectArray);
                    a2.scheduleDataTransferInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.H.m_efa(a.getProject()).m_q("Data Transfer Restore (Leader " + string + ")", String.format(DeviationReportVariable.m_rl((Object)"MTH\u000f!cR\u0007MCA\u0007\u000eF\u0001K\rCHS\u0007\u0007\u001aB\u001bS\u0007U\r\tHd\tR\u001bBR\u0007MT"), objectArray));
                    try {
                        d.warn(UserDto.m_rl((Object)"=r\rr-a\u0018}\nu\u001ca4r\u0017r\u001ev\u000b3Q_\u001cr\u001dv\u000b3\u0002nP)YR\rg\u001c~\tg\u0010}\u001e3\r|Yp\u0018}\u001av\u00153\u001dr\rrYg\u000br\u0017`\u001fv\u000b3\u0002nYr\u001fg\u001caYa\u001c`\r|\u000br\rz\u0016}Yu\u0018z\u0015f\u000bvW"), (Object)string, (Object)a.getId());
                        a2.cancelDataTransferInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        d.error(DeviationReportVariable.m_rl((Object)",F\u001cF<U\tI\u001bA\rU%F\u0006F\u000fB\u001a\u0007@k\rF\fB\u001a\u0007\u0013ZA\u001dHa\tN\u0004B\f\u0007\u001cHHD\tI\u000bB\u0004\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001a\u0007\u0013ZHF\u000eS\rUHU\rT\u001cH\u001aF\u001cN\u0007IHA\tN\u0004R\u001aBR\u0007\u0013Z"), objectArray2);
                        return;
                    }
                }
            });
            d.info(DeviationReportVariable.m_rl((Object)",F\u001cF<U\tI\u001bA\rU%F\u0006F\u000fB\u001a\u0007@k\rF\fB\u001a\u0007\u0013ZA\u001dHa\u0001I\u0001T\u0000B\f\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001a\u0007\u001aB\u001bS\u0007U\tS\u0001H\u0006\u0007\u0018U\u0007D\rT\u001b\t"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            d.error(UserDto.m_rl((Object)"=r\rr-a\u0018}\nu\u001ca4r\u0017r\u001ev\u000b3Q_\u001cr\u001dv\u000b3\u0002nP)YV\u000ba\u0016aYw\fa\u0010}\u001e3\u001dr\rrYg\u000br\u0017`\u001fv\u000b3\u000bv\ng\u0016a\u0018g\u0010|\u00173\ta\u0016p\u001c`\n)Yh\u0004"), objectArray);
            return;
        }
        finally {
            a2.E.unlock();
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            Integer n = a.getProject().getId();
            d.info(DeviationReportVariable.m_rl((Object)"$b)c-uR\u0007 F\u0006C\u0004N\u0006@Hw\u001aH\u0002B\u000bS,B\tD\u001cN\u001eF\u001cB-Q\rI\u001c\u0007\u000eH\u001a\u0007\u0018U\u0007M\rD\u001c\u0007!cR\u0007\u0013Z"), (Object)n);
            a2.cancelDataTransfersByProjectIdInternal(n);
            return;
        }
        d.debug(UserDto.m_rl((Object)"]6]T_<R=V+)YZ\u001e}\u0016a\u0010}\u001e3)a\u0016y\u001cp\rW\u001cr\u001ag\u0010e\u0018g\u001cV\u000fv\u0017gYu\u0016aYc\u000b|\u0013v\u001agYZ=)Yh\u0004"), (Object)a.getProject().getId());
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, Double a2, VariableValue<?> a3) {
        DataTransferManager a4;
        return a4.isValueInThresholdRange(a, (VariableValue)new NumberVariableValue((Number)a2, new Date()), a3);
    }

    private /* synthetic */ void lambda$handleStatValues$14(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        if ((a = (LoggedVariableValueStats)a.get(a5.getSourceVariableId())) != null && (a2 = (Variable)a2.get(a5.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = a6.extractValue((LoggedVariableValueStats)a, a5.getCalcType());
            a = (VariableValue)a3.get(a5.getTargetVariableId());
            DataTransferManager dataTransferManager = a6;
            a3 = dataTransferManager.buildStatCacheKey(a5);
            String string = dataTransferManager.buildStatLastCalcTimeKey(a5);
            int n = dataTransferManager.getMaxTTLForRangeType(a5.getRangeType());
            dataTransferManager.J.setex((String)a3, (long)n, String.valueOf(d));
            a6.J.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager.isValueInThresholdRange(a5.getThreshold(), Double.valueOf(d), (VariableValue)a)) {
                a = new HashMap<String, Double>();
                a.put(DeviationReportVariable.m_rl((Object)"Q\tK\u001dB"), d);
                a4.put(a2.getName(), a);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.cancelDataTransfer(dataTransferManager.G.m_xk(a, a2).getId());
    }

    public DataTransferManager(c_ok a, c_oca a2, c_pea a3, c_gea a4, c_ni a5, JedisPooled a6, c_bd a7, ClusterOperations a8) {
        DataTransferManager a9;
        DataTransferManager dataTransferManager = a9;
        DataTransferManager dataTransferManager2 = a9;
        DataTransferManager dataTransferManager3 = a9;
        DataTransferManager dataTransferManager4 = a9;
        DataTransferManager dataTransferManager5 = a9;
        a9.E = new ReentrantLock();
        dataTransferManager5.F = new ConcurrentHashMap();
        dataTransferManager4.G = a;
        dataTransferManager4.l = a2;
        dataTransferManager3.h = a3;
        dataTransferManager3.m = a4;
        dataTransferManager2.L = a5;
        dataTransferManager2.H = a7;
        dataTransferManager.J = a6;
        dataTransferManager.I = a8;
    }

    protected c_ej getDataTransferStatusInternal(Integer a) {
        DataTransferManager a2;
        if (a2.F.containsKey(a)) {
            return c_ej.E;
        }
        return c_ej.K;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_ej> getDataTransferStatuses(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.I.isLeader()) {
            d.debug(UserDto.m_rl((Object)"5V8W<AC3>v\rg\u0010}\u001e3\u001dr\rrYg\u000br\u0017`\u001fv\u000b3\ng\u0018g\f`\u001c`Yu\u0016aYh\u000430W\n3\u0015|\u001ar\u0015\u007f\u0000)Yh\u0004"), (Object)a.size(), a);
            return a2.getDataTransferStatusesByIdsInternal(a);
        }
        d.debug(DeviationReportVariable.m_rl((Object)"i'iEk-f,b:\u001dHu\rV\u001dB\u001bS\u0001I\u000f\u0007\u0004B\tC\rUHA\u0007UHC\tS\t\u0007\u001cU\tI\u001bA\rUHT\u001cF\u001cR\u001bB\u001b\u0007\u000eH\u001a\u0007\u0013ZHn,TR\u0007\u0013Z"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)406), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(UserDto.m_rl((Object)"U"))), (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            d.info(DeviationReportVariable.m_rl((Object)"k-f,b:\u001dHo\tI\fK\u0001I\u000f\u0007+F\u0006D\rK-Q\rI\u001c\u0007\u000eH\u001a\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001a\u001dH\\\u0015\u0007@n,\u001dH\\\u0015\u000e"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            a2.cancelDataTransferInternal(dataTransfer);
            return;
        }
        d.debug(UserDto.m_rl((Object)"]6]T_<R=V+)YZ\u001e}\u0016a\u0010}\u001e3:r\u0017p\u001c\u007f<e\u001c}\r3\u001f|\u000b3\u001dr\rrYg\u000br\u0017`\u001fv\u000b)Yh\u0004"), (Object)a.getDataTransfer().getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.I.addListener((ClusterNodeListener)a);
        d.info(DeviationReportVariable.m_rl((Object)",F\u001cF<U\tI\u001bA\rU%F\u0006F\u000fB\u001a\u0007\u0001I\u0001S\u0001F\u0004N\u0012B\f\u0007\tI\f\u0007\u001aB\u000fN\u001bS\rU\rCHF\u001b\u0007+K\u001dT\u001cB\u001ai\u0007C\rk\u0001T\u001cB\u0006B\u001a\t"));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            d.debug(UserDto.m_rl((Object)"5V8W<AC3*p\u0011v\u001df\u0015z\u0017tYr\u0015\u007fYw\u0018g\u00183\ra\u0018}\nu\u001ca\n3\u001f|\u000b3\ta\u0016y\u001cp\r3\u0002nY\u007f\u0016p\u0018\u007f\u0015jW"), (Object)a);
            a2.scheduleDataTransfersByProjectIdInternal(a);
            return;
        }
        d.debug(DeviationReportVariable.m_rl((Object)"&h&\n$b)c-uR\u0007:B\u0019R\rT\u001cN\u0006@HK\rF\fB\u001a\u0007\u001cHHT\u000bO\rC\u001dK\r\u0007\tK\u0004\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001aTHA\u0007UHW\u001aH\u0002B\u000bSH\\\u0015\t"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)404), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC schedule data transfers for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            d.debug(UserDto.m_rl((Object)"_<R=V+)Y@\u001a{\u001cw\f\u007f\u0010}\u001e3\u001dr\rrYg\u000br\u0017`\u001fv\u000b3\u0002nY\u007f\u0016p\u0018\u007f\u0015jW"), (Object)a);
            a2.scheduleDataTransferInternal(a);
            return;
        }
        d.debug(DeviationReportVariable.m_rl((Object)"i'iEk-f,b:\u001dHu\rV\u001dB\u001bS\u0001I\u000f\u0007\u0004B\tC\rUHS\u0007\u0007\u001bD\u0000B\fR\u0004BHC\tS\t\u0007\u001cU\tI\u001bA\rUH\\\u0015\t"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)401), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC schedule data transfer " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$handleCurrentValues$8(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        a = (VariableValue)a.get(a5.getSourceVariableId());
        a2 = (VariableValue)a2.get(a5.getTargetVariableId());
        a3 = (Variable)a3.get(a5.getTargetVariableId());
        if (a != null && a3 != null && a6.isValueInThresholdRange(a5.getThreshold(), (VariableValue)a, (VariableValue)a2)) {
            a2 = new HashMap<String, Object>();
            a2.put(UserDto.m_rl((Object)"\u000fr\u0015f\u001c"), a.getValue());
            a4.put(a3.getName(), a2);
        }
    }

    private /* synthetic */ void handleStatValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a3) {
        DataTransferManager a4;
        Object object = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a4.l.m_owa(object).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = a4.h.m_ztb((Integer[])object.toArray(Integer[]::new));
        Date date = new Date();
        a.stream().filter(arg_0 -> a4.lambda$handleStatValues$10(date, map, a3, (Map)object, arg_0)).collect(Collectors.groupingBy(a2 -> {
            DataTransferManager a3;
            return (Date)a3.calculateDateRange(date, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> a4.lambda$handleStatValues$15(date, map, (Map)object, a3, arg_0, arg_1));
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(DeviationReportVariable.m_rl((Object)"C\tS\t\n\u001cU\tI\u001bA\rURT\u001cF\u001cTRQ\tU\u0001F\nK\r\u001dMCR\u0002\u001b\u001dMT"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.G.m_xk(a, a2).getId());
    }

    private /* synthetic */ boolean lambda$handleStatValues$10(Date a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        DataTransferManager dataTransferManager = a6;
        String string = dataTransferManager.buildStatCacheKey(a5);
        if (!dataTransferManager.shouldRecalculateStats(a5, a, string = dataTransferManager.J.get(string))) {
            a6.updateVariableWithCachedValue(string, a5, a2, a3, a4);
            return false;
        }
        return true;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_ej getDataTransferStatus(Integer a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            d.debug(UserDto.m_rl((Object)"_<R=V+)YT\u001cg\rz\u0017tYw\u0018g\u00183\ra\u0018}\nu\u001caY`\rr\rf\n3\u001f|\u000b30WC3\u0002nY\u007f\u0016p\u0018\u007f\u0015jW"), (Object)a);
            return a2.getDataTransferStatusInternal(a);
        }
        d.debug(DeviationReportVariable.m_rl((Object)"&h&\n$b)c-uR\u0007:B\u0019R\rT\u001cN\u0006@HK\rF\fB\u001a\u0007\u000eH\u001a\u0007\fF\u001cFHS\u001aF\u0006T\u000eB\u001a\u0007\u001bS\tS\u001dTHA\u0007UHn,\u001dH\\\u0015\t"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_ej)a2.I.callLeaderMethod(Short.valueOf((short)403), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get data transfer status for " + a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_zia.m_iec(() -> {
            DataTransferManager a2;
            a2.E.lock();
            try {
                a2.cancelDataTransferInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_sk("Project should be active to schedule data transfer " + a.getName());
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = a.getName();
                PeriodicJob periodicJob = a2.L.m_lea(a.getProject(), String.format(UserDto.m_rl((Object)"6\n3=r\rrYG\u000br\u0017`\u001fv\u000b"), objectArray), () -> {
                    DataTransferManager a2;
                    a2.transfer(a);
                }, Duration.ofMillis(a.getPeriod().intValue()));
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.F.put(a.getId(), periodicJob);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.J.sadd(i, stringArray);
                return;
            }
            finally {
                a2.E.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected void scheduleDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.G.m_cda((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    protected Map<Integer, c_ej> getDataTransferStatusesByIdsInternal(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    protected Map<Integer, c_ej> getDataTransferStatusesByProjectIdInternal(Integer a2) {
        DataTransferManager a3;
        if ((a2 = a3.G.m_nf((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(DataTransfer::getId, a -> {
            DataTransferManager a2;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.I.isLeader()) {
            d.debug(UserDto.m_rl((Object)"_<R=V+)YP\u0018}\u001av\u0015\u007f\u0010}\u001e3\u001dr\rrYg\u000br\u0017`\u001fv\u000b3\u0002nY\u007f\u0016p\u0018\u007f\u0015jW"), (Object)a);
            a2.cancelDataTransferInternal(a);
            return;
        }
        d.debug(DeviationReportVariable.m_rl((Object)"i'iEk-f,b:\u001dHu\rV\u001dB\u001bS\u0001I\u000f\u0007\u0004B\tC\rUHS\u0007\u0007\u000bF\u0006D\rKHC\tS\t\u0007\u001cU\tI\u001bA\rUH\\\u0015\t"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)402), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC cancel data transfer " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$handleStatValues$15(Date a, Map a2, Map a3, Map a4, Date a5, List a6) {
        DataTransferManager a7;
        Integer[] integerArray = (Integer[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(Integer[]::new);
        c_efa[] c_efaArray = (c_efa[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_efa[]::new);
        a = a7.m.m_nrb(integerArray, a5, (Date)a, c_efaArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableIdAsInt, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$14((Map)a, a2, a3, a4, arg_0));
    }

    protected void cancelDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_zia.m_iec(() -> {
            DataTransferManager a2;
            a2.E.lock();
            try {
                Job job = (Job)a2.F.get(a.getId());
                if (job != null) {
                    a2.L.m_jia(job);
                }
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.F.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.J.srem(i, stringArray);
                return;
            }
            finally {
                a2.E.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date a, c_lfa a2) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar.setTime(a);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = (Calendar)calendar2.clone();
        switch (c_we.K[a2.ordinal()]) {
            case 1: {
                Calendar calendar4 = calendar;
                while (false) {
                }
                calendar4.set(12, 0);
                return Pair.of((Object)calendar4.getTime(), (Object)a);
            }
            case 2: {
                calendar3.add(11, -1);
                Calendar calendar5 = calendar;
                calendar5.add(11, -2);
                calendar5.set(12, 0);
                return Pair.of((Object)calendar5.getTime(), (Object)calendar3.getTime());
            }
            case 3: {
                Calendar calendar6 = calendar;
                calendar6.set(11, 0);
                calendar6.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 4: {
                calendar3.add(5, -1);
                Calendar calendar7 = calendar;
                calendar.add(5, -2);
                calendar7.set(11, 0);
                calendar7.set(12, 0);
                return Pair.of((Object)calendar7.getTime(), (Object)calendar3.getTime());
            }
            case 5: {
                Calendar calendar8 = calendar;
                Calendar calendar9 = calendar;
                calendar9.set(7, calendar9.getFirstDayOfWeek());
                calendar8.set(11, 0);
                calendar8.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 6: {
                calendar3.add(3, -1);
                Calendar calendar10 = calendar;
                calendar.add(3, -2);
                Calendar calendar11 = calendar;
                calendar11.set(7, calendar11.getFirstDayOfWeek());
                calendar10.set(11, 0);
                calendar10.set(12, 0);
                return Pair.of((Object)calendar10.getTime(), (Object)calendar3.getTime());
            }
            case 7: {
                Calendar calendar12 = calendar;
                calendar.set(5, 1);
                calendar12.set(11, 0);
                calendar12.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 8: {
                calendar3.add(2, -1);
                Calendar calendar13 = calendar;
                Calendar calendar14 = calendar;
                calendar14.add(2, -2);
                calendar14.set(5, 1);
                calendar13.set(11, 0);
                calendar13.set(12, 0);
                return Pair.of((Object)calendar13.getTime(), (Object)calendar3.getTime());
            }
            case 9: {
                Calendar calendar15 = calendar;
                calendar.set(6, 1);
                calendar15.set(11, 0);
                calendar15.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 10: {
                calendar3.add(1, -1);
                Calendar calendar16 = calendar;
                Calendar calendar17 = calendar;
                calendar17.add(1, -2);
                calendar17.set(6, 1);
                calendar16.set(11, 0);
                calendar16.set(12, 0);
                return Pair.of((Object)calendar16.getTime(), (Object)calendar3.getTime());
            }
        }
        throw new IllegalArgumentException(UserDto.m_rl((Object)",}\u001ck\tv\u001ag\u001cwYa\u0018}\u001evYg\u0000c\u001c"));
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, VariableValue<?> a2, VariableValue<?> a3) {
        double d;
        double d2;
        if (a == null || a3 == null) {
            return true;
        }
        if (!(a2 instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d3 = ((Number)a2.getValue()).doubleValue();
        double d4 = ((Number)a3.getValue()).doubleValue();
        return (d3 == 0.0 ? (d2 = Math.abs(d4 - d3)) : (d = Math.abs((d4 - d3) / d3 * 100.0))) >= a;
    }

    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a2) {
        DataTransferManager a3;
        Object object = (Integer[])a.stream().map(DataTransferDetail::getSourceVariableId).toArray(Integer[]::new);
        Object object2 = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a3.l.m_owa(object2).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        DataTransferManager dataTransferManager = a3;
        object = dataTransferManager.h.m_ztb(object);
        object2 = dataTransferManager.h.m_ztb((Integer[])object2.toArray(Integer[]::new));
        a.forEach(arg_0 -> a3.lambda$handleCurrentValues$8((Map)object, (Map)object2, map, a2, arg_0));
    }

    protected void cancelDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.G.m_wl(a));
    }
}

