/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.restcontrollers;

import com.inscada.mono.broadcast.model.BroadcastOperationResponse;
import com.inscada.mono.datatransfer.j.c_ej;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.DataTransferManager;
import com.inscada.mono.datatransfer.services.c_ok;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.script.services.c_rd;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/datatransfer"})
public class DataTransferController
extends ProjectBasedImportExportController {
    private final DataTransferManager K;
    private final c_ok l;

    @PutMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDataTransfer(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransfer a) {
        this.l.m_eca(dataTransferId, a);
    }

    @PostMapping
    public ResponseEntity<DataTransfer> createDataTransfer(@Valid @RequestBody DataTransfer dataTransfer, UriComponentsBuilder a) {
        dataTransfer = this.l.m_pba(dataTransfer);
        Object[] objectArray = new Object[1];
        objectArray[0] = dataTransfer.getId();
        return ResponseEntity.created((URI)a.path(c_rd.m_rl((Object)"f*-0=0\u001d#(?:7,#\u000054")).buildAndExpand(objectArray).toUri()).body((Object)dataTransfer);
    }

    @DeleteMapping(value={""}, params={"dataTransferIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfersByIds(@RequestParam(value="dataTransferIds") Integer[] a) {
        this.l.m_yca(List.of(a));
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_ej> getDataTransferStatuses(@RequestParam(value="dataTransferIds") Integer[] a) {
        return this.K.getDataTransferStatuses(Arrays.asList(a));
    }

    @PutMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer detailId, @Valid @RequestBody DataTransferDetail a) {
        this.l.m_kfa(dataTransferId, detailId, a);
    }

    @GetMapping(value={"/{dataTransferId}"})
    public DataTransfer getDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        return this.l.m_la(a);
    }

    @GetMapping(value={"/{dataTransferId}/details/{detailId}"})
    public DataTransferDetail getDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        return this.l.m_sha(dataTransferId, a);
    }

    @PostMapping(value={"/{dataTransferId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="dataTransferId") Integer a) {
        this.K.scheduleDataTransfer(a);
    }

    @PostMapping(value={"/{dataTransferId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="dataTransferId") Integer a) {
        this.K.cancelDataTransfer(a);
    }

    @GetMapping(value={"/{dataTransferId}/status"})
    public c_ej getDataTransferStatus(@PathVariable(value="dataTransferId") Integer a) {
        return this.K.getDataTransferStatus(a);
    }

    @DeleteMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        this.l.m_hba(dataTransferId, a);
    }

    @DeleteMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        this.l.m_ma(a);
    }

    public DataTransferController(c_ok a, DataTransferManager a2, c_am a3, c_tm a4) {
        DataTransferController a5;
        DataTransferController dataTransferController = a5;
        super(a3, EnumSet.of(c_nn.K), a4);
        dataTransferController.l = a;
        dataTransferController.K = a2;
    }

    @DeleteMapping(value={"/details"}, params={"dataTransferDetailIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransferDetailsByIds(@RequestParam(value="dataTransferDetailIds") Integer[] a) {
        this.l.m_iga(List.of(a));
    }

    @GetMapping(value={"/{dataTransferId}/details"})
    public Collection<DataTransferDetail> getDetails(@PathVariable(value="dataTransferId") Integer a) {
        return this.l.m_gfa(a);
    }

    @PostMapping(value={"/{dataTransferId}/details"})
    public ResponseEntity<DataTransferDetail> createDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransferDetail dataTransferDetail, UriComponentsBuilder a) {
        dataTransferDetail = this.l.m_yaa(dataTransferId, dataTransferDetail);
        Object[] objectArray = new Object[2];
        objectArray[0] = dataTransferId;
        objectArray[1] = dataTransferDetail.getId();
        return ResponseEntity.created((URI)a.path(BroadcastOperationResponse.m_rl((Object)"4S\u007fIoIOZzFhN~ZRLf\u0007\u007fMoIrDh\u0007`L~\\zAwa\u007fU")).buildAndExpand(objectArray).toUri()).body((Object)dataTransferDetail);
    }

    @GetMapping
    public Collection<DataTransfer> getDataTransfers(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.K.scheduleDataTransfers(a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.K.cancelDataTransfers(a);
    }
}

