/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.animation.messages.AnimationResultsMessage;
import com.inscada.mono.config.BrokerProperties;
import com.inscada.mono.config.ListenerBrokerProperties;
import com.inscada.mono.shared.aspects.SetSpaceIdAspect;
import com.inscada.mono.shared.interfaces.Listener;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ListenerBrokerProperties.class})
@ConditionalOnProperty(value={"spring.remote.broker.enabled"}, havingValue="true")
@EnableJms
public class ListenerBrokerConfig
implements JmsListenerConfigurer {
    private final JmsProperties jmsProperties;
    private final ObjectMapper objectMapper;
    private final String nodeId;
    private final List<Listener<?>> listenerList;
    private final ListenerBrokerProperties brokerProperties;

    @Bean
    public MessageConverter jacksonReceiveJmsMessageConverter() {
        ListenerBrokerConfig a;
        MappingJackson2MessageConverter mappingJackson2MessageConverter;
        MappingJackson2MessageConverter mappingJackson2MessageConverter2 = mappingJackson2MessageConverter = new MappingJackson2MessageConverter();
        mappingJackson2MessageConverter.setObjectMapper(a.objectMapper);
        mappingJackson2MessageConverter2.setTargetType(MessageType.TEXT);
        mappingJackson2MessageConverter2.setTypeIdPropertyName(SetSpaceIdAspect.m_rl((Object)"\u0014327."));
        return mappingJackson2MessageConverter2;
    }

    @Bean(destroyMethod="stop")
    JmsListenerEndpointRegistry jmsListenerEndpointRegistry() {
        return new JmsListenerEndpointRegistry();
    }

    public ListenerBrokerConfig(List<Listener<?>> listenerList, ObjectMapper objectMapper, JmsProperties jmsProperties, ListenerBrokerProperties brokerProperties, @Value(value="${ins.node.id}") String a) {
        ListenerBrokerConfig listenerBrokerConfig = this;
        ListenerBrokerConfig listenerBrokerConfig2 = this;
        this.listenerList = listenerList;
        listenerBrokerConfig2.objectMapper = objectMapper;
        listenerBrokerConfig2.jmsProperties = jmsProperties;
        listenerBrokerConfig.brokerProperties = brokerProperties;
        listenerBrokerConfig.nodeId = a;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar a) {
        ListenerBrokerConfig a2;
        JmsListenerEndpointRegistrar jmsListenerEndpointRegistrar = a;
        ListenerBrokerConfig listenerBrokerConfig = a2;
        jmsListenerEndpointRegistrar.setEndpointRegistry(listenerBrokerConfig.jmsListenerEndpointRegistry());
        jmsListenerEndpointRegistrar.afterPropertiesSet();
        if (listenerBrokerConfig.brokerProperties.getList() == null) {
            return;
        }
        for (BrokerProperties brokerProperties : a2.brokerProperties.getList()) {
            Object object = new HashMap();
            object.put(AnimationResultsMessage.m_rl((Object)"RjIq"), brokerProperties.getHost());
            object.put(SetSpaceIdAspect.m_rl((Object)"7$5?"), brokerProperties.getPort());
            object = new TransportConfiguration(NettyConnectorFactory.class.getName(), object);
            TransportConfiguration[] transportConfigurationArray = new TransportConfiguration[1];
            transportConfigurationArray[0] = object;
            object = new ActiveMQConnectionFactory(false, transportConfigurationArray);
            String string = brokerProperties.getUser();
            if (StringUtils.hasText((String)string)) {
                object.setUser(string);
                object.setPassword(brokerProperties.getPassword());
            }
            object.setClientID(a2.nodeId);
            ListenerBrokerConfig listenerBrokerConfig2 = a2;
            brokerProperties = listenerBrokerConfig2.jmsProperties.getCache();
            object = new CachingConnectionFactory((ConnectionFactory)object);
            TransportConfiguration transportConfiguration = object;
            BrokerProperties brokerProperties2 = brokerProperties;
            object.setCacheConsumers(brokerProperties2.isConsumers());
            transportConfiguration.setCacheProducers(brokerProperties2.isProducers());
            transportConfiguration.setSessionCacheSize(brokerProperties.getSessionCacheSize());
            BrokerProperties brokerProperties3 = brokerProperties = new DefaultJmsListenerContainerFactory();
            ListenerBrokerConfig listenerBrokerConfig3 = a2;
            brokerProperties.setConnectionFactory((ConnectionFactory)object);
            brokerProperties.setMessageConverter(listenerBrokerConfig3.jacksonReceiveJmsMessageConverter());
            brokerProperties3.setPubSubDomain(Boolean.valueOf(listenerBrokerConfig3.jmsProperties.isPubSubDomain()));
            brokerProperties3.setSubscriptionDurable(Boolean.valueOf(true));
            object = listenerBrokerConfig2.jmsProperties.getListener();
            TransportConfiguration transportConfiguration2 = object;
            brokerProperties.setAutoStartup(transportConfiguration2.isAutoStartup());
            if (transportConfiguration2.getAcknowledgeMode() != null) {
                brokerProperties.setSessionAcknowledgeMode(Integer.valueOf(object.getAcknowledgeMode().getMode()));
            }
            if ((string = object.formatConcurrency()) != null) {
                brokerProperties.setConcurrency(string);
            }
            if ((object = object.getReceiveTimeout()) != null) {
                brokerProperties.setReceiveTimeout(Long.valueOf(((Duration)object).toMillis()));
            }
            Object object2 = object = a2.listenerList.iterator();
            while (object2.hasNext()) {
                SimpleJmsListenerEndpoint simpleJmsListenerEndpoint;
                string = (Listener)object.next();
                SimpleJmsListenerEndpoint simpleJmsListenerEndpoint2 = simpleJmsListenerEndpoint = new SimpleJmsListenerEndpoint();
                String string2 = string;
                simpleJmsListenerEndpoint.setId(string2.m_j());
                simpleJmsListenerEndpoint2.setSubscription(string2.m_y());
                simpleJmsListenerEndpoint2.setDestination(string.m_b());
                String string3 = string = new MessageListenerAdapter((Object)string);
                string3.setMessageConverter(a2.jacksonReceiveJmsMessageConverter());
                string3.setDefaultListenerMethod(AnimationResultsMessage.m_rl((Object)"w_f_lL`"));
                simpleJmsListenerEndpoint2.setMessageListener((MessageListener)string3);
                object2 = object;
                a.registerEndpoint((JmsListenerEndpoint)simpleJmsListenerEndpoint, (JmsListenerContainerFactory)brokerProperties);
            }
        }
    }
}

