/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.restcontrollers.VariableValueController;
import com.inscada.mono.communication.base.template.j.c_zf;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.sms.model.dataport.StringValueHolder;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class TemplateController<TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TTemplateService extends c_zf<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    private final TTemplateService l;

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.l.m_fqa(deviceId, a);
    }

    @PutMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDeviceTemplate a) {
        this.l.m_bna(deviceId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    public TFrameTemplate getFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrameTemplate)this.l.m_eua(deviceId, a);
    }

    @GetMapping(value={"/devices/{deviceId}"})
    public TDeviceTemplate getDevice(@PathVariable(value="deviceId") Integer a) {
        return (TDeviceTemplate)this.l.m_apa(a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public Collection<TVariableTemplate> getVariables(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return this.l.m_cpa(deviceId, a);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrameTemplate a) {
        this.l.m_dsa(deviceId, frameId, a);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariableTemplate a) {
        this.l.m_rua(deviceId, frameId, variableId, a);
    }

    @PostMapping(value={"/devices"})
    public ResponseEntity<TDeviceTemplate> createDevice(@Valid @RequestBody TDeviceTemplate device, UriComponentsBuilder a) {
        device = this.l.m_cta(device);
        Object[] objectArray = new Object[1];
        objectArray[0] = device.getId();
        return ResponseEntity.created((URI)a.path(StringValueHolder.m_rl((Object)"U5\u001f'\u00132\u001f\"U*\u001e4\f8\u0019435\u0007")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @PostMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public ResponseEntity<TVariableTemplate> createVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TVariableTemplate variable, UriComponentsBuilder a) {
        variable = this.l.m_ana(deviceId, frameId, variable);
        Object[] objectArray = new Object[3];
        objectArray[0] = deviceId;
        objectArray[1] = frameId;
        objectArray[2] = variable.getId();
        return ResponseEntity.created((URI)a.path(VariableValueController.m_rl((Object)"S\u0017\u0019\u0005\u0015\u0010\u0019\u0000S\b\u0018\u0016\n\u001a\u001f\u00165\u0017\u0001\\\u001a\u0001\u001d\u001e\u0019\u0000S\b\u001a\u0001\u001d\u001e\u0019:\u0018\u000eS\u0005\u001d\u0001\u0015\u0012\u001e\u001f\u0019\u0000S\b\n\u0012\u000e\u001a\u001d\u0011\u0010\u00165\u0017\u0001")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @GetMapping(value={"/devices/{deviceId}/frames"})
    public Collection<TFrameTemplate> getFrames(@PathVariable(value="deviceId") Integer a) {
        return this.l.m_jwa(a);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        this.l.m_spa(deviceId, frameId, a);
    }

    public TemplateController(TTemplateService a) {
        TemplateController a2;
        a2.l = a;
    }

    @PostMapping(value={"/devices/{deviceId}/frames"})
    public ResponseEntity<TFrameTemplate> createFrame(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrameTemplate frame, UriComponentsBuilder a) {
        frame = this.l.m_ara(deviceId, frame);
        Object[] objectArray = new Object[2];
        objectArray[0] = deviceId;
        objectArray[1] = frame.getId();
        return ResponseEntity.created((URI)a.path(StringValueHolder.m_rl((Object)"~\u001e4\f8\u00194\t~\u00015\u001f'\u00132\u001f\u0018\u001e,U7\b0\u00174\t~\u00017\b0\u0017435\u0007")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDeviceTemplate> getDevices() {
        TemplateController a;
        return a.l.m_rsa();
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    public TVariableTemplate getVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        return (TVariableTemplate)this.l.m_qsa(deviceId, frameId, a);
    }

    @DeleteMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="deviceId") Integer a) {
        this.l.m_mva(a);
    }
}

